 /* Copyright (c) 2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef MSM8X10_WCD_REGISTERS_H
#define MSM8X10_WCD_REGISTERS_H

#define MSM8X10_WCD_A_CHIP_CTL			(0x000)
#define MSM8X10_WCD_A_CHIP_CTL__POR				(0x04)
#define MSM8X10_WCD_A_CHIP_STATUS			(0x001)
#define MSM8X10_WCD_A_CHIP_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TLMM_MODE_SELECT			(0x002)
#define MSM8X10_WCD_A_CDC_TLMM_MODE_SELECT__POR				(0x00)
#define MSM8X10_WCD_A_MODE_LOCK			(0x003)
#define MSM8X10_WCD_A_MODE_LOCK__POR				(0x00)
#define MSM8X10_WCD_A_CHIP_ID_BYTE_0			(0x004)
#define MSM8X10_WCD_A_CHIP_ID_BYTE_0__POR				(0x00)
#define MSM8X10_WCD_A_CHIP_ID_BYTE_1			(0x005)
#define MSM8X10_WCD_A_CHIP_ID_BYTE_1__POR				(0x00)
#define MSM8X10_WCD_A_CHIP_ID_BYTE_2			(0x006)
#define MSM8X10_WCD_A_CHIP_ID_BYTE_2__POR				(0x04)
#define MSM8X10_WCD_A_CHIP_ID_BYTE_3			(0x007)
#define MSM8X10_WCD_A_CHIP_ID_BYTE_3__POR				(0x01)
#define MSM8X10_WCD_A_CHIP_VERSION			(0x008)
#define MSM8X10_WCD_A_CHIP_VERSION__POR				(0x00)
#define MSM8X10_WCD_A_ANALOG_SLAVE_ID			(0x00C)
#define MSM8X10_WCD_A_ANALOG_SLAVE_ID__POR				(0x77)
#define MSM8X10_WCD_A_PIN_CTL_OE			(0x010)
#define MSM8X10_WCD_A_PIN_CTL_OE__POR				(0x07)
#define MSM8X10_WCD_A_PIN_CTL_DATA			(0x012)
#define MSM8X10_WCD_A_PIN_CTL_DATA__POR				(0x00)
#define MSM8X10_WCD_A_PIN_STATUS			(0x014)
#define MSM8X10_WCD_A_PIN_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_HDRIVE_CTL			(0x018)
#define MSM8X10_WCD_A_HDRIVE_CTL__POR				(0x01)
#define MSM8X10_WCD_A_HDRIVE_I2C_CTL			(0x019)
#define MSM8X10_WCD_A_HDRIVE_I2C_CTL__POR				(0x01)
#define MSM8X10_WCD_A_CDC_RST_CTL			(0x020)
#define MSM8X10_WCD_A_CDC_RST_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TOP_CLK_CTL			(0x022)
#define MSM8X10_WCD_A_CDC_TOP_CLK_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_ANA_CLK_CTL			(0x023)
#define MSM8X10_WCD_A_CDC_ANA_CLK_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_DIG_CLK_CTL			(0x024)
#define MSM8X10_WCD_A_CDC_DIG_CLK_CTL__POR				(0x00)
#define MSM8X10_WCD_A_PROCESS_MONITOR_CTL0			(0x030)
#define MSM8X10_WCD_A_PROCESS_MONITOR_CTL0__POR				(0x80)
#define MSM8X10_WCD_A_PROCESS_MONITOR_CTL1			(0x031)
#define MSM8X10_WCD_A_PROCESS_MONITOR_CTL1__POR				(0x00)
#define MSM8X10_WCD_A_PROCESS_MONITOR_CTL2			(0x032)
#define MSM8X10_WCD_A_PROCESS_MONITOR_CTL2__POR				(0x00)
#define MSM8X10_WCD_A_PROCESS_MONITOR_CTL3			(0x033)
#define MSM8X10_WCD_A_PROCESS_MONITOR_CTL3__POR				(0x01)
#define MSM8X10_WCD_A_QFUSE_CTL			(0x034)
#define MSM8X10_WCD_A_QFUSE_CTL__POR				(0x00)
#define MSM8X10_WCD_A_QFUSE_STATUS			(0x035)
#define MSM8X10_WCD_A_QFUSE_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_QFUSE_DATA_OUT0			(0x036)
#define MSM8X10_WCD_A_QFUSE_DATA_OUT0__POR				(0x00)
#define MSM8X10_WCD_A_QFUSE_DATA_OUT1			(0x037)
#define MSM8X10_WCD_A_QFUSE_DATA_OUT1__POR				(0x00)
#define MSM8X10_WCD_A_QFUSE_DATA_OUT2			(0x038)
#define MSM8X10_WCD_A_QFUSE_DATA_OUT2__POR				(0x00)
#define MSM8X10_WCD_A_QFUSE_DATA_OUT3			(0x039)
#define MSM8X10_WCD_A_QFUSE_DATA_OUT3__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_TX1_CTL			(0x040)
#define MSM8X10_WCD_A_CDC_CONN_TX1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_TX2_CTL			(0x041)
#define MSM8X10_WCD_A_CDC_CONN_TX2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_HPHR_DAC_CTL			(0x042)
#define MSM8X10_WCD_A_CDC_CONN_HPHR_DAC_CTL__POR			(0x01)
#define MSM8X10_WCD_A_CDC_CONN_LO_DAC_CTL			(0x043)
#define MSM8X10_WCD_A_CDC_CONN_LO_DAC_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX1_CTL			(0x044)
#define MSM8X10_WCD_A_CDC_CONN_RX1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX2_CTL			(0x045)
#define MSM8X10_WCD_A_CDC_CONN_RX2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX3_CTL			(0x046)
#define MSM8X10_WCD_A_CDC_CONN_RX3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_DIGITAL_DEBUG_CTL			(0x048)
#define MSM8X10_WCD_A_DIGITAL_DEBUG_CTL__POR				(0x00)
#define MSM8X10_WCD_A_ANALOG_DEBUG_CTL			(0x049)
#define MSM8X10_WCD_A_ANALOG_DEBUG_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX1_CTL			(0x050)
#define MSM8X10_WCD_A_CDC_RX1_CTL__POR				(0x7C)
#define MSM8X10_WCD_A_CDC_RX2_CTL			(0x058)
#define MSM8X10_WCD_A_CDC_RX2_CTL__POR				(0x7C)
#define MSM8X10_WCD_A_CDC_RX3_CTL			(0x060)
#define MSM8X10_WCD_A_CDC_RX3_CTL__POR				(0x7C)
#define MSM8X10_WCD_A_DEM_BYPASS_DATA0			(0x070)
#define MSM8X10_WCD_A_DEM_BYPASS_DATA0__POR				(0x00)
#define MSM8X10_WCD_A_DEM_BYPASS_DATA1			(0x071)
#define MSM8X10_WCD_A_DEM_BYPASS_DATA1__POR				(0x00)
#define MSM8X10_WCD_A_DEM_BYPASS_DATA2			(0x072)
#define MSM8X10_WCD_A_DEM_BYPASS_DATA2__POR				(0x00)
#define MSM8X10_WCD_A_DEM_BYPASS_DATA3			(0x073)
#define MSM8X10_WCD_A_DEM_BYPASS_DATA3__POR				(0x00)
#define MSM8X10_WCD_A_SPARE_0			(0x080)
#define MSM8X10_WCD_A_SPARE_0__POR				(0x00)
#define MSM8X10_WCD_A_SPARE_1			(0x082)
#define MSM8X10_WCD_A_SPARE_1__POR				(0x00)
#define MSM8X10_WCD_A_SPARE_2			(0x084)
#define MSM8X10_WCD_A_SPARE_2__POR				(0x00)
#define MSM8X10_WCD_A_INTR_MODE			(0x090)
#define MSM8X10_WCD_A_INTR_MODE__POR				(0x00)
#define MSM8X10_WCD_A_INTR_MASK0			(0x094)
#define MSM8X10_WCD_A_INTR_MASK0__POR				(0xFF)
#define MSM8X10_WCD_A_INTR_MASK1			(0x095)
#define MSM8X10_WCD_A_INTR_MASK1__POR				(0xFF)
#define MSM8X10_WCD_A_INTR_MASK2			(0x096)
#define MSM8X10_WCD_A_INTR_MASK2__POR				(0x3F)
#define MSM8X10_WCD_A_INTR_STATUS0			(0x098)
#define MSM8X10_WCD_A_INTR_STATUS0__POR				(0x00)
#define MSM8X10_WCD_A_INTR_STATUS1			(0x099)
#define MSM8X10_WCD_A_INTR_STATUS1__POR				(0x00)
#define MSM8X10_WCD_A_INTR_STATUS2			(0x09A)
#define MSM8X10_WCD_A_INTR_STATUS2__POR				(0x00)
#define MSM8X10_WCD_A_INTR_CLEAR0			(0x09C)
#define MSM8X10_WCD_A_INTR_CLEAR0__POR				(0x00)
#define MSM8X10_WCD_A_INTR_CLEAR1			(0x09D)
#define MSM8X10_WCD_A_INTR_CLEAR1__POR				(0x00)
#define MSM8X10_WCD_A_INTR_CLEAR2			(0x09E)
#define MSM8X10_WCD_A_INTR_CLEAR2__POR				(0x00)
#define MSM8X10_WCD_A_INTR_TEST0			(0x0A4)
#define MSM8X10_WCD_A_INTR_TEST0__POR				(0x00)
#define MSM8X10_WCD_A_INTR_TEST1			(0x0A5)
#define MSM8X10_WCD_A_INTR_TEST1__POR				(0x00)
#define MSM8X10_WCD_A_INTR_TEST2			(0x0A6)
#define MSM8X10_WCD_A_INTR_TEST2__POR				(0x00)
#define MSM8X10_WCD_A_INTR_SET0			(0x0A8)
#define MSM8X10_WCD_A_INTR_SET0__POR				(0x00)
#define MSM8X10_WCD_A_INTR_SET1			(0x0A9)
#define MSM8X10_WCD_A_INTR_SET1__POR				(0x00)
#define MSM8X10_WCD_A_INTR_SET2			(0x0AA)
#define MSM8X10_WCD_A_INTR_SET2__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_EN_CTL			(0x0C0)
#define MSM8X10_WCD_A_CDC_MBHC_EN_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_FIR_B1_CFG			(0x0C1)
#define MSM8X10_WCD_A_CDC_MBHC_FIR_B1_CFG__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_FIR_B2_CFG			(0x0C2)
#define MSM8X10_WCD_A_CDC_MBHC_FIR_B2_CFG__POR				(0x06)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B1_CTL			(0x0C3)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B1_CTL__POR			(0x03)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B2_CTL			(0x0C4)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B2_CTL__POR			(0x09)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B3_CTL			(0x0C5)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B3_CTL__POR			(0x1E)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B4_CTL			(0x0C6)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B4_CTL__POR			(0x45)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B5_CTL			(0x0C7)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B5_CTL__POR			(0x04)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B6_CTL			(0x0C8)
#define MSM8X10_WCD_A_CDC_MBHC_TIMER_B6_CTL__POR			(0x78)
#define MSM8X10_WCD_A_CDC_MBHC_B1_STATUS			(0x0C9)
#define MSM8X10_WCD_A_CDC_MBHC_B1_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_B2_STATUS			(0x0CA)
#define MSM8X10_WCD_A_CDC_MBHC_B2_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_B3_STATUS			(0x0CB)
#define MSM8X10_WCD_A_CDC_MBHC_B3_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_B4_STATUS			(0x0CC)
#define MSM8X10_WCD_A_CDC_MBHC_B4_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_B5_STATUS			(0x0CD)
#define MSM8X10_WCD_A_CDC_MBHC_B5_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_B1_CTL			(0x0CE)
#define MSM8X10_WCD_A_CDC_MBHC_B1_CTL__POR				(0xC0)
#define MSM8X10_WCD_A_CDC_MBHC_B2_CTL			(0x0CF)
#define MSM8X10_WCD_A_CDC_MBHC_B2_CTL__POR				(0x5D)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B1_CTL			(0x0D0)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B2_CTL			(0x0D1)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B3_CTL			(0x0D2)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B4_CTL			(0x0D3)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B4_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B5_CTL			(0x0D4)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B5_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B6_CTL			(0x0D5)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B6_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B7_CTL			(0x0D6)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B7_CTL__POR				(0xFF)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B8_CTL			(0x0D7)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B8_CTL__POR				(0x07)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B9_CTL			(0x0D8)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B9_CTL__POR				(0xFF)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B10_CTL			(0x0D9)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B10_CTL__POR			(0x7F)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B11_CTL			(0x0DA)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B11_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B12_CTL			(0x0DB)
#define MSM8X10_WCD_A_CDC_MBHC_VOLT_B12_CTL__POR			(0x80)
#define MSM8X10_WCD_A_CDC_MBHC_CLK_CTL			(0x0DC)
#define MSM8X10_WCD_A_CDC_MBHC_CLK_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_INT_CTL			(0x0DD)
#define MSM8X10_WCD_A_CDC_MBHC_INT_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_DEBUG_CTL			(0x0DE)
#define MSM8X10_WCD_A_CDC_MBHC_DEBUG_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_MBHC_SPARE			(0x0DF)
#define MSM8X10_WCD_A_CDC_MBHC_SPARE__POR				(0x00)
#define MSM8X10_WCD_A_BIAS_REF_CTL			(0x100)
#define MSM8X10_WCD_A_BIAS_REF_CTL__POR				(0x1C)
#define MSM8X10_WCD_A_BIAS_CENTRAL_BG_CTL			(0x101)
#define MSM8X10_WCD_A_BIAS_CENTRAL_BG_CTL__POR				(0x50)
#define MSM8X10_WCD_A_BIAS_PRECHRG_CTL			(0x102)
#define MSM8X10_WCD_A_BIAS_PRECHRG_CTL__POR				(0x07)
#define MSM8X10_WCD_A_BIAS_CURR_CTL_1			(0x103)
#define MSM8X10_WCD_A_BIAS_CURR_CTL_1__POR				(0x52)
#define MSM8X10_WCD_A_BIAS_CURR_CTL_2			(0x104)
#define MSM8X10_WCD_A_BIAS_CURR_CTL_2__POR				(0x00)
#define MSM8X10_WCD_A_BIAS_OSC_BG_CTL			(0x105)
#define MSM8X10_WCD_A_BIAS_OSC_BG_CTL__POR				(0x16)
#define MSM8X10_WCD_A_MICB_CFILT_1_CTL			(0x128)
#define MSM8X10_WCD_A_MICB_CFILT_1_CTL__POR				(0x40)
#define MSM8X10_WCD_A_MICB_CFILT_1_VAL			(0x129)
#define MSM8X10_WCD_A_MICB_CFILT_1_VAL__POR				(0x80)
#define MSM8X10_WCD_A_MICB_CFILT_1_PRECHRG			(0x12A)
#define MSM8X10_WCD_A_MICB_CFILT_1_PRECHRG__POR				(0x00)
#define MSM8X10_WCD_A_MICB_1_CTL			(0x12B)
#define MSM8X10_WCD_A_MICB_1_CTL__POR				(0x02)
#define MSM8X10_WCD_A_MICB_1_INT_RBIAS			(0x12C)
#define MSM8X10_WCD_A_MICB_1_INT_RBIAS__POR				(0x00)
#define MSM8X10_WCD_A_MICB_1_MBHC			(0x12D)
#define MSM8X10_WCD_A_MICB_1_MBHC__POR				(0x00)
#define MSM8X10_WCD_A_MBHC_INSERT_DETECT			(0x14A)
#define MSM8X10_WCD_A_MBHC_INSERT_DETECT__POR				(0x00)
#define MSM8X10_WCD_A_MBHC_INSERT_DET_STATUS			(0x14B)
#define MSM8X10_WCD_A_MBHC_INSERT_DET_STATUS__POR			(0x00)
#define MSM8X10_WCD_A_TX_COM_BIAS			(0x14C)
#define MSM8X10_WCD_A_TX_COM_BIAS__POR				(0xF0)
#define MSM8X10_WCD_A_MBHC_SCALING_MUX_1			(0x14E)
#define MSM8X10_WCD_A_MBHC_SCALING_MUX_1__POR				(0x00)
#define MSM8X10_WCD_A_MBHC_SCALING_MUX_2			(0x14F)
#define MSM8X10_WCD_A_MBHC_SCALING_MUX_2__POR				(0x80)
#define MSM8X10_WCD_A_RESERVED_MAD_ANA_CTRL			(0x150)
#define MSM8X10_WCD_A_RESERVED_MAD_ANA_CTRL__POR			(0xF1)
#define MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_1			(0x151)
#define MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_1__POR				(0x00)
#define MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_2			(0x152)
#define MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_2__POR				(0x80)
#define MSM8X10_WCD_A_TX_1_EN			(0x153)
#define MSM8X10_WCD_A_TX_1_EN__POR				(0x02)
#define MSM8X10_WCD_A_TX_2_EN			(0x154)
#define MSM8X10_WCD_A_TX_2_EN__POR				(0x02)
#define MSM8X10_WCD_A_TX_1_2_ADC_CH1			(0x155)
#define MSM8X10_WCD_A_TX_1_2_ADC_CH1__POR				(0x44)
#define MSM8X10_WCD_A_TX_1_2_ADC_CH2			(0x156)
#define MSM8X10_WCD_A_TX_1_2_ADC_CH2__POR				(0x44)
#define MSM8X10_WCD_A_TX_1_2_ATEST_REFCTRL			(0x157)
#define MSM8X10_WCD_A_TX_1_2_ATEST_REFCTRL__POR				(0x00)
#define MSM8X10_WCD_A_TX_1_2_TEST_CTL			(0x158)
#define MSM8X10_WCD_A_TX_1_2_TEST_CTL__POR				(0x38)
#define MSM8X10_WCD_A_TX_1_2_TEST_BLOCK_EN			(0x159)
#define MSM8X10_WCD_A_TX_1_2_TEST_BLOCK_EN__POR				(0xFC)
#define MSM8X10_WCD_A_TX_1_2_TXFE_CLKDIV			(0x15A)
#define MSM8X10_WCD_A_TX_1_2_TXFE_CLKDIV__POR				(0x55)
#define MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH1			(0x15B)
#define MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH1__POR				(0x00)
#define MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH2			(0x15C)
#define MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH2__POR				(0x00)
#define MSM8X10_WCD_A_TX_3_EN			(0x15D)
#define MSM8X10_WCD_A_TX_3_EN__POR				(0x00)
#define MSM8X10_WCD_A_TX_1_2_TEST_EN			(0x15E)
#define MSM8X10_WCD_A_TX_1_2_TEST_EN__POR				(0xCC)
#define MSM8X10_WCD_A_TX_7_MBHC_EN_ATEST_CTRL			(0x171)
#define MSM8X10_WCD_A_TX_7_MBHC_EN_ATEST_CTRL__POR			(0x10)
#define MSM8X10_WCD_A_TX_7_MBHC_SAR_ERR			(0x175)
#define MSM8X10_WCD_A_TX_7_MBHC_SAR_ERR__POR				(0x00)
#define MSM8X10_WCD_A_CP_EN			(0x192)
#define MSM8X10_WCD_A_CP_EN__POR				(0xE6)
#define MSM8X10_WCD_A_CP_CLK			(0x193)
#define MSM8X10_WCD_A_CP_CLK__POR				(0x29)
#define MSM8X10_WCD_A_CP_STATIC			(0x194)
#define MSM8X10_WCD_A_CP_STATIC__POR				(0x10)
#define MSM8X10_WCD_A_CP_DCC1			(0x195)
#define MSM8X10_WCD_A_CP_DCC1__POR				(0x52)
#define MSM8X10_WCD_A_CP_DCC3			(0x196)
#define MSM8X10_WCD_A_CP_DCC3__POR				(0x01)
#define MSM8X10_WCD_A_CP_ATEST			(0x197)
#define MSM8X10_WCD_A_CP_ATEST__POR				(0x00)
#define MSM8X10_WCD_A_CP_DTEST			(0x198)
#define MSM8X10_WCD_A_CP_DTEST__POR				(0x00)
#define MSM8X10_WCD_A_RX_AUX_SW_CTL			(0x19B)
#define MSM8X10_WCD_A_RX_AUX_SW_CTL__POR				(0x00)
#define MSM8X10_WCD_A_RX_PA_AUX_IN_CONN			(0x19C)
#define MSM8X10_WCD_A_RX_PA_AUX_IN_CONN__POR				(0x00)
#define MSM8X10_WCD_A_RX_COM_TIMER_DIV			(0x19E)
#define MSM8X10_WCD_A_RX_COM_TIMER_DIV__POR				(0xE8)
#define MSM8X10_WCD_A_RX_COM_OCP_CTL			(0x19F)
#define MSM8X10_WCD_A_RX_COM_OCP_CTL__POR				(0x1F)
#define MSM8X10_WCD_A_RX_COM_OCP_COUNT			(0x1A0)
#define MSM8X10_WCD_A_RX_COM_OCP_COUNT__POR				(0x77)
#define MSM8X10_WCD_A_RX_COM_DAC_CTL			(0x1A1)
#define MSM8X10_WCD_A_RX_COM_DAC_CTL__POR				(0x00)
#define MSM8X10_WCD_A_RX_COM_BIAS			(0x1A2)
#define MSM8X10_WCD_A_RX_COM_BIAS__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_AUTO_CHOP			(0x1A4)
#define MSM8X10_WCD_A_RX_HPH_AUTO_CHOP__POR				(0x38)
#define MSM8X10_WCD_A_RX_HPH_CHOP_CTL			(0x1A5)
#define MSM8X10_WCD_A_RX_HPH_CHOP_CTL__POR				(0x34)
#define MSM8X10_WCD_A_RX_HPH_BIAS_PA			(0x1A6)
#define MSM8X10_WCD_A_RX_HPH_BIAS_PA__POR				(0x5A)
#define MSM8X10_WCD_A_RX_HPH_BIAS_LDO			(0x1A7)
#define MSM8X10_WCD_A_RX_HPH_BIAS_LDO__POR				(0x87)
#define MSM8X10_WCD_A_RX_HPH_BIAS_CNP			(0x1A8)
#define MSM8X10_WCD_A_RX_HPH_BIAS_CNP__POR				(0x8A)
#define MSM8X10_WCD_A_RX_HPH_BIAS_WG_OCP			(0x1A9)
#define MSM8X10_WCD_A_RX_HPH_BIAS_WG_OCP__POR				(0x2A)
#define MSM8X10_WCD_A_RX_HPH_OCP_CTL			(0x1AA)
#define MSM8X10_WCD_A_RX_HPH_OCP_CTL__POR				(0x69)
#define MSM8X10_WCD_A_RX_HPH_CNP_EN			(0x1AB)
#define MSM8X10_WCD_A_RX_HPH_CNP_EN__POR				(0x80)
#define MSM8X10_WCD_A_RX_HPH_CNP_WG_CTL			(0x1AC)
#define MSM8X10_WCD_A_RX_HPH_CNP_WG_CTL__POR				(0xDE)
#define MSM8X10_WCD_A_RX_HPH_CNP_WG_TIME			(0x1AD)
#define MSM8X10_WCD_A_RX_HPH_CNP_WG_TIME__POR				(0x15)
#define MSM8X10_WCD_A_RX_HPH_L_GAIN			(0x1AE)
#define MSM8X10_WCD_A_RX_HPH_L_GAIN__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_L_TEST			(0x1AF)
#define MSM8X10_WCD_A_RX_HPH_L_TEST__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_L_PA_CTL			(0x1B0)
#define MSM8X10_WCD_A_RX_HPH_L_PA_CTL__POR				(0x40)
#define MSM8X10_WCD_A_RX_HPH_L_DAC_CTL			(0x1B1)
#define MSM8X10_WCD_A_RX_HPH_L_DAC_CTL__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_L_ATEST			(0x1B2)
#define MSM8X10_WCD_A_RX_HPH_L_ATEST__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_L_STATUS			(0x1B3)
#define MSM8X10_WCD_A_RX_HPH_L_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_R_GAIN			(0x1B4)
#define MSM8X10_WCD_A_RX_HPH_R_GAIN__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_R_TEST			(0x1B5)
#define MSM8X10_WCD_A_RX_HPH_R_TEST__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_R_PA_CTL			(0x1B6)
#define MSM8X10_WCD_A_RX_HPH_R_PA_CTL__POR				(0x40)
#define MSM8X10_WCD_A_RX_HPH_R_DAC_CTL			(0x1B7)
#define MSM8X10_WCD_A_RX_HPH_R_DAC_CTL__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_R_ATEST			(0x1B8)
#define MSM8X10_WCD_A_RX_HPH_R_ATEST__POR				(0x00)
#define MSM8X10_WCD_A_RX_HPH_R_STATUS			(0x1B9)
#define MSM8X10_WCD_A_RX_HPH_R_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_RX_EAR_BIAS_PA			(0x1BA)
#define MSM8X10_WCD_A_RX_EAR_BIAS_PA__POR				(0x56)
#define MSM8X10_WCD_A_RX_EAR_BIAS_CMBUFF			(0x1BB)
#define MSM8X10_WCD_A_RX_EAR_BIAS_CMBUFF__POR				(0xA0)
#define MSM8X10_WCD_A_RX_EAR_EN			(0x1BC)
#define MSM8X10_WCD_A_RX_EAR_EN__POR				(0x00)
#define MSM8X10_WCD_A_RX_EAR_GAIN			(0x1BD)
#define MSM8X10_WCD_A_RX_EAR_GAIN__POR				(0x02)
#define MSM8X10_WCD_A_RX_EAR_CMBUFF			(0x1BE)
#define MSM8X10_WCD_A_RX_EAR_CMBUFF__POR				(0x05)
#define MSM8X10_WCD_A_RX_EAR_ICTL			(0x1BF)
#define MSM8X10_WCD_A_RX_EAR_ICTL__POR				(0x40)
#define MSM8X10_WCD_A_RX_EAR_CCOMP			(0x1C0)
#define MSM8X10_WCD_A_RX_EAR_CCOMP__POR				(0x08)
#define MSM8X10_WCD_A_RX_EAR_VCM			(0x1C1)
#define MSM8X10_WCD_A_RX_EAR_VCM__POR				(0x03)
#define MSM8X10_WCD_A_RX_EAR_CNP			(0x1C2)
#define MSM8X10_WCD_A_RX_EAR_CNP__POR				(0xF2)
#define MSM8X10_WCD_A_RX_EAR_DAC_CTL_ATEST			(0x1C3)
#define MSM8X10_WCD_A_RX_EAR_DAC_CTL_ATEST__POR				(0x00)
#define MSM8X10_WCD_A_RX_EAR_STATUS			(0x1C5)
#define MSM8X10_WCD_A_RX_EAR_STATUS__POR				(0x04)
#define MSM8X10_WCD_A_RX_LINE_BIAS_PA			(0x1C6)
#define MSM8X10_WCD_A_RX_LINE_BIAS_PA__POR				(0x58)
#define MSM8X10_WCD_A_RX_BUCK_BIAS1			(0x1C7)
#define MSM8X10_WCD_A_RX_BUCK_BIAS1__POR				(0x42)
#define MSM8X10_WCD_A_RX_BUCK_BIAS2			(0x1C8)
#define MSM8X10_WCD_A_RX_BUCK_BIAS2__POR				(0x84)
#define MSM8X10_WCD_A_RX_LINE_COM			(0x1C9)
#define MSM8X10_WCD_A_RX_LINE_COM__POR				(0x80)
#define MSM8X10_WCD_A_RX_LINE_CNP_EN			(0x1CA)
#define MSM8X10_WCD_A_RX_LINE_CNP_EN__POR				(0x00)
#define MSM8X10_WCD_A_RX_LINE_CNP_WG_CTL			(0x1CB)
#define MSM8X10_WCD_A_RX_LINE_CNP_WG_CTL__POR				(0x00)
#define MSM8X10_WCD_A_RX_LINE_CNP_WG_TIME			(0x1CC)
#define MSM8X10_WCD_A_RX_LINE_CNP_WG_TIME__POR				(0x04)
#define MSM8X10_WCD_A_RX_LINE_1_GAIN			(0x1CD)
#define MSM8X10_WCD_A_RX_LINE_1_GAIN__POR				(0x00)
#define MSM8X10_WCD_A_RX_LINE_1_TEST			(0x1CE)
#define MSM8X10_WCD_A_RX_LINE_1_TEST__POR				(0x00)
#define MSM8X10_WCD_A_RX_LINE_1_DAC_CTL			(0x1CF)
#define MSM8X10_WCD_A_RX_LINE_1_DAC_CTL__POR				(0x00)
#define MSM8X10_WCD_A_RX_LINE_1_STATUS			(0x1D0)
#define MSM8X10_WCD_A_RX_LINE_1_STATUS__POR				(0x00)
#define MSM8X10_WCD_A_RX_LINE_CNP_DBG			(0x1DD)
#define MSM8X10_WCD_A_RX_LINE_CNP_DBG__POR				(0x00)
#define MSM8X10_WCD_A_SPKR_DRV_EN			(0x1DF)
#define MSM8X10_WCD_A_SPKR_DRV_EN__POR				(0x6F)
#define MSM8X10_WCD_A_SPKR_DRV_GAIN			(0x1E0)
#define MSM8X10_WCD_A_SPKR_DRV_GAIN__POR				(0x00)
#define MSM8X10_WCD_A_SPKR_DRV_DAC_CTL			(0x1E1)
#define MSM8X10_WCD_A_SPKR_DRV_DAC_CTL__POR				(0x04)
#define MSM8X10_WCD_A_SPKR_DRV_OCP_CTL			(0x1E2)
#define MSM8X10_WCD_A_SPKR_DRV_OCP_CTL__POR				(0x98)
#define MSM8X10_WCD_A_SPKR_DRV_CLIP_DET			(0x1E3)
#define MSM8X10_WCD_A_SPKR_DRV_CLIP_DET__POR				(0x01)
#define MSM8X10_WCD_A_SPKR_DRV_IEC			(0x1E4)
#define MSM8X10_WCD_A_SPKR_DRV_IEC__POR				(0x00)
#define MSM8X10_WCD_A_SPKR_DRV_DBG_DAC			(0x1E5)
#define MSM8X10_WCD_A_SPKR_DRV_DBG_DAC__POR				(0x05)
#define MSM8X10_WCD_A_SPKR_DRV_DBG_PA			(0x1E6)
#define MSM8X10_WCD_A_SPKR_DRV_DBG_PA__POR				(0x18)
#define MSM8X10_WCD_A_SPKR_DRV_DBG_PWRSTG			(0x1E7)
#define MSM8X10_WCD_A_SPKR_DRV_DBG_PWRSTG__POR				(0x00)
#define MSM8X10_WCD_A_SPKR_DRV_BIAS_LDO			(0x1E8)
#define MSM8X10_WCD_A_SPKR_DRV_BIAS_LDO__POR				(0x45)
#define MSM8X10_WCD_A_SPKR_DRV_BIAS_INT			(0x1E9)
#define MSM8X10_WCD_A_SPKR_DRV_BIAS_INT__POR				(0xA5)
#define MSM8X10_WCD_A_SPKR_DRV_BIAS_PA			(0x1EA)
#define MSM8X10_WCD_A_SPKR_DRV_BIAS_PA__POR				(0x55)
#define MSM8X10_WCD_A_SPKR_DRV_STATUS_OCP			(0x1EB)
#define MSM8X10_WCD_A_SPKR_DRV_STATUS_OCP__POR				(0x00)
#define MSM8X10_WCD_A_SPKR_DRV_STATUS_PA			(0x1EC)
#define MSM8X10_WCD_A_SPKR_DRV_STATUS_PA__POR				(0x00)
#define MSM8X10_WCD_A_RC_OSC_FREQ			(0x1FA)
#define MSM8X10_WCD_A_RC_OSC_FREQ__POR				(0x46)
#define MSM8X10_WCD_A_RC_OSC_TEST			(0x1FB)
#define MSM8X10_WCD_A_RC_OSC_TEST__POR				(0x0A)
#define MSM8X10_WCD_A_RC_OSC_STATUS			(0x1FC)
#define MSM8X10_WCD_A_RC_OSC_STATUS__POR				(0x18)
#define MSM8X10_WCD_A_RC_OSC_TUNER			(0x1FD)
#define MSM8X10_WCD_A_RC_OSC_TUNER__POR				(0x00)
#define MSM8X10_WCD_A_MBHC_HPH			(0x1FE)
#define MSM8X10_WCD_A_MBHC_HPH__POR				(0x44)
#define MSM8X10_WCD_A_CDC_CLK_RX_RESET_CTL			(0x400)
#define MSM8X10_WCD_A_CDC_CLK_RX_RESET_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CLK_TX_RESET_B1_CTL			(0x404)
#define MSM8X10_WCD_A_CDC_CLK_TX_RESET_B1_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_CLK_DMIC_B1_CTL			(0x408)
#define MSM8X10_WCD_A_CDC_CLK_DMIC_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CLK_RX_I2S_CTL			(0x40C)
#define MSM8X10_WCD_A_CDC_CLK_RX_I2S_CTL__POR				(0x10)
#define MSM8X10_WCD_A_CDC_CLK_TX_I2S_CTL			(0x410)
#define MSM8X10_WCD_A_CDC_CLK_TX_I2S_CTL__POR				(0x10)
#define MSM8X10_WCD_A_CDC_CLK_OTHR_RESET_B1_CTL			(0x414)
#define MSM8X10_WCD_A_CDC_CLK_OTHR_RESET_B1_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_CLK_TX_CLK_EN_B1_CTL			(0x418)
#define MSM8X10_WCD_A_CDC_CLK_TX_CLK_EN_B1_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_CLK_OTHR_CTL			(0x41C)
#define MSM8X10_WCD_A_CDC_CLK_OTHR_CTL__POR				(0x04)
#define MSM8X10_WCD_A_CDC_CLK_RX_B1_CTL			(0x420)
#define MSM8X10_WCD_A_CDC_CLK_RX_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CLK_MCLK_CTL			(0x424)
#define MSM8X10_WCD_A_CDC_CLK_MCLK_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CLK_PDM_CTL			(0x428)
#define MSM8X10_WCD_A_CDC_CLK_PDM_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CLK_SD_CTL			(0x42C)
#define MSM8X10_WCD_A_CDC_CLK_SD_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX1_B1_CTL			(0x440)
#define MSM8X10_WCD_A_CDC_RX1_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX2_B1_CTL			(0x460)
#define MSM8X10_WCD_A_CDC_RX2_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX3_B1_CTL			(0x480)
#define MSM8X10_WCD_A_CDC_RX3_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX1_B2_CTL			(0x444)
#define MSM8X10_WCD_A_CDC_RX1_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX2_B2_CTL			(0x464)
#define MSM8X10_WCD_A_CDC_RX2_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX3_B2_CTL			(0x484)
#define MSM8X10_WCD_A_CDC_RX3_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX1_B3_CTL			(0x448)
#define MSM8X10_WCD_A_CDC_RX1_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX2_B3_CTL			(0x468)
#define MSM8X10_WCD_A_CDC_RX2_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX3_B3_CTL			(0x488)
#define MSM8X10_WCD_A_CDC_RX3_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX1_B4_CTL			(0x44C)
#define MSM8X10_WCD_A_CDC_RX1_B4_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX2_B4_CTL			(0x46C)
#define MSM8X10_WCD_A_CDC_RX2_B4_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX3_B4_CTL			(0x48C)
#define MSM8X10_WCD_A_CDC_RX3_B4_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX1_B5_CTL			(0x450)
#define MSM8X10_WCD_A_CDC_RX1_B5_CTL__POR				(0x68)
#define MSM8X10_WCD_A_CDC_RX2_B5_CTL			(0x470)
#define MSM8X10_WCD_A_CDC_RX2_B5_CTL__POR				(0x68)
#define MSM8X10_WCD_A_CDC_RX3_B5_CTL			(0x490)
#define MSM8X10_WCD_A_CDC_RX3_B5_CTL__POR				(0x68)
#define MSM8X10_WCD_A_CDC_RX1_B6_CTL			(0x454)
#define MSM8X10_WCD_A_CDC_RX1_B6_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX2_B6_CTL			(0x474)
#define MSM8X10_WCD_A_CDC_RX2_B6_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX3_B6_CTL			(0x494)
#define MSM8X10_WCD_A_CDC_RX3_B6_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B1_CTL			(0x458)
#define MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B1_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B1_CTL			(0x478)
#define MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B1_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B1_CTL			(0x498)
#define MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B1_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B2_CTL			(0x45C)
#define MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B2_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B2_CTL			(0x47C)
#define MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B2_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B2_CTL			(0x49C)
#define MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B2_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B1_CTL			(0x4A0)
#define MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B1_CTL__POR			(0x07)
#define MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B2_CTL			(0x4A4)
#define MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B2_CTL__POR			(0x13)
#define MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B3_CTL			(0x4A8)
#define MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B3_CTL__POR			(0x1B)
#define MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B4_CTL			(0x4AC)
#define MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B4_CTL__POR			(0x7F)
#define MSM8X10_WCD_A_CDC_CLSG_GAIN_THRESH_CTL			(0x4B0)
#define MSM8X10_WCD_A_CDC_CLSG_GAIN_THRESH_CTL__POR			(0x26)
#define MSM8X10_WCD_A_CDC_CLSG_TIMER_B1_CFG			(0x4B4)
#define MSM8X10_WCD_A_CDC_CLSG_TIMER_B1_CFG__POR			(0x0A)
#define MSM8X10_WCD_A_CDC_CLSG_TIMER_B2_CFG			(0x4B8)
#define MSM8X10_WCD_A_CDC_CLSG_TIMER_B2_CFG__POR			(0x00)
#define MSM8X10_WCD_A_CDC_CLSG_CTL			(0x4BC)
#define MSM8X10_WCD_A_CDC_CLSG_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TX1_VOL_CTL_TIMER			(0x4C0)
#define MSM8X10_WCD_A_CDC_TX1_VOL_CTL_TIMER__POR			(0x00)
#define MSM8X10_WCD_A_CDC_TX2_VOL_CTL_TIMER			(0x4E0)
#define MSM8X10_WCD_A_CDC_TX2_VOL_CTL_TIMER__POR			(0x00)
#define MSM8X10_WCD_A_CDC_TX1_VOL_CTL_GAIN			(0x4C4)
#define MSM8X10_WCD_A_CDC_TX1_VOL_CTL_GAIN__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TX2_VOL_CTL_GAIN			(0x4E4)
#define MSM8X10_WCD_A_CDC_TX2_VOL_CTL_GAIN__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TX1_VOL_CTL_CFG			(0x4C8)
#define MSM8X10_WCD_A_CDC_TX1_VOL_CTL_CFG__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TX2_VOL_CTL_CFG			(0x4E8)
#define MSM8X10_WCD_A_CDC_TX2_VOL_CTL_CFG__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TX1_MUX_CTL			(0x4CC)
#define MSM8X10_WCD_A_CDC_TX1_MUX_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TX2_MUX_CTL			(0x4EC)
#define MSM8X10_WCD_A_CDC_TX2_MUX_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TX1_CLK_FS_CTL			(0x4D0)
#define MSM8X10_WCD_A_CDC_TX1_CLK_FS_CTL__POR				(0x03)
#define MSM8X10_WCD_A_CDC_TX2_CLK_FS_CTL			(0x4F0)
#define MSM8X10_WCD_A_CDC_TX2_CLK_FS_CTL__POR				(0x03)
#define MSM8X10_WCD_A_CDC_TX1_DMIC_CTL			(0x4D4)
#define MSM8X10_WCD_A_CDC_TX1_DMIC_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TX2_DMIC_CTL			(0x4F4)
#define MSM8X10_WCD_A_CDC_TX2_DMIC_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B1_CTL			(0x500)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B1_CTL			(0x540)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B2_CTL			(0x504)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B2_CTL			(0x544)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B3_CTL			(0x508)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B3_CTL			(0x548)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B4_CTL			(0x50C)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B4_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B4_CTL			(0x54C)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B4_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B5_CTL			(0x510)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B5_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B5_CTL			(0x550)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B5_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B6_CTL			(0x514)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B6_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B6_CTL			(0x554)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B6_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B7_CTL			(0x518)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B7_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B7_CTL			(0x558)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B7_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B8_CTL			(0x51C)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_B8_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B8_CTL			(0x55C)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_B8_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_CTL			(0x520)
#define MSM8X10_WCD_A_CDC_IIR1_CTL__POR				(0x40)
#define MSM8X10_WCD_A_CDC_IIR2_CTL			(0x560)
#define MSM8X10_WCD_A_CDC_IIR2_CTL__POR				(0x40)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_TIMER_CTL			(0x524)
#define MSM8X10_WCD_A_CDC_IIR1_GAIN_TIMER_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_TIMER_CTL			(0x564)
#define MSM8X10_WCD_A_CDC_IIR2_GAIN_TIMER_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_COEF_B1_CTL			(0x528)
#define MSM8X10_WCD_A_CDC_IIR1_COEF_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_COEF_B1_CTL			(0x568)
#define MSM8X10_WCD_A_CDC_IIR2_COEF_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR1_COEF_B2_CTL			(0x52C)
#define MSM8X10_WCD_A_CDC_IIR1_COEF_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_IIR2_COEF_B2_CTL			(0x56C)
#define MSM8X10_WCD_A_CDC_IIR2_COEF_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX1_B1_CTL			(0x580)
#define MSM8X10_WCD_A_CDC_CONN_RX1_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX1_B2_CTL			(0x584)
#define MSM8X10_WCD_A_CDC_CONN_RX1_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX1_B3_CTL			(0x588)
#define MSM8X10_WCD_A_CDC_CONN_RX1_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX2_B1_CTL			(0x58C)
#define MSM8X10_WCD_A_CDC_CONN_RX2_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX2_B2_CTL			(0x590)
#define MSM8X10_WCD_A_CDC_CONN_RX2_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX2_B3_CTL			(0x594)
#define MSM8X10_WCD_A_CDC_CONN_RX2_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX3_B1_CTL			(0x598)
#define MSM8X10_WCD_A_CDC_CONN_RX3_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_RX3_B2_CTL			(0x59C)
#define MSM8X10_WCD_A_CDC_CONN_RX3_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_TX_B1_CTL			(0x5A4)
#define MSM8X10_WCD_A_CDC_CONN_TX_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_EQ1_B1_CTL			(0x5A8)
#define MSM8X10_WCD_A_CDC_CONN_EQ1_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_EQ1_B2_CTL			(0x5AC)
#define MSM8X10_WCD_A_CDC_CONN_EQ1_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_EQ1_B3_CTL			(0x5B0)
#define MSM8X10_WCD_A_CDC_CONN_EQ1_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_EQ1_B4_CTL			(0x5B4)
#define MSM8X10_WCD_A_CDC_CONN_EQ1_B4_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_EQ2_B1_CTL			(0x5B8)
#define MSM8X10_WCD_A_CDC_CONN_EQ2_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_EQ2_B2_CTL			(0x5BC)
#define MSM8X10_WCD_A_CDC_CONN_EQ2_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_EQ2_B3_CTL			(0x5C0)
#define MSM8X10_WCD_A_CDC_CONN_EQ2_B3_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_EQ2_B4_CTL			(0x5C4)
#define MSM8X10_WCD_A_CDC_CONN_EQ2_B4_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_CONN_TX_I2S_SD1_CTL			(0x5C8)
#define MSM8X10_WCD_A_CDC_CONN_TX_I2S_SD1_CTL__POR			(0x00)
#define MSM8X10_WCD_A_CDC_TOP_GAIN_UPDATE			(0x5D0)
#define MSM8X10_WCD_A_CDC_TOP_GAIN_UPDATE__POR				(0x00)
#define MSM8X10_WCD_A_CDC_TOP_CTL			(0x5D8)
#define MSM8X10_WCD_A_CDC_TOP_CTL__POR				(0x01)
#define MSM8X10_WCD_A_CDC_DEBUG_DESER1_CTL			(0x5E0)
#define MSM8X10_WCD_A_CDC_DEBUG_DESER1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_DEBUG_DESER2_CTL			(0x5E4)
#define MSM8X10_WCD_A_CDC_DEBUG_DESER2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_DEBUG_B1_CTL			(0x5E8)
#define MSM8X10_WCD_A_CDC_DEBUG_B1_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_DEBUG_B2_CTL			(0x5EC)
#define MSM8X10_WCD_A_CDC_DEBUG_B2_CTL__POR				(0x00)
#define MSM8X10_WCD_A_CDC_DEBUG_B3_CTL			(0x5F0)
#define MSM8X10_WCD_A_CDC_DEBUG_B3_CTL__POR				(0x00)
#endif
