/* ----------------------------------------------------------------------
    This is the

    ██╗     ██╗ ██████╗  ██████╗  ██████╗ ██╗  ██╗████████╗███████╗
    ██║     ██║██╔════╝ ██╔════╝ ██╔════╝ ██║  ██║╚══██╔══╝██╔════╝
    ██║     ██║██║  ███╗██║  ███╗██║  ███╗███████║   ██║   ███████╗
    ██║     ██║██║   ██║██║   ██║██║   ██║██╔══██║   ██║   ╚════██║
    ███████╗██║╚██████╔╝╚██████╔╝╚██████╔╝██║  ██║   ██║   ███████║
    ╚══════╝╚═╝ ╚═════╝  ╚═════╝  ╚═════╝ ╚═╝  ╚═╝   ╚═╝   ╚══════╝®

    DEM simulation engine, released by
    DCS Computing Gmbh, Linz, Austria
    http://www.dcs-computing.com, office@dcs-computing.com

    LIGGGHTS® is part of CFDEM®project:
    http://www.liggghts.com | http://www.cfdem.com

    Core developer and main author:
    Christoph Kloss, christoph.kloss@dcs-computing.com

    LIGGGHTS® is open-source, distributed under the terms of the GNU Public
    License, version 2 or later. It is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. You should have
    received a copy of the GNU General Public License along with LIGGGHTS®.
    If not, see http://www.gnu.org/licenses . See also top-level README
    and LICENSE files.

    LIGGGHTS® and CFDEM® are registered trade marks of DCS Computing GmbH,
    the producer of the LIGGGHTS® software and the CFDEM®coupling software
    See http://www.cfdem.com/terms-trademark-policy for details.

-------------------------------------------------------------------------
    Contributing author and copyright for this file:

    Stefan Radl (TU Graz)

    Copyright 2014-     TU Graz
------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------
   Description
    Fix for to deform a box, but ensures that it is initialized AFTER
    the fix 'contacthistory' (if any). This is to avoid troubles with
    contacthistory when flipping the box.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(deform/check,FixDeformCheck)

#else

#ifndef LMP_FIX_DEFORM_CHECK_H
#define LMP_FIX_DEFORM_CHECK_H

#include "fix_deform.h"

namespace LAMMPS_NS {

class FixDeformCheck : public FixDeform {
 public:

  FixDeformCheck(class LAMMPS *, int, char **);
  ~FixDeformCheck();
  void init();

 private:

  int  iContactHist_;
  bool noProblem_;
};

}

#endif
#endif
