#ifndef STRINGF_H
#define STRINGF_H

#include <string>

#ifndef ATTR_PRINTF
 #ifdef GCC
  #define ATTR_PRINTF(string, first) __attribute__((format (printf, string, first)))
 #else
  #define ATTR_PRINTF(string, first)
 #endif
#endif

namespace stringf
{
	/// Format the printf-style arguments and add the result to `str'
	int addf(std::string& str, const char* fmt, ...) throw() ATTR_PRINTF(2, 3);

	/// Format the printf-style arguments and return the result as a string 
	std::string fmt(const char* fmt, ...) throw() ATTR_PRINTF(1, 2);

	std::string fmt(int val) throw ();
	std::string fmt(unsigned int val) throw ();
	std::string fmt(long int val) throw ();
	std::string fmt(long unsigned int val) throw ();
};

/// Pass a string to a printf-like function for a %.*s argument
#define PFSTR(str) (int)(str).size(), (str).data()

// vim:set ts=4 sw=4:
#endif
