package latexDraw.parsers.svg.elements.path;

/**
 * Defines the SVGPath horizontal lineto segment.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/20/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1
 */
public class SVGPathSegLinetoHorizontal extends SVGPathSegLineto
{
	/**
	 * The main constructor.
	 * @param x The X-coordinate of the second point of the line.
	 * @param isRelative isRelative True: the path segment is relative, false it is absolute.
	 */
	public SVGPathSegLinetoHorizontal(double x, boolean isRelative)
	{
		super(x, x, isRelative);
	}
	
	
	@Override
	public String toString()
	{
		StringBuffer stringBuffer = new StringBuffer();
		
		stringBuffer.append((isRelative() ? "h" : "H"));//$NON-NLS-1$//$NON-NLS-2$
		stringBuffer.append(' ');
		stringBuffer.append(x);
		
		return stringBuffer.toString() ;
	}
	
	
	@Override
	public PathSeg getType()
	{
		return isRelative() ? PathSeg.LINETO_HORIZONTAL_REL : PathSeg.LINETO_HORIZONTAL_ABS;
	}

	
	@Override
	public double getY()
	{
		return getX();
	}
}
