
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaObject.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaObject>
#include <QChildEvent>
#include <QEvent>
#include <QMediaService>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaObject

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaObject::staticMetaObject);
}


// QMultimedia::AvailabilityStatus QMediaObject::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QMediaObject *)cls)->availability ()));
}


// void QMediaObject::availabilityChanged(bool available)


static void _init_f_availabilityChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_availabilityChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject *)cls)->availabilityChanged (arg1);
}


// void QMediaObject::availabilityChanged(QMultimedia::AvailabilityStatus availability)


static void _init_f_availabilityChanged_3555 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("availability");
  decl->add_arg<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_availabilityChanged_3555 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject *)cls)->availabilityChanged (qt_gsi::QtToCppAdaptor<QMultimedia::AvailabilityStatus>(arg1).cref());
}


// QStringList QMediaObject::availableMetaData()


static void _init_f_availableMetaData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_availableMetaData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QMediaObject *)cls)->availableMetaData ());
}


// bool QMediaObject::bind(QObject *)


static void _init_f_bind_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_bind_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<bool > ((bool)((QMediaObject *)cls)->bind (arg1));
}


// bool QMediaObject::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaObject *)cls)->isAvailable ());
}


// bool QMediaObject::isMetaDataAvailable()


static void _init_f_isMetaDataAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMetaDataAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaObject *)cls)->isMetaDataAvailable ());
}


// QVariant QMediaObject::metaData(const QString &key)


static void _init_f_metaData_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_metaData_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QMediaObject *)cls)->metaData (arg1));
}


// void QMediaObject::metaDataAvailableChanged(bool available)


static void _init_f_metaDataAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_metaDataAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject *)cls)->metaDataAvailableChanged (arg1);
}


// void QMediaObject::metaDataChanged()


static void _init_f_metaDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_metaDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject *)cls)->metaDataChanged ();
}


// void QMediaObject::metaDataChanged(const QString &key, const QVariant &value)


static void _init_f_metaDataChanged_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_metaDataChanged_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject *)cls)->metaDataChanged (arg1, arg2);
}


// int QMediaObject::notifyInterval()


static void _init_f_notifyInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_notifyInterval_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaObject *)cls)->notifyInterval ());
}


// void QMediaObject::notifyIntervalChanged(int milliSeconds)


static void _init_f_notifyIntervalChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("milliSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_notifyIntervalChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject *)cls)->notifyIntervalChanged (arg1);
}


// QMediaService *QMediaObject::service()


static void _init_f_service_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaService * > ();
}

static void _call_f_service_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaService * > ((QMediaService *)((QMediaObject *)cls)->service ());
}


// void QMediaObject::setNotifyInterval(int milliSeconds)


static void _init_f_setNotifyInterval_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("milliSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNotifyInterval_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject *)cls)->setNotifyInterval (arg1);
}


// void QMediaObject::unbind(QObject *)


static void _init_f_unbind_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unbind_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject *)cls)->unbind (arg1);
}


// static QString QMediaObject::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaObject::tr (arg1, arg2, arg3));
}


// static QString QMediaObject::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaObject::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaObject () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QMediaObject::availability()\n", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod ("availabilityChanged_bool", "@brief Method void QMediaObject::availabilityChanged(bool available)\n", false, &_init_f_availabilityChanged_864, &_call_f_availabilityChanged_864);
  methods += new qt_gsi::GenericMethod ("availabilityChanged_status", "@brief Method void QMediaObject::availabilityChanged(QMultimedia::AvailabilityStatus availability)\n", false, &_init_f_availabilityChanged_3555, &_call_f_availabilityChanged_3555);
  methods += new qt_gsi::GenericMethod ("availableMetaData", "@brief Method QStringList QMediaObject::availableMetaData()\n", true, &_init_f_availableMetaData_c0, &_call_f_availableMetaData_c0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Method bool QMediaObject::bind(QObject *)\n", false, &_init_f_bind_1302, &_call_f_bind_1302);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QMediaObject::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isMetaDataAvailable?", "@brief Method bool QMediaObject::isMetaDataAvailable()\n", true, &_init_f_isMetaDataAvailable_c0, &_call_f_isMetaDataAvailable_c0);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Method QVariant QMediaObject::metaData(const QString &key)\n", true, &_init_f_metaData_c2025, &_call_f_metaData_c2025);
  methods += new qt_gsi::GenericMethod ("metaDataAvailableChanged", "@brief Method void QMediaObject::metaDataAvailableChanged(bool available)\n", false, &_init_f_metaDataAvailableChanged_864, &_call_f_metaDataAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("metaDataChanged", "@brief Method void QMediaObject::metaDataChanged()\n", false, &_init_f_metaDataChanged_0, &_call_f_metaDataChanged_0);
  methods += new qt_gsi::GenericMethod ("metaDataChanged_kv", "@brief Method void QMediaObject::metaDataChanged(const QString &key, const QVariant &value)\n", false, &_init_f_metaDataChanged_4036, &_call_f_metaDataChanged_4036);
  methods += new qt_gsi::GenericMethod (":notifyInterval", "@brief Method int QMediaObject::notifyInterval()\n", true, &_init_f_notifyInterval_c0, &_call_f_notifyInterval_c0);
  methods += new qt_gsi::GenericMethod ("notifyIntervalChanged", "@brief Method void QMediaObject::notifyIntervalChanged(int milliSeconds)\n", false, &_init_f_notifyIntervalChanged_767, &_call_f_notifyIntervalChanged_767);
  methods += new qt_gsi::GenericMethod ("service", "@brief Method QMediaService *QMediaObject::service()\n", true, &_init_f_service_c0, &_call_f_service_c0);
  methods += new qt_gsi::GenericMethod ("setNotifyInterval|notifyInterval=", "@brief Method void QMediaObject::setNotifyInterval(int milliSeconds)\n", false, &_init_f_setNotifyInterval_767, &_call_f_setNotifyInterval_767);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Method void QMediaObject::unbind(QObject *)\n", false, &_init_f_unbind_1302, &_call_f_unbind_1302);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaObject::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMediaObject::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QMediaObject> decl_QMediaObject (qtdecl_QObject (), "QtMultimedia", "QMediaObject_Native",
  methods_QMediaObject (),
  "@hide\n@alias QMediaObject");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaObject> &qtdecl_QMediaObject () { return decl_QMediaObject; }

}


class QMediaObject_Adaptor : public QMediaObject, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaObject_Adaptor();

  //  [expose] void QMediaObject::addPropertyWatch(QByteArray const &name)
  void fp_QMediaObject_addPropertyWatch_2309 (QByteArray const &name) {
    QMediaObject::addPropertyWatch(name);
  }

  //  [expose] bool QMediaObject::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaObject_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaObject::isSignalConnected(signal);
  }

  //  [expose] int QMediaObject::receivers(const char *signal)
  int fp_QMediaObject_receivers_c1731 (const char *signal) const {
    return QMediaObject::receivers(signal);
  }

  //  [expose] void QMediaObject::removePropertyWatch(QByteArray const &name)
  void fp_QMediaObject_removePropertyWatch_2309 (QByteArray const &name) {
    QMediaObject::removePropertyWatch(name);
  }

  //  [expose] QObject *QMediaObject::sender()
  QObject * fp_QMediaObject_sender_c0 () const {
    return QMediaObject::sender();
  }

  //  [expose] int QMediaObject::senderSignalIndex()
  int fp_QMediaObject_senderSignalIndex_c0 () const {
    return QMediaObject::senderSignalIndex();
  }

  //  [adaptor impl] QMultimedia::AvailabilityStatus QMediaObject::availability()
  qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type cbs_availability_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(QMediaObject::availability());
  }

  virtual QMultimedia::AvailabilityStatus availability() const
  {
    if (cb_availability_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMultimedia::AvailabilityStatus>(cb_availability_c0_0.issue<QMediaObject_Adaptor, qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type>(&QMediaObject_Adaptor::cbs_availability_c0_0)).cref();
    } else {
      return QMediaObject::availability();
    }
  }

  //  [adaptor impl] bool QMediaObject::bind(QObject *)
  bool cbs_bind_1302_0(QObject *arg1)
  {
    return QMediaObject::bind(arg1);
  }

  virtual bool bind(QObject *arg1)
  {
    if (cb_bind_1302_0.can_issue()) {
      return cb_bind_1302_0.issue<QMediaObject_Adaptor, bool, QObject *>(&QMediaObject_Adaptor::cbs_bind_1302_0, arg1);
    } else {
      return QMediaObject::bind(arg1);
    }
  }

  //  [adaptor impl] bool QMediaObject::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QMediaObject::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaObject_Adaptor, bool, QEvent *>(&QMediaObject_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QMediaObject::event(arg1);
    }
  }

  //  [adaptor impl] bool QMediaObject::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMediaObject::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaObject_Adaptor, bool, QObject *, QEvent *>(&QMediaObject_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMediaObject::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QMediaObject::isAvailable()
  bool cbs_isAvailable_c0_0() const
  {
    return QMediaObject::isAvailable();
  }

  virtual bool isAvailable() const
  {
    if (cb_isAvailable_c0_0.can_issue()) {
      return cb_isAvailable_c0_0.issue<QMediaObject_Adaptor, bool>(&QMediaObject_Adaptor::cbs_isAvailable_c0_0);
    } else {
      return QMediaObject::isAvailable();
    }
  }

  //  [adaptor impl] QMediaService *QMediaObject::service()
  QMediaService * cbs_service_c0_0() const
  {
    return QMediaObject::service();
  }

  virtual QMediaService * service() const
  {
    if (cb_service_c0_0.can_issue()) {
      return cb_service_c0_0.issue<QMediaObject_Adaptor, QMediaService *>(&QMediaObject_Adaptor::cbs_service_c0_0);
    } else {
      return QMediaObject::service();
    }
  }

  //  [adaptor impl] void QMediaObject::unbind(QObject *)
  void cbs_unbind_1302_0(QObject *arg1)
  {
    QMediaObject::unbind(arg1);
  }

  virtual void unbind(QObject *arg1)
  {
    if (cb_unbind_1302_0.can_issue()) {
      cb_unbind_1302_0.issue<QMediaObject_Adaptor, QObject *>(&QMediaObject_Adaptor::cbs_unbind_1302_0, arg1);
    } else {
      QMediaObject::unbind(arg1);
    }
  }

  //  [adaptor impl] void QMediaObject::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMediaObject::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaObject_Adaptor, QChildEvent *>(&QMediaObject_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMediaObject::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaObject::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMediaObject::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaObject_Adaptor, QEvent *>(&QMediaObject_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMediaObject::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaObject::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaObject::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaObject_Adaptor, const QMetaMethod &>(&QMediaObject_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaObject::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaObject::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMediaObject::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaObject_Adaptor, QTimerEvent *>(&QMediaObject_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMediaObject::timerEvent(arg1);
    }
  }

  gsi::Callback cb_availability_c0_0;
  gsi::Callback cb_bind_1302_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAvailable_c0_0;
  gsi::Callback cb_service_c0_0;
  gsi::Callback cb_unbind_1302_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaObject_Adaptor::~QMediaObject_Adaptor() { }

// exposed void QMediaObject::addPropertyWatch(QByteArray const &name)

static void _init_fp_addPropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addPropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject_Adaptor *)cls)->fp_QMediaObject_addPropertyWatch_2309 (arg1);
}


// QMultimedia::AvailabilityStatus QMediaObject::availability()

static void _init_cbs_availability_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_cbs_availability_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)((QMediaObject_Adaptor *)cls)->cbs_availability_c0_0 ());
}

static void _set_callback_cbs_availability_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_availability_c0_0 = cb;
}


// bool QMediaObject::bind(QObject *)

static void _init_cbs_bind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_bind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<bool > ((bool)((QMediaObject_Adaptor *)cls)->cbs_bind_1302_0 (arg1));
}

static void _set_callback_cbs_bind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_bind_1302_0 = cb;
}


// void QMediaObject::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaObject::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QMediaObject::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QMediaObject::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaObject_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaObject::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaObject_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QMediaObject::isAvailable()

static void _init_cbs_isAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaObject_Adaptor *)cls)->cbs_isAvailable_c0_0 ());
}

static void _set_callback_cbs_isAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_isAvailable_c0_0 = cb;
}


// exposed bool QMediaObject::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaObject_Adaptor *)cls)->fp_QMediaObject_isSignalConnected_c2394 (arg1));
}


// exposed int QMediaObject::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaObject_Adaptor *)cls)->fp_QMediaObject_receivers_c1731 (arg1));
}


// exposed void QMediaObject::removePropertyWatch(QByteArray const &name)

static void _init_fp_removePropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_removePropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject_Adaptor *)cls)->fp_QMediaObject_removePropertyWatch_2309 (arg1);
}


// exposed QObject *QMediaObject::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaObject_Adaptor *)cls)->fp_QMediaObject_sender_c0 ());
}


// exposed int QMediaObject::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaObject_Adaptor *)cls)->fp_QMediaObject_senderSignalIndex_c0 ());
}


// QMediaService *QMediaObject::service()

static void _init_cbs_service_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaService * > ();
}

static void _call_cbs_service_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaService * > ((QMediaService *)((QMediaObject_Adaptor *)cls)->cbs_service_c0_0 ());
}

static void _set_callback_cbs_service_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_service_c0_0 = cb;
}


// void QMediaObject::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QMediaObject::unbind(QObject *)

static void _init_cbs_unbind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unbind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaObject_Adaptor *)cls)->cbs_unbind_1302_0 (arg1);
}

static void _set_callback_cbs_unbind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaObject_Adaptor *)cls)->cb_unbind_1302_0 = cb;
}


namespace gsi
{

gsi::Class<QMediaObject> &qtdecl_QMediaObject ();

static gsi::Methods methods_QMediaObject_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("*addPropertyWatch", "@brief Method void QMediaObject::addPropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addPropertyWatch_2309, &_call_fp_addPropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Virtual method QMultimedia::AvailabilityStatus QMediaObject::availability()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("availability", "@hide", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0, &_set_callback_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Virtual method bool QMediaObject::bind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("bind", "@hide", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0, &_set_callback_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaObject::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaObject::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaObject::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaObject::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaObject::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@brief Virtual method bool QMediaObject::isAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@hide", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0, &_set_callback_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaObject::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaObject::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removePropertyWatch", "@brief Method void QMediaObject::removePropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removePropertyWatch_2309, &_call_fp_removePropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaObject::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaObject::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("service", "@brief Virtual method QMediaService *QMediaObject::service()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("service", "@hide", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0, &_set_callback_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaObject::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Virtual method void QMediaObject::unbind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@hide", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0, &_set_callback_cbs_unbind_1302_0);
  return methods;
}

gsi::Class<QMediaObject_Adaptor> decl_QMediaObject_Adaptor (qtdecl_QMediaObject (), "QtMultimedia", "QMediaObject",
  methods_QMediaObject_Adaptor (),
  "@qt\n@brief Binding of QMediaObject");

}

