TEMPLATE = app
DEPENDPATH += . src
INCLUDEPATH += .
CONFIG += thread
RESOURCES += kitsune.qrc

# Definition des configurations de compilation
win32 {
	DEFINES += WINDOWS
	RC_FILE = kitsuneico.rc
	CONFIG += static
}

unix {
	DEFINES += LINUX
	TARGET = bin/kitsune
	CONFIG += static
}

macx {
	DEFINES += MACX
	RC_FILE = kitsune.icns
	CONFIG += x86 ppc
	CONFIG += static
}

#choisir un mode de compilation parmi release, test, debug ou profil
CONFIG += release

profil {
	CONFIG += debug
	QMAKE_CXXFLAGS_DEBUG += -pg
	QMAKE_LFLAGS_DEBUG += -pg
}

# utilisation du flag TEST dans les fichiers lors de la config test
test {
	CONFIG += release
	DEFINES += TEST
}

# Input
HEADERS += src/calcul.h \
           src/jeu.h \
           src/tirage.h \
           src/global.h \
           src/widgethorloge.h \
           src/widgetoperation.h \
           src/widgetoptions.h \
           src/widgetpopup.h \
           src/widgetplaque.h \
           src/widgetprincipal.h \
           src/widgetresolution.h
SOURCES += src/calcul.cpp \
           src/jeu.cpp \
           src/kitsune.cpp \
           src/tirage.cpp \
           src/global.cpp \
           src/widgethorloge.cpp \
           src/widgetoperation.cpp \
           src/widgetoptions.cpp \
           src/widgetpopup.cpp \
           src/widgetplaque.cpp \
           src/widgetprincipal.cpp \
           src/widgetresolution.cpp

#liste des fichiers de traductions pour lupdate
TRANSLATIONS = kitsune_en.ts \
               kitsune_ja.ts

isEmpty(PREFIX) {
        PREFIX = /usr
}
isEmpty(I18NDIR) {
        I18NDIR = $${PREFIX}/share/kitsune/i18n
}

target.path      = $${PREFIX}/bin
i18n.files       = kitsune_en.qm kitsune_ja.qm
i18n.path        = $$I18NDIR

INSTALLS        += target i18n
