/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.awt.AWTPermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.Permissions;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Hashtable;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.Main;

public class KJASSecurityManager
extends SecurityManager {
    static Hashtable confirmRequests = new Hashtable();
    static int confirmId = 0;
    Hashtable grantedPermissions = new Hashtable();
    HashSet grantAllPermissions = new HashSet();
    HashSet rejectAllPermissions = new HashSet();
    private static final char[] base64table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    static String encode64(byte[] byArray) {
        byte by;
        byte by2;
        StringBuffer stringBuffer = new StringBuffer(4 * ((byArray.length + 2) / 3));
        int n = 0;
        while (n < byArray.length - 2) {
            by2 = byArray[n++];
            by = byArray[n++];
            byte by3 = byArray[n++];
            stringBuffer.append(base64table[by2 >>> 2 & 0x3F]);
            stringBuffer.append(base64table[by2 << 4 & 0x30 | by >>> 4 & 0xF]);
            stringBuffer.append(base64table[by << 2 & 0x3C | by3 >>> 6 & 3]);
            stringBuffer.append(base64table[by3 & 0x3F]);
        }
        if (n < byArray.length) {
            by2 = byArray[n++];
            stringBuffer.append(base64table[by2 >>> 2 & 0x3F]);
            if (n < byArray.length) {
                by = byArray[n++];
                stringBuffer.append(base64table[by2 << 4 & 0x30 | by >>> 4 & 0xF]);
                stringBuffer.append(base64table[by << 2 & 0x3C]);
            } else {
                stringBuffer.append(base64table[by2 << 4 & 0x30]);
                stringBuffer.append("=");
            }
            stringBuffer.append('=');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermission(Permission permission) throws SecurityException, NullPointerException {
        block24: {
            try {
                super.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                int n;
                Object[] objectArray;
                if (permission instanceof AWTPermission) {
                    throw securityException;
                }
                HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
                Class<?>[] classArray = this.getClassContext();
                for (int i = 1; i < classArray.length; ++i) {
                    objectArray = classArray[i].getSigners();
                    if (objectArray == null || objectArray.length <= 0) continue;
                    for (n = 0; n < objectArray.length; ++n) {
                        if (!(objectArray[n] instanceof X509Certificate)) continue;
                        hashSet.add((X509Certificate)objectArray[n]);
                    }
                }
                Main.debug("Certificates " + hashSet.size() + " for " + permission);
                if (this.grantAllPermissions.contains(hashSet)) {
                    return;
                }
                if (this.rejectAllPermissions.contains(hashSet)) {
                    throw securityException;
                }
                Permissions permissions = (Permissions)this.grantedPermissions.get(hashSet);
                if (permissions != null && permissions.implies(permission)) {
                    return;
                }
                objectArray = new String[hashSet.size()];
                n = 0;
                Object object = hashSet.iterator();
                while (object.hasNext()) {
                    try {
                        objectArray[n] = KJASSecurityManager.encode64(((X509Certificate)object.next()).getEncoded());
                        ++n;
                    }
                    catch (CertificateEncodingException certificateEncodingException) {}
                }
                if (n == 0) {
                    throw securityException;
                }
                object = "" + confirmId++;
                confirmRequests.put(object, Thread.currentThread());
                Main.protocol.sendSecurityConfirm((String[])objectArray, n, permission.toString(), (String)object);
                boolean bl = false;
                try {
                    Thread.currentThread();
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                    if (((String)confirmRequests.get(object)).equals("yes")) {
                        bl = true;
                        permissions = (Permissions)this.grantedPermissions.get(hashSet);
                        if (permissions == null) {
                            permissions = new Permissions();
                            this.grantedPermissions.put(hashSet, permissions);
                        }
                        permissions.add(permission);
                    } else if (((String)confirmRequests.get(object)).equals("grant")) {
                        this.grantAllPermissions.add(hashSet);
                        bl = true;
                    } else if (((String)confirmRequests.get(object)).equals("reject")) {
                        this.rejectAllPermissions.add(hashSet);
                    }
                }
                finally {
                    confirmRequests.remove(object);
                }
                if (bl) break block24;
                Main.debug("Permission denied" + permission);
                throw securityException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disabled___checkPermission(Permission permission) throws SecurityException, NullPointerException {
        Object object = this.getSecurityContext();
        Thread thread = Thread.currentThread();
        if (permission instanceof SocketPermission) {
            block7: {
                Main.debug("*** checkPermission " + permission + " in context=" + object + " Thread=" + thread);
                ClassLoader classLoader = thread.getContextClassLoader();
                Main.debug("*   ClassLoader=" + classLoader);
                try {
                    KJASAppletClassLoader kJASAppletClassLoader = (KJASAppletClassLoader)classLoader;
                    URL uRL = kJASAppletClassLoader.getCodeBase();
                    URL uRL2 = kJASAppletClassLoader.getDocBase();
                    Main.debug("*   Class Loader docbase=" + uRL2 + " codebase=" + uRL);
                    String string = permission.getName();
                    int n = string.indexOf(58);
                    if (n > 0) {
                        string = string.substring(0, n);
                    }
                    if (KJASSecurityManager.hostsAreEqual(string, uRL.getHost())) {
                        String string2 = permission.getActions();
                        if (string2 != null && string2.indexOf("listen") >= 0) {
                            Main.debug("*   Listen is not allowed.");
                            break block7;
                        } else {
                            Main.debug("*   Hostname equals. Permission granted.");
                            return;
                        }
                    }
                    Main.info("Host mismatch: " + permission + " != " + uRL.getHost());
                }
                catch (ClassCastException classCastException) {
                    Main.debug("*   ClassLoader is not a KJASAppletClassLoader");
                }
            }
            Main.debug("*   Fall through to super.checkPermission()");
        }
        super.checkPermission(permission);
    }

    private static final boolean hostsAreEqual(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (Main.proxyHost != null && Main.proxyPort != 0) {
            return false;
        }
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            Main.kjas_err("Unknown host:" + string, unknownHostException);
            return false;
        }
        try {
            inetAddress2 = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            Main.kjas_err("Unknown host:" + string2, unknownHostException);
            return false;
        }
        return inetAddress.equals(inetAddress2);
    }
}

