# Test to ensure that none of our filenames exceed 90 characters in length (causes portability issues with tar)

SET(ERROR_COUNT 0)
SET(MAX_LENGTH 90)
SET(SKIP_FILES
	"^[.]hg/.*$"
  "^.*[.]svn/.*$"
	)

FILE(GLOB_RECURSE SOURCE_FILES *)
LIST(SORT SOURCE_FILES)

FOREACH(SOURCE_FILE ${SOURCE_FILES})
	FILE(RELATIVE_PATH RELATIVE_SOURCE_FILE ${CMAKE_CURRENT_SOURCE_DIR} ${SOURCE_FILE})

	SET(TEST_FILE 1)
	FOREACH(SKIP_FILE ${SKIP_FILES})
		IF(RELATIVE_SOURCE_FILE MATCHES "${SKIP_FILE}")
			SET(TEST_FILE 0)
		ENDIF()
	ENDFOREACH()

	IF(TEST_FILE)
		STRING(LENGTH ${RELATIVE_SOURCE_FILE} FILENAME_LENGTH)

		IF(FILENAME_LENGTH GREATER ${MAX_LENGTH})
			MATH(EXPR ERROR_COUNT "${ERROR_COUNT} + 1")
			MESSAGE("${RELATIVE_SOURCE_FILE} too long [${FILENAME_LENGTH} chars]")
		ENDIF()
	ENDIF()
ENDFOREACH()

IF(ERROR_COUNT)
	MESSAGE(SEND_ERROR "Found ${ERROR_COUNT} filenames longer than ${MAX_LENGTH} characters, which can cause portability problems with tar.")
ENDIF(ERROR_COUNT)

