/*
 *    Copyright 2008 Christian Stussak
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.mfo.jsurf.algebra;

public class PolynomialVariable implements PolynomialOperation
{
    public enum Var { x, y, z; }
    private Var variable;
    private boolean hasParentheses;

    public PolynomialVariable( Var variable )
    {
        this( variable, false );
    }

    public PolynomialVariable( Var variable, boolean hasParentheses )
    {
        this.variable = variable;
        this.hasParentheses = hasParentheses;
    }

    public Var getVariable() { return variable; }
    public boolean hasParentheses() { return hasParentheses; }

    public < RETURN_TYPE, PARAM_TYPE > RETURN_TYPE accept( Visitor< RETURN_TYPE, PARAM_TYPE > visitor, PARAM_TYPE arg )
    {
        return visitor.visit( this, arg );
    }
}
