/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.elements.impl;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.elements.impl.AbstractEntryElement;
import org.intabulas.sandler.elements.impl.ContentImpl;
import org.intabulas.sandler.elements.impl.LinkImpl;
import org.intabulas.sandler.elements.impl.PersonImpl;
import org.intabulas.sandler.util.SandlerUtilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class EntryImpl
extends AbstractEntryElement
implements Entry,
AtomElement {
    private Date _created;
    private Date _issued;
    private List _contentList = new ArrayList(1);

    public Content getSummary() {
        return this._summary;
    }

    public void setSummary(Content summary) {
        this._summary = summary;
    }

    public Date getCreated() {
        return this._created;
    }

    public void setIssued(Date date) {
        this._issued = date;
    }

    public void setCreated(Date date) {
        this._created = date;
    }

    public Date getIssued() {
        return this._issued;
    }

    public boolean addContent(Content content) {
        return this._contentList.add(content);
    }

    public int getContentCount() {
        return this._contentList.size();
    }

    public Content getContent(int index) {
        Content result = null;
        if (index >= 0 && index < this._contentList.size()) {
            result = (Content)this._contentList.get(index);
        }
        return result;
    }

    public boolean removeContent(Content content) {
        return this._contentList.remove(content);
    }

    public void removeContent(int index) {
        if (index >= 0 && index < this._contentList.size()) {
            this._contentList.remove(index);
        }
    }

    public void addContent(int index, Content content) {
        this._contentList.add(index, content);
    }

    public String toString() {
        int x;
        StringBuffer buffer = new StringBuffer();
        buffer.append(MessageFormat.format("<{0}{1}>", "entry", "", ""));
        buffer.append(this._title.toString());
        buffer.append(MessageFormat.format("<{0}{1}>{2}</{0}>", "id", "", this._id));
        if (this._summary != null) {
            buffer.append(this._summary.toString());
        }
        if (this._linksList.size() > 0) {
            for (x = 0; x < this._linksList.size(); ++x) {
                Link link = (Link)this._linksList.get(x);
                buffer.append(link.toString());
            }
        }
        if (this._modified != null) {
            buffer.append(MessageFormat.format("<{0}{1}>{2}</{0}>", "modified", "", SandlerUtilities.getUTCDate(this._modified)));
        }
        if (this._issued != null) {
            buffer.append(MessageFormat.format("<{0}{1}>{2}</{0}>", "issued", "", SandlerUtilities.getUTCDate(this._issued)));
        }
        if (this._created != null) {
            buffer.append(MessageFormat.format("<{0}{1}>{2}</{0}>", "created", "", SandlerUtilities.getUTCDate(this._created)));
        }
        if (this._summary != null) {
            buffer.append(MessageFormat.format("<{0}{1}>{2}</{0}>", "summary", "", this._summary));
        }
        if (this._author != null) {
            buffer.append("<").append("author").append(">");
            buffer.append(this._author.toString());
            buffer.append("</").append("author").append(">");
        }
        if (this._contributorList.size() > 0) {
            for (x = 0; x < this._contributorList.size(); ++x) {
                Person contributor = (Person)this._contributorList.get(x);
                buffer.append("<").append("contributor").append(">");
                buffer.append(contributor.toString());
                buffer.append("</").append("contributor").append(">");
            }
        }
        if (this._contentList.size() > 0) {
            for (x = 0; x < this._contentList.size(); ++x) {
                Content content = (Content)this._contentList.get(x);
                if (content == null) continue;
                buffer.append(content.toString());
            }
        }
        buffer.append("</").append("entry").append(">");
        return buffer.toString();
    }

    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                ContentImpl content;
                if (parser.getName().equalsIgnoreCase("title")) {
                    content = new ContentImpl("title");
                    content.loadDocument(parser);
                    this.setTitle(content);
                } else if (parser.getName().equalsIgnoreCase("link")) {
                    LinkImpl link = new LinkImpl();
                    link.loadDocument(parser);
                    this._linksList.add(link);
                } else if (parser.getName().equalsIgnoreCase("id")) {
                    try {
                        this._id = parser.nextText();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (parser.getName().equalsIgnoreCase("summary")) {
                    content = new ContentImpl("summary");
                    content.loadDocument(parser);
                    this.setSummary(content);
                } else if (parser.getName().equalsIgnoreCase("modified")) {
                    this.processModifiedTag(parser);
                } else if (parser.getName().equalsIgnoreCase("issued")) {
                    this.processIssuedTag(parser);
                } else if (parser.getName().equalsIgnoreCase("created")) {
                    this.processCreatedTag(parser);
                } else if (parser.getName().equalsIgnoreCase("author")) {
                    this._author = new PersonImpl();
                    this._author.loadDocument(parser);
                } else if (parser.getName().equalsIgnoreCase("content")) {
                    content = new ContentImpl();
                    content.loadDocument(parser);
                    this._contentList.add(content);
                } else if (parser.getName().equalsIgnoreCase("contributor")) {
                    PersonImpl contrib = new PersonImpl();
                    contrib.loadDocument(parser);
                    this._contributorList.add(contrib);
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (eventType != 3 || !"entry".equals(parser.getName()));
    }

    private void processModifiedTag(XmlPullParser parser) throws XmlPullParserException {
        try {
            this._modified = SandlerUtilities.getDateFromUTCDate(parser.nextText());
        }
        catch (ParseException e) {
            this._modified = new Date();
        }
        catch (IOException e) {
            this._modified = null;
        }
    }

    private void processCreatedTag(XmlPullParser parser) throws XmlPullParserException {
        try {
            this._created = SandlerUtilities.getDateFromUTCDate(parser.nextText());
        }
        catch (ParseException e) {
            this._created = new Date();
        }
        catch (IOException e) {
            this._created = null;
        }
    }

    private void processIssuedTag(XmlPullParser parser) throws XmlPullParserException {
        try {
            this._issued = SandlerUtilities.getDateFromUTCDate(parser.nextText());
        }
        catch (ParseException e) {
            this._issued = new Date();
        }
        catch (IOException e) {
            this._issued = null;
        }
    }
}

