/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

import java.io.*;

import javax.xml.bind.*;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import static javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI;

import org.xml.sax.SAXException;

// import java content classes generated by binding compiler
import primer.myPo.*;

/*
 * $Id: Main.java,v 1.1 2007-12-05 00:49:48 kohsuke Exp $
 */
public class Main {
    
    // This sample application demonstrates how to modify a java content
    // tree and marshal it back to a xml data. This example demonstrates
    // customiation within the schema file, po.xsd, and the impact that these 
    // customizations have on the schema derived Java representation.
    
/*
      XML --> Unmarshal -->Serialize
       |                        |
       ?=                       |
       |                        v
      XML <-- Marshal <--Deserialize
*/

    public static void main( String[] args ) {
        final String INPUT_XML_FILE="poInput.xml";
	final String SERIALIZE_FILE="po.ser";
        final String DESERIALIZED_XML="poMarshalled.xml";
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);

        try {
            Schema schema = sf.newSchema(new File("po.xsd"));
            JAXBContext jc = JAXBContext.newInstance("primer.myPo");
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setSchema(schema);
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT ,
                   new Boolean(true));
            System.out.println( "unmarshalling from \"" + INPUT_XML_FILE + "\"..." );
            Object po = unmarshaller.unmarshal(new File(INPUT_XML_FILE));
            PurchaseOrderType pot = (PurchaseOrderType)((JAXBElement)po).getValue();
	    System.out.println("Demo superclass override of toString() method for all schema-derived JAXB classes purchaseOrderType.toString()=" + pot.toString());

            System.out.println( "serializing content tree to \"" + SERIALIZE_FILE + "\"..." );
            FileOutputStream out = new FileOutputStream(SERIALIZE_FILE);
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(po);
            objOut.flush();
	    out.close();

            System.out.println( "deserializing content tree from \"" + SERIALIZE_FILE + "\"..." );
            FileInputStream in = new FileInputStream(SERIALIZE_FILE);
            ObjectInputStream objIn = new ObjectInputStream(in);
            po=objIn.readObject();

            System.out.println( "marshalling to \"" + DESERIALIZED_XML + "\"..." );
            FileOutputStream mout = 
		new FileOutputStream(DESERIALIZED_XML);
            marshaller.marshal(po, mout);
	    in.close();
	    mout.close();

            System.out.println( "test complete." );
        } catch( JAXBException je ) {
            je.printStackTrace();
        } catch( SAXException se ) {
            se.printStackTrace();
        } catch( IOException ioe ) {
            ioe.printStackTrace();
        } catch ( ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
    }
}

