# -*- makefile -*-
# --------------------------------------------------------------------
#
# Ipe configuration for Mac OS X
#
# --------------------------------------------------------------------
#
# Where is your X11 installation?
#X11LIBS    = /opt/X11
#X11LIBS    = /usr/X11
X11LIBS	   ?= $(IPESRCDIR)/../../dependencies
#
# We build as an application bundle (a directory "Ipe.app" that
# contains Ipe and all its files).
# If you don't want this, you'll need to also set IPEPREFIX and
# all the variables in the "config.mak" file.
#
IPEBUNDLE  = 1
#
CONFIG     += x86_64
FRAMEWORKS ?= /Developer/SDKs/MacOSX10.6.sdk/System/Library/Frameworks/ApplicationServices.framework/Versions/A/Frameworks
DL_LIBS       ?= -ldl
ZLIB_CFLAGS   ?=
ZLIB_LIBS     ?= -lz
JPEG_CFLAGS   := -I$(FRAMEWORKS)/CoreGraphics.framework/Versions/A/Headers/
JPEG_LIBS     := -framework ApplicationServices
PNG_CFLAGS    ?= -I$(X11LIBS)/include
PNG_LIBS      ?= -L$(X11LIBS)/lib -lpng
FREETYPE_CFLAGS ?= -I$(X11LIBS)/include/freetype2 -I$(X11LIBS)/include
FREETYPE_LIBS ?= -L$(X11LIBS)/lib -lfreetype
CAIRO_CFLAGS  ?= -I$(X11LIBS)/include/cairo
CAIRO_LIBS ?= -L$(X11LIBS)/lib -lcairo
LUA_CFLAGS ?= -I$(X11LIBS)/include
LUA_LIBS   ?= -L$(X11LIBS)/lib -llua53 -lm

QT_CFLAGS  ?= -I/Library/Frameworks/QtCore.framework/Versions/4/Headers \
             -I/Library/Frameworks/QtGui.framework/Versions/4/Headers
QT_LIBS    ?= -F/Library/Frameworks -L/Library/Frameworks \
             -framework QtCore -framework ApplicationServices \
             -framework QtGui -framework AppKit -framework Cocoa -lz -lm

MOC	   ?= moc

IPEVERS = 7.1.10

# --------------------------------------------------------------------
