/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//  A container class that collects all ViewSubjects of the same ObjectType but accepting different DataType(s).
//  It is actually NOT a child of iViewSubject
//
#ifndef IVIEWOBJECT_H
#define IVIEWOBJECT_H


#include "iobject.h"
#include "imultitypedataconsumer.h"


#include "iarray.h"

class iViewSubject;


///
//  Helper intermediate class (need to avoid constructor recurrence)
//
class iViewObjectParent
{
	
	IPOINTER_AS_PART(ViewModule);

public:
		
	iViewObjectParent(iViewModule *vm, const iObjectType &ot, const iDataType &dt);

	inline const iDataType& GetDataType() const { return mDataType; }
	inline const iObjectType& GetObjectType() const { return mObjectType; }

protected:

	const iDataType &mDataType;
	const iObjectType &mObjectType;
};


//
//  Main class
//
class iViewObject : public iObject, public iMultiTypeDataConsumer
{
	
	friend class iObjectFactory;

public:
	
	vtkTypeMacro(iViewObject,iObject);
	static iViewObject* New(iViewObjectParent *parent = 0);

	iViewSubject* GetViewSubject(int obs = -1) const;
	iViewSubject* GetViewSubject(const iDataType &type) const;

	void Show(bool s);

	void Reset();
	float GetMemorySize() const;
	void ShowClipPlane(bool s);

	virtual void PackCompleteState(iString &s) const;
	virtual void UnPackCompleteState(const iString &s);

protected:
	
	virtual ~iViewObject();

	virtual void PackStateBody(iString &s) const;
	virtual void UnPackStateBody(const iString &s);

	virtual void UpdateDataType(int prev);
	virtual void SyncWithDataBody(const iDataSyncRequest &r);

private:

	iViewObject(iViewObjectParent *parent, bool synced, bool single);

	//
	//  Members
	//
	bool mIsSynced, mIsSingle;
	iViewObjectParent *mParent;
	iArray<iViewSubject*> mSubjects;

	//
	//  Constructor helpers accessible to iExtensionFactory only
	//
	void AddSubject(iViewSubject *subject);
	void Verify();
};

#endif // IVIEWOBJECT_H
