/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IPARTICLESVIEWSUBJECT_H
#define IPARTICLESVIEWSUBJECT_H


#include "iviewsubject.h"


class iParticleGroup;
class iParticleGroupFamily;
class iParticleSplitter;
class iRangeMapping;


class iParticlesViewSubject : public iViewSubject
{
	
	friend class iAbstractExtension;
	friend class iObjectFactory;
	friend class iParticleGroup;

public:
	
	vtkTypeMacro(iParticlesViewSubject,iViewSubject);
	static const iObjectType& Type();

	static const int CurrentId;

	virtual void BecomeClone(iParticlesViewSubject *other);

	static const iObjectKey& KeyMaxGroup();
	int GetMaxGroupIndex() const;
	
	static const iObjectKey& KeyCurrentGroup();
    void SetCurrentGroupIndex(int i);
	int GetCurrentGroupIndex() const;

	iParticleGroup* GetCurrentGroup() const;
	iParticleGroup* GetGroup(int i) const;

	//
	//  Decorator functions
	//
	inline iParticleGroup* GetCurrentMember() const { return this->GetCurrentGroup(); }
	inline iParticleGroup* GetMember(int i) const { return this->GetGroup(i); }
	inline int GetMaxMemberIndex() const { return this->GetMaxGroupIndex(); }

	virtual void UpdateColorLookupTable();

	virtual void UpdateMaterialProperties();
	virtual void Reset();
	virtual void ShowClipPlane(bool s);
	virtual void ShowColorBars(bool s);
	virtual float GetMemorySize() const;
	virtual bool IsVisible() const;
	virtual const iObjectType& RealType();

	//
	//  Decorator keys
	//
	static const iObjectKey& KeyType();
	static const iObjectKey& KeyPalette();
	static const iObjectKey& KeyColor();
	static const iObjectKey& KeyAttributeToColor();
	static const iObjectKey& KeyAttributeToSize();
	static const iObjectKey& KeyOpacity();
	static const iObjectKey& KeyFixedSize();
	static const iObjectKey& KeyStretchToColor();
	static const iObjectKey& KeyLowerLimitToColor();
	static const iObjectKey& KeyUpperLimitToColor();
	static const iObjectKey& KeyStretchToSize();
	static const iObjectKey& KeyLowerLimitToSize();
	static const iObjectKey& KeyUpperLimitToSize();
	static const iObjectKey& KeyAttributeSizeDirect();
	static const iObjectKey& KeyAttributeSizeExtraFactor();
	static const iObjectKey& KeyLineWidth();
	static const iObjectKey& KeyAutoScaled();
	static const iObjectKey& KeyAttributeToConnect();
	static const iObjectKey& KeyAttributeToSeparate();
	static const iObjectKey& KeySizeFunction();

	IVIEWSUBJECT_DECLARE_INHERITED_KEYS;

	//
	//  Splitter functionality (decorator)
	//
	IOBJECT_DECLARE_GETSET2(AttributeToSplit,int);
	//void SetAttributeToSplit(int a);
	//int GetAttributeToSplit() const;
	
	static const iObjectKey& KeySplitRangesStretch();
	static const iObjectKey& KeySplitRangesTiled();
	static const iObjectKey& KeySplitRangesMin();
	static const iObjectKey& KeySplitRangesMax();
	static const iObjectKey& KeySplitRangeLowerLimit();
	static const iObjectKey& KeySplitRangeUpperLimit();

	virtual int CreateGroup();
	virtual bool DeleteGroup(int n);

	static const iObjectKey& KeySplitRanges();
	iRangeMapping* GetSplitRanges(); // for direct access

	virtual void PackCompleteState(iString &s) const;
	virtual void UnPackCompleteState(const iString &s);

	static void UseFullState(bool s){ mUseFullState = s; }

	virtual bool CanBeShown() const;

protected:
	
	iParticlesViewSubject(iViewModule *vm, const iDataType &type, const iString &name, const iColor &color = iColor::Invalid(), bool shaded = false);
	virtual ~iParticlesViewSubject();
	virtual void ConfigureBody();

	virtual void UpdateReplicas();
	virtual void ShowBody(bool s);

	virtual void ViewSubjectSyncWithData(const iDataSyncRequest &r);

	virtual void PackGroupStateBody(iString &s, int first, int last) const;
	virtual void UnPackGroupStateBody(const iString &s, int first, int last);
	virtual void PackStateBody(iString &s) const; \
	virtual void UnPackStateBody(const iString &s); \

	virtual void ViewSubjectPackStateBody(iString &s) const;
	virtual void ViewSubjectUnPackStateBody(const iString &s);

	static bool mUseFullState;

	iParticleGroupFamily *mGroups;
	iParticleSplitter *mSplitter;
};

#endif // IPARTICLESVIEWSUBJECT_H
 
