
// output12ax7_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -3.000000
 // --table_div  73.995059
 // --table_op  0.100000

struct tableoutput12ax7_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tableoutput12ax7_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tableoutput12ax7_neg&() const { return *(tableoutput12ax7_neg*)this; }
};

 static tableoutput12ax7_neg_imp<2048> output12ax7_neg_table __rt_data = {
	0,0.575793,68.2333,2048, {
	0.000000000000,0.000586859355,0.001173400184,0.001759622579,0.002345526633,
	0.002931112438,0.003516380084,0.004101329664,0.004685961270,0.005270274992,
	0.005854270923,0.006437949155,0.007021309777,0.007604352882,0.008187078561,
	0.008769486904,0.009351578003,0.009933351949,0.010514808832,0.011095948743,
	0.011676771773,0.012257278012,0.012837467551,0.013417340480,0.013996896890,
	0.014576136870,0.015155060511,0.015733667903,0.016311959136,0.016889934299,
	0.017467593483,0.018044936777,0.018621964271,0.019198676055,0.019775072217,
	0.020351152847,0.020926918034,0.021502367868,0.022077502438,0.022652321833,
	0.023226826141,0.023801015452,0.024374889854,0.024948449436,0.025521694287,
	0.026094624494,0.026667240148,0.027239541335,0.027811528144,0.028383200663,
	0.028954558980,0.029525603184,0.030096333362,0.030666749602,0.031236851992,
	0.031806640619,0.032376115571,0.032945276936,0.033514124800,0.034082659252,
	0.034650880378,0.035218788265,0.035786383001,0.036353664672,0.036920633365,
	0.037487289168,0.038053632166,0.038619662447,0.039185380097,0.039750785202,
	0.040315877849,0.040880658123,0.041445126112,0.042009281901,0.042573125577,
	0.043136657224,0.043699876930,0.044262784779,0.044825380857,0.045387665251,
	0.045949638044,0.046511299324,0.047072649174,0.047633687681,0.048194414930,
	0.048754831004,0.049314935991,0.049874729973,0.050434213037,0.050993385266,
	0.051552246745,0.052110797560,0.052669037793,0.053226967531,0.053784586856,
	0.054341895853,0.054898894606,0.055455583200,0.056011961717,0.056568030242,
	0.057123788858,0.057679237650,0.058234376700,0.058789206093,0.059343725911,
	0.059897936238,0.060451837156,0.061005428750,0.061558711102,0.062111684295,
	0.062664348411,0.063216703534,0.063768749747,0.064320487131,0.064871915769,
	0.065423035745,0.065973847139,0.066524350034,0.067074544512,0.067624430656,
	0.068174008547,0.068723278268,0.069272239899,0.069820893523,0.070369239220,
	0.070917277074,0.071465007164,0.072012429573,0.072559544382,0.073106351671,
	0.073652851522,0.074199044016,0.074744929233,0.075290507255,0.075835778162,
	0.076380742034,0.076925398953,0.077469748998,0.078013792250,0.078557528790,
	0.079100958696,0.079644082050,0.080186898932,0.080729409420,0.081271613596,
	0.081813511538,0.082355103327,0.082896389041,0.083437368760,0.083978042565,
	0.084518410532,0.085058472743,0.085598229276,0.086137680210,0.086676825623,
	0.087215665596,0.087754200205,0.088292429531,0.088830353651,0.089367972643,
	0.089905286587,0.090442295561,0.090978999642,0.091515398908,0.092051493438,
	0.092587283310,0.093122768601,0.093657949388,0.094192825751,0.094727397765,
	0.095261665508,0.095795629059,0.096329288493,0.096862643889,0.097395695322,
	0.097928442871,0.098460886612,0.098993026621,0.099524862976,0.100056395752,
	0.100587625027,0.101118550877,0.101649173378,0.102179492607,0.102709508639,
	0.103239221550,0.103768631417,0.104297738315,0.104826542320,0.105355043508,
	0.105883241954,0.106411137733,0.106938730922,0.107466021595,0.107993009827,
	0.108519695694,0.109046079271,0.109572160632,0.110097939852,0.110623417007,
	0.111148592170,0.111673465416,0.112198036820,0.112722306455,0.113246274397,
	0.113769940719,0.114293305496,0.114816368801,0.115339130708,0.115861591291,
	0.116383750623,0.116905608779,0.117427165832,0.117948421855,0.118469376921,
	0.118990031104,0.119510384476,0.120030437112,0.120550189083,0.121069640462,
	0.121588791323,0.122107641737,0.122626191778,0.123144441518,0.123662391029,
	0.124180040383,0.124697389653,0.125214438911,0.125731188228,0.126247637677,
	0.126763787329,0.127279637256,0.127795187530,0.128310438221,0.128825389402,
	0.129340041144,0.129854393517,0.130368446593,0.130882200444,0.131395655139,
	0.131908810750,0.132421667348,0.132934225002,0.133446483784,0.133958443764,
	0.134470105013,0.134981467600,0.135492531595,0.136003297069,0.136513764092,
	0.137023932734,0.137533803063,0.138043375151,0.138552649066,0.139061624878,
	0.139570302656,0.140078682469,0.140586764388,0.141094548479,0.141602034814,
	0.142109223460,0.142616114487,0.143122707962,0.143629003955,0.144135002534,
	0.144640703767,0.145146107723,0.145651214470,0.146156024075,0.146660536608,
	0.147164752135,0.147668670725,0.148172292445,0.148675617363,0.149178645546,
	0.149681377062,0.150183811978,0.150685950361,0.151187792278,0.151689337796,
	0.152190586983,0.152691539904,0.153192196627,0.153692557218,0.154192621744,
	0.154692390271,0.155191862865,0.155691039593,0.156189920520,0.156688505713,
	0.157186795237,0.157684789159,0.158182487544,0.158679890457,0.159176997964,
	0.159673810131,0.160170327022,0.160666548704,0.161162475240,0.161658106696,
	0.162153443137,0.162648484628,0.163143231232,0.163637683016,0.164131840043,
	0.164625702378,0.165119270085,0.165612543228,0.166105521871,0.166598206078,
	0.167090595914,0.167582691441,0.168074492723,0.168565999825,0.169057212809,
	0.169548131739,0.170038756678,0.170529087689,0.171019124836,0.171508868180,
	0.171998317786,0.172487473716,0.172976336032,0.173464904796,0.173953180073,
	0.174441161923,0.174928850409,0.175416245593,0.175903347537,0.176390156302,
	0.176876671952,0.177362894547,0.177848824149,0.178334460820,0.178819804621,
	0.179304855613,0.179789613857,0.180274079415,0.180758252348,0.181242132715,
	0.181725720579,0.182209015999,0.182692019037,0.183174729753,0.183657148207,
	0.184139274459,0.184621108569,0.185102650598,0.185583900606,0.186064858651,
	0.186545524795,0.187025899096,0.187505981614,0.187985772409,0.188465271540,
	0.188944479065,0.189423395045,0.189902019537,0.190380352601,0.190858394296,
	0.191336144681,0.191813603813,0.192290771751,0.192767648554,0.193244234279,
	0.193720528986,0.194196532731,0.194672245574,0.195147667571,0.195622798780,
	0.196097639259,0.196572189066,0.197046448257,0.197520416891,0.197994095023,
	0.198467482712,0.198940580014,0.199413386986,0.199885903685,0.200358130167,
	0.200830066488,0.201301712706,0.201773068877,0.202244135056,0.202714911300,
	0.203185397664,0.203655594206,0.204125500979,0.204595118040,0.205064445445,
	0.205533483249,0.206002231507,0.206470690274,0.206938859605,0.207406739556,
	0.207874330182,0.208341631536,0.208808643674,0.209275366650,0.209741800519,
	0.210207945335,0.210673801152,0.211139368025,0.211604646006,0.212069635151,
	0.212534335512,0.212998747144,0.213462870101,0.213926704434,0.214390250199,
	0.214853507447,0.215316476233,0.215779156608,0.216241548627,0.216703652341,
	0.217165467804,0.217626995067,0.218088234184,0.218549185207,0.219009848187,
	0.219470223177,0.219930310229,0.220390109395,0.220849620726,0.221308844275,
	0.221767780092,0.222226428229,0.222684788737,0.223142861668,0.223600647073,
	0.224058145002,0.224515355506,0.224972278636,0.225428914444,0.225885262978,
	0.226341324290,0.226797098430,0.227252585447,0.227707785393,0.228162698317,
	0.228617324269,0.229071663298,0.229525715454,0.229979480786,0.230432959345,
	0.230886151178,0.231339056336,0.231791674867,0.232244006820,0.232696052244,
	0.233147811188,0.233599283700,0.234050469828,0.234501369621,0.234951983127,
	0.235402310394,0.235852351470,0.236302106403,0.236751575240,0.237200758030,
	0.237649654820,0.238098265656,0.238546590587,0.238994629659,0.239442382920,
	0.239889850416,0.240337032195,0.240783928302,0.241230538785,0.241676863689,
	0.242122903062,0.242568656949,0.243014125396,0.243459308450,0.243904206155,
	0.244348818559,0.244793145707,0.245237187643,0.245680944414,0.246124416064,
	0.246567602639,0.247010504184,0.247453120743,0.247895452362,0.248337499085,
	0.248779260957,0.249220738021,0.249661930323,0.250102837906,0.250543460814,
	0.250983799092,0.251423852783,0.251863621931,0.252303106579,0.252742306771,
	0.253181222550,0.253619853960,0.254058201043,0.254496263843,0.254934042401,
	0.255371536762,0.255808746967,0.256245673059,0.256682315080,0.257118673073,
	0.257554747079,0.257990537141,0.258426043301,0.258861265600,0.259296204079,
	0.259730858780,0.260165229746,0.260599317016,0.261033120632,0.261466640634,
	0.261899877065,0.262332829964,0.262765499373,0.263197885330,0.263629987878,
	0.264061807056,0.264493342905,0.264924595463,0.265355564772,0.265786250871,
	0.266216653799,0.266646773597,0.267076610302,0.267506163956,0.267935434596,
	0.268364422261,0.268793126992,0.269221548825,0.269649687801,0.270077543957,
	0.270505117331,0.270932407963,0.271359415889,0.271786141149,0.272212583779,
	0.272638743818,0.273064621303,0.273490216272,0.273915528761,0.274340558809,
	0.274765306452,0.275189771727,0.275613954672,0.276037855322,0.276461473714,
	0.276884809884,0.277307863870,0.277730635707,0.278153125431,0.278575333078,
	0.278997258684,0.279418902285,0.279840263916,0.280261343612,0.280682141409,
	0.281102657342,0.281522891445,0.281942843755,0.282362514305,0.282781903130,
	0.283201010264,0.283619835743,0.284038379600,0.284456641869,0.284874622584,
	0.285292321779,0.285709739488,0.286126875744,0.286543730581,0.286960304031,
	0.287376596129,0.287792606907,0.288208336399,0.288623784636,0.289038951651,
	0.289453837478,0.289868442148,0.290282765693,0.290696808146,0.291110569539,
	0.291524049903,0.291937249270,0.292350167672,0.292762805140,0.293175161705,
	0.293587237399,0.293999032253,0.294410546297,0.294821779562,0.295232732079,
	0.295643403878,0.296053794990,0.296463905445,0.296873735272,0.297283284503,
	0.297692553166,0.298101541292,0.298510248909,0.298918676047,0.299326822736,
	0.299734689005,0.300142274882,0.300549580396,0.300956605577,0.301363350452,
	0.301769815050,0.302175999399,0.302581903528,0.302987527465,0.303392871237,
	0.303797934871,0.304202718397,0.304607221841,0.305011445230,0.305415388591,
	0.305819051953,0.306222435341,0.306625538782,0.307028362303,0.307430905930,
	0.307833169690,0.308235153609,0.308636857713,0.309038282028,0.309439426579,
	0.309840291392,0.310240876493,0.310641181908,0.311041207660,0.311440953776,
	0.311840420280,0.312239607197,0.312638514551,0.313037142368,0.313435490671,
	0.313833559484,0.314231348833,0.314628858740,0.315026089229,0.315423040324,
	0.315819712049,0.316216104427,0.316612217480,0.317008051233,0.317403605708,
	0.317798880927,0.318193876914,0.318588593690,0.318983031279,0.319377189701,
	0.319771068981,0.320164669138,0.320557990195,0.320951032174,0.321343795096,
	0.321736278982,0.322128483853,0.322520409731,0.322912056636,0.323303424590,
	0.323694513611,0.324085323722,0.324475854942,0.324866107291,0.325256080790,
	0.325645775458,0.326035191314,0.326424328379,0.326813186672,0.327201766212,
	0.327590067017,0.327978089108,0.328365832502,0.328753297219,0.329140483276,
	0.329527390692,0.329914019486,0.330300369675,0.330686441278,0.331072234311,
	0.331457748793,0.331842984740,0.332227942171,0.332612621102,0.332997021551,
	0.333381143533,0.333764987066,0.334148552166,0.334531838850,0.334914847134,
	0.335297577034,0.335680028565,0.336062201743,0.336444096585,0.336825713105,
	0.337207051319,0.337588111242,0.337968892888,0.338349396273,0.338729621412,
	0.339109568318,0.339489237006,0.339868627491,0.340247739786,0.340626573905,
	0.341005129862,0.341383407671,0.341761407344,0.342139128896,0.342516572339,
	0.342893737686,0.343270624950,0.343647234144,0.344023565280,0.344399618370,
	0.344775393427,0.345150890462,0.345526109488,0.345901050516,0.346275713557,
	0.346650098623,0.347024205725,0.347398034874,0.347771586081,0.348144859357,
	0.348517854712,0.348890572157,0.349263011701,0.349635173356,0.350007057130,
	0.350378663034,0.350749991077,0.351121041269,0.351491813619,0.351862308135,
	0.352232524828,0.352602463705,0.352972124776,0.353341508048,0.353710613530,
	0.354079441231,0.354447991157,0.354816263318,0.355184257720,0.355551974371,
	0.355919413278,0.356286574449,0.356653457890,0.357020063609,0.357386391611,
	0.357752441904,0.358118214493,0.358483709385,0.358848926586,0.359213866102,
	0.359578527938,0.359942912099,0.360307018592,0.360670847420,0.361034398590,
	0.361397672106,0.361760667973,0.362123386194,0.362485826775,0.362847989719,
	0.363209875031,0.363571482715,0.363932812773,0.364293865209,0.364654640027,
	0.365015137230,0.365375356820,0.365735298801,0.366094963176,0.366454349945,
	0.366813459113,0.367172290680,0.367530844649,0.367889121022,0.368247119800,
	0.368604840984,0.368962284576,0.369319450577,0.369676338988,0.370032949809,
	0.370389283041,0.370745338685,0.371101116740,0.371456617206,0.371811840084,
	0.372166785373,0.372521453073,0.372875843182,0.373229955701,0.373583790627,
	0.373937347960,0.374290627699,0.374643629841,0.374996354386,0.375348801331,
	0.375700970674,0.376052862412,0.376404476544,0.376755813067,0.377106871978,
	0.377457653274,0.377808156952,0.378158383008,0.378508331439,0.378858002241,
	0.379207395411,0.379556510944,0.379905348837,0.380253909084,0.380602191681,
	0.380950196624,0.381297923907,0.381645373525,0.381992545473,0.382339439746,
	0.382686056337,0.383032395242,0.383378456453,0.383724239965,0.384069745771,
	0.384414973865,0.384759924240,0.385104596888,0.385448991804,0.385793108979,
	0.386136948406,0.386480510077,0.386823793984,0.387166800120,0.387509528476,
	0.387851979043,0.388194151814,0.388536046778,0.388877663928,0.389219003254,
	0.389560064746,0.389900848396,0.390241354193,0.390581582127,0.390921532189,
	0.391261204368,0.391600598653,0.391939715034,0.392278553501,0.392617114041,
	0.392955396644,0.393293401298,0.393631127991,0.393968576713,0.394305747450,
	0.394642640191,0.394979254923,0.395315591633,0.395651650310,0.395987430939,
	0.396322933508,0.396658158004,0.396993104412,0.397327772720,0.397662162913,
	0.397996274977,0.398330108897,0.398663664660,0.398996942251,0.399329941654,
	0.399662662855,0.399995105838,0.400327270588,0.400659157089,0.400990765326,
	0.401322095281,0.401653146940,0.401983920285,0.402314415300,0.402644631969,
	0.402974570273,0.403304230196,0.403633611720,0.403962714828,0.404291539502,
	0.404620085723,0.404948353474,0.405276342737,0.405604053492,0.405931485720,
	0.406258639403,0.406585514522,0.406912111056,0.407238428987,0.407564468295,
	0.407890228958,0.408215710959,0.408540914275,0.408865838886,0.409190484771,
	0.409514851910,0.409838940281,0.410162749862,0.410486280633,0.410809532570,
	0.411132505653,0.411455199858,0.411777615164,0.412099751547,0.412421608985,
	0.412743187455,0.413064486933,0.413385507395,0.413706248820,0.414026711181,
	0.414346894455,0.414666798619,0.414986423646,0.415305769514,0.415624836196,
	0.415943623667,0.416262131903,0.416580360877,0.416898310563,0.417215980937,
	0.417533371971,0.417850483640,0.418167315916,0.418483868773,0.418800142183,
	0.419116136120,0.419431850556,0.419747285463,0.420062440814,0.420377316580,
	0.420691912733,0.421006229245,0.421320266086,0.421634023229,0.421947500643,
	0.422260698299,0.422573616169,0.422886254221,0.423198612426,0.423510690754,
	0.423822489174,0.424134007655,0.424445246168,0.424756204680,0.425066883160,
	0.425377281577,0.425687399899,0.425997238094,0.426306796131,0.426616073975,
	0.426925071596,0.427233788960,0.427542226033,0.427850382784,0.428158259178,
	0.428465855181,0.428773170760,0.429080205881,0.429386960508,0.429693434609,
	0.429999628147,0.430305541087,0.430611173395,0.430916525036,0.431221595972,
	0.431526386169,0.431830895590,0.432135124198,0.432439071958,0.432742738833,
	0.433046124785,0.433349229777,0.433652053772,0.433954596732,0.434256858619,
	0.434558839394,0.434860539020,0.435161957459,0.435463094670,0.435763950615,
	0.436064525255,0.436364818549,0.436664830460,0.436964560946,0.437264009967,
	0.437563177483,0.437862063453,0.438160667836,0.438458990591,0.438757031678,
	0.439054791053,0.439352268676,0.439649464504,0.439946378495,0.440243010607,
	0.440539360797,0.440835429022,0.441131215238,0.441426719403,0.441721941473,
	0.442016881403,0.442311539149,0.442605914668,0.442900007915,0.443193818845,
	0.443487347412,0.443780593571,0.444073557278,0.444366238486,0.444658637149,
	0.444950753221,0.445242586655,0.445534137405,0.445825405424,0.446116390664,
	0.446407093079,0.446697512620,0.446987649239,0.447277502889,0.447567073522,
	0.447856361087,0.448145365538,0.448434086823,0.448722524895,0.449010679704,
	0.449298551199,0.449586139332,0.449873444050,0.450160465305,0.450447203044,
	0.450733657218,0.451019827774,0.451305714662,0.451591317829,0.451876637224,
	0.452161672794,0.452446424487,0.452730892251,0.453015076031,0.453298975775,
	0.453582591430,0.453865922941,0.454148970255,0.454431733318,0.454714212075,
	0.454996406471,0.455278316452,0.455559941963,0.455841282947,0.456122339349,
	0.456403111114,0.456683598184,0.456963800505,0.457243718018,0.457523350667,
	0.457802698396,0.458081761145,0.458360538859,0.458639031478,0.458917238945,
	0.459195161201,0.459472798188,0.459750149847,0.460027216117,0.460303996941,
	0.460580492258,0.460856702009,0.461132626132,0.461408264569,0.461683617257,
	0.461958684136,0.462233465146,0.462507960223,0.462782169307,0.463056092336,
	0.463329729247,0.463603079978,0.463876144466,0.464148922648,0.464421414462,
	0.464693619842,0.464965538726,0.465237171050,0.465508516749,0.465779575758,
	0.466050348013,0.466320833450,0.466591032001,0.466860943603,0.467130568188,
	0.467399905691,0.467668956046,0.467937719186,0.468206195044,0.468474383552,
	0.468742284644,0.469009898252,0.469277224307,0.469544262742,0.469811013488,
	0.470077476476,0.470343651638,0.470609538904,0.470875138204,0.471140449469,
	0.471405472629,0.471670207613,0.471934654351,0.472198812772,0.472462682805,
	0.472726264378,0.472989557419,0.473252561858,0.473515277621,0.473777704637,
	0.474039842832,0.474301692133,0.474563252468,0.474824523762,0.475085505942,
	0.475346198934,0.475606602664,0.475866717056,0.476126542036,0.476386077529,
	0.476645323460,0.476904279752,0.477162946330,0.477421323117,0.477679410037,
	0.477937207014,0.478194713970,0.478451930827,0.478708857509,0.478965493937,
	0.479221840033,0.479477895719,0.479733660916,0.479989135546,0.480244319528,
	0.480499212783,0.480753815232,0.481008126794,0.481262147390,0.481515876938,
	0.481769315357,0.482022462567,0.482275318486,0.482527883032,0.482780156124,
	0.483032137678,0.483283827612,0.483535225844,0.483786332291,0.484037146868,
	0.484287669493,0.484537900081,0.484787838548,0.485037484809,0.485286838780,
	0.485535900376,0.485784669511,0.486033146100,0.486281330056,0.486529221294,
	0.486776819726,0.487024125267,0.487271137829,0.487517857325,0.487764283667,
	0.488010416767,0.488256256538,0.488501802890,0.488747055734,0.488992014983,
	0.489236680545,0.489481052333,0.489725130255,0.489968914223,0.490212404144,
	0.490455599929,0.490698501486,0.490941108724,0.491183421552,0.491425439878,
	0.491667163608,0.491908592652,0.492149726916,0.492390566306,0.492631110731,
	0.492871360095,0.493111314306,0.493350973268,0.493590336888,0.493829405070,
	0.494068177720,0.494306654743,0.494544836041,0.494782721520,0.495020311084,
	0.495257604635,0.495494602077,0.495731303313,0.495967708245,0.496203816776,
	0.496439628807,0.496675144241,0.496910362979,0.497145284922,0.497379909970,
	0.497614238025,0.497848268986,0.498082002754,0.498315439228,0.498548578307,
	0.498781419891,0.499013963879,0.499246210168,0.499478158657,0.499709809244,
	0.499941161827,0.500172216302,0.500402972567,0.500633430519,0.500863590054,
	0.501093451067,0.501323013456,0.501552277115,0.501781241939,0.502009907824,
	0.502238274665,0.502466342354,0.502694110787,0.502921579858,0.503148749459,
	0.503375619483,0.503602189825,0.503828460375,0.504054431027,0.504280101673,
	0.504505472203,0.504730542510,0.504955312484,0.505179782016,0.505403950997,
	0.505627819317,0.505851386865,0.506074653531,0.506297619205,0.506520283775,
	0.506742647129,0.506964709157,0.507186469747,0.507407928785,0.507629086160,
	0.507849941758,0.508070495467,0.508290747173,0.508510696762,0.508730344120,
	0.508949689133,0.509168731686,0.509387471664,0.509605908951,0.509824043433,
	0.510041874993,0.510259403516,0.510476628883,0.510693550980,0.510910169688,
	0.511126484891,0.511342496470,0.511558204308,0.511773608285,0.511988708285,
	0.512203504187,0.512417995873,0.512632183222,0.512846066115,0.513059644433,
	0.513272918054,0.513485886857,0.513698550722,0.513910909527,0.514122963151,
	0.514334711472,0.514546154366,0.514757291713,0.514968123388,0.515178649269,
	0.515388869232,0.515598783153,0.515808390909,0.516017692374,0.516226687424,
	0.516435375934,0.516643757779,0.516851832833,0.517059600970,0.517267062064,
	0.517474215988,0.517681062615,0.517887601819,0.518093833471,0.518299757444,
	0.518505373611,0.518710681841,0.518915682007,0.519120373980,0.519324757630,
	0.519528832828,0.519732599444,0.519936057347,0.520139206408,0.520342046494,
	0.520544577476,0.520746799221,0.520948711598,0.521150314475,0.521351607719,
	0.521552591198,0.521753264778,0.521953628327,0.522153681710,0.522353424794,
	0.522552857445,0.522751979528,0.522950790909,0.523149291451,0.523347481020,
	0.523545359480,0.523742926695,0.523940182528,0.524137126843,0.524333759504,
	0.524530080371,0.524726089309,0.524921786179,0.525117170843,0.525312243162,
	0.525507002998,0.525701450212,0.525895584664,0.526089406214,0.526282914722,
	0.526476110049,0.526668992053,0.526861560594,0.527053815530,0.527245756720,
	0.527437384021,0.527628697293,0.527819696391,0.528010381175,0.528200751499,
	0.528390807222,0.528580548200,0.528769974288,0.528959085342,0.529147881218,
	0.529336361771,0.529524526855,0.529712376326,0.529899910037,0.530087127842,
	0.530274029595,0.530460615150,0.530646884358,0.530832837074,0.531018473149,
	0.531203792436,0.531388794786,0.531573480051,0.531757848082,0.531941898730,
	0.532125631846,0.532309047280,0.532492144882,0.532674924501,0.532857385988,
	0.533039529191,0.533221353959,0.533402860141,0.533584047585,0.533764916138,
	0.533945465649,0.534125695966,0.534305606934,0.534485198400,0.534664470212,
	0.534843422215,0.535022054256,0.535200366179,0.535378357831,0.535556029056,
	0.535733379698,0.535910409603,0.536087118614,0.536263506576,0.536439573331,
	0.536615318723,0.536790742595,0.536965844790,0.537140625150,0.537315083518,
	0.537489219734,0.537663033641,0.537836525079,0.538009693890,0.538182539915,
	0.538355062993,0.538527262965,0.538699139671,0.538870692949,0.539041922641,
	0.539212828583,0.539383410615,0.539553668576,0.539723602303,0.539893211635,
	0.540062496408,0.540231456460,0.540400091629,0.540568401750,0.540736386660,
	0.540904046196,0.541071380193,0.541238388486,0.541405070912,0.541571427304,
	0.541737457499,0.541903161329,0.542068538631,0.542233589236,0.542398312980,
	0.542562709696,0.542726779215,0.542890521373,0.543053936000,0.543217022930,
	0.543379781994,0.543542213024,0.543704315851,0.543866090308,0.544027536224,
	0.544188653431,0.544349441759,0.544509901037,0.544670031097,0.544829831767,
	0.544989302878,0.545148444257,0.545307255734,0.545465737138,0.545623888297,
	0.545781709038,0.545939199191,0.546096358581,0.546253187038,0.546409684386,
	0.546565850455,0.546721685069,0.546877188056,0.547032359241,0.547187198450,
	0.547341705509,0.547495880242,0.547649722476,0.547803232034,0.547956408742,
	0.548109252423,0.548261762901,0.548413940002,0.548565783547,0.548717293360,
	0.548868469265,0.549019311084,0.549169818640,0.549319991755,0.549469830252,
	0.549619333952,0.549768502676,0.549917336247,0.550065834486,0.550213997212,
	0.550361824248,0.550509315414,0.550656470529,0.550803289415,0.550949771890,
	0.551095917775,0.551241726888,0.551387199049,0.551532334077,0.551677131791,
	0.551821592008,0.551965714548,0.552109499228,0.552252945866,0.552396054280,
	0.552538824286,0.552681255703,0.552823348348,0.552965102036,0.553106516585,
	0.553247591810,0.553388327529,0.553528723557,0.553668779709,0.553808495801,
	0.553947871649,0.554086907068,0.554225601873,0.554363955877,0.554501968897,
	0.554639640745,0.554776971237,0.554913960187,0.555050607407,0.555186912712,
	0.555322875915,0.555458496830,0.555593775268,0.555728711044,0.555863303969,
	0.555997553857,0.556131460519,0.556265023767,0.556398243414,0.556531119272,
	0.556663651151,0.556795838864,0.556927682222,0.557059181035,0.557190335115,
	0.557321144272,0.557451608317,0.557581727060,0.557711500313,0.557840927884,
	0.557970009583,0.558098745222,0.558227134608,0.558355177552,0.558482873864,
	0.558610223351,0.558737225824,0.558863881091,0.558990188962,0.559116149244,
	0.559241761746,0.559367026276,0.559491942643,0.559616510655,0.559740730120,
	0.559864600846,0.559988122640,0.560111295309,0.560234118662,0.560356592506,
	0.560478716648,0.560600490894,0.560721915053,0.560842988930,0.560963712333,
	0.561084085068,0.561204106942,0.561323777761,0.561443097332,0.561562065460,
	0.561680681952,0.561798946614,0.561916859252,0.562034419671,0.562151627678,
	0.562268483077,0.562384985676,0.562501135278,0.562616931690,0.562732374717,
	0.562847464164,0.562962199836,0.563076581539,0.563190609076,0.563304282255,
	0.563417600878,0.563530564752,0.563643173680,0.563755427468,0.563867325920,
	0.563978868840,0.564090056034,0.564200887306,0.564311362460,0.564421481301,
	0.564531243633,0.564640649260,0.564749697987,0.564858389617,0.564966723956,
	0.565074700807,0.565182319975,0.565289581263,0.565396484475,0.565503029417,
	0.565609215891,0.565715043703,0.565820512655,0.565925622552,0.566030373199,
	0.566134764398,0.566238795955,0.566342467672,0.566445779355,0.566548730808,
	0.566651321833,0.566753552236,0.566855421821,0.566956930391,0.567058077751,
	0.567158863705,0.567259288057,0.567359350611,0.567459051172,0.567558389544,
	0.567657365530,0.567755978937,0.567854229567,0.567952117226,0.568049641718,
	0.568146802847,0.568243600419,0.568340034237,0.568436104107,0.568531809834,
	0.568627151222,0.568722128076,0.568816740202,0.568910987404,0.569004869488,
	0.569098386258,0.569191537522,0.569284323083,0.569376742747,0.569468796321,
	0.569560483610,0.569651804420,0.569742758556,0.569833345825,0.569923566034,
	0.570013418988,0.570102904494,0.570192022359,0.570280772389,0.570369154391,
	0.570457168173,0.570544813541,0.570632090302,0.570718998265,0.570805537237,
	0.570891707025,0.570977507437,0.571062938282,0.571147999368,0.571232690503,
	0.571317011495,0.571400962154,0.571484542289,0.571567751708,0.571650590221,
	0.571733057637,0.571815153767,0.571896878419,0.571978231405,0.572059212535,
	0.572139821618,0.572220058466,0.572299922891,0.572379414702,0.572458533712,
	0.572537279732,0.572615652574,0.572693652050,0.572771277973,0.572848530155,
	0.572925408409,0.573001912549,0.573078042388,0.573153797739,0.573229178416,
	0.573304184234,0.573378815007,0.573453070550,0.573526950679,0.573600455207,
	0.573673583952,0.573746336729,0.573818713354,0.573890713644,0.573962337416,
	0.574033584487,0.574104454675,0.574174947797,0.574245063671,0.574314802117,
	0.574384162953,0.574453145999,0.574521751073,0.574589977996,0.574657826588,
	0.574725296670,0.574792388063,0.574859100588,0.574925434066,0.574991388321,
	0.575056963175,0.575122158450,0.575186973970,0.575251409559,0.575315465041,
	0.575379140240,0.575442434981,0.575505349090,0.575567882392,0.575630034714,
	0.575691805883,0.575753195725,0.575814204069,0.575874830742,0.575935075572,
	0.575994938389,0.576054419022,0.576113517301,0.576172233056,0.576230566118,
	0.576288516319,0.576346083489,0.576403267463,0.576460068072,0.576516485149,
	0.576572518529,0.576628168046,0.576683433535,0.576738314831,0.576792811770,
	0.576846924189,0.576900651924,0.576953994813,0.577006952695,0.577059525409,
	0.577111712792,0.577163514686,0.577214930930,0.577265961366,0.577316605834,
	0.577366864179,0.577416736241,0.577466221865,0.577515320895,0.577564033175,
	0.577612358550,0.577660296867,0.577707847971,0.577755011710,0.577801787932,
	0.577848176486,0.577894177219,0.577939789983,0.577985014627,0.578029851002,
	0.578074298961,0.578118358356,0.578162029040,0.578205310867,0.578248203691,
	0.578290707368,0.578332821754,0.578374546705,0.578415882079,0.578456827734,
	0.578497383529,0.578537549324,0.578577324979,0.578616710355,0.578655705314,
	0.578694309720,0.578732523434,0.578770346323,0.578807778250,0.578844819082,
	0.578881468685,0.578917726927,0.578953593676,0.578989068801,0.579024152172,
	0.579058843660,0.579093143136,0.579127050473,0.579160565545,0.579193688225,
	0.579226418388,0.579258755911,0.579290700669,0.579322252541,0.579353411406,
	0.579384177142,0.579414549630,0.579444528752,0.579474114389,0.579503306425,
	0.579532104743,0.579560509229,0.579588519769,0.579616136248,0.579643358556,
	0.579670186581,0.579696620213,0.579722659342,0.579748303860,0.579773553660,
	0.579798408636,0.579822868681,0.579846933693,0.579870603567,0.579893878202,
	0.579916757495,0.579939241348,0.579961329660,0.579983022334,0.580004319273,
	0.580025220380,0.580045725561,0.580065834722,0.580085547770,0.580104864614,
	0.580123785162,0.580142309326,0.580160437017,0.580178168148,0.580195502633,
	0.580212440387,0.580228981325,0.580245125366,0.580260872427,0.580276222429,
	0.580291175292,0.580305730939,0.580319889291,0.580333650274,0.580347013814,
	0.580359979836,0.580372548269,0.580384719041,0.580396492085,0.580407867330,
	0.580418844710,0.580429424158,0.580439605611,0.580449389005,0.580458774277,
	0.580467761367,0.580476350216,0.580484540764,0.580492332955,0.580499726733,
	0.580506722044,0.580513318834,0.580519517053,0.580525316648,0.580530717572,
	0.580535719777,0.580540323216,0.580544527844,0.580548333617,0.580551740493,
	0.580554748432,0.580557357392,0.580559567338,0.580561378231,0.580562790036,
	0.580563802719,0.580564416248,0.580564630592,0.580564445721,0.580563861606,
	0.580562878222,0.580561495542,0.580559713543,0.580557532202,0.580554951499,
	0.580551971414,0.580548591929,0.580544813027,0.580540634695,0.580536056917,
	0.580531079683,0.580525702982,0.580519926806,0.580513751146,0.580507175997,
	0.580500201356,0.580492827218,0.580485053584,0.580476880454,0.580468307829,
	0.580459335714,0.580449964114,0.580440193036,0.580430022487,0.580419452479,
	0.580408483023,0.580397114132,0.580385345822,0.580373178109,0.580360611011,
	0.580347644548,0.580334278742,0.580320513616,0.580306349196,0.580291785507,
	0.580276822579,0.580261460440,0.580245699124,0.580229538663,0.580212979093,
	0.580196020451,0.580178662775,0.580160906105,0.580142750485,0.580124195957,
	0.580105242567,0.580085890363,0.580066139394,0.580045989711,0.580025441367,
	0.580004494417,0.579983148915,0.579961404922,0.579939262497,0.579916721701,
	0.579893782598,0.579870445254,0.579846709736,0.579822576114,0.579798044457,
	0.579773114839,0.579747787335,0.579722062022,0.579695938977,0.579669418281,
	0.579642500017,0.579615184268,0.579587471121,0.579559360663,0.579530852985,
	0.579501948177,0.579472646335,0.579442947553,0.579412851929,0.579382359562,
	0.579351470555,0.579320185010,0.579288503033,0.579256424731,0.579223950214,
	0.579191079592,0.579157812980,0.579124150492,0.579090092246,0.579055638360,
	0.579020788958,0.578985544160,0.578949904094,0.578913868886,0.578877438666,
	0.578840613564,0.578803393716,0.578765779255,0.578727770320,0.578689367050,
	0.578650569587,0.578611378075,0.578571792659,0.578531813488,0.578491440711,
	0.578450674481,0.578409514951,0.578367962278,0.578326016620,0.578283678138,
	0.578240946994,0.578197823353,0.578154307382,0.578110399249,0.578066099127,
	0.578021407187,0.577976323606,0.577930848561,0.577884982232,0.577838724800,
	0.577792076449,0.577745037366,0.577697607739,0.577649787758,0.577601577616,
	0.577552977508,0.577503987631,0.577454608184,0.577404839368,0.577354681387,
	0.577304134448,0.577253198757,0.577201874525,0.577150161964,0.577098061290,
	0.577045572719,0.576992696469,0.576939432764,0.576885781825,0.576831743879,
	0.576777319154,0.576722507879,0.576667310288,0.576611726616,0.576555757099,
	0.576499401976,0.576442661489,0.576385535882,0.576328025401,0.576270130294,
	0.576211850812,0.576153187207,0.576094139735,0.576034708653,0.575974894220,
	0.575914696699,0.575854116354,0.575793153452
	}
};

double always_inline output12ax7_negclip(double x) {
    double f = fabs(x);
    f = f * output12ax7_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = output12ax7_neg_table.data[0];
    } else if (i >= output12ax7_neg_table.size-1) {
        f = output12ax7_neg_table.data[output12ax7_neg_table.size-1];
    } else {
    f -= i;
    f = output12ax7_neg_table.data[i]*(1-f) + output12ax7_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

