INCLUDE(CheckIncludeFile)
INCLUDE(CheckIncludeFiles)
INCLUDE(CheckSymbolExists)
INCLUDE(CheckFunctionExists)
INCLUDE(CheckLibraryExists)
INCLUDE(CheckTypeSize)
INCLUDE(CheckCXXSourceCompiles)
INCLUDE(MacroBoolTo01)

find_package(Gettext)
find_package(DBUS)

CHECK_INCLUDE_FILES(crypt.h HAVE_CRYPT_H)
CHECK_INCLUDE_FILES(linux/inet.h HAVE_LINUX_INET_H)
CHECK_INCLUDE_FILES(unistd.h HAVE_UNISTD_H)
CHECK_INCLUDE_FILES(locale.h HAVE_LOCALE_H)

MACRO_BOOL_TO_01(GETTEXT_FOUND ENABLE_NLS)
MACRO_BOOL_TO_01(DBUS_FOUND HAVE_DBUS)

if (GETTEXT_FOUND)
  set(GETTEXT_PACKAGE "gpsdrive")
endif (GETTEXT_FOUND)

SET(LOCALEDIR ${LOCALE_INSTALL_DIR})
SET(PACKAGE ${APPLICATION_NAME})
SET(VERSION ${APPLICATION_VERSION})
SET(DATADIR ${DATA_INSTALL_DIR})
SET(LIBDIR ${LIB_INSTALL_DIR})

