/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.internal.pluginsipc;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AntPluginDeviceDbProvider {
    private static final String TAG = AntPluginDeviceDbProvider.class.getSimpleName();

    public static DeviceDbDeviceInfo dbsrvc_getDeviceInfo(Context currentContext, int antDeviceNumber, String pluginName) throws AntPluginDeviceDbException {
        Bundle req = new Bundle();
        req.putInt("int_RequestType", 18);
        req.putInt("int_AntDeviceNumber", antDeviceNumber);
        req.putString("string_PluginName", pluginName);
        Bundle results = AntPluginDeviceDbProvider.executeDbRequest(currentContext, req);
        return (DeviceDbDeviceInfo)results.getParcelable("parcelable_DeviceDbInfo");
    }

    public static void dbsrvc_changeDeviceInfo(Context currentContext, DeviceDbDeviceInfo dev, String chgVisibleName, Boolean chgIsPreferredDevice) throws AntPluginDeviceDbException {
        Bundle req = new Bundle();
        req.putInt("int_RequestType", 20);
        req.putParcelable("parcelable_DeviceDbInfo", (Parcelable)dev);
        req.putString("string_DISPLAYNAME", chgVisibleName);
        req.putBoolean("boolean_IsUserPreferredDevice", chgIsPreferredDevice.booleanValue());
        AntPluginDeviceDbProvider.executeDbRequest(currentContext, req);
    }

    public static void dbsrvc_addDevice(Context currentContext, DeviceDbDeviceInfo devInfo, String pluginName, Bundle deviceParams) throws AntPluginDeviceDbException {
        Bundle req = new Bundle();
        req.putInt("int_RequestType", 22);
        req.putParcelable("parcelable_DeviceDbInfo", (Parcelable)devInfo);
        req.putString("string_PluginName", pluginName);
        req.putBundle("bundle_PluginDeviceParams", deviceParams);
        AntPluginDeviceDbProvider.executeDbRequest(currentContext, req);
    }

    private static Bundle executeDbRequest(Context currentContext, Bundle req) throws AntPluginDeviceDbException {
        PackageManager pm = currentContext.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo("com.dsi.ant.plugins.antplus", 4);
            boolean serviceInstalled = false;
            for (ServiceInfo i : pi.services) {
                if (!"com.dsi.ant.plugins.antplus.utility.db.Service_DeviceDbProvider".equals(i.name)) continue;
                serviceInstalled = true;
                break;
            }
            if (!serviceInstalled) {
                throw new AntPluginDeviceDbException("AntPlusPlugins not installed", -2);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new AntPluginDeviceDbException("AntPlusPlugins not installed", -3);
        }
        final Exchanger<Object> requestFinishedExchange = new Exchanger<Object>();
        final HandlerThread ht = new HandlerThread("AntPluginDeviceDb Result Handler");
        ht.start();
        Messenger resultHandler = new Messenger(new Handler(ht.getLooper()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                try {
                    requestFinishedExchange.exchange(msg.getData(), 100L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LogAnt.e(TAG, "Handler result exchange interrupted");
                }
                catch (TimeoutException e) {
                    LogAnt.e(TAG, "Handler result exchange timed out");
                }
                finally {
                    ht.quit();
                }
            }
        });
        req.putParcelable("msgr_ResultReceiver", (Parcelable)resultHandler);
        Intent i = new Intent();
        i.setClassName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.utility.db.Service_DeviceDbProvider");
        i.putExtra("com.dsi.ant.plugins.antplus.utility.db.devicedbrequest", req);
        currentContext.startService(i);
        try {
            Bundle result = requestFinishedExchange.exchange(null, 5L, TimeUnit.SECONDS);
            result.setClassLoader(currentContext.getClassLoader());
            int resultCode = result.getInt("int_ResultCode");
            if (resultCode != 0) {
                throw new AntPluginDeviceDbException("Result returned failure", resultCode);
            }
            return result;
        }
        catch (InterruptedException e) {
            LogAnt.e(TAG, "Main result exchange interrupted");
            throw new AntPluginDeviceDbException("Main result exchange interrupted", -4);
        }
        catch (TimeoutException e) {
            LogAnt.e(TAG, "Result exchange interrupted");
            throw new AntPluginDeviceDbException("DB request timed out", -4);
        }
    }

    public static class AntPluginDeviceDbException
    extends Exception {
        private static final long serialVersionUID = 8657725579688499890L;
        public int deviceDbQueryResult;

        public AntPluginDeviceDbException(String s, int deviceDbQueryResult) {
            super(s);
            this.deviceDbQueryResult = deviceDbQueryResult;
        }

        public class DeviceDbQueryResult {
            public static final int SUCCESS = 0;
            public static final int FAIL_PROCESSING = -1;
            public static final int FAIL_FUNCTIONALITY_NOT_AVAILABLE_FOR_INSTALLED_PLUGIN_VERSION = -2;
            public static final int FAIL_PLUGINS_NOT_INSTALLED = -3;
            public static final int FAIL_OTHER = -4;
        }
    }

    public static class DeviceDbDeviceInfo
    implements Parcelable {
        public static final String KEY_DEFAULT_DEVICEDBKEY = "parcelable_DeviceDbInfo";
        private int ipcVersionNumber;
        public Long device_dbId;
        public Long plugin_dbId;
        public Integer antDeviceNumber;
        public String visibleName;
        public Boolean isPreferredDevice;
        public static final Parcelable.Creator<DeviceDbDeviceInfo> CREATOR = new Parcelable.Creator<DeviceDbDeviceInfo>(){

            public DeviceDbDeviceInfo createFromParcel(Parcel in) {
                return new DeviceDbDeviceInfo(in);
            }

            public DeviceDbDeviceInfo[] newArray(int size) {
                return new DeviceDbDeviceInfo[size];
            }
        };

        public DeviceDbDeviceInfo() {
            this.ipcVersionNumber = 1;
            this.isPreferredDevice = false;
        }

        public DeviceDbDeviceInfo(int ipcVersionNumber) {
            this.ipcVersionNumber = ipcVersionNumber;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeValue((Object)this.device_dbId);
            dest.writeValue((Object)this.plugin_dbId);
            dest.writeValue((Object)this.antDeviceNumber);
            dest.writeValue((Object)this.visibleName);
            dest.writeValue((Object)this.isPreferredDevice);
        }

        public DeviceDbDeviceInfo(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " AsyncScanResultDeviceInfo parcel with version 1 parser.");
            }
            this.device_dbId = (Long)in.readValue(null);
            this.plugin_dbId = (Long)in.readValue(null);
            this.antDeviceNumber = (Integer)in.readValue(null);
            this.visibleName = (String)in.readValue(null);
            this.isPreferredDevice = (Boolean)in.readValue(null);
        }
    }

    public static class IpcDefines {
        public static final String PATH_ARS_DEVICEDBSRVC_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ARS_DEVICEDBSRVC_SERVICE = "com.dsi.ant.plugins.antplus.utility.db.Service_DeviceDbProvider";
        public static final String MSG_ARS_DEVICEDBSRVC_PARAMPKGNAME = "com.dsi.ant.plugins.antplus.utility.db.devicedbrequest";
        public static final String MSG_ARS_DEVICEDBSRVC_REQ_PARAM_KEY_msgrRESULTRECEIVER = "msgr_ResultReceiver";
        public static final String MSG_ARS_DEVICEDBSRVC_REQ_PARAM_KEY_intREQUESTTYPE = "int_RequestType";
        public static final int MSG_ARS_DEVICEDBSRVC_REQ_TYPE_GETDEVICEINFO = 18;
        public static final int MSG_ARS_DEVICEDBSRVC_REQ_TYPE_ADDDEVICE = 20;
        public static final int MSG_ARS_DEVICEDBSRVC_REQ_TYPE_CHANGEDEVICEINFO = 22;
        public static final String MSG_ARS_DEVICEDBSRVC_PARAM_intANTDEVNUMBER = "int_AntDeviceNumber";
        public static final String MSG_ARS_DEVICEDBSRVC_PARAM_stringPLUGINNAME = "string_PluginName";
        public static final String MSG_ARS_DEVICEDBSRVC_PARAM_stringDISPLAYNAME = "string_DISPLAYNAME";
        public static final String MSG_ARS_DEVICEDBSRVC_PARAM_booleanISUSERPREFFEREDDEVICE = "boolean_IsUserPreferredDevice";
        public static final String MSG_ARS_DEVICEDBSRVC_PARAM_bundlePLUGINDEVICEPARAMS = "bundle_PluginDeviceParams";
        public static final String MSG_ARS_DEVICEDBSRVC_REQ_RESULT_intRESULTCODE = "int_ResultCode";
    }
}

