// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package doc

import (
	"entgo.io/ent/entc/integration/customid/ent/schema"
)

const (
	// Label holds the string label denoting the doc type in the database.
	Label = "doc"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldText holds the string denoting the text field in the database.
	FieldText = "text"
	// EdgeParent holds the string denoting the parent edge name in mutations.
	EdgeParent = "parent"
	// EdgeChildren holds the string denoting the children edge name in mutations.
	EdgeChildren = "children"
	// EdgeRelated holds the string denoting the related edge name in mutations.
	EdgeRelated = "related"
	// Table holds the table name of the doc in the database.
	Table = "docs"
	// ParentTable is the table that holds the parent relation/edge.
	ParentTable = "docs"
	// ParentColumn is the table column denoting the parent relation/edge.
	ParentColumn = "doc_children"
	// ChildrenTable is the table that holds the children relation/edge.
	ChildrenTable = "docs"
	// ChildrenColumn is the table column denoting the children relation/edge.
	ChildrenColumn = "doc_children"
	// RelatedTable is the table that holds the related relation/edge. The primary key declared below.
	RelatedTable = "doc_related"
)

// Columns holds all SQL columns for doc fields.
var Columns = []string{
	FieldID,
	FieldText,
}

// ForeignKeys holds the SQL foreign-keys that are owned by the "docs"
// table and are not defined as standalone fields in the schema.
var ForeignKeys = []string{
	"doc_children",
}

var (
	// RelatedPrimaryKey and RelatedColumn2 are the table columns denoting the
	// primary key for the related relation (M2M).
	RelatedPrimaryKey = []string{"doc_id", "related_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	for i := range ForeignKeys {
		if column == ForeignKeys[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultID holds the default value on creation for the "id" field.
	DefaultID func() schema.DocID
	// IDValidator is a validator for the "id" field. It is called by the builders before save.
	IDValidator func(string) error
)
