/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2011 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMDB_H
#define GMDB_H

#include "gmconfig.h"

#include <new>
#include <fx.h>
#include <fx3d.h>
#include <FXArray.h>
#include <FXTextCodec.h>
#include <sqlite3.h>

#define FOXVERSION ((FOX_LEVEL) + (FOX_MINOR*1000) + (FOX_MAJOR*100000))
#define FXVERSION(major,minor,release) ((release)+(minor*1000)+(major*100000))
#define SQVERSION(major,minor,release) ((release)+(minor*1000)+(major*1000000))

#include "fxext.h"

#if FOXVERSION < FXVERSION(1,7,0)
#define TIME_NSEC(ns) ((FXuint)(ns/1000000LL))
#define TIME_MSEC(ms) (ms)
#define TIME_SEC(s) 	(1000*s)
#define TIME_MIN(m) 	TIME_SEC(60*m)
#define TIME_HOUR(h) 	TIME_MIN(60*h)
#else
#define TIME_NSEC(ns) (ns)
#define TIME_SEC(s) 	(1000000000LL*s)
#define TIME_MSEC(ms) (1000000LL*ms)
#define TIME_MIN(m) 	TIME_SEC(60*m)
#define TIME_HOUR(h) 	TIME_MIN(60*h)
#endif

#if FOXVERSION >= FXVERSION(1,7,12)
#define GMStringVal(str) FXString::value(str)
#define GMStringFormat  FXString::value
#define GMFloatVal(str) str.toFloat()
#define GMIntVal(str)  (str).toInt()
#else
#define GMStringVal(str) FXStringVal(str)
#define GMStringFormat  FXStringFormat
#define GMFloatVal(str) FXFloatVal(str)
#define GMIntVal(str) FXIntVal(str)
#endif


#if FOXVERSION >= FXVERSION(1,7,0)
#include <FXAutoPtr.h>
#endif

#include "GMURL.h"
#include "GMAutoPtr.h"
#if FOXVERSION < FXVERSION(1,7,0)
#include "GMMessageChannel.h"
#endif


#ifdef DEBUG
namespace FX {
extern FXlong fxgetticks();
}
#define GM_DEBUG_PRINT(format, args...) fxmessage (format , ##args)
#else
#define GM_DEBUG_PRINT(arguments, args...) ((void)0)
#endif

#define UTF8_COPYRIGHT_SIGN "\xc2\xa9"
#define UTF8_ELLIPSIS "…"

#include "GMTag.h"

typedef sqlite3 GMDatabaseEngine;
typedef sqlite3_stmt GMDatabaseStatement;
typedef FXArray<FXString> FXStringList;
typedef FXArray<FXint> FXIntList;
typedef FXArray<FXlong> FXLongList;
typedef FXAutoPtr<FXCursor>   FXCursorPtr;
typedef FXAutoPtr<FXIcon>     FXIconPtr;
typedef FXAutoPtr<FXImage>    FXImagePtr;
typedef FXAutoPtr<FXMenuPane> FXMenuPtr;
typedef FXAutoPtr<FXFont>     FXFontPtr;
typedef FXAutoPtr<FXPopup>    FXPopupPtr;

enum {
  REPEAT_OFF    = 0,
  REPEAT_TRACK,
  REPEAT_ALL,
  };

enum {
  SOURCE_UNKNOWN  = -1,
  SOURCE_INVALID  = -1,
  SOURCE_DATABASE,
  SOURCE_DATABASE_PLAYLIST,
  SOURCE_INTERNET_RADIO,
  SOURCE_ALBUM,
  SOURCE_ARTIST,
  SOURCE_AUDIOCD,
  };

enum {
  HEADER_DEFAULT=0,
  HEADER_SHUFFLE=1,
  HEADER_BROWSE,
  HEADER_QUEUE,
  HEADER_TRACK,
  HEADER_TITLE,
  HEADER_ALBUM,
  HEADER_ARTIST,
  HEADER_TIME,
  HEADER_GENRE,
  HEADER_BITRATE,
	HEADER_RATING,
	HEADER_YEAR,
  HEADER_DISC,
  HEADER_ALBUM_ARTIST,
  HEADER_NONE
  };



struct GMStream{
  FXString url;
  FXString description;
	FXString genre;
  FXint    bitrate;
  };

class GMTrackItem;

extern const FXchar * fxtr(const FXchar *) __attribute__ ((format_arg(1)));

#define notr(x) x
#define fxtrformat(x) fxtr(x)


#define INVALID_TRACK -1

#include "GMQuery.h"
#include "GMDatabase.h"

#include "GMPreferences.h"

#include "gmutils.h"
#include <tag.h>

#endif

