SetFactory("OpenCASCADE");
Mesh.CharacteristicLengthMax=1;
Mesh.CharacteristicLengthMin=2;

//-----------------------------------------
Sphere(0)={-0.766778,20.7137,24.2035,5.55064};
Sphere(1)={-0.766778,-29.2863,-25.7965,5.55064};
Sphere(2)={-0.766778,20.7137,-25.7965,5.55064};
Sphere(3)={-0.766778,-29.2863,24.2035,5.55064};
Sphere(4)={-16.3526,-0.542467,-17.053,4.93224};
Sphere(5)={24.6536,-6.80334,21.0158,5.26445};
Sphere(6)={-25.3464,-6.80334,-28.9842,5.26445};
Sphere(7)={24.6536,-6.80334,-28.9842,5.26445};
Sphere(8)={-25.3464,-6.80334,21.0158,5.26445};
Sphere(9)={18.9207,10.9859,12.8826,5.36834};
Sphere(10)={-8.36131,20.8556,5.27741,5.54417};
Sphere(11)={-8.36131,-29.1444,5.27741,5.54417};
Sphere(12)={5.20264,12.6171,-6.50426,4.98626};
Sphere(13)={-7.55715,-7.01544,7.78298,5.97244};
Sphere(14)={13.4167,23.5565,5.64821,5.1245};
Sphere(15)={13.4167,-26.4435,5.64821,5.1245};
Sphere(16)={2.14164,3.37306,24.0677,5.9318};
Sphere(17)={2.14164,3.37306,-25.9323,5.9318};
Sphere(18)={20.5428,-12.4615,-4.38017,5.69185};
Sphere(19)={-29.4572,-12.4615,-4.38017,5.69185};
Sphere(20)={-17.0087,-7.99814,-6.19144,5.16264};
Sphere(21)={7.64718,-13.8791,20.8266,4.69366};
Sphere(22)={7.64718,-13.8791,-29.1734,4.69366};
Sphere(23)={17.3765,-22.5829,16.6761,4.08114};
Sphere(24)={17.3765,27.4171,16.6761,4.08114};
Sphere(25)={-0.164037,23.8754,-8.54747,4.49897};
Sphere(26)={-0.164037,-26.1246,-8.54747,4.49897};
Sphere(27)={-23.262,10.5144,4.23215,4.03221};
Sphere(28)={26.738,10.5144,4.23215,4.03221};
Sphere(29)={16.1939,1.81204,-22.1923,4.22093};
Sphere(30)={16.1939,1.81204,27.8077,4.22093};
Sphere(31)={18.4904,-18.9512,-15.3958,4.53351};
Sphere(32)={0.205237,-7.92642,-18.6232,4.59185};
Sphere(33)={-16.5754,15.4492,-20.3307,3.81433};
Sphere(34)={24.6261,24.6139,2.88171,4.1409};
Sphere(35)={-25.3739,-25.3861,2.88171,4.1409};
Sphere(36)={24.6261,-25.3861,2.88171,4.1409};
Sphere(37)={-25.3739,24.6139,2.88171,4.1409};
Sphere(38)={-20.7228,19.3663,-9.12275,3.81564};
Sphere(39)={15.315,15.4431,-15.3027,4.50561};
Sphere(40)={-6.37608,13.3435,-7.17261,4.36878};
Sphere(41)={6.46611,-15.5332,4.2581,4.08746};
Sphere(42)={-22.3663,-8.51848,8.62377,3.67807};
Sphere(43)={27.6337,-8.51848,8.62377,3.67807};
Sphere(44)={-3.73775,-4.19095,-4.21537,4.20893};
Sphere(45)={-18.2051,-19.8042,-18.7132,4.41231};
Sphere(46)={-12.4966,-18.4111,-2.74895,4.66561};
Sphere(47)={-3.25709,8.75805,2.18589,3.90399};
Sphere(48)={15.7758,1.49922,-3.39442,4.26543};
Sphere(49)={-12.7865,21.0295,19.2534,3.88284};
Sphere(50)={4.88067,5.01648,11.9427,4.10168};
Sphere(51)={4.65026,-20.4665,-18.7895,4.25111};
Sphere(52)={-12.759,-19.6989,19.0626,4.44534};
Sphere(53)={-19.8012,9.81399,-9.16395,4.04785};
Sphere(54)={-6.72399,-15.9696,-22.7279,4.03679};
Sphere(55)={-6.72399,-15.9696,27.2721,4.03679};
Sphere(56)={17.0637,-0.490585,8.57646,4.65234};
Sphere(57)={-16.6669,12.7331,14.9091,3.89182};
Sphere(58)={6.53172,-17.3643,-8.31095,4.08547};
Sphere(59)={12.109,-9.92843,-12.3531,3.4285};
Sphere(60)={17.2956,-14.0835,8.31095,2.75881};
Sphere(61)={-10.9554,-8.54442,-14.8343,2.76435};
Sphere(62)={11.4055,19.3648,20.9609,2.54022};
Sphere(63)={-8.66192,17.6069,-16.3587,2.82335};
Sphere(64)={20.7213,19.8241,18.8154,2.91626};
Sphere(65)={-20.8083,1.3329,24.7726,2.82525};
Sphere(66)={-20.8083,1.3329,-25.2274,2.82525};
Sphere(67)={17.8617,24.4293,-5.93204,2.85445};
Sphere(68)={17.8617,-25.5707,-5.93204,2.85445};
Sphere(69)={-7.17109,-23.0544,-14.5245,3.04353};
Sphere(70)={-7.17109,26.9456,-14.5245,3.04353};
Sphere(71)={-17.1857,-19.7981,6.44169,2.64843};
Sphere(72)={4.78607,-3.63399,2.4865,3.5592};
Sphere(73)={-3.65383,-20.381,-0.112156,2.73399};
Sphere(74)={4.76928,12.2768,17.2514,3.26024};
Sphere(75)={7.79672,-1.4626,-5.51241,2.65776};
Sphere(76)={-3.64772,-16.818,-5.93661,2.62581};
Sphere(77)={8.37199,24.7177,14.3445,3.05381};
Sphere(78)={8.37199,-25.2823,14.3445,3.05381};
Sphere(79)={8.01492,16.6135,12.1807,2.69034};
Sphere(80)={-16.0596,4.1055,8.74279,2.52585};
Sphere(81)={12.55,-2.3629,20.999,2.74325};
Sphere(82)={23.3383,11.3781,-20.5718,2.72698};
Sphere(83)={-26.6617,11.3781,-20.5718,2.72698};
Sphere(84)={10.1726,0.145726,-12.1548,2.6789};
Sphere(85)={-4.19095,1.96463,-11.3567,3.35913};
Sphere(86)={-10.847,9.03424,-18.5667,2.6075};
Sphere(87)={-0.228126,-24.9359,9.85977,2.90216};
Sphere(88)={-0.228126,25.0641,9.85977,2.90216};
Sphere(89)={-2.27287,-12.4294,20.0087,2.88965};
Sphere(90)={-7.45186,-6.56835,19.1099,2.74939};
Sphere(91)={-15.1944,-0.115207,19.8637,2.67811};
Sphere(92)={-24.736,-17.642,12.8155,3.46855};
Sphere(93)={25.264,-17.642,12.8155,3.46855};
Sphere(94)={7.31758,7.21686,2.1218,3.5279};
Sphere(95)={19.293,3.99869,-13.0093,3.54954};
Sphere(96)={-5.89846,12.8277,12.8216,3.62975};
Sphere(97)={5.2942,-10.0856,13.2397,2.54444};
Sphere(98)={13.5617,-9.44014,-20.9349,2.92234};
Sphere(99)={-21.3088,8.59325,-24.6017,3.03485};
Sphere(100)={-21.3088,8.59325,25.3983,3.03485};
Sphere(101)={4.74334,4.54344,-14.7229,3.05775};
Sphere(102)={5.00275,-9.51186,-6.03122,2.5196};
Sphere(103)={-16.203,0.766778,-0.698111,3.36603};
Sphere(104)={20.4131,-5.89389,-14.581,3.56694};
Sphere(105)={15.0357,-8.726,13.7387,3.38855};
Sphere(106)={7.79366,-2.67724,-18.6811,2.66122};
Sphere(107)={-9.63546,3.94528,3.37458,2.53505};
Sphere(108)={5.5063,13.6868,6.36387,3.04199};
Sphere(109)={21.1989,16.1374,-4.35575,3.2791};
Sphere(110)={9.6263,-24.3805,-11.9884,2.57606};
Sphere(111)={9.6263,25.6195,-11.9884,2.57606};
Sphere(112)={-18.1944,-9.77889,-19.8225,3.10028};
Sphere(113)={-13.8607,10.2626,0.200659,3.61734};
Sphere(114)={0.339518,-1.66707,12.5027,2.56204};
Sphere(115)={14.6542,10.9951,2.30186,2.69539};
Sphere(116)={-23.7594,24.9054,17.4314,3.23316};
Sphere(117)={26.2406,-25.0946,17.4314,3.23316};
Sphere(118)={-23.7594,-25.0946,17.4314,3.23316};
Sphere(119)={26.2406,24.9054,17.4314,3.23316};
Sphere(120)={19.0397,14.8282,24.4766,3.20771};
Sphere(121)={19.0397,14.8282,-25.5234,3.20771};
Sphere(122)={-0.717948,-14.5856,11.2026,2.65678};
Sphere(123)={21.3073,-18.4416,-24.913,3.04939};
Sphere(124)={21.3073,-18.4416,25.087,3.04939};
Sphere(125)={-18.4004,-18.1455,-9.59731,2.54997};
Sphere(126)={-1.24897,10.5632,-18.199,3.21962};
Sphere(127)={-24.2904,0.516526,10.2855,2.62489};
Sphere(128)={25.7096,0.516526,10.2855,2.62489};
Sphere(129)={-17.0942,18.2508,-0.377667,2.86626};
Sphere(130)={-17.79,24.1592,12.5637,2.90096};
Sphere(131)={-17.79,-25.8408,12.5637,2.90096};
Sphere(132)={-17.6176,-9.03272,15.0739,2.94846};
Sphere(133)={1.48396,24.7894,1.70827,2.54259};
Sphere(134)={1.48396,-25.2106,1.70827,2.54259};
Sphere(135)={-12.1929,6.78808,19.6165,3.24162};
Sphere(136)={-6.58666,3.02515,15.5866,3.13162};
Sphere(137)={6.71789,20.1109,-16.5082,3.22781};
Sphere(138)={23.8495,-24.4415,-10.4289,3.01192};
Sphere(139)={-26.1505,25.5585,-10.4289,3.01192};
Sphere(140)={23.8495,25.5585,-10.4289,3.01192};
Sphere(141)={-26.1505,-24.4415,-10.4289,3.01192};
Sphere(142)={7.65481,12.7804,-21.3561,3.29168};
Sphere(143)={-24.678,21.6842,-18.5881,2.52178};
Sphere(144)={25.322,21.6842,-18.5881,2.52178};
Sphere(145)={-21.6552,3.98953,15.7987,2.78116};
Sphere(146)={18.9589,23.6663,-21.6536,2.59998};
Sphere(147)={18.9589,-26.3337,-21.6536,2.59998};
Sphere(148)={-3.17469,11.784,20.0774,2.67018};
Sphere(149)={-19.1145,22.7813,24.9908,3.19073};
Sphere(150)={-19.1145,-27.2187,-25.0092,3.19073};
Sphere(151)={-19.1145,22.7813,-25.0092,3.19073};
Sphere(152)={-19.1145,-27.2187,24.9908,3.19073};
Sphere(153)={-24.2904,-0.0144963,-0.627918,2.78683};
Sphere(154)={25.7096,-0.0144963,-0.627918,2.78683};
Sphere(155)={4.56023,-4.65484,-11.5322,2.61005};
Sphere(156)={-10.9218,23.0071,-7.29316,3.4167};
Sphere(157)={-10.9218,-26.9929,-7.29316,3.4167};
Sphere(158)={13.5052,-24.4461,24.8871,2.88401};
Sphere(159)={13.5052,25.5539,-25.1129,2.88401};
Sphere(160)={13.5052,-24.4461,-25.1129,2.88401};
Sphere(161)={13.5052,25.5539,24.8871,2.88401};
Sphere(162)={-13.7463,-9.56832,21.1104,2.62451};
Sphere(163)={-10.5281,23.9654,-22.8683,3.15136};
Sphere(164)={-10.5281,-26.0346,27.1317,3.15136};
Sphere(165)={-10.5281,23.9654,27.1317,3.15136};
Sphere(166)={-10.5281,-26.0346,-22.8683,3.15136};
Sphere(167)={-0.846126,17.9731,-15.7712,2.63751};
Sphere(168)={14.0561,-7.85775,3.64925,2.63351};
Sphere(169)={-7.12683,-19.084,12.3058,2.68876};
Sphere(170)={-23.8098,15.727,24.913,2.52126};
Sphere(171)={26.1902,15.727,-25.087,2.52126};
Sphere(172)={-23.8098,15.727,-25.087,2.52126};
Sphere(173)={26.1902,15.727,24.913,2.52126};
Sphere(174)={-10.0398,4.81964,-5.37812,3.3768};
Sphere(175)={-5.58412,24.3683,15.9406,2.77442};
Sphere(176)={-5.58412,-25.6317,15.9406,2.77442};
Sphere(177)={-9.32112,-15.5255,-14.7382,2.78026};
Sphere(178)={-8.04849,-2.1569,-23.7808,3.12347};
Sphere(179)={-8.04849,-2.1569,26.2192,3.12347};
Sphere(180)={-21.4583,-15.5103,19.5082,2.71053};
Sphere(181)={9.14411,-2.50786,9.36842,3.13174};
Sphere(182)={23.2238,8.42998,-3.35322,3.25564};
Sphere(183)={-26.7762,8.42998,-3.35322,3.25564};
Sphere(184)={-23.4634,-13.0154,-13.1726,2.75489};
Sphere(185)={26.5366,-13.0154,-13.1726,2.75489};
Sphere(186)={11.5139,12.4645,21.9543,3.01166};
Sphere(187)={2.4102,-6.10904,17.6725,2.66744};
Sphere(188)={-9.42793,12.7972,24.9771,3.38355};
Sphere(189)={-9.42793,12.7972,-25.0229,3.38355};
Sphere(190)={0.826289,-21.0356,17.4055,3.10875};
Sphere(191)={10.0078,23.5778,-4.60143,3.36417};
Sphere(192)={10.0078,-26.4222,-4.60143,3.36417};
Sphere(193)={-20.9548,1.15284,-7.22602,2.99831};

xmin=-25;
xmax=25;
ymin=-25;
ymax=25;
zmin=-25;
zmax=25;
maxDiameter=12;

maxSphere=193;
For i In {1:6}
	boxNumbers(i-1)=maxSphere+i;
EndFor

Box(boxNumbers(0))={xmin-1.5*maxDiameter,ymin-1.5*maxDiameter,zmin,1.5*maxDiameter,ymax-ymin+2*1.5*maxDiameter,zmax-zmin};
Box(boxNumbers(1))={xmax,ymin-1.5*maxDiameter,zmin,1.5*maxDiameter,ymax-ymin+2*1.5*maxDiameter,zmax-zmin};
Box(boxNumbers(2))={xmin,ymin-1.5*maxDiameter,zmin,xmax-xmin,1.5*maxDiameter,zmax-zmin};
Box(boxNumbers(3))={xmin,ymax,zmin,xmax-xmin,1.5*maxDiameter,zmax-zmin};
Box(boxNumbers(4))={xmin-1.5*maxDiameter,ymin-1.5*maxDiameter,zmin-1.5*maxDiameter,xmax-xmin+2*1.5*maxDiameter,ymax-ymin+2*1.5*maxDiameter,1.5*maxDiameter};
Box(boxNumbers(5))={xmin-1.5*maxDiameter,ymin-1.5*maxDiameter,zmax,xmax-xmin+2*1.5*maxDiameter,ymax-ymin+2*1.5*maxDiameter,1.5*maxDiameter};

tool=BooleanUnion{Volume {boxNumbers(0)};Delete;} {Volume {boxNumbers()};Delete;};
Printf("Boolean Operation: %g",tool);

For t In {0:maxSphere}
	outcome()=BooleanDifference{Volume {t};} {Volume {tool};};
	If (outcome(0)!=t)

	SpheresToBeDeleted()+=t;
		Printf("Boolean Operation succesfull at Sphere %g. Outcome: %g;",t,outcome[0]);
		SphereClass()+=outcome(0);
	Else
		SphereClass()+=t;
	EndIf

EndFor

Recursive Delete{Volume{SpheresToBeDeleted(),tool};}


mainvolume=newv;
Box(mainvolume)={xmin,ymin,zmin,xmax-xmin,ymax-ymin,zmax-zmin};

Coherence;

e = 1e-3;

Sxmin() = Surface In BoundingBox{ -25-e, -25-e, -25-e, -25+e, 25+e, 25+e };

For i In {0:#Sxmin()-1}
  bb() = BoundingBox Surface { Sxmin(i) };
  bbe() = { bb(0)-e+50, bb(1)-e, bb(2)-e, bb(3)+e+50, bb(4)+e, bb(5)+e };
  Sxmax() = Surface In BoundingBox { bbe() };
  For j In {0:#Sxmax()-1}
    bb2() = BoundingBox Surface { Sxmax(j) };
    bb2(0) -= 50;
    bb2(3) -= 50;
    If(Fabs(bb2(0)-bb(0)) < e && Fabs(bb2(1)-bb(1)) < e &&
       Fabs(bb2(2)-bb(2)) < e && Fabs(bb2(3)-bb(3)) < e &&
       Fabs(bb2(4)-bb(4)) < e && Fabs(bb2(5)-bb(5)) < e)
      Periodic Surface {Sxmax(j)} = {Sxmin(i)} Translate {50,0,0};
    EndIf
  EndFor
EndFor
