
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/fs.h>
#include <linux/hdreg.h>
#include <assert.h>
#include <string.h>
#include <errno.h>

#include "dvh.h"

#if 1
#define SECTORS_PER_TRACK	32
#define BYTES_PER_SECTOR	512
#else
#define SECTORS_PER_TRACK	8
#define BYTES_PER_SECTOR	2048
#endif

#define __u16	unsigned short
#define __u32	unsigned int

#define swab16(x) \
({ \
	__u16 __x = (x); \
	((__u16)( \
		(((__u16)(__x) & (__u16)0x00ffU) << 8) | \
		(((__u16)(__x) & (__u16)0xff00U) >> 8) )); \
})

#define swab32(x) \
({ \
	__u32 __x = (x); \
	((__u32)( \
		(((__u32)(__x) & (__u32)0x000000ffUL) << 24) | \
		(((__u32)(__x) & (__u32)0x0000ff00UL) <<  8) | \
		(((__u32)(__x) & (__u32)0x00ff0000UL) >>  8) | \
		(((__u32)(__x) & (__u32)0xff000000UL) >> 24) )); \
})

#if __BYTE_ORDER == __LITTLE_ENDIAN
#define be32_to_cpu(x) swab32((x))
#define be16_to_cpu(x) swab16((x))
#define cpu_to_be32(x) swab32((x))
#define cpu_to_be16(x) swab16((x))
#else
#define be32_to_cpu(x) ((__u32)(x))
#define be16_to_cpu(x) ((__u16)(x))
#define cpu_to_be32(x) ((__u32)(x))
#define cpu_to_be16(x) ((__u16)(x))
#endif


__u32 vh_calc_checksum(struct volume_header *vh) {
	__u32	oldchecksum,
		newsum=0,
		*buffer=(__u32 *) vh;
	int	i;

	oldchecksum=vh->vh_csum;
	vh->vh_csum=0;

	for(i=0;i<sizeof(struct volume_header)/sizeof(__u32);i++) {
		newsum=newsum-be32_to_cpu(buffer[i]);
	}

	vh->vh_csum=oldchecksum;
	return(newsum);
}

void usage(void ) {
	printf("Usage:\ngenisovh <isofile> <name:sblock,size> ... \n");
	exit(1);
}

int main(int argc, char **argv) {
	int			fd,
				i,
				v,
				block,
				size;
	char			*isoname,
				*cline,
				*pos;
	struct stat		st;
	struct volume_header	vh;


	if (argc < 2)
		usage();

	isoname=argv[1];

	if (!(fd=open(isoname, O_RDWR))) {
		printf("File not found %s\n", isoname);
		exit(1);
	}

	if (fstat(fd, &st)) {
		printf("Failed to stat file %s\n", isoname);
		close(fd);
		exit(1);
	}
	
	memset(&vh, 0, sizeof(struct volume_header));

	vh.vh_magic = cpu_to_be32(VHMAGIC);

	/* Values from an IRIX cd */
	vh.vh_dp.dp_secbytes=cpu_to_be16(BYTES_PER_SECTOR);
	vh.vh_dp.dp_secs=cpu_to_be16(SECTORS_PER_TRACK);
	vh.vh_dp.dp_flags=cpu_to_be32(DP_RESEEK|DP_IGNOREERRORS|DP_TRKFWD);
	vh.vh_dp.dp_trks0=cpu_to_be16(1);

	vh.vh_dp.dp_cyls=cpu_to_be16((st.st_size + BYTES_PER_SECTOR - 1) /
		(SECTORS_PER_TRACK*BYTES_PER_SECTOR));

	for(i=2,v=0;i<argc;i++,v++) {

		cline=argv[i];	

		/* ip22:3838383,3333 */
		if (!(pos=strchr(cline, ':'))) {
			printf("Couldnt find : in parameter %s\n", cline);	
			usage();
		}

		*pos=0x0;

		/* copy name */
		strncpy(vh.vh_vd[v].vd_name, cline, VDNAMESIZE);

		cline=pos+1;

		if (!(pos=strchr(cline, ','))) {
			printf("Could find , in parameter %s\n", cline);
			usage();
		}

		*pos=0x0;

		block=atoi(cline);	
		vh.vh_vd[v].vd_lbn=cpu_to_be32(block);

		cline=pos+1;

		size=atoi(cline);	
		vh.vh_vd[v].vd_nbytes=cpu_to_be32(size);

	}

	/* Create volume header partition on WHOLE cd iso */
	vh.vh_pt[8].pt_nblks=cpu_to_be32((st.st_size + (BYTES_PER_SECTOR - 1)) /
		BYTES_PER_SECTOR);

	/* Create checksum */
	vh.vh_csum=cpu_to_be32(vh_calc_checksum(&vh));

	if (write(fd, &vh, sizeof(struct volume_header)) != sizeof(struct volume_header)) {
		printf("Failed to write volume header to iso image");
		close(fd);
		exit(1);
	}

	close(fd);
}
