Getting Started with FnordMetric Server
=======================================

_This guide will walk you through starting a FnordMetric Server instance, inserting
metric data and querying the metric data with ChartSQL. If you do not have installed
FnordMetric yet, read the [Installation page](/documentation/installation) first._

Fnordmetric Server is a standalone HTTP server application. It exposes a web UI
and a HTTP API to run ChartSQL queries and collect timeseries data.

You can start FnordMetric Server with or without a "storage backend".
If FnordMetric Server is started without a storage backend you can only use the
web interface to execute ChartSQL queries against external data sources (like a
MySQL database). If it is started with a storage backend, you can also use the
HTTP (and optionally the statsd) API to collect timeseries data into the storage
backend and subsequently query that timerseries data using ChartSQL.

FnordMetric Server currently supports three storage backends: `inmemory`, `disk`,
and `hbase`.


#### Starting Fnordmetric Server

For the getting started guide we will use the `disk` backend which stores the
metric data in a folder on the local hard disk. To start a FnordMetric server
instance with a local disk storage backend on HTTP port 8080 run:

    $ mkdir -p /tmp/fnordmetric-data
    $ fnordmetric-server --http_port 8080 --statsd_port 8125 --storage_backend disk --datadir /tmp/fnordmetric-data

#### Collecting Timeseries Data

FnordMetric Server records timeseries data in "Metrics". A Metric is somewhat
equivalent to a table in a regular SQL database. Each metric has a unique name
and consists of a collection of data points called "samples" that are recorded
over time (i.e. a timeseries).

A "sample" is a single datapoint. Each sample contains at least a timestamp
and a numeric value. To keep the table analogy, each metric is a table that has
two default columns `value` and `time` and each sample is a row in that table.

You can query metrics using ChartSQL like normal tables:

    > select time, value from mymetric;

    ===================================
    | time                  |  value  |
    ===================================
    | 2014-11-08 20:30:12   |  0.913  |
    | 2014-11-08 20:30:42   |  0.837  |
    | 2014-11-08 20:31:13   |  0.638  |
    | 2014-11-08 20:31:41   |  0.326  |
    | ...                   |  ...    |



As an example, we will monitor the http response times of a fictional web
application. We will create one "metric" that will be called `http\_response\_times`
and will record the http response times (latencies) of our application. We are
going to insert a sample into this metric for each HTTP request that our web
application serves.

There are a number of client libraries that allow you to send samples to
FnordMetric Server using the HTTP or statsd API. For now, lets cheat a bit and
manually send samples from the command line. The simplest way to send samples
from your command line is using the statsd API. If you started FnordMetric Server
on port 8125 (see above), you can use the netcat utility to send a sample via
UDP+statsd.

Let's insert the value `42` into the `http\_response\_times` metric. In our example this
means we record the response time of a single HTTP request that took 42ms.

    $ echo "http_response_times:42" | nc -u -w0 127.0.0.1 8125


Execute this command a few times with different values to insert multiple samples
into the metric. FnordMetric Server will automatically create the metric if it
doesn't exist yet.

#### Execute Queries from the Web Interface

You should now be able to navigate to the admin interface on
`http://localhost:8080/` in your browser and see our newly created metric. Click
on the metric to bring up the interactive query editor. This should look something
like this:

<div style="width:960px; margin:50px auto 40px auto; height:583px; overflow: hidden;" class="shadow">
  <video width="960" height="583" autoplay="autoplay" loop>
    <source src="/fnordmetric-server.mp4" type="video/mp4">
    <script type="text/javascript">
      if (!(navigator.userAgent.search("Safari") >= 0 && navigator.userAgent.search("Chrome") < 0)) {
        document.write('<source src="/fnordmetric-server.webm" type="video/webm">');
      }
    </script>
    <img src="/img/fnordmetric_server_screen.png" width="875" />
  </video>
</div>

Click around a bit to make yourself familiar with the Web UI. The charts you see
above are generated using ChartSQL. The queries are  automatically generated by
the interactive query editor. Here is an example query:

<i>Display the 100 latest samples from `http\_response\_times` as a line chart with the
sample time plotted on the X axis and the sample value plotted on the Y axis.:</i>

    DRAW LINECHART
        AXIS LEFT
        AXIS BOTTOM;

    SELECT time as x, value as y
        FROM http_response_times
        ORDER BY time DESC
        LIMIT 100;


#### Adding labels

To allow you to drill down into your metric data in arbitrary dimensions, each
sample can optionally be labelled with one or more "labels". Each label is a
key: value pair.

In our example, assume we run our web application on multiple hosts in different
datacenters. It would be nice to label each sample with  `hostname=...` and
`datacenter=...` so that we can roll up the http response times by host, datacenter
or a combinaton of both.

Let's insert a few more example samples into our <code>http\_response\_times</code> metric
and attach these labels:

    $ echo "http_response_times[hostname=machine82][datacenter=ams1]:18" | nc -u -w0 127.0.0.1 8125
    $ echo "http_response_times[hostname=machine83][datacenter=ams1]:42" | nc -u -w0 127.0.0.1 8125
    $ echo "http_response_times[hostname=machine84][datacenter=ams1]:23" | nc -u -w0 127.0.0.1 8125

When querying metrics with ChartSQL, the label keys act as table columns so you
can filter and aggregate/group by label values. Our <code>http\_response\_times</code> table
now has 4 columns:

    > select time, value, hostname, datacenter from http_response_times;

    ==============================================================
    | time                  | value  | hostname   | datacenter  |
    ==============================================================
    | 2014-11-08 20:30:12   | 18     | machine82  | ams1        |
    | 2014-11-08 20:30:12   | 42     | machine83  | ams1        |
    | 2014-11-08 20:30:12   | 23     | machine84  | ams1        |
    | ...                   | ...    | ...        | ...         |

You can execute this query from the interactive query editor to display the last
hour of samples in the `http\_response\_times` metric rolled up by hostname. It
will draw a line chart with the sample time plotted on the X axis and the sample value
plotted on the Y axis and one series per hostname:

    DRAW LINECHART
        AXIS LEFT
        AXIS BOTTOM;

    SELECT hostname as series, time as x, value as y
        FROM http_response_times
        WHERE time > -1hour;

The result should look something like this:

<img src="/img/fnordmetric_server_screen2.png" width="800" class="shadow" />
<br />

You now have a running FnordMetric Server, but there is a lot more you can do.
These are good docs to read next:

  + [Examples](/examples/)
  + [ChartSQL Query Language](/documentation/chartsql/introduction/)
  + [Time-window aggregations](/documentation/chartsql/timewindow_aggregations/)

This guide will walk you through building a simple HTML5 dashboard using ChartSQL
and FnordMetric Server:

  + [Gettting Started with HTML5 Dashboards in 5 Minutes](/documentation/html5_dashboards)
