/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AncillaryData;
import edu.wisc.ssec.mcidas.CalibratorGvar;
import java.io.DataInputStream;
import java.io.IOException;

public class CalibratorGvarG10
extends CalibratorGvar {
    protected static float[] imager10FK1 = new float[5];
    protected static float[] sounder10FK1 = new float[18];
    protected static float[] imager10FK2 = new float[5];
    protected static float[] sounder10FK2 = new float[18];
    protected static float[] imager10TC1 = new float[5];
    protected static float[] sounder10TC1 = new float[18];
    protected static float[] imager10TC2 = new float[5];
    protected static float[] sounder10TC2 = new float[18];

    public CalibratorGvarG10(DataInputStream dis, AncillaryData ad, int[] cb) throws IOException {
        super(dis, ad, cb);
    }

    public CalibratorGvarG10(int sensorId, int[] cb) {
        super(sensorId, cb);
    }

    public float radToTemp(float inVal, int band, int sId) {
        float outVal;
        if (sId % 2 == 0) {
            double expn = (double)(imager10FK1[band - 1] / inVal) + 1.0;
            double temp = (double)imager10FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)imager10TC1[band - 1]) / (double)imager10TC2[band - 1]);
        } else {
            double expn = (double)(sounder10FK1[band - 1] / inVal) + 1.0;
            double temp = (double)sounder10FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)sounder10TC1[band - 1]) / (double)sounder10TC2[band - 1]);
        }
        return outVal;
    }

    static {
        CalibratorGvarG10.imager10FK1[0] = 0.0f;
        CalibratorGvarG10.imager10FK1[1] = 198410.0f;
        CalibratorGvarG10.imager10FK1[2] = 39086.0f;
        CalibratorGvarG10.imager10FK1[3] = 9774.4f;
        CalibratorGvarG10.imager10FK1[4] = 6828.6f;
        CalibratorGvarG10.sounder10FK1[0] = 3730.5f;
        CalibratorGvarG10.sounder10FK1[1] = 4003.9f;
        CalibratorGvarG10.sounder10FK1[2] = 4312.4f;
        CalibratorGvarG10.sounder10FK1[3] = 4661.6f;
        CalibratorGvarG10.sounder10FK1[4] = 4973.4f;
        CalibratorGvarG10.sounder10FK1[5] = 5869.8f;
        CalibratorGvarG10.sounder10FK1[6] = 6816.1f;
        CalibratorGvarG10.sounder10FK1[7] = 8940.4f;
        CalibratorGvarG10.sounder10FK1[8] = 12973.0f;
        CalibratorGvarG10.sounder10FK1[9] = 28708.0f;
        CalibratorGvarG10.sounder10FK1[10] = 34401.0f;
        CalibratorGvarG10.sounder10FK1[11] = 43086.0f;
        CalibratorGvarG10.sounder10FK1[12] = 124680.0f;
        CalibratorGvarG10.sounder10FK1[13] = 128820.0f;
        CalibratorGvarG10.sounder10FK1[14] = 135320.0f;
        CalibratorGvarG10.sounder10FK1[15] = 168530.0f;
        CalibratorGvarG10.sounder10FK1[16] = 188620.0f;
        CalibratorGvarG10.sounder10FK1[17] = 224870.0f;
        CalibratorGvarG10.imager10FK2[0] = 0.0f;
        CalibratorGvarG10.imager10FK2[1] = 3674.5f;
        CalibratorGvarG10.imager10FK2[2] = 2138.1f;
        CalibratorGvarG10.imager10FK2[3] = 1347.0f;
        CalibratorGvarG10.imager10FK2[4] = 1195.3f;
        CalibratorGvarG10.sounder10FK2[0] = 977.1f;
        CalibratorGvarG10.sounder10FK2[1] = 1000.4f;
        CalibratorGvarG10.sounder10FK2[2] = 1025.5f;
        CalibratorGvarG10.sounder10FK2[3] = 1052.4f;
        CalibratorGvarG10.sounder10FK2[4] = 1075.4f;
        CalibratorGvarG10.sounder10FK2[5] = 1136.5f;
        CalibratorGvarG10.sounder10FK2[6] = 1194.5f;
        CalibratorGvarG10.sounder10FK2[7] = 1307.6f;
        CalibratorGvarG10.sounder10FK2[8] = 1480.4f;
        CalibratorGvarG10.sounder10FK2[9] = 1929.1f;
        CalibratorGvarG10.sounder10FK2[10] = 2049.0f;
        CalibratorGvarG10.sounder10FK2[11] = 2208.7f;
        CalibratorGvarG10.sounder10FK2[12] = 3147.4f;
        CalibratorGvarG10.sounder10FK2[13] = 3181.8f;
        CalibratorGvarG10.sounder10FK2[14] = 3234.5f;
        CalibratorGvarG10.sounder10FK2[15] = 3480.0f;
        CalibratorGvarG10.sounder10FK2[16] = 3613.1f;
        CalibratorGvarG10.sounder10FK2[17] = 3831.1f;
        CalibratorGvarG10.imager10TC1[0] = 0.0f;
        CalibratorGvarG10.imager10TC1[1] = 0.62226f;
        CalibratorGvarG10.imager10TC1[2] = 0.61438f;
        CalibratorGvarG10.imager10TC1[3] = 0.27791f;
        CalibratorGvarG10.imager10TC1[4] = 0.21145f;
        CalibratorGvarG10.sounder10TC1[0] = 0.00988f;
        CalibratorGvarG10.sounder10TC1[1] = 0.01196f;
        CalibratorGvarG10.sounder10TC1[2] = 0.01245f;
        CalibratorGvarG10.sounder10TC1[3] = 0.01245f;
        CalibratorGvarG10.sounder10TC1[4] = 0.01366f;
        CalibratorGvarG10.sounder10TC1[5] = 0.04311f;
        CalibratorGvarG10.sounder10TC1[6] = 0.13973f;
        CalibratorGvarG10.sounder10TC1[7] = 0.11707f;
        CalibratorGvarG10.sounder10TC1[8] = 0.03979f;
        CalibratorGvarG10.sounder10TC1[9] = 0.14968f;
        CalibratorGvarG10.sounder10TC1[10] = 0.27603f;
        CalibratorGvarG10.sounder10TC1[11] = 0.13049f;
        CalibratorGvarG10.sounder10TC1[12] = 0.02008f;
        CalibratorGvarG10.sounder10TC1[13] = 0.01834f;
        CalibratorGvarG10.sounder10TC1[14] = 0.02017f;
        CalibratorGvarG10.sounder10TC1[15] = 0.05292f;
        CalibratorGvarG10.sounder10TC1[16] = 0.0533f;
        CalibratorGvarG10.sounder10TC1[17] = 0.28683f;
        CalibratorGvarG10.imager10TC2[0] = 0.0f;
        CalibratorGvarG10.imager10TC2[1] = 0.99912f;
        CalibratorGvarG10.imager10TC2[2] = 0.99857f;
        CalibratorGvarG10.imager10TC2[3] = 0.99905f;
        CalibratorGvarG10.imager10TC2[4] = 0.99919f;
        CalibratorGvarG10.sounder10TC2[0] = 0.99995f;
        CalibratorGvarG10.sounder10TC2[1] = 0.99994f;
        CalibratorGvarG10.sounder10TC2[2] = 0.99994f;
        CalibratorGvarG10.sounder10TC2[3] = 0.99995f;
        CalibratorGvarG10.sounder10TC2[4] = 0.99994f;
        CalibratorGvarG10.sounder10TC2[5] = 0.99983f;
        CalibratorGvarG10.sounder10TC2[6] = 0.99947f;
        CalibratorGvarG10.sounder10TC2[7] = 0.99959f;
        CalibratorGvarG10.sounder10TC2[8] = 0.99988f;
        CalibratorGvarG10.sounder10TC2[9] = 0.99962f;
        CalibratorGvarG10.sounder10TC2[10] = 0.99933f;
        CalibratorGvarG10.sounder10TC2[11] = 0.9997f;
        CalibratorGvarG10.sounder10TC2[12] = 0.99997f;
        CalibratorGvarG10.sounder10TC2[13] = 0.99997f;
        CalibratorGvarG10.sounder10TC2[14] = 0.99997f;
        CalibratorGvarG10.sounder10TC2[15] = 0.99992f;
        CalibratorGvarG10.sounder10TC2[16] = 0.99992f;
        CalibratorGvarG10.sounder10TC2[17] = 0.99961f;
    }
}

