/* $Id: parallel.c,v 1.23 2009-01-28 14:38:00 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "compiler.h"

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

CODE16;

#include "assert.h"
#include "fixme.h"
#include "io.h"
#include "var.h"
#include "parallel.h"

void
bios_17_xxxx(struct regs *regs)
{
	if (AH < 3 && DX == 0) {	/* FIXME VOSSI */
		uint16_t addr;
		uint16_t timeout;
		uint8_t val8;

		addr = var_get(addr_par[DX]);
		timeout = var_get(par_tmout[DX]) << 8;

		if (AH == 0x00) {
			outb(AL, addr);
			val8 = inb(addr + 2);
			outb(val8 | 0x01, addr + 2);	/* Send strobe. */
			asm ("nop");
			outb(val8 & ~0x01, addr + 2);
			while ((inb(addr + 1) & 0x40) == 0x40 && timeout) {
				timeout--;
			}

		} else if (AH == 0x01) {
			val8 = inb(addr + 2);
			outb(val8 & ~0x04, addr + 2);	/* Send init. */
			asm ("nop");
			outb(val8 | 0x40, addr + 2);

		} else { assert(AH == 0x02);
			/* Do nothing... */
		}

		AH = inb(addr + 1);
		val8 = ~AH & 0x48;
		AH &= 0xb7;
		AH |= val8;
		if (! timeout) {
			AH |= 0x01;
		}
		F &= ~(1 << 0);	/* Clear carry. */

	} else {
		/* Unsupported. */
		F |= 1 << 0;	/* Set carry. */
	}
}

void
bios_0f(struct regs *regs)
{
	/* Might be spurious interrupt *or* parallel port interrupt. */
	eoi();
}

#endif /* RUNTIME_RM */
/* =================== REAL-MODE INIT ========================= */
#ifdef INIT_RM

CODE16;

#include "io.h"
#include "var.h"

static void
detect_parport(uint16_t *nr, uint8_t timeout, uint16_t port)
{
	/* Clear input mode. */
	outb(inb(port + 2) & 0xdf, port + 2);

	outb(0xaa, port);
	if (inb(port) != 0xaa) {
		/* No parallel port found. */
		return;
	}

	var_put(addr_par[*nr], port);
	var_put(par_tmout[*nr], timeout);

	(*nr)++;
}

void
parallel_init(void)
{
	uint16_t nr;
	uint16_t equipment;

	/* Detect parallel ports. */
	nr = 0;
	detect_parport(&nr, 0x14, 0x378);
	detect_parport(&nr, 0x14, 0x278);

	/* Set equipment byte. */
	equipment = var_get(sys_conf);
	equipment &= ~(3 << 14);
	equipment |= nr << 14;
	var_put(sys_conf, equipment);
}

#endif /* INIT_RM */
