/*
 * $Id: sig_eth.h,v 1.9 2012-03-06 14:46:49 siflkres Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_ETH_H_INCLUDED
#define __SIG_ETH_H_INCLUDED

#include "sig_gen.h"
#include <stdio.h>

struct sig_eth_funcs {
	void (*recv)(void *s, const void *buf, unsigned int buflen);
};

struct sig_eth {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_eth_funcs *f;
	} member[32];
	unsigned int nmembers;
};

extern void
sig_eth_send(struct sig_eth *b, void *s, const void *buf, unsigned int buflen);

extern void
sig_eth_connect(struct sig_eth *b, void *s, const struct sig_eth_funcs *f);

extern struct sig_eth *
sig_eth_create(const char *name);
extern void
sig_eth_destroy(struct sig_eth *sig);

extern void
sig_eth_suspend(struct sig_eth *b, FILE *fSig);
extern void
sig_eth_resume(struct sig_eth *b, FILE *fSig);

#endif /* __SIG_ETH_H_INCLUDED */
