/* $Id: cim_cardbus.h,v 1.23 2009-01-27 17:44:18 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "bridge.h"

#include "sig_boolean.h"
#include "sig_cardbus.h"
#include "sig_pci_bus.h"

struct cim_cardbus_msg {
	enum {
		CIM_CARDBUS_POWER = 1,
		CIM_CARDBUS_N_RESET,
		CIM_CARDBUS_TYPE_ADDR,
		CIM_CARDBUS_READ_DATA,
		CIM_CARDBUS_WRITE_DATA,
		CIM_CARDBUS_IRQ,
	} msg_type;
	int ack; /* ack=0: request, ack=1: answer */
	union {
		unsigned int p5V;
		unsigned int n_reset;
		struct {
			uint32_t addr;
			unsigned int bs;
			uint32_t val;
		};
		unsigned int irq;
	};
};

struct cim_cardbus {
	struct sig_boolean *sig_p5V;
	struct sig_boolean *sig_n_reset;
	struct sig_pci_bus_main *sig_bus;
	struct sig_boolean_or *sig_irq;
	struct sig_boolean *sig_conn;

	struct bridge bridge;

	struct cim_cardbus_msg ans;
	int ans_available;

	int type;
	uint32_t addr;
};

extern void
cim_cardbus_reconfig(struct cim_cardbus *b);

extern void
cim_cardbus_init(struct cim_cardbus *css, struct sig_cardbus *sig);

extern void
cim_cardbus_create(struct cim_cardbus *b);
extern void
cim_cardbus_destroy(struct cim_cardbus *b);
