-- $Id: stdlogic.vhdl 4329 2009-01-27 14:48:04Z potyra $
-- vim:tabstop=8:shiftwidth=8:textwidth=72

-- VHDL-testbench for ieee.std_logic_1164 (FAUmachine's own hacked
-- version, not the IEEE one)
--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library ieee;
use ieee.std_logic_1164.ALL;

entity foo is 
	port (
		signal std_vec_in : in std_logic_vector(1 to 32);
		signal std_vec_out : out std_logic_vector(1 to 32)
	);
end entity foo;

architecture foos of foo is
begin
	catcher : process
	BEGIN
		wait on std_vec_in;
		ASSERT FALSE REPORT "event on std_vec_in" 
		SEVERITY NOTE;
		std_vec_out(1) <= 'L';
	END PROCESS catcher;
end architecture foos;

library ieee;
use ieee.std_logic_1164.ALL;

entity node is
	port (
		signal std_vec_out : out std_logic_vector(1 to 32);
		signal std_vec_in : in std_logic_vector(1 to 32)
	);

	signal dummy : boolean;

end entity node;

architecture structural of node is
begin
	bar : foo port map (
		std_vec_in => std_vec_out,
		std_vec_out => std_vec_in
	);

	test_stdlogic : PROCESS
		VARIABLE o1 : std_logic;
		VARIABLE o2 : std_logic;
		VARIABLE result : std_logic;
		VARIABLE stdvec : std_logic_vector(23 to 42);
		VARIABLE b : integer;
		VARIABLE stdvec32 : std_logic_vector(1 to 32);
	BEGIN
		-- ****************************************************
		-- **                      OR                        **
		-- ****************************************************
		ASSERT false REPORT "testing std_logic: or" SEVERITY
		NOTE;
		
		-- U against others
		o1 := 'U';
		o2 := 'U';
		result := o1 or o2;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'X';
		result := o1 or o2;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := '0';
		result := o1 or o2;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := '1';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'Z';
		result := o1 or o2;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;

		o1 := 'U';
		o2 := 'W';
		result := o1 or o2;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'L';
		result := o1 or o2;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'H';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := 'U';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'U' REPORT "or" SEVERITY FAILURE;

		-- X against others (w.o. U)
		o1 := 'X';
		o2 := 'X';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := '0';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := '1';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'Z';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;

		o1 := 'X';
		o2 := 'W';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'L';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'H';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := 'X';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;

		-- 0 against others (w.o. U, X)
		o1 := '0';
		o2 := '0';
		result := o1 or o2;
		ASSERT result = '0' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '0' REPORT "or" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := '1';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'Z';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;

		o1 := '0';
		o2 := 'W';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'L';
		result := o1 or o2;
		ASSERT result = '0' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '0' REPORT "or" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'H';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := '0';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;

		-- 1 against others (w.o. U, X, 0)
		o1 := '1';
		o2 := '1';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'Z';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := '1';
		o2 := 'W';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'L';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'H';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := '1';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

	-- Z against others (w.o. U, X, 0, 1)
		o1 := 'Z';
		o2 := 'Z';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;

		o1 := 'Z';
		o2 := 'W';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'Z';
		o2 := 'L';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'Z';
		o2 := 'H';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := 'Z';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;

		-- W against others (w.o. U, X, 0, 1, Z)
		o1 := 'W';
		o2 := 'W';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'W';
		o2 := 'L';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'W';
		o2 := 'H';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := 'W';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;

		-- L against others (w.o. U, X, 0, 1, Z, W)
		o1 := 'L';
		o2 := 'L';
		result := o1 or o2;
		ASSERT result = '0' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '0' REPORT "or" SEVERITY FAILURE;
		
		o1 := 'L';
		o2 := 'H';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := 'L';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;

		-- H against others (w.o. U, X, 0, 1, Z, W, L)
		o1 := 'H';
		o2 := 'H';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		o1 := 'H';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = '1' REPORT "or" SEVERITY FAILURE;

		-- - against others (w.o. U, X, 0, 1, Z, W, L, H)
		o1 := '-';
		o2 := '-';
		result := o1 or o2;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		result := o2 or o1;
		ASSERT result = 'X' REPORT "or" SEVERITY FAILURE;
		
		-- ****************************************************
		-- **                      AND                       **
		-- ****************************************************
		ASSERT false REPORT "testing std_logic: and" SEVERITY
		NOTE;

		-- U against others
		o1 := 'U';
		o2 := 'U';
		result := o1 and o2;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'X';
		result := o1 and o2;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := '0';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := '1';
		result := o1 and o2;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'Z';
		result := o1 and o2;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;

		o1 := 'U';
		o2 := 'W';
		result := o1 and o2;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'L';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'H';
		result := o1 and o2;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;

		o1 := 'U';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'U' REPORT "and" SEVERITY FAILURE;

		-- X against others (w.o. U)
		o1 := 'X';
		o2 := 'X';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := '0';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := '1';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'Z';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		o1 := 'X';
		o2 := 'W';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'L';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'H';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		o1 := 'X';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		-- 0 against others (w.o. U, X)
		o1 := '0';
		o2 := '0';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := '1';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'Z';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;

		o1 := '0';
		o2 := 'W';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'L';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'H';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;

		o1 := '0';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;

		-- 1 against others (w.o. U, X, 0)
		o1 := '1';
		o2 := '1';
		result := o1 and o2;
		ASSERT result = '1' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '1' REPORT "and" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'Z';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		o1 := '1';
		o2 := 'W';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'L';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'H';
		result := o1 and o2;
		ASSERT result = '1' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '1' REPORT "and" SEVERITY FAILURE;

		o1 := '1';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

	-- Z against others (w.o. U, X, 0, 1)
		o1 := 'Z';
		o2 := 'Z';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		o1 := 'Z';
		o2 := 'W';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'Z';
		o2 := 'L';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'Z';
		o2 := 'H';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		o1 := 'Z';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		-- W against others (w.o. U, X, 0, 1, Z)
		o1 := 'W';
		o2 := 'W';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'W';
		o2 := 'L';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'W';
		o2 := 'H';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		o1 := 'W';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		-- L against others (w.o. U, X, 0, 1, Z, W)
		o1 := 'L';
		o2 := 'L';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		
		o1 := 'L';
		o2 := 'H';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;

		o1 := 'L';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '0' REPORT "and" SEVERITY FAILURE;

		-- H against others (w.o. U, X, 0, 1, Z, W, L)
		o1 := 'H';
		o2 := 'H';
		result := o1 and o2;
		ASSERT result = '1' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = '1' REPORT "and" SEVERITY FAILURE;

		o1 := 'H';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		-- - against others (w.o. U, X, 0, 1, Z, W, L, H)
		o1 := '-';
		o2 := '-';
		result := o1 and o2;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;
		result := o2 and o1;
		ASSERT result = 'X' REPORT "and" SEVERITY FAILURE;

		-- ****************************************************
		-- **                      XOR                       **
		-- ****************************************************
		ASSERT false REPORT "testing std_logic: XOR" SEVERITY
		NOTE;

		-- U against others
		o1 := 'U';
		o2 := 'U';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'X';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := '0';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := '1';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'Z';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;

		o1 := 'U';
		o2 := 'W';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'L';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'U';
		o2 := 'H';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;

		o1 := 'U';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'U' REPORT "xor" SEVERITY FAILURE;

		-- X against others (w.o. U)
		o1 := 'X';
		o2 := 'X';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := '0';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := '1';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'Z';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		o1 := 'X';
		o2 := 'W';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'L';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'X';
		o2 := 'H';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		o1 := 'X';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		-- 0 against others (w.o. U, X)
		o1 := '0';
		o2 := '0';
		result := o1 xor o2;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := '1';
		result := o1 xor o2;
		ASSERT result = '1' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '1' REPORT "xor" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'Z';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		o1 := '0';
		o2 := 'W';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'L';
		result := o1 xor o2;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		
		o1 := '0';
		o2 := 'H';
		result := o1 xor o2;
		ASSERT result = '1' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '1' REPORT "xor" SEVERITY FAILURE;

		o1 := '0';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		-- 1 against others (w.o. U, X, 0)
		o1 := '1';
		o2 := '1';
		result := o1 xor o2;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'Z';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		o1 := '1';
		o2 := 'W';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'L';
		result := o1 xor o2;
		ASSERT result = '1' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '1' REPORT "xor" SEVERITY FAILURE;
		
		o1 := '1';
		o2 := 'H';
		result := o1 xor o2;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;

		o1 := '1';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

	-- Z against others (w.o. U, X, 0, 1)
		o1 := 'Z';
		o2 := 'Z';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		o1 := 'Z';
		o2 := 'W';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'Z';
		o2 := 'L';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'Z';
		o2 := 'H';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		o1 := 'Z';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		-- W against others (w.o. U, X, 0, 1, Z)
		o1 := 'W';
		o2 := 'W';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'W';
		o2 := 'L';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'W';
		o2 := 'H';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		o1 := 'W';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		-- L against others (w.o. U, X, 0, 1, Z, W)
		o1 := 'L';
		o2 := 'L';
		result := o1 xor o2;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		
		o1 := 'L';
		o2 := 'H';
		result := o1 xor o2;
		ASSERT result = '1' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '1' REPORT "xor" SEVERITY FAILURE;

		o1 := 'L';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		-- H against others (w.o. U, X, 0, 1, Z, W, L)
		o1 := 'H';
		o2 := 'H';
		result := o1 xor o2;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = '0' REPORT "xor" SEVERITY FAILURE;

		o1 := 'H';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;

		-- - against others (w.o. U, X, 0, 1, Z, W, L, H)
		o1 := '-';
		o2 := '-';
		result := o1 xor o2;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		result := o2 xor o1;
		ASSERT result = 'X' REPORT "xor" SEVERITY FAILURE;
		
		-- ****************************************************
		-- **                      NOT                       **
		-- ****************************************************
		ASSERT false REPORT "testing std_logic: NOT" SEVERITY
		NOTE;

		o1 := 'U';
		result := not o1;
		ASSERT result = 'U' REPORT "not" SEVERITY FAILURE;

		o1 := 'X';
		result := not o1;
		ASSERT result = 'X' REPORT "not" SEVERITY FAILURE;
		
		o1 := '0';
		result := not o1;
		ASSERT result = '1' REPORT "not" SEVERITY FAILURE;

		o1 := '1';
		result := not o1;
		ASSERT result = '0' REPORT "not" SEVERITY FAILURE;

		o1 := 'Z';
		result := not o1;
		ASSERT result = 'X' REPORT "not" SEVERITY FAILURE;

		o1 := 'W';
		result := not o1;
		ASSERT result = 'X' REPORT "not" SEVERITY FAILURE;

		o1 := 'L';
		result := not o1;
		ASSERT result = '1' REPORT "not" SEVERITY FAILURE;

		o1 := 'H';
		result := not o1;
		ASSERT result = '0' REPORT "not" SEVERITY FAILURE;

		o1 := '-';
		result := not o1;
		ASSERT result = 'X' REPORT "not" SEVERITY FAILURE;

		-- ****************************************************
		-- **                  AGGREGATES                    **
		-- ****************************************************
		assert false REPORT "testing aggregates" SEVERITY NOTE;

		stdvec := (27 => 'H', 32 => 'L', others => 'Z');
		assert stdvec(23) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(24) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(25) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(26) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(27) = 'H' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(28) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(29) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(30) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(31) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(32) = 'L' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(33) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(34) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(35) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(36) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(37) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(38) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(39) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(40) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(41) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;
		assert stdvec(42) = 'Z' REPORT "aggregates" SEVERITY
		FAILURE;

		-- the following should be valid vhdl, but it isn't
		-- thus, I cannot test aggregates of aggregates

		-- stdvecvec = (others => (others => 'Z'));

		-- ****************************************************
		-- **                  CONVERSION                    **
		-- ****************************************************
		assert false REPORT "testing conversion" SEVERITY NOTE;

		o1 := 'H';
		to_bit(o1, 0, b);
		ASSERT b = 1 REPORT "conversion" SEVERITY FAILURE;

		stdvec32 := (1 => '1', 4 => '1', 7 => '1', 13 => '1', 
		             20=> '1', 30 => '1', others => '0');
			     
		to_bit_vector32(stdvec32, 0, b);
		ASSERT b = 537399369 REPORT "conversion" SEVERITY
		FAILURE;
		
		stdvec32 := (1 => 'H', 2 => 'L', 3 => 'H', 4 => 'H', 
			     others => 'L');
		to_bit_vector32(stdvec32, 0, b);
		
		ASSERT b = 13 REPORT "conversion" SEVERITY
		FAILURE;

		-- ****************************************************
		-- **                  CONVERSION (2)                **
		-- ****************************************************
		assert false REPORT "testing conversion back" SEVERITY NOTE;
		-- convert some deadbeaf :)
		b := -559038801;
		to_stdlogic_vector32(b, stdvec32);
		-- 'f'
		ASSERT stdvec32(1) = '1' REPORT "conversion2-b0" SEVERITY FAILURE;
		ASSERT stdvec32(2) = '1' REPORT "conversion2-b1" SEVERITY FAILURE;
		ASSERT stdvec32(3) = '1' REPORT "conversion2-b2" SEVERITY FAILURE;
		ASSERT stdvec32(4) = '1' REPORT "conversion2-b3" SEVERITY FAILURE;
		--'a'
		ASSERT stdvec32(5) = '0' REPORT "conversion2-b4" SEVERITY FAILURE;
		ASSERT stdvec32(6) = '1' REPORT "conversion2-b5" SEVERITY FAILURE;
		ASSERT stdvec32(7) = '0' REPORT "conversion2-b6" SEVERITY FAILURE;
		ASSERT stdvec32(8) = '1' REPORT "conversion2-b7" SEVERITY FAILURE;
		
		--'e'
		ASSERT stdvec32(9) = '0' REPORT "conversion2-b8" SEVERITY FAILURE;
		ASSERT stdvec32(10) = '1' REPORT "conversion2-b9" SEVERITY FAILURE;
		ASSERT stdvec32(11) = '1' REPORT "conversion2-b10" SEVERITY FAILURE;
		ASSERT stdvec32(12) = '1' REPORT "conversion2-b11" SEVERITY FAILURE;
		--'b'
		ASSERT stdvec32(13) = '1' REPORT "conversion2-b12" SEVERITY FAILURE;
		ASSERT stdvec32(14) = '1' REPORT "conversion2-b13" SEVERITY FAILURE;
		ASSERT stdvec32(15) = '0' REPORT "conversion2-b14" SEVERITY FAILURE;
		ASSERT stdvec32(16) = '1' REPORT "conversion2-b15" SEVERITY FAILURE;
		
		-- 'd'
		ASSERT stdvec32(17) = '1' REPORT "conversion2-b16" SEVERITY FAILURE;
		ASSERT stdvec32(18) = '0' REPORT "conversion2-b17" SEVERITY FAILURE;
		ASSERT stdvec32(19) = '1' REPORT "conversion2-b18" SEVERITY FAILURE;
		ASSERT stdvec32(20) = '1' REPORT "conversion2-b19" SEVERITY FAILURE;
		--'a'
		ASSERT stdvec32(21) = '0' REPORT "conversion2-b20" SEVERITY FAILURE;
		ASSERT stdvec32(22) = '1' REPORT "conversion2-b21" SEVERITY FAILURE;
		ASSERT stdvec32(23) = '0' REPORT "conversion2-b22" SEVERITY FAILURE;
		ASSERT stdvec32(24) = '1' REPORT "conversion2-b23" SEVERITY FAILURE;
		
		--'e'
		ASSERT stdvec32(25) = '0' REPORT "conversion2-b24" SEVERITY FAILURE;
		ASSERT stdvec32(26) = '1' REPORT "conversion2-b25" SEVERITY FAILURE;
		ASSERT stdvec32(27) = '1' REPORT "conversion2-b26" SEVERITY FAILURE;
		ASSERT stdvec32(28) = '1' REPORT "conversion2-b27" SEVERITY FAILURE;
		--'d'
		ASSERT stdvec32(29) = '1' REPORT "conversion2-b28" SEVERITY FAILURE;
		ASSERT stdvec32(30) = '0' REPORT "conversion2-b29" SEVERITY FAILURE;
		ASSERT stdvec32(31) = '1' REPORT "conversion2-b30" SEVERITY FAILURE;
		ASSERT stdvec32(32) = '1' REPORT "conversion2-b31" SEVERITY FAILURE;

		-- ****************************************************
		-- **            SIGNAL ASSIGNMENT (VECTOR)          **
		-- ****************************************************
		ASSERT false REPORT 
		"testing std_logic: array signal assignment" 
		SEVERITY NOTE;
		std_vec_out <= stdvec32;

		wait on std_vec_in;
		ASSERT false REPORT
		"got event back. good." SEVERITY NOTE;
		ASSERT std_vec_in(1) = 'L' REPORT 
		"signal assignement (vector)" SEVERITY FAILURE;

		-- ****************************************************
		-- **                  GENERAL SANITY                **
		-- ****************************************************
		--ASSERT false REPORT "testing std_logic: illegal assign" 
		--SEVERITY NOTE;
		--o1 := 'a';
		--o2 := 'F';
		--ASSERT false REPORT "The last test should have failed."
		--SEVERITY failure;
		
		wait on dummy;

	END PROCESS test_stdlogic;

end architecture structural;
