/*
Copyright (C) 2005 Joseph L. Chuma, TRIUMF

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include "FCN_lnbeta.h"
#include "EExpressionError.h"
#include "UsefulFunctions.h"

FCN_lnbeta *FCN_lnbeta::fcn_lnbeta_ = 0;

void FCN_lnbeta::ScalarEval( int j, std::vector<double> &rStack ) const
{
  try
  {
    rStack[j] = UsefulFunctions::LnCompleteBeta( rStack[j], rStack[j+1] );
  }
  catch (EExpressionError &e)
  {
    throw;
  }
  rStack.pop_back();
}

// end of file

