/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __LINE_H
#define __LINE_H

//-- Project includes --
#include "Foundation/vec3.h"

/*!
  \class Line
  \brief Class representing a line

  \author Steffen Abe
*/
class Line
{
 protected:
  Vec3 Pos,U,N;
  Line();

 public:
  Line(const Vec3&,const Vec3&);
  virtual ~Line(){};

  Vec3 GetU() const {return U;};
  Vec3 GetO() const {return Pos;};
  Vec3 GetN() const {return N;};
  virtual double sep(const Vec3&);
};

#endif //__LINE_H
