.\" This page was taken from the 4.4BSD-Lite CDROM (BSD license)
.\"
.\" @(#)rpc.3n	2.4 88/08/08 4.0 RPCSRC; from 1.19 88/06/24 SMI
.\"
.\" 2007-12-30, mtk, Convert function prototypes to modern C syntax
.\"
.TH RPC 3 2008-07-17 "" "Linux Programmer's Manual"
.SH NAME
rpc \- library routines for remote procedure calls
.SH "SYNOPSIS AND DESCRIPTION"
These routines allow C programs to make procedure
calls on other machines across the network.
First, the client calls a procedure to send a data packet to the server.
Upon receipt of the packet, the server calls a dispatch routine
to perform the requested service, and then sends back a reply.
Finally, the procedure call returns to the client.
.\" .LP
.\" We don't have an rpc_secure.3 page at the moment -- MTK, 19 Sep 05
.\" Routines that are used for Secure RPC (DES authentication) are described in
.\" .BR rpc_secure (3).
.\" Secure RPC can be used only if DES encryption is available.
.LP
To take use of these routines, include the header file
.IR "<rpc/rpc.h>" .

The prototypes below make use of the following types:
.in +4n
.nf

typedef int \fIbool_t\fP;

typedef bool_t (*\fIxdrproc_t\fP) (XDR *, void *,...);

typedef bool_t (*\fIresultproc_t\fP) (caddr_t resp,
                                struct sockaddr_in *raddr);
.fi
.in
.LP
See the header files for the declarations of the
.IR AUTH ,
.IR CLIENT ,
.IR SVCXPRT ,
and
.IR XDR
types.
.LP
.nf
.BI "void auth_destroy(AUTH *" auth );
.fi
.IP
A macro that destroys the authentication information associated with
.IR auth .
Destruction usually involves deallocation of private data structures.
The use of
.I auth
is undefined after calling
.BR auth_destroy ().
.LP
.nf
.BI "AUTH *authnone_create(void);"
.fi
.IP
Create and return an RPC
authentication handle that passes nonusable authentication
information with each remote procedure call.
This is the default authentication used by RPC.
.LP
.nf
.BI "AUTH *authunix_create(char *" host ", int " uid ", int " gid ,
.BI "                      int " len ", int *" aup_gids );
.fi
.IP
Create and return an RPC authentication handle that contains
authentication information.
The parameter
.I host
is the name of the machine on which the information was created;
.I uid
is the user's user ID;
.I gid
is the user's current group ID;
.I len
and
.I aup_gids
refer to a counted array of groups to which the user belongs.
It is easy to impersonate a user.
.LP
.nf
.BI "AUTH *authunix_create_default(void);"
.fi
.IP
Calls
.BR authunix_create ()
with the appropriate parameters.
.LP
.nf
.BI "int callrpc(char *" host ", unsigned long " prognum ,
.BI "            unsigned long " versnum ", unsigned long " procnum ,
.BI "            xdrproc_t " inproc ", char *" in ,
.BI "            xdrproc_t " outproc ", char *" out );
.fi
.IP
Call the remote procedure associated with
.IR prognum ,
.IR versnum ,
and
.I procnum
on the machine,
.IR host .
The parameter
.I in
is the address of the procedure's argument(s), and
.I out
is the address of where to place the result(s);
.I inproc
is used to encode the procedure's parameters, and
.I outproc
is used to decode the procedure's results.
This routine returns zero if it succeeds, or the value of
.B "enum clnt_stat"
cast to an integer if it fails.
The routine
.BR clnt_perrno ()
is handy for translating failure statuses into messages.
.IP
Warning: calling remote procedures with this routine
uses UDP/IP as a transport; see
.BR clntudp_create ()
for restrictions.
You do not have control of timeouts or authentication using this routine.
.LP
.nf
.BI "enum clnt_stat clnt_broadcast(unsigned long " prognum ,
.BI "                     unsigned long " versnum ", unsigned long " procnum ,
.BI "                     xdrproc_t " inproc ", char *" in ,
.BI "                     xdrproc_t " outproc ", char *" out ,
.BI "                     resultproc_t " eachresult );
.fi
.IP
Like
.BR callrpc (),
except the call message is broadcast to all locally
connected broadcast nets.
Each time it receives a response, this routine calls
.BR eachresult (),
whose form is:
.IP
.in +4n
.nf
.BI "eachresult(char *" out ", struct sockaddr_in *" addr );
.fi
.in
.IP
where
.I out
is the same as
.I out
passed to
.BR clnt_broadcast (),
except that the remote procedure's output is decoded there;
.I addr
points to the address of the machine that sent the results.
If
.BR eachresult ()
returns zero,
.BR clnt_broadcast ()
waits for more replies; otherwise it returns with appropriate status.
.IP
Warning: broadcast sockets are limited in size to the
maximum transfer unit of the data link.
For ethernet, this value is 1500 bytes.
.LP
.nf
.BI "enum clnt_stat clnt_call(CLIENT *" clnt ", unsigned long " procnum ,
.BI "                    xdrproc_t " inproc ", char *" in ,
.BI "                    xdrproc_t " outproc ", char *" out ,
.BI "                    struct timeval " tout );
.fi
.IP
A macro that calls the remote procedure
.I procnum
associated with the client handle,
.IR clnt ,
which is obtained with an RPC client creation routine such as
.BR clnt_create ().
The parameter
.I in
is the address of the procedure's argument(s), and
.I out
is the address of where to place the result(s);
.I inproc
is used to encode the procedure's parameters, and
.I outproc
is used to decode the procedure's results;
.I tout
is the time allowed for results to come back.
.LP
.nf
.BI "clnt_destroy(CLIENT *" clnt );
.fi
.IP
A macro that destroys the client's RPC handle.
Destruction usually involves deallocation
of private data structures, including
.I clnt
itself.
Use of
.I clnt
is undefined after calling
.BR clnt_destroy ().
If the RPC library opened the associated socket, it will close it also.
Otherwise, the socket remains open.
.LP
.nf
.BI "CLIENT *clnt_create(char *" host ", unsigned long " prog ,
.BI "                    unsigned long " vers ", char *" proto );
.fi
.IP
Generic client creation routine.
.I host
identifies the name of the remote host where the server is located.
.I proto
indicates which kind of transport protocol to use.
The currently supported values for this field are \(lqudp\(rq
and \(lqtcp\(rq.
Default timeouts are set, but can be modified using
.BR clnt_control ().
.IP
Warning: Using UDP has its shortcomings.
Since UDP-based RPC messages can only hold up to 8 Kbytes of encoded data,
this transport cannot be used for procedures that take
large arguments or return huge results.
.LP
.nf
.BI "bool_t clnt_control(CLIENT *" cl ", int " req ", char *" info );
.fi
.IP
A macro used to change or retrieve various information
about a client object.
.I req
indicates the type of operation, and
.I info
is a pointer to the information.
For both UDP and TCP, the supported values of
.I req
and their argument types and what they do are:
.IP
.in +4n
.nf
\fBCLSET_TIMEOUT\fP  \fIstruct timeval\fP // set total timeout
\fBCLGET_TIMEOUT\fP  \fIstruct timeval\fP // get total timeout
.fi
.in
.IP
Note: if you set the timeout using
.BR clnt_control (),
the timeout parameter passed to
.BR clnt_call ()
will be ignored in all future calls.
.IP
.in +4n
.nf
\fBCLGET_SERVER_ADDR\fP  \fIstruct sockaddr_in \fP // get server's address
.fi
.in
.IP
The following operations are valid for UDP only:
.IP
.in +4n
.nf
\fBCLSET_RETRY_TIMEOUT\fP  \fIstruct timeval\fP // set the retry timeout
\fBCLGET_RETRY_TIMEOUT\fP  \fIstruct timeval\fP // get the retry timeout
.fi
.in
.IP
The retry timeout is the time that "UDP RPC"
waits for the server to reply before
retransmitting the request.
.LP
.nf
.BI "clnt_freeres(CLIENT * " clnt ", xdrproc_t " outproc ", char *" out );
.fi
.IP
A macro that frees any data allocated by the RPC/XDR
system when it decoded the results of an RPC call.
The parameter
.I out
is the address of the results, and
.I outproc
is the XDR routine describing the results.
This routine returns one if the results were successfully freed,
and zero otherwise.
.LP
.nf
.BI "void clnt_geterr(CLIENT *" clnt ", struct rpc_err *" errp );
.fi
.IP
A macro that copies the error structure out of the client
handle to the structure at address
.IR errp .
.LP
.nf
.BI "void clnt_pcreateerror(char *" s );
.fi
.IP
Print a message to standard error indicating why a client RPC
handle could not be created.
The message is prepended with string
.I s
and a colon.
Used when a
.BR clnt_create (),
.BR clntraw_create (),
.BR clnttcp_create (),
or
.BR clntudp_create ()
call fails.
.LP
.nf
.BI "void clnt_perrno(enum clnt_stat " stat );
.fi
.IP
Print a message to standard error corresponding
to the condition indicated by
.IR stat .
Used after
.BR callrpc ().
.LP
.nf
.BI "clnt_perror(CLIENT *" clnt ", char *" s );
.fi
.IP
Print a message to standard error indicating why an RPC call failed;
.I clnt
is the handle used to do the call.
The message is prepended with string
.I s
and a colon.
Used after
.BR clnt_call ().
.LP
.nf
.BI "char *clnt_spcreateerror(char *" s );
.fi
.IP
Like
.BR clnt_pcreateerror (),
except that it returns a string instead of printing to the standard error.
.IP
Bugs: returns pointer to static data that is overwritten on each call.
.LP
.nf
.BI "char *clnt_sperrno(enum clnt_stat " stat );
.fi
.IP
Take the same arguments as
.BR clnt_perrno (),
but instead of sending a message to the standard error indicating why an RPC
call failed, return a pointer to a string which contains the message.
The string ends with a NEWLINE.
.IP
.BR clnt_sperrno ()
is used instead of
.BR clnt_perrno ()
if the program does not have a standard error (as a program
running as a server quite likely does not), or if the programmer
does not want the message to be output with
.BR printf (3),
or if a message format different than that supported by
.BR clnt_perrno ()
is to be used.
Note: unlike
.BR clnt_sperror ()
and
.BR clnt_spcreaterror (),
.BR clnt_sperrno ()
returns pointer to static data, but the
result will not get overwritten on each call.
.LP
.nf
.BI "char *clnt_sperror(CLIENT *" rpch ", char *" s );
.fi
.IP
Like
.BR clnt_perror (),
except that (like
.BR clnt_sperrno ())
it returns a string instead of printing to standard error.
.IP
Bugs: returns pointer to static data that is overwritten on each call.
.LP
.nf
.BI "CLIENT *clntraw_create(unsigned long " prognum \
", unsigned long " versnum );
.fi
.IP
This routine creates a toy RPC client for the remote program
.IR prognum ,
version
.IR versnum .
The transport used to pass messages to the service is
actually a buffer within the process's address space, so the
corresponding RPC server should live in the same address space; see
.BR svcraw_create ().
This allows simulation of RPC and acquisition of RPC
overheads, such as round trip times, without any kernel interference.
This routine returns NULL if it fails.
.LP
.nf
.BI "CLIENT *clnttcp_create(struct sockaddr_in *" addr ,
.BI "                unsigned long " prognum ", unsigned long " versnum ,
.BI "                int *" sockp ", unsigned int " sendsz \
", unsigned int " recvsz );
.fi
.IP
This routine creates an RPC client for the remote program
.IR prognum ,
version
.IR versnum ;
the client uses TCP/IP as a transport.
The remote program is located at Internet address
.IR *addr .
If
.\"The following inline font conversion is necessary for the hyphen indicator
\fIaddr\->sin_port\fR
is zero, then it is set to the actual port that the remote
program is listening on (the remote
.B portmap
service is consulted for this information).
The parameter
.I sockp
is a socket; if it is
.BR RPC_ANYSOCK ,
then this routine opens a new one and sets
.IR sockp .
Since TCP-based RPC uses buffered I/O,
the user may specify the size of the send and receive buffers
with the parameters
.I sendsz
and
.IR recvsz ;
values of zero choose suitable defaults.
This routine returns NULL if it fails.
.LP
.nf
.BI "CLIENT *clntudp_create(struct sockaddr_in *" addr ,
.BI "                unsigned long " prognum ", unsigned long " versnum ,
.BI "                struct timeval " wait ", int *" sockp );
.fi
.IP
This routine creates an RPC client for the remote program
.IR prognum ,
version
.IR versnum ;
the client uses use UDP/IP as a transport.
The remote program is located at Internet address
.IR addr .
If
\fIaddr\->sin_port\fR
is zero, then it is set to actual port that the remote
program is listening on (the remote
.B portmap
service is consulted for this information).
The parameter
.I sockp
is a socket; if it is
.BR RPC_ANYSOCK ,
then this routine opens a new one and sets
.IR sockp .
The UDP transport resends the call message in intervals of
.I wait
time until a response is received or until the call times out.
The total time for the call to time out is specified by
.BR clnt_call ().
.IP
Warning: since UDP-based RPC messages can only hold up to 8 Kbytes
of encoded data, this transport cannot be used for procedures
that take large arguments or return huge results.
.LP
.nf
.BI "CLIENT *clntudp_bufcreate(struct sockaddr_in *" addr ,
.BI "            unsigned long " prognum ", unsigned long " versnum ,
.BI "            struct timeval " wait ", int *" sockp ,
.BI "            unsigned int " sendsize ", unsigned int "recosize );
.fi
.IP
This routine creates an RPC client for the remote program
.IR prognum ,
on
.IR versnum ;
the client uses use UDP/IP as a transport.
The remote program is located at Internet address
.IR addr .
If
\fIaddr\->sin_port\fR
is zero, then it is set to actual port that the remote
program is listening on (the remote
.B portmap
service is consulted for this information).
The parameter
.I sockp
is a socket; if it is
.BR RPC_ANYSOCK ,
then this routine opens a new one and sets
.IR sockp .
The UDP transport resends the call message in intervals of
.I wait
time until a response is received or until the call times out.
The total time for the call to time out is specified by
.BR clnt_call ().
.IP
This allows the user to specify the maximum packet
size for sending and receiving UDP-based RPC messages.
.LP
.nf
.BI "void get_myaddress(struct sockaddr_in *" addr );
.fi
.IP
Stuff the machine's IP address into
.IR *addr ,
without consulting the library routines that deal with
.IR /etc/hosts .
The port number is always set to
.BR htons(PMAPPORT) .
.LP
.nf
.BI "struct pmaplist *pmap_getmaps(struct sockaddr_in *" addr );
.fi
.IP
A user interface to the
.B portmap
service, which returns a list of the current RPC
program-to-port mappings on the host located at IP address
.IR *addr .
This routine can return NULL.
The command
.IR "rpcinfo\ \-p"
uses this routine.
.LP
.nf
.BI "unsigned short pmap_getport(struct sockaddr_in *" addr ,
.BI "                    unsigned long " prognum ", unsigned long " versnum ,
.BI "                    unsigned int " protocol );
.fi
.IP
A user interface to the
.B portmap
service, which returns the port number
on which waits a service that supports program number
.IR prognum ,
version
.IR versnum ,
and speaks the transport protocol associated with
.IR protocol .
The value of
.I protocol
is most likely
.B IPPROTO_UDP
or
.BR IPPROTO_TCP .
A return value of zero means that the mapping does not exist
or that the RPC system failed to contact the remote
.B portmap
service.
In the latter case, the global variable
.I rpc_createerr
contains the RPC status.
.LP
.nf
.BI "enum clnt_stat pmap_rmtcall(struct sockaddr_in *" addr ,
.BI "                    unsigned long " prognum ", unsigned long " versnum ,
.BI "                    unsigned long " procnum ,
.BI "                    xdrproc_t " inproc ", char *" in ,
.BI "                    xdrproc_t " outproc ", char *" out ,
.BI "                    struct timeval " tout ", unsigned long *" portp );
.fi
.IP
A user interface to the
.B portmap
service, which instructs
.B portmap
on the host at IP address
.I *addr
to make an RPC call on your behalf to a procedure on that host.
The parameter
.I *portp
will be modified to the program's port number if the procedure succeeds.
The definitions of other parameters are discussed
in
.BR callrpc ()
and
.BR clnt_call ().
This procedure should be used for a \(lqping\(rq and nothing else.
See also
.BR clnt_broadcast ().
.LP
.nf
.BI "bool_t pmap_set(unsigned long " prognum ", unsigned long " versnum ,
.BI "                unsigned int " protocol ", unsigned short " port );
.fi
.IP
A user interface to the
.B portmap
service, which establishes a mapping between the triple
.RI [ prognum , versnum , protocol\fR]
and
.I port
on the machine's
.B portmap
service.
The value of
.I protocol
is most likely
.B IPPROTO_UDP
or
.BR IPPROTO_TCP .
This routine returns one if it succeeds, zero otherwise.
Automatically done by
.BR svc_register ().
.LP
.nf
.BI "bool_t pmap_unset(unsigned long " prognum ", unsigned long " versnum );
.fi
.IP
A user interface to the
.B portmap
service, which destroys all mapping between the triple
.RI [ prognum , versnum , *\fR]
and
.B ports
on the machine's
.B portmap
service.
This routine returns one if it succeeds, zero otherwise.
.LP
.nf
.BI "int registerrpc(unsigned long " prognum ", unsigned long " versnum ,
.BI "                unsigned long " procnum ", char *(*" procname ")(char *),"
.BI "                xdrproc_t " inproc ", xdrproc_t " outproc );
.fi
.IP
Register procedure
.I procname
with the RPC service package.
If a request arrives for program
.IR prognum ,
version
.IR versnum ,
and procedure
.IR procnum ,
.I procname
is called with a pointer to its parameter(s);
.I progname
should return a pointer to its static result(s);
.I inproc
is used to decode the parameters while
.I outproc
is used to encode the results.
This routine returns zero if the registration succeeded, \-1 otherwise.
.IP
Warning: remote procedures registered in this form
are accessed using the UDP/IP transport; see
.BR svcudp_create ()
for restrictions.
.LP
.nf
.BI "struct rpc_createerr " rpc_createerr ;
.fi
.IP
A global variable whose value is set by any RPC client creation routine
that does not succeed.
Use the routine
.BR clnt_pcreateerror ()
to print the reason why.
.LP
.nf
.BI "void svc_destroy(SVCXPRT *" xprt );
.fi
.IP
A macro that destroys the RPC service transport handle,
.IR xprt .
Destruction usually involves deallocation
of private data structures, including
.I xprt
itself.
Use of
.I xprt
is undefined after calling this routine.
.LP
.nf
.BI "fd_set " svc_fdset ;
.fi
.IP
A global variable reflecting the RPC service side's
read file descriptor bit mask; it is suitable as a parameter to the
.BR select (2)
system call.
This is only of interest if a service implementor does not call
.BR svc_run (),
but rather does his own asynchronous event processing.
This variable is read-only (do not pass its address to
.BR select (2)!),
yet it may change after calls to
.BR svc_getreqset ()
or any creation routines.
.LP
.nf
.BI "int " svc_fds ;
.fi
.IP
Similar to
.BR svc_fdset ,
but limited to 32 descriptors.
This interface is obsoleted by
.BR svc_fdset .
.LP
.nf
.BI "svc_freeargs(SVCXPRT *" xprt ", xdrproc_t " inproc ", char *" in );
.fi
.IP
A macro that frees any data allocated by the RPC/XDR
system when it decoded the arguments to a service procedure using
.BR svc_getargs ().
This routine returns 1 if the results were successfully freed,
and zero otherwise.
.LP
.nf
.BI "svc_getargs(SVCXPRT *" xprt ", xdrproc_t " inproc ", char *" in );
.fi
.IP
A macro that decodes the arguments of an RPC request
associated with the RPC service transport handle,
.IR xprt .
The parameter
.I in
is the address where the arguments will be placed;
.I inproc
is the XDR routine used to decode the arguments.
This routine returns one if decoding succeeds, and zero otherwise.
.LP
.nf
.BI "struct sockaddr_in *svc_getcaller(SVCXPRT *" xprt );
.fi
.IP
The approved way of getting the network address of the caller
of a procedure associated with the RPC service transport handle,
.IR xprt .
.LP
.nf
.BI "void svc_getreqset(fd_set *" rdfds );
.fi
.IP
This routine is only of interest if a service implementor does not call
.BR svc_run (),
but instead implements custom asynchronous event processing.
It is called when the
.BR select (2)
system call has determined that an RPC request has arrived on some
RPC socket(s);
.I rdfds
is the resultant read file descriptor bit mask.
The routine returns when all sockets associated with the value of
.I rdfds
have been serviced.
.LP
.nf
.BI "void svc_getreq(int " rdfds );
.fi
.IP
Similar to
.BR svc_getreqset (),
but limited to 32 descriptors.
This interface is obsoleted by
.BR svc_getreqset ().
.LP
.nf
.BI "bool_t svc_register(SVCXPRT *" xprt ", unsigned long " prognum ,
.BI "                    unsigned long " versnum ,
.BI "                    void (*" dispatch ")(svc_req *, SVCXPRT *),"
.BI "                    unsigned long " protocol );
.fi
.IP
Associates
.I prognum
and
.I versnum
with the service dispatch procedure,
.IR dispatch .
If
.I protocol
is zero, the service is not registered with the
.B portmap
service.
If
.I protocol
is nonzero, then a mapping of the triple
.RI [ prognum , versnum , protocol\fR]
to
\fIxprt\->xp_port\fR
is established with the local
.B portmap
service (generally
.I protocol
is zero,
.B IPPROTO_UDP
or
.BR IPPROTO_TCP ).
The procedure
.I dispatch
has the following form:
.in +4n
.nf

dispatch(struct svc_req *request, SVCXPRT *xprt);
.fi
.in
.IP
The
.BR svc_register ()
routine returns one if it succeeds, and zero otherwise.
.LP
.nf
.B "void svc_run(void);"
.fi
.IP
This routine never returns.
It waits for RPC requests to arrive, and calls the appropriate service
procedure using
.BR svc_getreq ()
when one arrives.
This procedure is usually waiting for a
.BR select (2)
system call to return.
.LP
.nf
.BI "bool_t svc_sendreply(SVCXPRT *" xprt ", xdrproc_t " outproc \
", char *" out );
.fi
.IP
Called by an RPC service's dispatch routine to send the results of a
remote procedure call.
The parameter
.I xprt
is the request's associated transport handle;
.I outproc
is the XDR routine which is used to encode the results; and
.I out
is the address of the results.
This routine returns one if it succeeds, zero otherwise.
.LP
.nf
.BI "void svc_unregister(unsigned long " prognum ", unsigned long " versnum );
.fi
.IP
Remove all mapping of the double
.RI [ prognum , versnum ]
to dispatch routines, and of the triple
.RI [ prognum , versnum , *\fR]
to port number.
.LP
.nf
.BI "void svcerr_auth(SVCXPRT *" xprt ", enum auth_stat " why );
.fi
.IP
Called by a service dispatch routine that refuses to perform
a remote procedure call due to an authentication error.
.LP
.nf
.BI "void svcerr_decode(SVCXPRT *" xprt );
.fi
.IP
Called by a service dispatch routine that cannot successfully
decode its parameters.
See also
.BR svc_getargs ().
.LP
.nf
.BI "void svcerr_noproc(SVCXPRT *" xprt );
.fi
.IP
Called by a service dispatch routine that does not implement
the procedure number that the caller requests.
.LP
.nf
.BI "void svcerr_noprog(SVCXPRT *" xprt );
.fi
.IP
Called when the desired program is not registered with the RPC package.
Service implementors usually do not need this routine.
.LP
.nf
.BI "void svcerr_progvers(SVCXPRT *" xprt );
.fi
.IP
Called when the desired version of a program is not registered
with the RPC package.
Service implementors usually do not need this routine.
.LP
.nf
.BI "void svcerr_systemerr(SVCXPRT *" xprt );
.fi
.IP
Called by a service dispatch routine when it detects a system
error not covered by any particular protocol.
For example, if a service can no longer allocate storage,
it may call this routine.
.LP
.nf
.BI "void svcerr_weakauth(SVCXPRT *" xprt );
.fi
.IP
Called by a service dispatch routine that refuses to perform
a remote procedure call due to insufficient authentication parameters.
The routine calls
.BR "svcerr_auth(xprt, AUTH_TOOWEAK)" .
.LP
.nf
.BI "SVCXPRT *svcfd_create(int " fd ", unsigned int " sendsize ,
.BI "                      unsigned int " recvsize );
.fi
.IP
Create a service on top of any open descriptor.
Typically, this descriptor is a connected socket for a stream protocol such
as TCP.
.I sendsize
and
.I recvsize
indicate sizes for the send and receive buffers.
If they are zero, a reasonable default is chosen.
.LP
.nf
.BI "SVCXPRT *svcraw_create(void);"
.fi
.IP
This routine creates a toy RPC
service transport, to which it returns a pointer.
The transport is really a buffer within the process's address space,
so the corresponding RPC client should live in the same address space; see
.BR clntraw_create ().
This routine allows simulation of RPC and acquisition of RPC
overheads (such as round trip times), without any kernel interference.
This routine returns NULL if it fails.
.LP
.nf
.BI "SVCXPRT *svctcp_create(int " sock ", unsigned int " send_buf_size ,
.BI "                       unsigned int " recv_buf_size );
.fi
.IP
This routine creates a TCP/IP-based RPC
service transport, to which it returns a pointer.
The transport is associated with the socket
.IR sock ,
which may be
.BR RPC_ANYSOCK ,
in which case a new socket is created.
If the socket is not bound to a local TCP
port, then this routine binds it to an arbitrary port.
Upon completion,
\fIxprt\->xp_sock\fR
is the transport's socket descriptor, and
\fIxprt\->xp_port\fR
is the transport's port number.
This routine returns NULL if it fails.
Since TCP-based RPC uses buffered I/O,
users may specify the size of buffers; values of zero
choose suitable defaults.
.LP
.nf
.BI "SVCXPRT *svcudp_bufcreate(int " sock ", unsigned int " sendsize ,
.BI "                          unsigned int " recosize );
.fi
.IP
This routine creates a UDP/IP-based RPC
service transport, to which it returns a pointer.
The transport is associated with the socket
.IR sock ,
which may be
.BR RPC_ANYSOCK ,
in which case a new socket is created.
If the socket is not bound to a local UDP
port, then this routine binds it to an arbitrary port.
Upon completion,
\fIxprt\->xp_sock\fR
is the transport's socket descriptor, and
\fIxprt\->xp_port\fR
is the transport's port number.
This routine returns NULL if it fails.
.IP
This allows the user to specify the maximum packet size for sending and
receiving UDP-based RPC messages.
.LP
.nf
.BI "SVCXPRT *svcudp_create(int " sock );
.fi
.IP
This call is equivalent to
\fIsvcudp_bufcreate(sock,SZ,SZ)\fP
for some default size \fISZ\fP.
.LP
.nf
.BI "bool_t xdr_accepted_reply(XDR *" xdrs ", struct accepted_reply *" ar );
.fi
.IP
Used for encoding RPC reply messages.
This routine is useful for users who wish to generate
RPC-style messages without using the RPC package.
.LP
.nf
.BI "bool_t xdr_authunix_parms(XDR *" xdrs ", struct authunix_parms *" aupp );
.fi
.IP
Used for describing UNIX credentials.
This routine is useful for users
who wish to generate these credentials without using the RPC
authentication package.
.LP
.nf
.BI "void xdr_callhdr(XDR *" xdrs ", struct rpc_msg *" chdr );
.fi
.IP
Used for describing RPC call header messages.
This routine is useful for users who wish to generate
RPC-style messages without using the RPC package.
.LP
.nf
.BI "bool_t xdr_callmsg(XDR *" xdrs ", struct rpc_msg *" cmsg );
.fi
.IP
Used for describing RPC call messages.
This routine is useful for users who wish to generate RPC-style
messages without using the RPC package.
.LP
.nf
.BI "bool_t xdr_opaque_auth(XDR *" xdrs ", struct opaque_auth *" ap );
.fi
.IP
Used for describing RPC authentication information messages.
This routine is useful for users who wish to generate
RPC-style messages without using the RPC package.
.LP
.nf
.BI "bool_t xdr_pmap(XDR *" xdrs ", struct pmap *" regs );
.fi
.IP
Used for describing parameters to various
.B portmap
procedures, externally.
This routine is useful for users who wish to generate
these parameters without using the
.B pmap
interface.
.LP
.nf
.BI "bool_t xdr_pmaplist(XDR *" xdrs ", struct pmaplist **" rp );
.fi
.IP
Used for describing a list of port mappings, externally.
This routine is useful for users who wish to generate
these parameters without using the
.B pmap
interface.
.LP
.nf
.BI "bool_t xdr_rejected_reply(XDR *" xdrs ", struct rejected_reply *" rr );
.fi
.IP
Used for describing RPC reply messages.
This routine is useful for users who wish to generate
RPC-style messages without using the RPC package.
.LP
.nf
.BI "bool_t xdr_replymsg(XDR *" xdrs ", struct rpc_msg *" rmsg );
.fi
.IP
Used for describing RPC reply messages.
This routine is useful for users who wish to generate
RPC style messages without using the RPC package.
.LP
.nf
.BI "void xprt_register(SVCXPRT *" xprt );
.fi
.IP
After RPC service transport handles are created,
they should register themselves with the RPC service package.
This routine modifies the global variable
.IR svc_fds .
Service implementors usually do not need this routine.
.LP
.nf
.BI "void xprt_unregister(SVCXPRT *" xprt );
.fi
.IP
Before an RPC service transport handle is destroyed,
it should unregister itself with the RPC service package.
This routine modifies the global variable
.IR svc_fds .
Service implementors usually do not need this routine.
.SH "SEE ALSO"
.\" We don't have an rpc_secure.3 page in the set at the moment -- MTK, 19 Sep 05
.\" .BR rpc_secure (3),
.BR xdr (3)

The following manuals:
.RS
Remote Procedure Calls: Protocol Specification
.br
Remote Procedure Call Programming Guide
.br
rpcgen Programming Guide
.br
.RE

.IR "RPC: Remote Procedure Call Protocol Specification" ,
RFC\ 1050, Sun Microsystems, Inc.,
USC-ISI.
.SH COLOPHON
This page is part of release 3.44 of the Linux
.I man-pages
project.
A description of the project,
and information about reporting bugs,
can be found at
http://www.kernel.org/doc/man-pages/.
