#include "shortcuts.h"
#include "var.h"
#include <cstring>
#include <ostream>

namespace dballe {
namespace impl {

const Shortcut& Shortcut::by_name(const char* name) { return by_name(name, strlen(name)); }
const Shortcut& Shortcut::by_name(const std::string& name) { return by_name(name.data(), name.size()); }

std::ostream& operator<<(std::ostream& out, const Shortcut& shortcut)
{
    char buf[7];
    format_bcode(shortcut.code, buf);
    return out << shortcut.level << ":" << shortcut.trange << ":" << buf;
}

namespace sc {


const Shortcut st_type = { true, Level(), Trange(), WR_VAR(0, 2, 1) };
const Shortcut st_name = { true, Level(), Trange(), WR_VAR(0, 1, 19) };
const Shortcut st_name_icao = { true, Level(), Trange(), WR_VAR(0, 1, 63) };
const Shortcut rep_memo = { true, Level(), Trange(), WR_VAR(0, 1, 194) };
const Shortcut poll_lcode = { true, Level(), Trange(), WR_VAR(0, 1, 212) };
const Shortcut poll_scode = { true, Level(), Trange(), WR_VAR(0, 1, 213) };
const Shortcut poll_gemscode = { true, Level(), Trange(), WR_VAR(0, 1, 214) };
const Shortcut poll_source = { true, Level(), Trange(), WR_VAR(0, 1, 215) };
const Shortcut poll_atype = { true, Level(), Trange(), WR_VAR(0, 1, 216) };
const Shortcut poll_ttype = { true, Level(), Trange(), WR_VAR(0, 1, 217) };
const Shortcut flight_reg_no = { true, Level(), Trange(), WR_VAR(0, 1, 8) };
const Shortcut flight_phase = { true, Level(), Trange(), WR_VAR(0, 8, 4) };
const Shortcut flight_roll = { true, Level(), Trange(), WR_VAR(0, 2, 63) };
const Shortcut navsys = { true, Level(), Trange(), WR_VAR(0, 2, 61) };
const Shortcut data_relay = { true, Level(), Trange(), WR_VAR(0, 2, 62) };
const Shortcut wind_inst = { true, Level(), Trange(), WR_VAR(0, 2, 2) };
const Shortcut temp_precision = { true, Level(), Trange(), WR_VAR(0, 2, 5) };
const Shortcut latlon_spec = { true, Level(), Trange(), WR_VAR(0, 2, 70) };
const Shortcut timesig = { true, Level(), Trange(), WR_VAR(0, 8, 21) };
const Shortcut block = { true, Level(), Trange(), WR_VAR(0, 1, 1) };
const Shortcut station = { true, Level(), Trange(), WR_VAR(0, 1, 2) };
const Shortcut ident = { true, Level(), Trange(), WR_VAR(0, 1, 11) };
const Shortcut year = { true, Level(), Trange(), WR_VAR(0, 4, 1) };
const Shortcut month = { true, Level(), Trange(), WR_VAR(0, 4, 2) };
const Shortcut day = { true, Level(), Trange(), WR_VAR(0, 4, 3) };
const Shortcut hour = { true, Level(), Trange(), WR_VAR(0, 4, 4) };
const Shortcut minute = { true, Level(), Trange(), WR_VAR(0, 4, 5) };
const Shortcut second = { true, Level(), Trange(), WR_VAR(0, 4, 6) };
const Shortcut latitude = { true, Level(), Trange(), WR_VAR(0, 5, 1) };
const Shortcut longitude = { true, Level(), Trange(), WR_VAR(0, 6, 1) };
const Shortcut height_station = { true, Level(), Trange(), WR_VAR(0, 7, 30) };
const Shortcut height_baro = { true, Level(), Trange(), WR_VAR(0, 7, 31) };
const Shortcut height_release = { true, Level(), Trange(), WR_VAR(0, 7, 7) };
const Shortcut station_height_quality = { true, Level(), Trange(), WR_VAR(0, 33, 24) };
const Shortcut isobaric_surface = { true, Level(), Trange(), WR_VAR(0, 7, 4) };
const Shortcut st_dir = { false, Level(1), Trange(254,0,0), WR_VAR(0, 1, 12) };
const Shortcut st_speed = { false, Level(1), Trange(254,0,0), WR_VAR(0, 1, 13) };
const Shortcut meas_equip_type = { false, Level(1), Trange(254,0,0), WR_VAR(0, 2, 3) };
const Shortcut sonde_type = { false, Level(1), Trange(254,0,0), WR_VAR(0, 2, 11) };
const Shortcut sonde_method = { false, Level(1), Trange(254,0,0), WR_VAR(0, 2, 12) };
const Shortcut sonde_correction = { false, Level(1), Trange(254,0,0), WR_VAR(0, 2, 13) };
const Shortcut sonde_tracking = { false, Level(1), Trange(254,0,0), WR_VAR(0, 2, 14) };
const Shortcut press = { false, Level(1), Trange(254,0,0), WR_VAR(0, 10, 4) };
const Shortcut press_3h = { false, Level(1), Trange(4,0,10800), WR_VAR(0, 10, 60) };
const Shortcut press_24h = { false, Level(1), Trange(4,0,86400), WR_VAR(0, 10, 60) };
const Shortcut water_temp = { false, Level(1), Trange(254,0,0), WR_VAR(0, 22, 43) };
const Shortcut height_anem = { false, Level(1), Trange(254,0,0), WR_VAR(0, 10, 197) };
const Shortcut press_tend = { false, Level(1), Trange(205,0,10800), WR_VAR(0, 10, 63) };
const Shortcut visibility = { false, Level(1), Trange(254,0,0), WR_VAR(0, 20, 1) };
const Shortcut pres_wtr = { false, Level(1), Trange(254,0,0), WR_VAR(0, 20, 3) };
const Shortcut past_wtr1_3h = { false, Level(1), Trange(205,0,10800), WR_VAR(0, 20, 4) };
const Shortcut past_wtr1_6h = { false, Level(1), Trange(205,0,21600), WR_VAR(0, 20, 4) };
const Shortcut past_wtr2_3h = { false, Level(1), Trange(205,0,10800), WR_VAR(0, 20, 5) };
const Shortcut past_wtr2_6h = { false, Level(1), Trange(205,0,21600), WR_VAR(0, 20, 5) };
const Shortcut metar_wtr = { false, Level(1), Trange(254,0,0), WR_VAR(0, 20, 9) };
const Shortcut tot_prec1 = { false, Level(1), Trange(1,0,3600), WR_VAR(0, 13, 11) };
const Shortcut tot_prec3 = { false, Level(1), Trange(1,0,10800), WR_VAR(0, 13, 11) };
const Shortcut tot_prec6 = { false, Level(1), Trange(1,0,21600), WR_VAR(0, 13, 11) };
const Shortcut tot_prec12 = { false, Level(1), Trange(1,0,43200), WR_VAR(0, 13, 11) };
const Shortcut tot_prec24 = { false, Level(1), Trange(1,0,86400), WR_VAR(0, 13, 11) };
const Shortcut tot_snow = { false, Level(1), Trange(254,0,0), WR_VAR(0, 13, 13) };
const Shortcut state_ground = { false, Level(1), Trange(254,0,0), WR_VAR(0, 20, 62) };
const Shortcut press_msl = { false, Level(101), Trange(254,0,0), WR_VAR(0, 10, 51) };
const Shortcut qnh = { false, Level(103,2000), Trange(254,0,0), WR_VAR(0, 10, 52) };
const Shortcut temp_2m = { false, Level(103,2000), Trange(254,0,0), WR_VAR(0, 12, 101) };
const Shortcut wet_temp_2m = { false, Level(103,2000), Trange(254,0,0), WR_VAR(0, 12, 102) };
const Shortcut dewpoint_2m = { false, Level(103,2000), Trange(254,0,0), WR_VAR(0, 12, 103) };
const Shortcut humidity = { false, Level(103,2000), Trange(254,0,0), WR_VAR(0, 13, 3) };
const Shortcut wind_dir = { false, Level(103,10000), Trange(254,0,0), WR_VAR(0, 11, 1) };
const Shortcut wind_speed = { false, Level(103,10000), Trange(254,0,0), WR_VAR(0, 11, 2) };
const Shortcut wind_gust_max_speed = { false, Level(103,10000), Trange(254,0,0), WR_VAR(0, 11, 41) };
const Shortcut wind_gust_max_dir = { false, Level(103,10000), Trange(254,0,0), WR_VAR(0, 11, 43) };
const Shortcut ex_ccw_wind = { false, Level(103,10000), Trange(254,0,0), WR_VAR(0, 11, 16) };
const Shortcut ex_cw_wind = { false, Level(103,10000), Trange(254,0,0), WR_VAR(0, 11, 17) };
const Shortcut cloud_n = { false, Level(256), Trange(254,0,0), WR_VAR(0, 20, 10) };
const Shortcut cloud_nh = { false, Level(256,MISSING_INT,258,0), Trange(254,0,0), WR_VAR(0, 20, 11) };
const Shortcut cloud_hh = { false, Level(256,MISSING_INT,258,0), Trange(254,0,0), WR_VAR(0, 20, 13) };
const Shortcut cloud_cl = { false, Level(256,MISSING_INT,258,1), Trange(254,0,0), WR_VAR(0, 20, 12) };
const Shortcut cloud_cm = { false, Level(256,MISSING_INT,258,2), Trange(254,0,0), WR_VAR(0, 20, 12) };
const Shortcut cloud_ch = { false, Level(256,MISSING_INT,258,3), Trange(254,0,0), WR_VAR(0, 20, 12) };
const Shortcut cloud_n1 = { false, Level(256,MISSING_INT,259,1), Trange(254,0,0), WR_VAR(0, 20, 11) };
const Shortcut cloud_c1 = { false, Level(256,MISSING_INT,259,1), Trange(254,0,0), WR_VAR(0, 20, 12) };
const Shortcut cloud_h1 = { false, Level(256,MISSING_INT,259,1), Trange(254,0,0), WR_VAR(0, 20, 13) };
const Shortcut cloud_n2 = { false, Level(256,MISSING_INT,259,2), Trange(254,0,0), WR_VAR(0, 20, 11) };
const Shortcut cloud_c2 = { false, Level(256,MISSING_INT,259,2), Trange(254,0,0), WR_VAR(0, 20, 12) };
const Shortcut cloud_h2 = { false, Level(256,MISSING_INT,259,2), Trange(254,0,0), WR_VAR(0, 20, 13) };
const Shortcut cloud_n3 = { false, Level(256,MISSING_INT,259,3), Trange(254,0,0), WR_VAR(0, 20, 11) };
const Shortcut cloud_c3 = { false, Level(256,MISSING_INT,259,3), Trange(254,0,0), WR_VAR(0, 20, 12) };
const Shortcut cloud_h3 = { false, Level(256,MISSING_INT,259,3), Trange(254,0,0), WR_VAR(0, 20, 13) };
const Shortcut cloud_n4 = { false, Level(256,MISSING_INT,259,4), Trange(254,0,0), WR_VAR(0, 20, 11) };
const Shortcut cloud_c4 = { false, Level(256,MISSING_INT,259,4), Trange(254,0,0), WR_VAR(0, 20, 12) };
const Shortcut cloud_h4 = { false, Level(256,MISSING_INT,259,4), Trange(254,0,0), WR_VAR(0, 20, 13) };

}
}
}
