#!/bin/bash

PACKAGE=$(dpkg-parsechangelog | sed -ne 's/^Source: \(.*\)/\1/p')
SRC_VERSION=$(dpkg-parsechangelog | sed -ne 's/^Version: \(\([0-9]\+\):\)\?\(.*\)-.*/\3/p')
SRC_REVISION=$(dpkg-parsechangelog | sed -ne 's/^Version: .*~r\(.*\)-.*/\1/p')
SRC_DIR=$PACKAGE-$SRC_VERSION.orig
TARBALL=$PACKAGE'_'$SRC_VERSION'.orig.tar.bz2'
SVN_REPOS=http://cofoja.googlecode.com/svn

echo "Package: "$PACKAGE
echo "Version: "$SRC_VERSION
echo "Revision: "$SRC_REVISION
echo "Tarball: "$TARBALL


rm -rf get-orig-source $TARBALL
mkdir get-orig-source
svn export -r $SRC_REVISION $SVN_REPOS/trunk/ get-orig-source/$SRC_DIR
BZIP2='--best' tar cjf $TARBALL -C get-orig-source $SRC_DIR
rm -r get-orig-source
echo "  "$TARBALL" created; move it to the right destination to build the package"

