# changelog

## [0.6.0](https://github.com/lynaghk/cljx/issues?q=milestone%3A0.6.0)

* Fixed issue with `0.5.0` where either cljx or cljsbuild would be invoked
  multiple times in the course of a build when run under Leiningen >= `2.4.2`.
  (gh-61)
* Fixed issue where cljx would not be invoked despite inclusion of it in
  `:prep-tasks`. (gh-60)
* Polling rate of `cljx auto` changed to 250ms (gh-46)

The first of the above fixes necessitated a change in how cljx folds into the
Leiningen "lifecycle" (now it is a "pure" plugin, and does not use `eval-in` at
all). This is _technically_ a breaking change, in that any use of
custom `:rules` in `:cljx` configuration resolved from project dependencies will
break under `0.6.0`. The fix is to either change project configuration and/or
refactor the definition of such `:rules` vars such that they are added to the
project as `:plugin` dependencies (rather than "regular" `:dependencies`
dependencies). [Terminology fail :-/]

## [0.5.0](https://github.com/lynaghk/cljx/issues?q=milestone%3A0.5.0)

* cljx hooks have been eliminated (their use only emits a warning now), due to
  [upstream changes in Leiningen](https://github.com/lynaghk/cljx/issues/51)
  (gh-51, gh-49, gh-22)
* cljx now depends upon a canonical release of sjacket, which eliminates various
  dependency resolution warnings
* `cljx auto` will now only reprocess files that have changed (gh-53)

## 0.4.0

* The cljx nREPL middleware has been enhanced to make running `lein cljx once`
  unnecessary when running a _ClojureScript_ REPL. This means that
  e.g. `(load-namespace 'ns.written.in.cljx)` or `(ns foo (:require
  ns.written.in.cljx))` will work, even if no corresponding `.cljs` file has
  been generated yet. (gh-24)
* Updated the piggieback dependency to align with its range of compatibility
  with the ClojureScript compiler API (gh-40)

## 0.3.2

* The cljx nREPL middleware has been enhanced to make running `lein cljx once`
  unnecessary when running a _Clojure_ REPL.  This means that e.g. `(require
  'ns.written.in.cljx)` will work, even if no corresponding `.clj` file has been
  generated yet. (Analogous support for on-the-fly cljx transformations for
  _ClojureScript_ is coming.)  (gh-24)

## 0.3.1

* cljx now includes a small bit of Leiningen middleware that will automatically
  configure your project to use cljx's nREPL middleware and Piggieback,
  eliminating the need to duplicate cljx as a dependency in your `project.clj`.
  (gh-26)
* Clojure test files generated by cljx are now properly recognized as "eligible"
  for testing by Leiningen's `lein test` task (gh-19)

## 0.3.0

Mostly a rewrite to use [sjacket](https://github.com/cgrand/sjacket), removing
all dependency on the Clojure reader and thereby eliminating all of the issues
that go along with it (e.g. lossy representation, line number changes when
emitting Clojure[Script],
[issues like this](https://github.com/jonase/kibit/issues/14), etc).

The syntax for annotations has changed, as described in the readme.  tl;dr, all
you need to do is `s/\^:(cljs?)/#+$1/g`.  The only gotcha is that putting
annotations on var symbols no longer supported (which carried a bunch of
problems before anyway, but nevermind that); so, you have to change e.g. this:

```clojure
(defn ^:cljs foo [x] (whatever x))
```

into:

```clojure
#+cljs (defn foo [x] (whatever x))
```

Again, tl;dr: cljx annotations apply to _expressions_, and nothing else.

Otherwise, everything works as it did; even your existing `project.clj`
configurations can stay as they are (though anything other than the three
`:build` map keys described in the README are now superfluous).
