# Функции для работы со строками

## empty
Возвращает 1 для пустой строки, и 0 для непустой строки.
Тип результата - UInt8.
Строка считается непустой, если содержит хотя бы один байт, пусть даже это пробел или нулевой байт.
Функция также работает для массивов.

## notEmpty
Возвращает 0 для пустой строки, и 1 для непустой строки.
Тип результата - UInt8.
Функция также работает для массивов.

## length
Возвращает длину строки в байтах (не символах, не кодовых точках).
Тип результата - UInt64.
Функция также работает для массивов.

## lengthUTF8
Возвращает длину строки в кодовых точках Unicode (не символах), при допущении, что строка содержит набор байт, являющийся текстом в кодировке UTF-8. Если допущение не выполнено - то возвращает какой-нибудь результат (не кидает исключение).
Тип результата - UInt64.

## lower
Переводит ASCII-символы латиницы в строке в нижний регистр.

## upper
Переводит ASCII-символы латиницы в строке в верхний регистр.

## lowerUTF8
Переводит строку в нижний регистр, при допущении, что строка содержит набор байт, представляющий текст в кодировке UTF-8.
Не учитывает язык. То есть, для турецкого языка, результат может быть не совсем верным.
Если длина UTF-8 последовательности байт различна для верхнего и нижнего регистра кодовой точки, то для этой кодовой точки, результат работы может быть некорректным.
Если строка содержит набор байт, не являющийся UTF-8, то поведение не определено.

## upperUTF8
Переводит строку в верхний регистр, при допущении, что строка содержит набор байт, представляющий текст в кодировке UTF-8.
Не учитывает язык. То есть, для турецкого языка, результат может быть не совсем верным.
Если длина UTF-8 последовательности байт различна для верхнего и нижнего регистра кодовой точки, то для этой кодовой точки, результат работы может быть некорректным.
Если строка содержит набор байт, не являющийся UTF-8, то поведение не определено.

## reverse
Разворачивает строку (как последовательность байт).

## reverseUTF8
Разворачивает последовательность кодовых точек Unicode, при допущении, что строка содержит набор байт, представляющий текст в кодировке UTF-8. Иначе - что-то делает (не кидает исключение).

## concat(s1, s2, ...)
Склеивает строки, перечисленные в аргументах, без разделителей.

## substring(s, offset, length)
Возвращает подстроку, начиная с байта по индексу offset, длины length байт. Индексация символов - начиная с единицы (как в стандартном SQL). Аргументы offset и length должны быть константами.

## substringUTF8(s, offset, length)
Так же, как substring, но для кодовых точек Unicode. Работает при допущении, что строка содержит набор байт, представляющий текст в кодировке UTF-8. Если допущение не выполнено - то возвращает какой-нибудь результат (не кидает исключение).

## appendTrailingCharIfAbsent(s, c)
Если строка s непустая и не содержит символ c на конце, то добавляет символ c в конец.

## convertCharset(s, from, to)
Возвращает сконвертированную из кодировки from в кодировку to строку s.

## base64Encode(s)
Производит кодирование строки s в base64-представление.

## base64Decode(s)
Декодирует base64-представление s в исходную строку. При невозможности декодирования выбрасывает исключение

## tryBase64Decode(s)
Функционал аналогичен base64Decode, но при невозможности декодирования возвращает пустую строку.

[Оригинальная статья](https://clickhouse.yandex/docs/ru/query_language/functions/string_functions/) <!--hide-->