from __future__ import absolute_import, division, print_function
from scitbx.array_family import flex
from libtbx import group_args
from libtbx.utils import user_plus_sys_time
from mmtbx.refinement.real_space import individual_sites
import mmtbx
from six.moves import range

pdb_str_answer = """\
CRYST1   23.136   23.980   28.180  90.00  90.00  90.00 P 1
ATOM      1  O5'  DC A   1      18.769  14.782   4.393  1.00  6.75           O
ATOM      2  C5'  DC A   1      19.006  13.768   5.373  1.00  5.76           C
ATOM      3  C4'  DC A   1      17.877  12.780   5.508  1.00  5.43           C
ATOM      4  O4'  DC A   1      16.718  13.456   6.038  1.00  6.23           O
ATOM      5  C3'  DC A   1      17.408  12.109   4.197  1.00  5.76           C
ATOM      6  O3'  DC A   1      17.067  10.753   4.414  1.00  6.24           O
ATOM      7  C2'  DC A   1      16.176  12.865   3.829  1.00  5.97           C
ATOM      8  C1'  DC A   1      15.604  13.235   5.204  1.00  5.80           C
ATOM      9  N1   DC A   1      14.782  14.462   5.186  1.00  5.86           N
ATOM     10  C2   DC A   1      13.418  14.369   4.997  1.00  5.95           C
ATOM     11  O2   DC A   1      12.899  13.225   4.851  1.00  7.16           O
ATOM     12  N3   DC A   1      12.644  15.476   4.959  1.00  5.87           N
ATOM     13  C4   DC A   1      13.230  16.686   5.118  1.00  5.87           C
ATOM     14  N4   DC A   1      12.439  17.760   5.083  1.00  6.52           N
ATOM     15  C5   DC A   1      14.638  16.833   5.308  1.00  6.61           C
ATOM     16  C6   DC A   1      15.363  15.687   5.329  1.00  6.96           C
ATOM     17  P    DG A   2      18.103   9.542   4.276  1.00  6.42           P
ATOM     18  OP1  DG A   2      19.079   9.771   3.150  1.00  7.41           O
ATOM     19  OP2  DG A   2      17.248   8.315   4.226  1.00  7.63           O
ATOM     20  O5'  DG A   2      18.994   9.571   5.600  1.00  6.87           O
ATOM     21  C5'  DG A   2      18.415   9.369   6.879  1.00  6.28           C
ATOM     22  C4'  DG A   2      19.448   9.733   7.953  1.00  6.57           C
ATOM     23  O4'  DG A   2      19.856  11.086   7.791  1.00  6.18           O
ATOM     24  C3'  DG A   2      18.941   9.610   9.402  1.00  6.90           C
ATOM     25  O3'  DG A   2      19.154   8.270   9.879  1.00  8.35           O
ATOM     26  C2'  DG A   2      19.700  10.666  10.139  1.00  7.77           C
ATOM     27  C1'  DG A   2      20.136  11.660   9.131  1.00  6.65           C
ATOM     28  N9   DG A   2      19.464  12.952   9.099  1.00  6.28           N
ATOM     29  C8   DG A   2      20.053  14.194   9.112  1.00  7.19           C
ATOM     30  N7   DG A   2      19.229  15.185   9.059  1.00  7.47           N
ATOM     31  C5   DG A   2      17.967  14.561   8.992  1.00  5.84           C
ATOM     32  C6   DG A   2      16.667  15.118   8.902  1.00  5.59           C
ATOM     33  O6   DG A   2      16.345  16.344   8.881  1.00  6.73           O
ATOM     34  N1   DG A   2      15.678  14.152   8.859  1.00  5.14           N
ATOM     35  C2   DG A   2      15.918  12.799   8.880  1.00  4.97           C
ATOM     36  N2   DG A   2      14.843  12.012   8.812  1.00  5.85           N
ATOM     37  N3   DG A   2      17.133  12.263   8.960  1.00  5.27           N
ATOM     38  C4   DG A   2      18.094  13.192   9.015  1.00  5.60           C
ATOM     39  P    DC A   3      17.905   7.353  10.333  1.00  8.32           P
ATOM     40  OP1  DC A   3      18.531   6.058  10.697  1.00 10.45           O
ATOM     41  OP2  DC A   3      16.864   7.362   9.303  1.00  9.29           O
ATOM     42  O5'  DC A   3      17.434   8.114  11.651  1.00  7.83           O
ATOM     43  C5'  DC A   3      16.856   7.412  12.761  1.00  6.84           C
ATOM     44  C4'  DC A   3      15.465   7.945  13.113  1.00  6.76           C
ATOM     45  O4'  DC A   3      15.564   9.296  13.572  1.00  6.82           O
ATOM     46  C3'  DC A   3      14.464   7.959  11.956  1.00  7.23           C
ATOM     47  O3'  DC A   3      13.169   7.697  12.441  1.00  8.29           O
ATOM     48  C2'  DC A   3      14.478   9.374  11.464  1.00  7.01           C
ATOM     49  C1'  DC A   3      14.673  10.096  12.792  1.00  6.65           C
ATOM     50  N1   DC A   3      15.294  11.429  12.660  1.00  6.27           N
ATOM     51  C2   DC A   3      14.431  12.528  12.451  1.00  6.39           C
ATOM     52  O2   DC A   3      13.224  12.349  12.410  1.00  6.84           O
ATOM     53  N3   DC A   3      15.018  13.772  12.326  1.00  6.04           N
ATOM     54  C4   DC A   3      16.331  13.903  12.377  1.00  6.43           C
ATOM     55  N4   DC A   3      16.826  15.147  12.241  1.00  7.42           N
ATOM     56  C5   DC A   3      17.207  12.775  12.563  1.00  7.12           C
ATOM     57  C6   DC A   3      16.622  11.579  12.698  1.00  6.73           C
ATOM     58  P    DG A   4      12.497   6.227  12.392  1.00  9.26           P
ATOM     59  OP1  DG A   4      12.848   5.570  11.074  1.00 12.46           O
ATOM     60  OP2  DG A   4      11.080   6.441  12.826  1.00 14.73           O
ATOM     61  O5'  DG A   4      13.267   5.407  13.510  1.00  7.56           O
ATOM     62  C5'  DG A   4      13.061   5.684  14.893  1.00  6.32           C
ATOM     63  C4'  DG A   4      14.029   4.913  15.745  1.00  5.92           C
ATOM     64  O4'  DG A   4      15.366   5.301  15.383  1.00  5.78           O
ATOM     65  C3'  DG A   4      13.916   5.172  17.257  1.00  5.01           C
ATOM     66  O3'  DG A   4      12.999   4.199  17.771  1.00  5.69           O
ATOM     67  C2'  DG A   4      15.325   5.056  17.776  1.00  6.12           C
ATOM     68  C1'  DG A   4      16.228   5.340  16.601  1.00  5.65           C
ATOM     69  N9   DG A   4      16.915   6.618  16.530  1.00  5.85           N
ATOM     70  C8   DG A   4      18.291   6.782  16.475  1.00  7.25           C
ATOM     71  N7   DG A   4      18.680   8.017  16.413  1.00  7.01           N
ATOM     72  C5   DG A   4      17.464   8.741  16.415  1.00  5.60           C
ATOM     73  C6   DG A   4      17.242  10.148  16.359  1.00  5.58           C
ATOM     74  O6   DG A   4      18.121  11.031  16.291  1.00  6.97           O
ATOM     75  N1   DG A   4      15.891  10.462  16.389  1.00  5.26           N
ATOM     76  C2   DG A   4      14.889   9.555  16.456  1.00  4.93           C
ATOM     77  N2   DG A   4      13.638  10.069  16.465  1.00  5.47           N
ATOM     78  N3   DG A   4      15.072   8.221  16.519  1.00  5.01           N
ATOM     79  C4   DG A   4      16.385   7.910  16.495  1.00  5.12           C
ATOM     80  P    DC A   5      12.572   4.152  19.322  1.00  5.45           P
ATOM     81  OP1  DC A   5      13.736   4.126  20.235  1.00  7.21           O
ATOM     82  OP2  DC A   5      11.598   3.000  19.416  1.00  6.66           O
ATOM     83  O5'  DC A   5      11.791   5.543  19.444  1.00  5.28           O
ATOM     84  C5'  DC A   5      10.979   5.787  20.626  1.00  4.67           C
ATOM     85  C4'  DC A   5      10.589   7.248  20.660  1.00  4.60           C
ATOM     86  O4'  DC A   5      11.727   8.033  21.072  1.00  4.74           O
ATOM     87  C3'  DC A   5      10.101   7.836  19.317  1.00  4.77           C
ATOM     88  O3'  DC A   5       9.017   8.722  19.505  1.00  5.08           O
ATOM     89  C2'  DC A   5      11.292   8.621  18.827  1.00  4.62           C
ATOM     90  C1'  DC A   5      11.958   9.078  20.121  1.00  4.39           C
ATOM     91  N1   DC A   5      13.411   9.260  20.041  1.00  4.58           N
ATOM     92  C2   DC A   5      13.939  10.568  19.863  1.00  4.24           C
ATOM     93  O2   DC A   5      13.163  11.535  19.786  1.00  4.74           O
ATOM     94  N3   DC A   5      15.298  10.717  19.786  1.00  4.45           N
ATOM     95  C4   DC A   5      16.094   9.653  19.871  1.00  4.35           C
ATOM     96  N4   DC A   5      17.408   9.835  19.801  1.00  5.02           N
ATOM     97  C5   DC A   5      15.570   8.322  20.058  1.00  5.31           C
ATOM     98  C6   DC A   5      14.243   8.187  20.118  1.00  4.82           C
ATOM     99  P    DG A   6       7.494   8.228  19.402  1.00  5.08           P
ATOM    100  OP1  DG A   6       7.310   7.262  18.277  1.00  6.02           O
ATOM    101  OP2  DG A   6       6.660   9.486  19.429  1.00  6.23           O
ATOM    102  O5'  DG A   6       7.212   7.367  20.738  1.00  5.07           O
ATOM    103  C5'  DG A   6       7.051   7.997  22.037  1.00  5.27           C
ATOM    104  C4'  DG A   6       6.878   6.925  23.088  1.00  5.46           C
ATOM    105  O4'  DG A   6       8.106   6.152  23.156  1.00  5.73           O
ATOM    106  C3'  DG A   6       6.580   7.396  24.517  1.00  5.95           C
ATOM    107  O3'  DG A   6       5.694   6.529  25.180  1.00  6.71           O
ATOM    108  C2'  DG A   6       7.953   7.365  25.168  1.00  5.78           C
ATOM    109  C1'  DG A   6       8.598   6.176  24.518  1.00  5.71           C
ATOM    110  N9   DG A   6      10.051   6.215  24.426  1.00  5.53           N
ATOM    111  C8   DG A   6      10.886   5.131  24.573  1.00  6.04           C
ATOM    112  N7   DG A   6      12.120   5.390  24.441  1.00  6.08           N
ATOM    113  C5   DG A   6      12.156   6.739  24.175  1.00  5.46           C
ATOM    114  C6   DG A   6      13.245   7.610  23.935  1.00  5.43           C
ATOM    115  O6   DG A   6      14.472   7.293  23.919  1.00  7.16           O
ATOM    116  N1   DG A   6      12.861   8.910  23.717  1.00  4.97           N
ATOM    117  C2   DG A   6      11.580   9.343  23.699  1.00  4.93           C
ATOM    118  N2   DG A   6      11.374  10.652  23.451  1.00  5.51           N
ATOM    119  N3   DG A   6      10.512   8.551  23.926  1.00  5.24           N
ATOM    120  C4   DG A   6      10.888   7.269  24.156  1.00  5.04           C
TER
ATOM    121  O5'  DC B  11      18.926  15.402  23.792  1.00  8.02           O
ATOM    122  C5'  DC B  11      18.416  16.333  22.847  1.00  6.88           C
ATOM    123  C4'  DC B  11      16.899  16.301  22.748  1.00  5.81           C
ATOM    124  O4'  DC B  11      16.480  15.034  22.222  1.00  5.58           O
ATOM    125  C3'  DC B  11      16.099  16.450  24.062  1.00  5.79           C
ATOM    126  O3'  DC B  11      14.877  17.152  23.896  1.00  5.67           O
ATOM    127  C2'  DC B  11      15.784  15.014  24.475  1.00  5.97           C
ATOM    128  C1'  DC B  11      15.580  14.368  23.065  1.00  5.24           C
ATOM    129  N1   DC B  11      15.882  12.934  23.082  1.00  5.01           N
ATOM    130  C2   DC B  11      14.847  12.021  23.209  1.00  4.82           C
ATOM    131  O2   DC B  11      13.666  12.396  23.290  1.00  5.52           O
ATOM    132  N3   DC B  11      15.151  10.700  23.262  1.00  4.74           N
ATOM    133  C4   DC B  11      16.452  10.300  23.188  1.00  4.81           C
ATOM    134  N4   DC B  11      16.692   8.979  23.227  1.00  5.77           N
ATOM    135  C5   DC B  11      17.509  11.226  23.042  1.00  5.27           C
ATOM    136  C6   DC B  11      17.166  12.534  23.005  1.00  5.27           C
ATOM    137  P    DG B  12      14.738  18.742  23.923  1.00  5.73           P
ATOM    138  OP1  DG B  12      15.560  19.334  25.015  1.00  7.08           O
ATOM    139  OP2  DG B  12      13.260  18.999  23.911  1.00  6.80           O
ATOM    140  O5'  DG B  12      15.384  19.231  22.538  1.00  5.63           O
ATOM    141  C5'  DG B  12      14.783  18.830  21.263  1.00  5.55           C
ATOM    142  C4'  DG B  12      15.691  19.270  20.124  1.00  5.48           C
ATOM    143  O4'  DG B  12      16.967  18.683  20.271  1.00  5.59           O
ATOM    144  C3'  DG B  12      15.187  18.840  18.742  1.00  5.35           C
ATOM    145  O3'  DG B  12      14.327  19.843  18.179  1.00  5.75           O
ATOM    146  C2'  DG B  12      16.450  18.633  17.932  1.00  6.20           C
ATOM    147  C1'  DG B  12      17.527  18.400  18.932  1.00  5.70           C
ATOM    148  N9   DG B  12      18.007  17.025  19.037  1.00  5.43           N
ATOM    149  C8   DG B  12      19.344  16.654  19.033  1.00  6.29           C
ATOM    150  N7   DG B  12      19.526  15.347  19.161  1.00  6.25           N
ATOM    151  C5   DG B  12      18.218  14.827  19.251  1.00  5.07           C
ATOM    152  C6   DG B  12      17.785  13.503  19.394  1.00  5.05           C
ATOM    153  O6   DG B  12      18.473  12.458  19.472  1.00  6.39           O
ATOM    154  N1   DG B  12      16.381  13.433  19.443  1.00  4.49           N
ATOM    155  C2   DG B  12      15.529  14.511  19.382  1.00  4.50           C
ATOM    156  N2   DG B  12      14.216  14.246  19.458  1.00  5.39           N
ATOM    157  N3   DG B  12      15.942  15.754  19.240  1.00  4.99           N
ATOM    158  C4   DG B  12      17.303  15.861  19.182  1.00  4.82           C
ATOM    159  P    DC B  13      12.749  19.626  18.034  1.00  5.23           P
ATOM    160  OP1  DC B  13      12.194  20.980  17.701  1.00  6.06           O
ATOM    161  OP2  DC B  13      12.186  18.926  19.224  1.00  6.16           O
ATOM    162  O5'  DC B  13      12.689  18.675  16.744  1.00  6.62           O
ATOM    163  C5'  DC B  13      11.704  18.813  15.707  1.00  5.76           C
ATOM    164  C4'  DC B  13      11.117  17.442  15.391  1.00  5.29           C
ATOM    165  O4'  DC B  13      12.152  16.582  14.797  1.00  5.84           O
ATOM    166  C3'  DC B  13      10.535  16.656  16.565  1.00  5.51           C
ATOM    167  O3'  DC B  13       9.392  15.893  16.173  1.00  5.91           O
ATOM    168  C2'  DC B  13      11.657  15.727  16.940  1.00  6.03           C
ATOM    169  C1'  DC B  13      12.262  15.400  15.551  1.00  5.71           C
ATOM    170  N1   DC B  13      13.686  15.016  15.630  1.00  5.35           N
ATOM    171  C2   DC B  13      13.999  13.675  15.839  1.00  5.14           C
ATOM    172  O2   DC B  13      13.077  12.844  15.945  1.00  5.75           O
ATOM    173  N3   DC B  13      15.315  13.303  15.935  1.00  5.24           N
ATOM    174  C4   DC B  13      16.250  14.212  15.820  1.00  5.38           C
ATOM    175  N4   DC B  13      17.551  13.848  15.907  1.00  6.48           N
ATOM    176  C5   DC B  13      15.980  15.587  15.611  1.00  6.18           C
ATOM    177  C6   DC B  13      14.676  15.941  15.515  1.00  5.88           C
ATOM    178  P    DG B  14       7.907  16.465  16.240  1.00  6.36           P
ATOM    179  OP1  DG B  14       7.703  17.278  17.477  1.00  6.92           O
ATOM    180  OP2  DG B  14       7.024  15.292  16.034  1.00  8.20           O
ATOM    181  O5'  DG B  14       7.782  17.484  14.993  1.00  6.06           O
ATOM    182  C5'  DG B  14       7.865  16.961  13.667  1.00  5.87           C
ATOM    183  C4'  DG B  14       7.769  18.118  12.661  1.00  5.61           C
ATOM    184  O4'  DG B  14       8.840  19.044  12.888  1.00  6.39           O
ATOM    185  C3'  DG B  14       7.848  17.657  11.210  1.00  6.20           C
ATOM    186  O3'  DG B  14       6.556  17.482  10.636  1.00  6.92           O
ATOM    187  C2'  DG B  14       8.640  18.776  10.533  1.00  6.66           C
ATOM    188  C1'  DG B  14       9.397  19.489  11.623  1.00  6.45           C
ATOM    189  N9   DG B  14      10.837  19.220  11.720  1.00  5.88           N
ATOM    190  C8   DG B  14      11.821  20.181  11.747  1.00  6.66           C
ATOM    191  N7   DG B  14      13.033  19.687  11.849  1.00  6.84           N
ATOM    192  C5   DG B  14      12.836  18.306  11.888  1.00  5.83           C
ATOM    193  C6   DG B  14      13.787  17.273  11.979  1.00  5.83           C
ATOM    194  O6   DG B  14      15.032  17.344  12.058  1.00  7.03           O
ATOM    195  N1   DG B  14      13.147  16.004  11.973  1.00  5.52           N
ATOM    196  C2   DG B  14      11.799  15.795  11.901  1.00  5.22           C
ATOM    197  N2   DG B  14      11.395  14.534  11.922  1.00  5.90           N
ATOM    198  N3   DG B  14      10.912  16.785  11.810  1.00  5.73           N
ATOM    199  C4   DG B  14      11.486  18.002  11.806  1.00  5.44           C
ATOM    200  P    DC B  15       5.984  16.067  10.203  1.00  7.01           P
ATOM    201  OP1  DC B  15       4.596  16.315   9.735  1.00  8.31           O
ATOM    202  OP2  DC B  15       6.231  15.081  11.304  1.00 10.11           O
ATOM    203  O5'  DC B  15       6.895  15.773   8.944  1.00  8.26           O
ATOM    204  C5'  DC B  15       6.422  15.063   7.798  1.00  6.44           C
ATOM    205  C4'  DC B  15       7.319  13.882   7.508  1.00  6.19           C
ATOM    206  O4'  DC B  15       8.617  14.367   7.098  1.00  6.22           O
ATOM    207  C3'  DC B  15       7.608  12.913   8.672  1.00  6.74           C
ATOM    208  O3'  DC B  15       7.616  11.558   8.249  1.00  7.06           O
ATOM    209  C2'  DC B  15       8.977  13.298   9.148  1.00  7.26           C
ATOM    210  C1'  DC B  15       9.643  13.752   7.880  1.00  6.21           C
ATOM    211  N1   DC B  15      10.694  14.769   8.067  1.00  5.66           N
ATOM    212  C2   DC B  15      12.004  14.337   8.318  1.00  5.46           C
ATOM    213  O2   DC B  15      12.229  13.104   8.348  1.00  6.74           O
ATOM    214  N3   DC B  15      12.996  15.236   8.500  1.00  5.33           N
ATOM    215  C4   DC B  15      12.695  16.549   8.464  1.00  5.54           C
ATOM    216  N4   DC B  15      13.712  17.414   8.637  1.00  6.29           N
ATOM    217  C5   DC B  15      11.369  17.030   8.229  1.00  6.28           C
ATOM    218  C6   DC B  15      10.424  16.108   8.047  1.00  5.99           C
ATOM    219  P    DG B  16       6.306  10.627   8.322  1.00  7.56           P
ATOM    220  OP1  DG B  16       5.687  10.785   9.659  1.00  9.30           O
ATOM    221  OP2  DG B  16       6.749   9.256   7.911  1.00 10.00           O
ATOM    222  O5'  DG B  16       5.295  11.234   7.254  1.00  6.99           O
ATOM    223  C5'  DG B  16       5.430  10.976   5.847  1.00  6.54           C
ATOM    224  C4'  DG B  16       4.379  11.744   5.091  1.00  5.93           C
ATOM    225  O4'  DG B  16       4.628  13.152   5.234  1.00  5.90           O
ATOM    226  C3'  DG B  16       4.307  11.492   3.565  1.00  6.25           C
ATOM    227  O3'  DG B  16       3.000  11.676   3.022  1.00  6.18           O
ATOM    228  C2'  DG B  16       5.200  12.524   3.000  1.00  6.00           C
ATOM    229  C1'  DG B  16       4.848  13.731   3.896  1.00  5.55           C
ATOM    230  N9   DG B  16       5.827  14.784   4.044  1.00  5.41           N
ATOM    231  C8   DG B  16       5.526  16.116   4.101  1.00  5.68           C
ATOM    232  N7   DG B  16       6.576  16.892   4.248  1.00  6.51           N
ATOM    233  C5   DG B  16       7.648  16.010   4.302  1.00  5.15           C
ATOM    234  C6   DG B  16       9.040  16.260   4.456  1.00  5.40           C
ATOM    235  O6   DG B  16       9.610  17.365   4.578  1.00  6.71           O
ATOM    236  N1   DG B  16       9.781  15.081   4.446  1.00  5.34           N
ATOM    237  C2   DG B  16       9.275  13.842   4.341  1.00  4.88           C
ATOM    238  N2   DG B  16      10.116  12.805   4.369  1.00  6.11           N
ATOM    239  N3   DG B  16       7.959  13.565   4.196  1.00  5.45           N
ATOM    240  C4   DG B  16       7.217  14.680   4.179  1.00  5.38           C
TER
END
"""

pdb_str_poor = """\
CRYST1   23.136   23.980   28.180  90.00  90.00  90.00 P 1
ATOM      1  O5'  DC A   1      18.558  14.341   2.992  1.00  6.75           O
ATOM      2  C5'  DC A   1      19.062  13.253   4.169  1.00  5.76           C
ATOM      3  C4'  DC A   1      17.780  12.428   4.683  1.00  5.43           C
ATOM      4  O4'  DC A   1      16.900  13.637   5.169  1.00  6.23           O
ATOM      5  C3'  DC A   1      16.903  11.517   3.475  1.00  5.76           C
ATOM      6  O3'  DC A   1      16.848  10.473   4.192  1.00  6.24           O
ATOM      7  C2'  DC A   1      15.977  12.516   3.163  1.00  5.97           C
ATOM      8  C1'  DC A   1      15.473  13.380   4.327  1.00  5.80           C
ATOM      9  N1   DC A   1      14.721  14.504   4.148  1.00  5.86           N
ATOM     10  C2   DC A   1      13.295  14.451   4.290  1.00  5.95           C
ATOM     11  O2   DC A   1      12.608  13.668   4.294  1.00  7.16           O
ATOM     12  N3   DC A   1      12.794  15.674   3.726  1.00  5.87           N
ATOM     13  C4   DC A   1      13.623  16.916   3.582  1.00  5.87           C
ATOM     14  N4   DC A   1      12.698  18.168   3.295  1.00  6.52           N
ATOM     15  C5   DC A   1      15.075  16.801   3.752  1.00  6.61           C
ATOM     16  C6   DC A   1      15.640  15.653   3.819  1.00  6.96           C
ATOM     17  P    DG A   2      17.631   9.187   3.781  1.00  6.42           P
ATOM     18  OP1  DG A   2      18.530   9.316   2.435  1.00  7.41           O
ATOM     19  OP2  DG A   2      16.668   7.990   3.994  1.00  7.63           O
ATOM     20  O5'  DG A   2      18.419   9.169   5.189  1.00  6.87           O
ATOM     21  C5'  DG A   2      18.197   9.223   6.308  1.00  6.28           C
ATOM     22  C4'  DG A   2      19.205   9.558   7.462  1.00  6.57           C
ATOM     23  O4'  DG A   2      19.611  10.643   7.367  1.00  6.18           O
ATOM     24  C3'  DG A   2      18.893   9.465   8.720  1.00  6.90           C
ATOM     25  O3'  DG A   2      18.617   7.901   9.449  1.00  8.35           O
ATOM     26  C2'  DG A   2      19.721  10.190   9.807  1.00  7.77           C
ATOM     27  C1'  DG A   2      20.006  11.229   8.414  1.00  6.65           C
ATOM     28  N9   DG A   2      19.144  12.823   8.744  1.00  6.28           N
ATOM     29  C8   DG A   2      19.751  13.993   9.106  1.00  7.19           C
ATOM     30  N7   DG A   2      19.167  14.955   9.254  1.00  7.47           N
ATOM     31  C5   DG A   2      17.619  14.462   8.993  1.00  5.84           C
ATOM     32  C6   DG A   2      16.547  14.971   8.491  1.00  5.59           C
ATOM     33  O6   DG A   2      16.216  16.020   8.843  1.00  6.73           O
ATOM     34  N1   DG A   2      15.417  14.114   8.033  1.00  5.14           N
ATOM     35  C2   DG A   2      16.031  12.765   7.873  1.00  4.97           C
ATOM     36  N2   DG A   2      14.640  11.946   7.438  1.00  5.85           N
ATOM     37  N3   DG A   2      17.153  11.919   8.147  1.00  5.27           N
ATOM     38  C4   DG A   2      17.851  13.132   8.324  1.00  5.60           C
ATOM     39  P    DC A   3      17.502   7.309   9.844  1.00  8.32           P
ATOM     40  OP1  DC A   3      17.951   5.867  10.049  1.00 10.45           O
ATOM     41  OP2  DC A   3      16.550   7.398   9.077  1.00  9.29           O
ATOM     42  O5'  DC A   3      17.323   8.078  11.161  1.00  7.83           O
ATOM     43  C5'  DC A   3      16.537   7.185  12.484  1.00  6.84           C
ATOM     44  C4'  DC A   3      15.368   7.829  12.973  1.00  6.76           C
ATOM     45  O4'  DC A   3      15.906   9.208  13.536  1.00  6.82           O
ATOM     46  C3'  DC A   3      14.080   8.010  11.984  1.00  7.23           C
ATOM     47  O3'  DC A   3      12.932   8.214  12.827  1.00  8.29           O
ATOM     48  C2'  DC A   3      14.502   9.696  11.586  1.00  7.01           C
ATOM     49  C1'  DC A   3      15.121  10.054  12.879  1.00  6.65           C
ATOM     50  N1   DC A   3      15.870  11.674  12.436  1.00  6.27           N
ATOM     51  C2   DC A   3      15.272  12.628  12.764  1.00  6.39           C
ATOM     52  O2   DC A   3      13.887  12.738  13.262  1.00  6.84           O
ATOM     53  N3   DC A   3      15.949  13.828  12.480  1.00  6.04           N
ATOM     54  C4   DC A   3      17.047  13.736  12.007  1.00  6.43           C
ATOM     55  N4   DC A   3      17.968  14.885  11.886  1.00  7.42           N
ATOM     56  C5   DC A   3      17.840  12.301  12.086  1.00  7.12           C
ATOM     57  C6   DC A   3      17.186  11.363  12.180  1.00  6.73           C
ATOM     58  P    DG A   4      12.004   6.579  12.593  1.00  9.26           P
ATOM     59  OP1  DG A   4      12.160   6.144  11.154  1.00 12.46           O
ATOM     60  OP2  DG A   4      11.035   6.669  13.355  1.00 14.73           O
ATOM     61  O5'  DG A   4      13.064   5.660  13.726  1.00  7.56           O
ATOM     62  C5'  DG A   4      12.931   5.750  14.924  1.00  6.32           C
ATOM     63  C4'  DG A   4      13.949   4.733  15.512  1.00  5.92           C
ATOM     64  O4'  DG A   4      15.498   5.413  15.267  1.00  5.78           O
ATOM     65  C3'  DG A   4      14.171   4.708  17.252  1.00  5.01           C
ATOM     66  O3'  DG A   4      13.508   3.987  17.712  1.00  5.69           O
ATOM     67  C2'  DG A   4      15.823   4.484  17.315  1.00  6.12           C
ATOM     68  C1'  DG A   4      16.551   4.971  16.232  1.00  5.65           C
ATOM     69  N9   DG A   4      17.292   6.386  16.378  1.00  5.85           N
ATOM     70  C8   DG A   4      18.506   6.600  16.684  1.00  7.25           C
ATOM     71  N7   DG A   4      18.815   7.882  16.775  1.00  7.01           N
ATOM     72  C5   DG A   4      17.566   8.317  16.955  1.00  5.60           C
ATOM     73  C6   DG A   4      17.372   9.788  16.816  1.00  5.58           C
ATOM     74  O6   DG A   4      18.199  10.657  17.123  1.00  6.97           O
ATOM     75  N1   DG A   4      16.188  10.185  16.558  1.00  5.26           N
ATOM     76  C2   DG A   4      14.888   9.117  16.295  1.00  4.93           C
ATOM     77  N2   DG A   4      13.978   9.590  16.453  1.00  5.47           N
ATOM     78  N3   DG A   4      15.451   7.903  16.321  1.00  5.01           N
ATOM     79  C4   DG A   4      16.459   7.404  16.414  1.00  5.12           C
ATOM     80  P    DC A   5      12.772   3.902  19.038  1.00  5.45           P
ATOM     81  OP1  DC A   5      14.279   3.981  20.147  1.00  7.21           O
ATOM     82  OP2  DC A   5      11.998   2.997  19.367  1.00  6.66           O
ATOM     83  O5'  DC A   5      12.022   5.431  19.103  1.00  5.28           O
ATOM     84  C5'  DC A   5      11.334   5.544  20.249  1.00  4.67           C
ATOM     85  C4'  DC A   5      10.943   7.022  20.772  1.00  4.60           C
ATOM     86  O4'  DC A   5      12.405   7.639  21.156  1.00  4.74           O
ATOM     87  C3'  DC A   5      10.518   7.796  19.459  1.00  4.77           C
ATOM     88  O3'  DC A   5       9.551   8.904  19.516  1.00  5.08           O
ATOM     89  C2'  DC A   5      11.807   8.652  18.820  1.00  4.62           C
ATOM     90  C1'  DC A   5      12.744   8.983  20.111  1.00  4.39           C
ATOM     91  N1   DC A   5      13.937   8.968  20.325  1.00  4.58           N
ATOM     92  C2   DC A   5      14.614  10.225  20.025  1.00  4.24           C
ATOM     93  O2   DC A   5      13.934  11.123  20.012  1.00  4.74           O
ATOM     94  N3   DC A   5      15.926  10.008  19.965  1.00  4.45           N
ATOM     95  C4   DC A   5      16.974   9.239  20.013  1.00  4.35           C
ATOM     96  N4   DC A   5      18.063   9.323  19.960  1.00  5.02           N
ATOM     97  C5   DC A   5      16.378   7.834  20.137  1.00  5.31           C
ATOM     98  C6   DC A   5      14.775   7.783  20.156  1.00  4.82           C
ATOM     99  P    DG A   6       8.103   8.716  19.351  1.00  5.08           P
ATOM    100  OP1  DG A   6       8.308   7.937  17.755  1.00  6.02           O
ATOM    101  OP2  DG A   6       7.257  10.030  19.470  1.00  6.23           O
ATOM    102  O5'  DG A   6       7.627   7.422  20.259  1.00  5.07           O
ATOM    103  C5'  DG A   6       7.203   7.790  21.297  1.00  5.27           C
ATOM    104  C4'  DG A   6       6.972   6.647  22.158  1.00  5.46           C
ATOM    105  O4'  DG A   6       8.258   6.009  22.883  1.00  5.73           O
ATOM    106  C3'  DG A   6       6.097   6.940  23.542  1.00  5.95           C
ATOM    107  O3'  DG A   6       5.267   5.980  23.696  1.00  6.71           O
ATOM    108  C2'  DG A   6       7.077   7.060  24.603  1.00  5.78           C
ATOM    109  C1'  DG A   6       8.105   6.138  24.281  1.00  5.71           C
ATOM    110  N9   DG A   6       9.592   6.377  24.627  1.00  5.53           N
ATOM    111  C8   DG A   6      10.207   5.269  25.424  1.00  6.04           C
ATOM    112  N7   DG A   6      11.421   5.902  25.774  1.00  6.08           N
ATOM    113  C5   DG A   6      11.524   7.174  24.874  1.00  5.46           C
ATOM    114  C6   DG A   6      12.666   8.150  24.715  1.00  5.43           C
ATOM    115  O6   DG A   6      13.806   7.876  25.335  1.00  7.16           O
ATOM    116  N1   DG A   6      12.202   9.109  23.974  1.00  4.97           N
ATOM    117  C2   DG A   6      10.786   9.275  23.280  1.00  4.93           C
ATOM    118  N2   DG A   6      10.584  10.385  22.676  1.00  5.51           N
ATOM    119  N3   DG A   6       9.936   8.281  23.715  1.00  5.24           N
ATOM    120  C4   DG A   6      10.352   7.374  24.191  1.00  5.04           C
TER
ATOM    121  O5'  DC B  11      18.390  16.178  25.020  1.00  8.02           O
ATOM    122  C5'  DC B  11      17.802  16.563  23.727  1.00  6.88           C
ATOM    123  C4'  DC B  11      16.475  16.367  23.351  1.00  5.81           C
ATOM    124  O4'  DC B  11      16.581  14.886  23.292  1.00  5.58           O
ATOM    125  C3'  DC B  11      15.567  16.424  24.589  1.00  5.79           C
ATOM    126  O3'  DC B  11      14.388  17.157  24.214  1.00  5.67           O
ATOM    127  C2'  DC B  11      15.358  15.062  25.107  1.00  5.97           C
ATOM    128  C1'  DC B  11      15.362  14.168  23.911  1.00  5.24           C
ATOM    129  N1   DC B  11      16.072  12.794  24.216  1.00  5.01           N
ATOM    130  C2   DC B  11      14.969  11.784  24.351  1.00  4.82           C
ATOM    131  O2   DC B  11      14.004  12.120  23.953  1.00  5.52           O
ATOM    132  N3   DC B  11      15.575  10.519  24.617  1.00  4.74           N
ATOM    133  C4   DC B  11      16.648  10.434  24.558  1.00  4.81           C
ATOM    134  N4   DC B  11      17.263   9.089  24.737  1.00  5.77           N
ATOM    135  C5   DC B  11      17.799  11.390  24.582  1.00  5.27           C
ATOM    136  C6   DC B  11      17.277  12.685  24.472  1.00  5.27           C
ATOM    137  P    DG B  12      14.063  18.580  24.253  1.00  5.73           P
ATOM    138  OP1  DG B  12      14.515  19.155  25.429  1.00  7.08           O
ATOM    139  OP2  DG B  12      12.595  18.913  23.977  1.00  6.80           O
ATOM    140  O5'  DG B  12      14.862  19.150  23.008  1.00  5.63           O
ATOM    141  C5'  DG B  12      14.356  18.875  21.718  1.00  5.55           C
ATOM    142  C4'  DG B  12      15.395  19.631  20.531  1.00  5.48           C
ATOM    143  O4'  DG B  12      16.373  18.884  20.689  1.00  5.59           O
ATOM    144  C3'  DG B  12      14.685  19.238  19.167  1.00  5.35           C
ATOM    145  O3'  DG B  12      13.921  20.367  18.684  1.00  5.75           O
ATOM    146  C2'  DG B  12      16.395  19.357  18.328  1.00  6.20           C
ATOM    147  C1'  DG B  12      17.393  19.037  19.623  1.00  5.70           C
ATOM    148  N9   DG B  12      17.756  17.291  19.447  1.00  5.43           N
ATOM    149  C8   DG B  12      19.095  16.934  18.862  1.00  6.29           C
ATOM    150  N7   DG B  12      19.008  15.920  18.711  1.00  6.25           N
ATOM    151  C5   DG B  12      17.723  15.302  19.321  1.00  5.07           C
ATOM    152  C6   DG B  12      17.465  14.049  19.481  1.00  5.05           C
ATOM    153  O6   DG B  12      18.109  12.934  19.018  1.00  6.39           O
ATOM    154  N1   DG B  12      16.159  13.768  19.730  1.00  4.49           N
ATOM    155  C2   DG B  12      15.334  15.147  20.261  1.00  4.50           C
ATOM    156  N2   DG B  12      14.217  14.760  20.752  1.00  5.39           N
ATOM    157  N3   DG B  12      15.746  16.198  20.052  1.00  4.99           N
ATOM    158  C4   DG B  12      17.074  16.421  19.555  1.00  4.82           C
ATOM    159  P    DC B  13      12.678  19.767  18.152  1.00  5.23           P
ATOM    160  OP1  DC B  13      11.869  20.815  17.883  1.00  6.06           O
ATOM    161  OP2  DC B  13      11.982  18.700  19.291  1.00  6.16           O
ATOM    162  O5'  DC B  13      12.924  18.779  16.938  1.00  6.62           O
ATOM    163  C5'  DC B  13      11.685  18.678  16.017  1.00  5.76           C
ATOM    164  C4'  DC B  13      11.180  17.477  15.593  1.00  5.29           C
ATOM    165  O4'  DC B  13      12.554  16.556  15.013  1.00  5.84           O
ATOM    166  C3'  DC B  13      10.859  16.392  16.854  1.00  5.51           C
ATOM    167  O3'  DC B  13       9.785  15.914  16.816  1.00  5.91           O
ATOM    168  C2'  DC B  13      11.948  15.746  17.260  1.00  6.03           C
ATOM    169  C1'  DC B  13      12.840  15.319  16.034  1.00  5.71           C
ATOM    170  N1   DC B  13      14.237  15.100  16.204  1.00  5.35           N
ATOM    171  C2   DC B  13      14.431  13.844  16.104  1.00  5.14           C
ATOM    172  O2   DC B  13      13.785  12.841  16.376  1.00  5.75           O
ATOM    173  N3   DC B  13      15.731  13.493  16.249  1.00  5.24           N
ATOM    174  C4   DC B  13      16.753  14.441  16.224  1.00  5.38           C
ATOM    175  N4   DC B  13      17.895  14.264  16.090  1.00  6.48           N
ATOM    176  C5   DC B  13      16.199  15.736  16.104  1.00  6.18           C
ATOM    177  C6   DC B  13      15.162  15.939  16.120  1.00  5.88           C
ATOM    178  P    DG B  14       8.272  16.421  16.796  1.00  6.36           P
ATOM    179  OP1  DG B  14       8.360  16.932  18.219  1.00  6.92           O
ATOM    180  OP2  DG B  14       7.245  14.971  16.815  1.00  8.20           O
ATOM    181  O5'  DG B  14       8.088  17.461  15.506  1.00  6.06           O
ATOM    182  C5'  DG B  14       8.027  16.856  14.427  1.00  5.87           C
ATOM    183  C4'  DG B  14       7.697  17.989  13.192  1.00  5.61           C
ATOM    184  O4'  DG B  14       9.260  18.737  13.333  1.00  6.39           O
ATOM    185  C3'  DG B  14       7.733  17.338  11.903  1.00  6.20           C
ATOM    186  O3'  DG B  14       6.494  17.192  11.417  1.00  6.92           O
ATOM    187  C2'  DG B  14       8.302  18.895  11.265  1.00  6.66           C
ATOM    188  C1'  DG B  14       9.437  19.067  12.135  1.00  6.45           C
ATOM    189  N9   DG B  14      10.701  19.070  11.753  1.00  5.88           N
ATOM    190  C8   DG B  14      11.918  19.990  11.280  1.00  6.66           C
ATOM    191  N7   DG B  14      12.868  19.546  11.476  1.00  6.84           N
ATOM    192  C5   DG B  14      12.649  18.022  11.679  1.00  5.83           C
ATOM    193  C6   DG B  14      13.602  17.047  11.491  1.00  5.83           C
ATOM    194  O6   DG B  14      14.927  16.875  11.151  1.00  7.03           O
ATOM    195  N1   DG B  14      13.042  15.748  12.041  1.00  5.52           N
ATOM    196  C2   DG B  14      11.672  15.592  12.236  1.00  5.22           C
ATOM    197  N2   DG B  14      11.348  14.455  12.712  1.00  5.90           N
ATOM    198  N3   DG B  14      10.836  16.766  12.350  1.00  5.73           N
ATOM    199  C4   DG B  14      11.354  17.756  12.028  1.00  5.44           C
ATOM    200  P    DC B  15       6.218  15.986  10.586  1.00  7.01           P
ATOM    201  OP1  DC B  15       4.510  15.946  10.477  1.00  8.31           O
ATOM    202  OP2  DC B  15       6.747  14.887  11.105  1.00 10.11           O
ATOM    203  O5'  DC B  15       6.697  16.141   9.256  1.00  8.26           O
ATOM    204  C5'  DC B  15       6.431  15.640   7.947  1.00  6.44           C
ATOM    205  C4'  DC B  15       7.332  14.796   7.485  1.00  6.19           C
ATOM    206  O4'  DC B  15       8.887  15.306   7.140  1.00  6.22           O
ATOM    207  C3'  DC B  15       7.729  13.783   8.602  1.00  6.74           C
ATOM    208  O3'  DC B  15       7.849  12.490   7.866  1.00  7.06           O
ATOM    209  C2'  DC B  15       9.421  14.123   9.032  1.00  7.26           C
ATOM    210  C1'  DC B  15       9.994  14.685   7.840  1.00  6.21           C
ATOM    211  N1   DC B  15      10.816  15.849   8.023  1.00  5.66           N
ATOM    212  C2   DC B  15      12.121  15.204   7.903  1.00  5.46           C
ATOM    213  O2   DC B  15      12.294  13.987   7.871  1.00  6.74           O
ATOM    214  N3   DC B  15      13.411  16.017   8.254  1.00  5.33           N
ATOM    215  C4   DC B  15      12.697  17.294   8.452  1.00  5.54           C
ATOM    216  N4   DC B  15      14.005  18.139   8.707  1.00  6.29           N
ATOM    217  C5   DC B  15      11.616  18.009   8.496  1.00  6.28           C
ATOM    218  C6   DC B  15      10.506  16.956   7.950  1.00  5.99           C
ATOM    219  P    DG B  16       6.746  11.289   8.146  1.00  7.56           P
ATOM    220  OP1  DG B  16       6.487  11.279   9.874  1.00  9.30           O
ATOM    221  OP2  DG B  16       7.228  10.074   7.851  1.00 10.00           O
ATOM    222  O5'  DG B  16       5.638  11.663   7.331  1.00  6.99           O
ATOM    223  C5'  DG B  16       5.337  11.421   6.141  1.00  6.54           C
ATOM    224  C4'  DG B  16       4.283  12.081   5.287  1.00  5.93           C
ATOM    225  O4'  DG B  16       4.658  13.293   5.164  1.00  5.90           O
ATOM    226  C3'  DG B  16       3.864  11.520   4.009  1.00  6.25           C
ATOM    227  O3'  DG B  16       2.393  11.576   4.196  1.00  6.18           O
ATOM    228  C2'  DG B  16       4.623  12.031   2.975  1.00  6.00           C
ATOM    229  C1'  DG B  16       4.307  13.500   3.878  1.00  5.55           C
ATOM    230  N9   DG B  16       5.591  14.582   3.394  1.00  5.41           N
ATOM    231  C8   DG B  16       5.456  15.603   2.606  1.00  5.68           C
ATOM    232  N7   DG B  16       6.305  16.450   2.616  1.00  6.51           N
ATOM    233  C5   DG B  16       7.431  15.552   3.086  1.00  5.15           C
ATOM    234  C6   DG B  16       8.756  15.541   2.915  1.00  5.40           C
ATOM    235  O6   DG B  16       9.537  16.295   2.806  1.00  6.71           O
ATOM    236  N1   DG B  16       9.587  14.409   3.788  1.00  5.34           N
ATOM    237  C2   DG B  16       8.585  13.432   4.167  1.00  4.88           C
ATOM    238  N2   DG B  16       9.598  12.532   4.976  1.00  6.11           N
ATOM    239  N3   DG B  16       7.242  13.447   4.092  1.00  5.45           N
ATOM    240  C4   DG B  16       6.936  14.354   3.721  1.00  5.38           C
TER
"""

def get_pdb_inputs(pdb_str, restraints):
  ppf = mmtbx.utils.process_pdb_file_srv(log=False).process_pdb_files(
    raw_records=pdb_str.splitlines())[0]
  xrs = ppf.xray_structure(show_summary = False)
  restraints_manager=None
  if(restraints):
    restraints_manager = mmtbx.restraints.manager(
      geometry      = ppf.geometry_restraints_manager(show_energies = False),
      normalization = True)
  return group_args(
    ph  = ppf.all_chain_proxies.pdb_hierarchy,
    grm = restraints_manager,
    xrs = xrs)

def get_map(xrs):
  f_calc = xrs.structure_factors(d_min = 1.2).f_calc()
  fft_map = f_calc.fft_map(resolution_factor=0.25)
  fft_map.apply_sigma_scaling()
  return fft_map.real_map_unpadded()

def exercise():
  """
  Exercise refine "easy" with DNA/RNA.
  """
  pi_good = get_pdb_inputs(pdb_str=pdb_str_answer, restraints=False)
  map_data = get_map(xrs=pi_good.xrs)
  xrs_good = pi_good.xrs.deep_copy_scatterers()
  pi_good.ph.write_pdb_file(file_name="answer.pdb",
    crystal_symmetry=xrs_good.crystal_symmetry())
  #
  pi_poor = get_pdb_inputs(pdb_str=pdb_str_poor, restraints=True)
  pi_poor.ph.write_pdb_file(file_name="poor.pdb")
  xrs_poor = pi_poor.xrs.deep_copy_scatterers()
  #
  d = xrs_good.distances(other=xrs_poor)
  print(d.min_max_mean().as_tuple())
  assert flex.max(d)>2
  assert flex.mean(d)>0.7
  #
  xrs_refined = xrs_poor
  for i in range(3):
    ero = individual_sites.easy(
      map_data                    = map_data,
      xray_structure              = xrs_refined,
      pdb_hierarchy               = pi_poor.ph,
      geometry_restraints_manager = pi_poor.grm)
    xrs_refined = ero.xray_structure
  # comapre
  d = xrs_good.distances(other=xrs_refined)
  print(d.min_max_mean().as_tuple())
  assert flex.max(d)<0.15
  assert flex.mean(d)<0.03
  ero.pdb_hierarchy.write_pdb_file(file_name="refined.pdb",
    crystal_symmetry=xrs_good.crystal_symmetry())

if(__name__ == "__main__"):
  timer = user_plus_sys_time()
  exercise()
  print("Time: %6.2f" % timer.elapsed())
  print("OK")
