/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-15 10:09
 */

#ifndef PEERMANAGER_H_
#define PEERMANAGER_H_

#include <string>
#include "BitStorm.h"
#include "ThreadMutex.h"

class CPeerManager : 
	public IPeerManager,
	public ITimerCallback
{
public:
	CPeerManager();
	virtual ~CPeerManager();
private:
	IBTTask* _task;
	unsigned int _connectTimerID;
	unsigned int _chokeTimerID;
	
	TPeerInfoMap _unusedPeerList;
	CThreadMutex _unusedPeerListMutex;
	
	TPeerInfoMap _connectingPeerList;
	TPeerInfoMap _connectedPeerList;
	TPeerInfoMap _banedPeerList;
private:
	void checkPeerConnection();	
	void checkPeerChoke();
	void countPeersSpeed();
	bool peerInUnusedList(std::string id);
	bool peerInConnectingList(std::string id);
	bool peerInConnectedList(std::string id);
	bool peerInBanedList(std::string id);
public:	
 	void setBTTask(IBTTask* task);
	IBTTask* getBTTask();	
	
	bool start();
	void stop();
	
	void onTimer(unsigned int id);
	
	void addPeerInfoWithoutID(const char* ip, unsigned short port);
	bool addAcceptedPeer(int handle, const char* ip, unsigned short port);
	void broadcastHave(unsigned int pieceIndex);
	void cancelPieceRequest(unsigned int pieceIndex);
	unsigned int getConnectedPeerCount();
	void onDownloadComplete();
};

#endif /*PEERMANAGER_H_*/
