# B.6 But won't decisions made by individuals with their own money be the
best?

This question refers to an argument commonly used by capitalists to justify
the fact that investment decisions are removed from public control under
capitalism, with private investors making all the decisions. Clearly the
assumption behind this argument is that individuals suddenly lose their
intelligence when they get together and discuss their common interests. But
surely, through debate, we can enrich our ideas by social interaction. In the
marketplace we do not discuss but instead act as atomised individuals.

This issue involves the _"Isolation Paradox,"_ according to which the very
logic of individual decision-making is different from that of collective
decision-making. An example is the _"tyranny of small decisions."_ Let us
assume that in the soft drink industry some companies start to produce
(cheaper) non-returnable bottles. The end result of this is that most, if not
all, the companies making returnable bottles lose business and switch to non-
returnables. Result? Increased waste and environmental destruction.

This is because market price fails to take into account social costs and
benefits, indeed it **mis** -estimates them for both buyer/seller and to
others not involved in the transaction. This is because, as Schumacher points
out, the _"strength of the idea of private enterprise lies in its terrifying
simplicity. It suggests that the totality of life can be reduced to one aspect
- profits..."_ [ **Small is Beautiful** , p. 215] But life cannot be reduced
to one aspect without impoverishing it and so capitalism _"knows the price of
everything but the value of nothing."_

Therefore the market promotes "the tyranny of small decisions" and this can
have negative outcomes for those involved. The capitalist "solution" to this
problem is no solution, namely to act after the event. Only after the
decisions have been made and their effects felt can action be taken. But by
then the damage has been done. Can suing a company **really** replace a
fragile eco-system? In addition, the economic context has been significantly
altered, because investment decisions are often difficult to unmake.

In other words, the operations of the market provide an unending source of
examples for the argument that the aggregate results of the pursuit of private
interest may well be collectively damaging. And as collectives are made up of
individuals, that means damaging to the individuals involved. The remarkable
ideological success of "free market" capitalism is to identify the anti-social
choice with self-interest, so that any choice in the favour of the interests
which we share collectively is treated as a piece of self-sacrifice. However,
by atomising decision making, the market often actively works against the
self-interest of the individuals that make it up.

Game theory is aware that the sum of rational choices do not automatically
yield a rational group outcome. Indeed, it terms such situations as
"collective action" problems. By not agreeing common standards, a "race to the
bottom" can ensue in which a given society reaps choices that we as
individuals really don't want. The rational pursuit of individual self-
interest leaves the group, and so most individuals, worse off. The problem is
not bad individual judgement (far from it, the individual is the only person
able to know what is best for them in a given situation). It is the absence of
social discussion and remedies that compels people to make unbearable choices
because the available menu presents no good options.

By **not** discussing the impact of their decisions with everyone who will be
affected, the individuals in question have not made a better decision. Of
course, under our present highly centralised statist and capitalist system,
such a discussion would be impossible to implement, and its closest
approximation -- the election process -- is too vast, bureaucratic and
dominated by wealth to do much beyond passing a few toothless laws which are
generally ignored when they hinder profits.

However, let's consider what the situation would be like under libertarian
socialism, where the local community assemblies discuss the question of
returnable bottles along with the workforce. Here the function of specific
interest groups (such as consumer co-operatives, ecology groups, workplace
Research and Development action committees and so on) would play a critical
role in producing information. Knowledge, as Bakunin, Kropotkin, etc. knew, is
widely dispersed throughout society and the role of interested parties is
essential in making it available to others. Based upon this information and
the debate it provokes, the collective decision reached would most probably
favour returnables over waste. This would be a better decision from a social
and ecological point of view, and one that would benefit the individuals who
discussed and agreed upon its effects on themselves and their society.

In other words, anarchists think we have to take an active part in creating
the menu as well as picking options from it which reflect our individual
tastes and interests.

It needs to be emphasised that such a system does not involve discussing and
voting on everything under the sun, which would paralyse all activity. To the
contrary, most decisions would be left to those interested (e.g. workers
decide on administration and day-to-day decisions within the factory), the
community decides upon policy (e.g. returnables over waste). Neither is it a
case of electing people to decide for us, as the decentralised nature of the
confederation of communities ensures that power lies in the hands of local
people.

This process in no way implies that "society" decides what an individual is to
consume. That, like all decisions affecting the individual only, is left
entirely up to the person involved. Communal decision-making is for decisions
that impact both the individual and society, allowing those affected by it to
discuss it among themselves as equals, thus creating a rich social context
within which individuals can act. This is an obvious improvement over the
current system, where decisions that often profoundly alter people's lives are
left to the discretion of an elite class of managers and owners, who are
supposed to "know best."

There is, of course, the danger of "tyranny of the majority" in any democratic
system, but in a direct libertarian democracy, this danger would be greatly
reduced, for reasons discussed in section I.5.6 ( [Won't there be a danger of
a "tyranny of the majority" under libertarian socialism?](secI5.md#seci56)).

[‹ B.5 Is capitalism empowering and based on human action?](secB5.md "Go to
previous page") [up](secBcon.md "Go to parent page") [B.7 What classes exist
within modern society? ›](secB7.md "Go to next page")

