# H.5 What is vanguardism and why do anarchists reject it?

Many socialists follow the ideas of Lenin and, in particular, his ideas on
vanguard parties. These ideas were expounded by Lenin in his (in)famous work
**What is to be Done?** which is considered as one of the important books in
the development of Bolshevism.

The core of these ideas is the concept of _"vanguardism,"_ or the _"vanguard
party."_ According to this perspective, socialists need to organise together
in a party, based on the principles of _"democratic centralism,"_ which aims
to gain a decisive influence in the class struggle. The ultimate aim of such a
party is revolution and its seizure of power. Its short term aim is to gather
into it all _"class conscious"_ workers into a _"efficient"_ and _"effective"_
party, alongside members of other classes who consider themselves as
revolutionary Marxists. The party would be strictly centralised, with all
members expected to submit to party decisions, speak in one voice and act in
one way. Without this _"vanguard,"_ injecting its politics into the working
class (who, it is asserted, can only reach trade union consciousness by its
own efforts), a revolution is impossible.

Lenin laid the foundation of this kind of party in his book **What is to be
Done?** and the vision of the _"vanguard"_ party was explicitly formalised in
the Communist International. As Lenin put it, _"Bolshevism **has created** the
ideological and tactical foundations of a Third International . . . Bolshevism
**can serve as a model of tactics for all.**"_ [**Collected Works**, vol. 28,
pp. 292-3] Using the Russian Communist Party as its model, Bolshevik ideas on
party organisation were raised as a model for revolutionaries across the
world. Since then, the various followers of Leninism and its offshoots like
Trotskyism have organised themselves in this manner (with varying success).

The wisdom of applying an organisational model that had been developed in the
semi-feudal conditions of Tsarist Russia to **every** country, regardless of
its level of development, has been questioned by anarchists from the start.
After all, could it not be wiser to build upon the revolutionary tendencies
which had developed in specific countries rather than import a new model which
had been created for, and shaped by, radically different social, political and
economic conditions? The wisdom of applying the vanguard model is not
questioned on these (essentially materialist) points by those who subscribe to
it. While revolutionary workers in the advanced capitalist nations subscribed
to anarchist and syndicalist ideas, this tradition is rejected in favour of
one developed by, in the main, bourgeois intellectuals in a nation which was
still primarily feudal and absolutist. The lessons learned from years of
struggle in actual capitalist societies were simply rejected in favour of
those from a party operating under Tsarism. While most supporters of
vanguardism will admit that conditions now are different than in Tsarist
Russia, they still subscribe to organisational methods developed in that
context and justify it, ironically enough, because of its "success" in the
totally different conditions that prevailed in Russia in the early 20th
Century! And Leninists claim to be materialists!

Perhaps the reason why Bolshevism rejected the materialist approach was
because most of the revolutionary movements in advanced capitalist countries
were explicitly anti-parliamentarian, direct actionist, decentralist,
federalist and influenced by libertarian ideas? This materialist analysis was
a key aspect of the council communist critique of Lenin's **Left-Wing
Communism**, for example (see Herman Gorter's **Open Letter to Comrade Lenin**
for one excellent reply to Bolshevik arguments, tactics and assumptions). This
attempt to squeeze every working class movement into **one** "officially
approved" model dates back to Marx and Engels. Faced with any working class
movement which did **not** subscribe to their vision of what they should be
doing (namely organising in political parties to take part in "political
action," i.e. standing in bourgeois elections) they simply labelled it as the
product of non-proletarian "sects." They went so far as to gerrymander the
1872 conference of the First International to make acceptance of "political
action" mandatory on all sections in an attempt to destroy anarchist influence
in it.

So this section of our FAQ will explain why anarchists reject this model. In
our view, the whole concept of a _"vanguard party"_ is fundamentally anti-
socialist. Rather than present an effective and efficient means of achieving
revolution, the Leninist model is elitist, hierarchical and highly inefficient
in achieving a socialist society. At best, these parties play a harmful role
in the class struggle by alienating activists and militants with their
organisational principles and manipulative tactics within popular structures
and groups. At worse, these parties can seize power and create a new form of
class society (a state capitalist one) in which the working class is oppressed
by new bosses (namely, the party hierarchy and its appointees).

However, before discussing why anarchists reject "vanguardism" we need to
stress a few points. Firstly, anarchists recognise the obvious fact that the
working class is divided in terms of political consciousness. Secondly, from
this fact most anarchists recognise the need to organise together to spread
our ideas as well as taking part in, influencing and learning from the class
struggle. As such, anarchists have long been aware of the need for
revolutionaries to organise **as revolutionaries.** Thirdly, anarchists are
well aware of the importance of revolutionary minorities playing an inspiring
and "leading" role in the class struggle. We do not reject the need for
revolutionaries to _"give a lead"_ in struggles, we reject the idea of
institutionalised leadership and the creation of a leader/led hierarchy
implicit (and sometimes no so implicit) in vanguardism.

As such, we do not oppose _"vanguardism"_ for these reasons. So when Leninists
like Tony Cliff argue that it is _"unevenness in the class [which] makes the
party necessary,"_ anarchists reply that _"unevenness in the class"_ makes it
essential that revolutionaries organise together to influence the class but
that organisation does not and need not take the form of a vanguard party.
[Tony Cliff, **Lenin**, vol. 2, p. 149] This is because we reject the concept
and practice for three reasons.

Firstly, and most importantly, anarchists reject the underlying assumption of
vanguardism. It is based on the argument that _"socialist consciousness"_ has
to be introduced into the working class from outside. We argue that not only
is this position empirically false, it is fundamentally anti-socialist in
nature. This is because it logically denies that the emancipation of the
working class is the task of the working class itself. Moreover, it serves to
justify elite rule. Some Leninists, embarrassed by the obvious anti-socialist
nature of this concept, try and argue that Lenin (and so Leninism) does not
hold this position. We show that such claims are false.

Secondly, there is the question of organisational structure. Vanguard parties
are based on the principle of _"democratic centralism"_. Anarchists argue that
such parties, while centralised, are not, in fact, democratic nor can they be.
As such, the _"revolutionary"_ or _"socialist"_ party is no such thing as it
reflects the structure of the capitalist system it claims to oppose.

Lastly, anarchists argue that such parties are, despite the claims of their
supporters, not actually very efficient or effective in the revolutionary
sense of the word. At best, they hinder the class struggle by being slow to
respond to rapidly changing situations. At worse, they are "efficient" in
shaping both the revolution and the post-revolutionary society in a
hierarchical fashion, so re-creating class rule.

So these are key aspects of the anarchist critique of vanguardism, which we
discuss in more depth in the following sections. It is a bit artificial to
divide these issues into different sections because they are all related. The
role of the party implies a specific form of organisation (as Lenin himself
stressed), the form of the party influences its effectiveness. It is for ease
of presentation we divide up our discussion so.

## H.5.1 Why are vanguard parties anti-socialist?

The reason why vanguard parties are anti-socialist is simply because of the
role assigned to them by Lenin, which he thought was vital. Simply put,
without the party, no revolution would be possible. As Lenin put it in 1900,
_"[i]solated from Social-Democracy, the working class movement becomes petty
and inevitably becomes bourgeois."_ [**Collected Works**, vol. 4, p. 368] In
**What is to be Done?**, he expands on this position:

> _"Class political consciousness can be brought to the workers **only from
without,** that is, only outside of the economic struggle, outside the sphere
of relations between workers and employers. The sphere from which alone it is
possible to obtain this knowledge is the sphere of relationships between
**all** the various classes and strata and the state and the government - the
sphere of the interrelations between **all** the various classes."_
[**Essential Works of Lenin**, p. 112]

Thus the role of the party is to inject socialist politics into a class
incapable of developing them itself.

Lenin is at pains to stress the Marxist orthodoxy of his claims and quotes the
_"profoundly true and important"_ comments of Karl Kautsky on the subject.
[**Op. Cit.**, p. 81] Kautsky, considered the "pope" of Social-Democracy,
stated that it was _"absolutely untrue"_ that _"socialist consciousness"_ was
a _"necessary and direct result of the proletarian class struggle."_ Rather,
_"socialism and the class struggle arise side by side and not one out of the
other . . . Modern socialist consciousness can arise only on the basis of
profound scientific knowledge . . . The vehicles of science are not the
proletariat, but the **bourgeois intelligentsia**: it was in the minds of some
members of this stratum that modern socialism originated, and it was they who
communicated it to the more intellectually developed proletarians who, in
their turn, introduced it into the proletarian class struggle."_ Kautsky
stressed that _"socialist consciousness is something introduced into the
proletarian class struggle from without."_ [quoted by Lenin, **Op. Cit.**, pp.
81-2]

So Lenin, it must be stressed, was not inventing anything new here. He was
simply repeating the orthodox Marxist position and, as is obvious,
wholeheartedly agreed with Kautsky's pronouncements (any attempt to claim that
he did not or later rejected them is nonsense, as we prove in [section
H.5.4](secH5.md#sech54)). Lenin, with his usual modesty, claimed to speak on
behalf of the workers when he wrote that _"intellectuals must talk to us, and
tell us more about what we do not know and what we can never learn from our
factory and 'economic' experience, that is, you must give us political
knowledge."_ [**Op. Cit.**, p. 108] Thus we have Lenin painting a picture of a
working class incapable of developing _"political knowledge"_ or _"socialist
consciousness"_ by its own efforts and so is reliant on members of the party,
themselves either radical elements of the bourgeoisie and petty-bourgeoisie or
educated by them, to provide it with such knowledge.

The obvious implication of this argument is that the working class cannot
liberate itself by its own efforts. Without the radical bourgeois to provide
the working class with "socialist" ideas, a socialist movement, let alone
society, is impossible. If the working class cannot develop its own political
theory by its own efforts then it cannot conceive of transforming society and,
at best, can see only the need to work within capitalism for reforms to
improve its position in society. A class whose members cannot develop
political knowledge by its own actions cannot emancipate itself. It is, by
necessity, dependent on others to shape and form its movements. To quote
Trotsky's telling analogy on the respective roles of party and class, leaders
and led:

> _"Without a guiding organisation, the energy of the masses would dissipate
like steam not enclosed in a piston. But nevertheless, what moves things is
not the piston or the box, but the steam."_ [**History of the Russian
Revolution**, vol. 1, p. 17]

While Trotsky's mechanistic analogy may be considered as somewhat crude, it
does expose the underlying assumptions of Bolshevism. After all, did not Lenin
argue that the working class could not develop _"socialist consciousness"_ by
themselves and that it had to be introduced from without? How can you expect
steam to create a piston? You cannot. Thus we have a blind, elemental force
incapable of conscious thought being guided by a creation of science, the
piston (which, of course, is a product of the work of the _"vehicles of
science,"_ namely the **bourgeois intelligentsia**). In the Leninist
perspective, if revolutions are the locomotives of history (to use Marx's
words) then the masses are the steam, the party the locomotive and the leaders
the train driver. The idea of a future society being constructed
democratically from below by the workers themselves rather than through
periodically elected leaders seems to have passed Bolshevism past. This is
unsurprising, given that the Bolsheviks saw the workers in terms of blindly
moving steam in a box, something incapable of being creative unless an outside
force gave them direction (instructions).

Libertarian socialist Cornelius Castoriadis provides a good critique of the
implications of the Leninist position:

> _"No positive content, nothing new capable of providing the foundation for
the reconstruction of society could arise out of a mere awareness of poverty.
From the experience of life under capitalism the proletariat could derive no
new principles either for organising this new society or for orientating it in
another direction. Under such conditions, the proletarian revolution becomes .
. . a simple reflex revolt against hunger. It is impossible to see how
socialist society could ever be the result of such a reflex . . . Their
situation forces them to suffer the consequences of capitalism's
contradictions, but in no way does it lead them to discover its causes. An
acquaintance with these causes comes not from experiencing the production
process but from theoretical knowledge . . . This knowledge may be accessible
to individual workers, but not to the proletariat **qua** proletariat. Driven
by its revolt against poverty, but incapable of self-direction since its
experiences does not give it a privileged viewpoint on reality, the
proletariat according to this outlook, can only be an infantry in the service
of a general staff of specialists. These specialists **know** (from
considerations that the proletariat as such does not have access to) what is
going wrong with present-day society and how it must be modified. The
traditional view of the economy and its revolutionary perspective can only
found, and actually throughout history has only founded, a **bureaucratic
politics** . . . [W]hat we have outlined are the consequences that follow
objectively from this theory. And they have been affirmed in an ever clearer
fashion within the actual historical movement of Marxism, culminating in
Stalinism."_ [**Social and Political Writings**, vol. 2, pp. 257-8]

Thus we have a privileged position for the party and a perspective which can
(and did) justify party dictatorship **over** the proletariat. Given the
perspective that the working class cannot formulate its own "ideology" by its
own efforts, of its incapacity to move beyond _"trade union consciousness"_
independently of the party, the clear implication is that the party could in
no way be bound by the predominant views of the working class. As the party
embodies _"socialist consciousness"_ (and this arises outside the working
class and its struggles) then opposition of the working class to the party
signifies a failure of the class to resist alien influences. As Lenin put it:

> _"Since there can be no talk of an independent ideology being developed by
the masses of the workers in the process of their movement, **the only choice
is**: either bourgeois or socialist ideology. There is no middle course . . .
Hence, to belittle socialist ideology **in any way,** to **deviate from it in
the slightest degree** means strengthening bourgeois ideology. There is a lot
of talk about spontaneity, but the **spontaneous** development of the labour
movement leads to its becoming subordinated to bourgeois ideology . . . Hence
our task, the task of Social-Democracy, is to **combat spontaneity,** to
**divert** the labour movement from its spontaneous, trade unionist striving
to go under the wing of the bourgeoisie, and to bring it under the wing of
revolutionary Social-Democracy."_ [**Op. Cit.**, pp. 82-3]

The implications of this argument became clear once the Bolsheviks seized
power. As a justification for party dictatorship, you would be hard pressed to
find any better. If the working class revolts against the ruling party, then
we have a _"spontaneous"_ development which, inevitably, is an expression of
bourgeois ideology. As the party represents socialist consciousness, any
deviation in working class support for it simply meant that the working class
was being _"subordinated"_ to the bourgeoisie. This meant, obviously, that to
_"belittle"_ the _"role"_ of the party by questioning its rule meant to
_"strengthen bourgeois ideology"_ and when workers spontaneously went on
strike or protested against the party's rule, the party had to _"combat"_
these strivings in order to maintain working class rule! As the _"masses of
the workers"_ cannot develop an _"independent ideology,"_ the workers are
rejecting socialist ideology in favour of bourgeois ideology. The party, in
order to defend the "the revolution" (even the "rule of the workers"!) has to
impose its will onto the class, to _"combat spontaneity."_

As we saw in [section H.1.2](secH1.md#sech12), none of the leading
Bolsheviks were shy about drawing these conclusions once in power and faced
with working class revolt against their rule. Indeed, they raised the idea
that the _"dictatorship of the proletariat"_ was also, in fact, the
_"dictatorship of the party"_ and, as we discussed in [section
H.3.8](secH3.md#sech38) integrated this into their theory of the state.
Thus, Leninist ideology implies that _"workers' power"_ exists independently
of the workers. This means that the sight of the _"dictatorship of the
proletariat"_ (i.e. the Bolshevik government) repressing the proletariat is to
be expected.

This elitist perspective of the party, the idea that it and it alone possesses
knowledge can be seen from the resolution of the Communist International on
the role of the party. It stated that _"the working class without an
independent political party is a body without a head."_ [**Proceedings and
Documents of the Second Congress 1920**, vol. 1, p. 194] This use of
biological analogies says more about Bolshevism that its authors intended.
After all, it suggests a division of labour which is unchangeable. Can the
hands evolve to do their own thinking? Of course not. Yet again, we have an
image of the class as unthinking brute force. As the Cohen-Bendit brothers
argued, the _"Leninist belief that the workers cannot spontaneously go beyond
the level of trade union consciousness is tantamount to beheading the
proletariat, and then insinuating the Party as the head . . . Lenin was wrong,
and in fact, in Russia the Party was forced to decapitate the workers'
movement with the help of the political police and the Red Army under the
brilliant leadership of Trotsky and Lenin."_ [**Obsolute Communism**, pp.
194-5]

As well as explaining the subsequent embrace of party dictatorship **over**
the working class, vanguardism also explains the notorious inefficiency of
Leninist parties faced with revolutionary situations we discuss in [section
H.5.8](secH5.md#sech58). Basing themselves on the perspective that all
spontaneous movements are inherently bourgeois they could not help but be
opposed to autonomous class struggle and the organisations and tactics it
generates. James C. Scott, in his excellent discussion of the roots and flaws
in Lenin's ideas on the party, makes the obvious point that since, for Lenin,
_"authentic, revolutionary class consciousness could never develop
autonomously within the working class, it followed that that the actual
political outlook of workers was always a threat to the vanguard party."_
[**Seeing like a State**, p. 155] As Maurice Brinton argued, the _"Bolshevik
cadres saw their role as the leadership of the revolution. Any movement not
initiated by them or independent of their control could only evoke their
suspicion."_ These developments, of course, did not occur by chance or
accidentally for _"a given ideological premise (the preordained hegemony of
the Party) led necessarily to certain conclusions in practice."_ [**The
Bolsheviks and Workers' Control**, p. xi and p. xii]

Bakunin expressed the implications of the vanguardist perspective extremely
well. It is worthwhile quoting him at length:

> _"Idealists of all sorts, metaphysicians, positivists, those who uphold the
priority of science over life, the doctrinaire revolutionists - all of them
champion with equal zeal although differing in their argumentation, the idea
of the State and State power, seeing in them, quite logically from their point
of view, the only salvation of society. **Quite logically,** I say, having
taken as their basis the tenet - a fallacious tenet in our opinion - that
thought is prior to life, and abstract theory is prior to social practice, and
that therefore sociological science must become the starting point for social
upheavals and social reconstruction - they necessarily arrived at the
conclusion that since thought, theory, and science are, for the present at
least, the property of only a very few people, those few should direct social
life; and that on the morrow of the Revolution the new social organisation
should be set up not by the free integration of workers' associations,
villages, communes, and regions from below upward, conforming to the needs and
instincts of the people, but solely by the dictatorial power of this learned
minority, allegedly expressing the general will of the people."_ [**The
Political Philosophy of Bakunin**, pp. 283-4]

The idea that _"socialist consciousness"_ can exist independently of the
working class and its struggle suggests exactly the perspective Bakunin was
critiquing. For vanguardism, the abstract theory of socialism exists prior to
the class struggle and exists waiting to be brought to the masses by the
educated few. The net effect is, as we have argued, to lay the ground for
party dictatorship. The concept is fundamentally anti-socialist, a
justification for elite rule and the continuation of class society in new,
party approved, ways.

## H.5.2 Have vanguardist assumptions been validated?

Lenin claimed that workers can only reach a _"trade union consciousness"_ by
their own efforts. Anarchists argue that such an assertion is empirically
false. The history of the labour movement is marked by revolts and struggles
which went far further than just seeking reforms as well as revolutionary
theories derived from such experiences.

The category of _"economic struggle"_ corresponds to no known social reality.
Every _"economic"_ struggle is _"political"_ in some sense and those involved
can, and do, learn political lessons from them. As Kropotkin noted in the
1880s, there _"is almost no serious strike which occurs today without the
appearance of troops, the exchange of blows and some acts of revolt. Here they
fight with the troops; there they march on the factories . . . Thanks to
government intervention the rebel against the factory becomes the rebel
against the State."_ [quoted by Caroline Cahm, **Kropotkin and the Rise of
Revolutionary Anarchism**, p. 256] If history shows anything, it shows that
workers are more than capable of going beyond _"trade union consciousness."_
The Paris Commune, the 1848 revolts and, ironically enough, the 1905 and 1917
Russian Revolutions show that the masses are capable of revolutionary
struggles in which the self-proclaimed _"vanguard"_ of socialists spend most
of their time trying to catch up with them!

The history of Bolshevism also helps discredit Lenin's argument that the
workers cannot develop socialist consciousness alone due to the power of
bourgeois ideology. Simply put, if the working class is subjected to bourgeois
influences, then so are the _"professional"_ revolutionaries within the party.
Indeed, the strength of such influences on the "professionals" of revolution
**must** be higher as they are not part of proletarian life. If social being
influences consciousness then if a revolutionary is no longer part of the
working class then they no longer are rooted in the social conditions which
generate socialist theory and action. No longer connected with collective
labour and working class life, the _"professional"_ revolutionary is more
likely to be influenced by the social milieu he or she now is part of (i.e. a
bourgeois, or at best petit-bourgeois, environment).

This tendency for the _"professional"_ revolutionary to be subject to
bourgeois influences can continually be seen from the history of the Bolshevik
party. As Trotsky himself noted:

> _"It should not be forgotten that the political machine of the Bolshevik
Party was predominantly made up of the intelligentsia, which was petty
bourgeois in its origin and conditions of life and Marxist in its ideas and in
its relations with the proletariat. Workers who turned professional
revolutionists joined this set with great eagerness and lost their identity in
it. The peculiar social structure of the Party machine and its authority over
the proletariat (neither of which is accidental but dictated by strict
historical necessity) were more than once the cause of the Party's vacillation
and finally became the source of its degeneration . . . In most cases they
lacked independent daily contact with the labouring masses as well as a
comprehensive understanding of the historical process. They thus left
themselves exposed to the influence of alien classes."_ [**Stalin**, vol. 1,
pp. 297-8]

He pointed to the example of the First World War, when, _"even the Bolshevik
party did not at once find its way in the labyrinth of war. As a general rule,
the confusion was most pervasive and lasted longest amongst the Party's
higher-ups, who came in direct contact with bourgeois public opinion."_ Thus
the professional revolutionaries _"were largely affected by compromisist
tendencies, which emanated from bourgeois circles, while the rank and file
Bolshevik workingmen displayed far greater stability resisting the patriotic
hysteria that had swept the country."_ [**Op. Cit.**, p. 248 and p. 298] It
should be noted that he was repeating earlier comments on the _"immense
intellectual backsliding of the upper stratum of the Bolsheviks during the
war"_ was caused by _"isolation from the masses and isolation from those
abroad - that is primarily from Lenin."_ [**History of the Russian
Revolution**, vol. 3, p. 134] As we discuss in [section
H.5.12](secH5.md#sech512), even Trotsky had to admit that during 1917 the
working class was far more revolutionary than the party and the party more
revolutionary than the _"party machine"_ of _"professional revolutionaries."_

Ironically enough, Lenin himself recognised this aspect of intellectuals after
he had praised their role in bringing "revolutionary" consciousness to the
working class. In his 1904 work **One Step Forward, Two Steps Back**, he
argued that it was now the presence of _"large numbers of radical
intellectuals in the ranks"_ which has ensured that _"the opportunism which
their mentality produces had been, and is, bound to exist."_ [**Collected
Works**, vol. 7, pp. 403-4] According to Lenin's new philosophy, the working
class simply needs to have been through the _"schooling of the factory"_ in
order to give the intelligentsia lessons in political discipline, the very
same intelligentsia which up until then had played the leading role in the
Party and had given political consciousness to the working class. In his
words:

> _"For the factory, which seems only a bogey to some, represents that highest
form of capitalist co-operation which has united and disciplined the
proletariat, taught it to organise . . . And it is Marxism, the ideology of
the proletariat trained by capitalism, has been and is teaching . . . unstable
intellectuals to distinguish between the factory as a means of exploitation
(discipline based on fear of starvation) and the factory as a means of
organisation (discipline based on collective work . . .). The discipline and
organisation which come so hard to the bourgeois intellectual are very easily
acquired by the proletariat just because of this factory 'schooling.'"_ [**Op.
Cit.**, pp. 392-3]

Lenin's analogy is, of course, flawed. The factory is a _"means of
exploitation"_ because its _"means of organisation"_ is top-down and
hierarchical. The _"collective work"_ which the workers are subjected to is
organised by the boss and the _"discipline"_ is that of the barracks, not that
of free individuals. In fact, the _"schooling"_ for revolutionaries is **not**
the factory, but the class struggle - healthy and positive self-discipline is
generated by the struggle against the way the workplace is organised under
capitalism. Factory discipline, in other words, is completely different from
the discipline required for social struggle or revolution. Workers become
revolutionary in so far as they reject the hierarchical discipline of the
workplace and develop the self-discipline required to fight it.

A key task of anarchism is to encourage working class revolt against this type
of discipline, particularly in the capitalist workplace. The _"discipline"_
Lenin praises simply replaces human thought and association with the following
of orders and hierarchy. Thus anarchism aims to undermine capitalist (imposed
and brutalising) discipline in favour of solidarity, the _"discipline"_ of
free association and agreement based on the community of struggle and the
political consciousness and revolutionary enthusiasm that struggle creates.
Thus, for anarchists, the model of the factory can never be the model for a
revolutionary organisation any more than Lenin's vision of society as _"one
big workplace"_ could be our vision of socialism (see [section
H.3.1](secH3.md#sech31)). Ultimately, the factory exists to reproduce
hierarchical social relationships and class society just as much as it exists
to produce goods.

It should be noted that Lenin's argument does not contradict his earlier ones.
The proletarian and intellectual have complementary jobs in the party. The
proletariat is to give lessons in political discipline to the intellectuals as
they have been through the process of factory (i.e. hierarchical) discipline.
The role of the intellectuals as providers of _"political consciousness"_ is
the same and so they give political lessons to the workers. Moreover, his
vision of the vanguard party is basically the same as in **What is to Be
Done?**. This can be seen from his comments that the leading Menshevik Martov
_"**lumps together** in the party organised and unorganised elements, those
who lend themselves to direction and those who do not, the advanced and the
incorrigibly backward."_ He stressed that the _"division of labour under the
direction of a centre evokes from him [the intellectual] a tragicomical outcry
against transforming people into 'cogs and wheels.'"_ [**Op. Cit.**, p. 258
and p. 392] Thus there is the same division of labour as in the capitalist
factory, with the boss (the _"centre"_) having the power to direct the workers
(who submit to _"direction"_). Thus we have a "revolutionary" party organised
in a **capitalist** manner, with the same _"division of labour"_ between order
givers and order takers.

## H.5.3 Why does vanguardism imply party power?

As we discussed in [section H.5.1](secH5.md#sech51), anarchists argue that
the assumptions of vanguardism lead to party rule over the working class.
Needless to say, followers of Lenin disagree. For example, Chris Harman of the
British **Socialist Workers Party** argues the opposite case in his essay
_"Party and Class."_ However, his own argument suggests the elitist
conclusions libertarians have draw from Lenin's.

Harman argues that there are two ways to look at the revolutionary party, the
Leninist way and the traditional social-democratic way (as represented by the
likes of Trotsky and Rosa Luxemburg in 1903-5). _"The latter,"_ he argues,
_"was thought of as a party of the whole [working] class . . . All the
tendencies within the class had to be represented within it. Any split within
it was to be conceived of as a split within the class. Centralisation,
although recognised as necessary, was feared as a centralisation over and
against the spontaneous activity of the class. Yet it was precisely in this
kind of party that the 'autocratic' tendencies warned against by Luxemburg
were to develop most. For within it the confusion of member and sympathiser,
the massive apparatus needed to hold together a mass of only half-politicised
members in a series of social activities, led to a toning down of political
debate, a lack of political seriousness, which in turn reduced the ability of
the members to make independent political evaluations and increased the need
for apparatus-induced involvement."_ [**Party and Class**, p. 32]

Thus, the lumping together into one organisation all those who consider
themselves as _"socialist"_ and agree with the party's aims creates in a mass
which results in _"autocratic"_ tendencies within the party organisation. As
such, it is important to remember that _"the Party, as the vanguard of the
working class, must not be confused with the entire class."_ [**Op. Cit.**, p.
22] For this reason, the party must be organised in a specific manner which
reflect his Leninist assumptions:

> _"The alternative [to the vanguard party] is the 'marsh' - where elements
motivated by scientific precision are so mixed up with those who are
irremediably confused as to prevent any decisive action, effectively allowing
the most backward to lead."_ [**Op. Cit.**, p. 30]

The problem for Harman is to explain how the proletariat can become the ruling
class if this were true. He argues that _"the party is not the embryo of the
workers' state - the workers' council is. The working class as a whole will be
involved in the organisations that constitute the state, the most backward as
well as the most progressive elements."_ The _"function of the party is not to
be the state."_ [**Op. Cit.**, p. 33] The implication is that the working
class will take an active part in the decision making process during the
revolution (although the level of this _"involvement"_ is unspecified,
probably for good reasons as we explain). If this **is** the case, then the
problem of the mass party reappears, but in a new form (we must also note that
this problem must have also appeared in 1917, when the Bolshevik party opened
its doors to become a mass party).

As the _"organisations that constitute the state"_ are made up of the working
class _"as a whole,"_ then, obviously, they cannot be expected to wield power
(i.e. directly manage the revolution from below). If they did, then the party
would be _"mixed up"_ with the _"irremediably confused"_ and so could not lead
(as we discuss in [section H.5.5](secH5.md#sech55), Lenin linked
_"opportunism"_ to _"primitive"_ democracy, i.e. self-management, within the
party). Hence the need for party power. Which, of course, explains Lenin's
1920 comments that an organisation embracing the whole working class cannot
exercise the _"dictatorship of the proletariat"_ and that a _"vanguard"_ is
required to do so (see [section H.1.2](secH1.md#sech12) for details). Of
course, Harman does not explain how the _"irremediably confused"_ are able to
judge that the party is the best representative of its interests. Surely if
someone is competent enough to pick their ruler, they must also be competent
enough to manage their own affairs directly? Equally, if the _"irremediably
confused"_ vote against the party once it is in power, what happens? Will the
party submit to the _"leadership"_ of what it considers _"the most backward"_?
If the Bolsheviks are anything to go by, the answer has to be no.

Ironically, Harman argues that it _"is worth noting that in Russia a real
victory of the apparatus over the party required precisely the bringing into
the party hundreds of thousands of 'sympathisers,' a dilution of the 'party'
by the 'class.' . . . The Leninist party does not suffer from this tendency to
bureaucratic control precisely because it restricts its membership to those
willing to be serious and disciplined enough to take **political** and
**theoretical** issues as their starting point, and to subordinate all their
activities to those."_ [**Op. Cit.**, p. 33] It would be churlish to note
that, firstly, the party had already imposed its dictatorship on the working
class by that time and, secondly, his own party is regularly attacked by its
own dissidents for being bureaucratic (see [section
H.5.11](secH5.md#sech511)).

Significantly, this substitution of the rule of the party for working class
self-government and the party apparatus for the party membership does not
happen by accident. In order to have a socialist revolution, the working class
as a whole must participate in the process so the decision making
organisations will be based on the party being _"mixed up"_ with the
_"irremediably confused"_ as if they were part of a non-Leninist party. So
from Harman's own assumptions, this by necessity results in an _"autocratic"_
regime within the new _"workers' state."_

This was implicitly recognised by the Bolsheviks when they stressed that the
function of the party was to become the government, the head of the state, to
_"assume power"_, (see [section H.3.3](secH3.md#sech33)). Thus, while the
working class _"as a whole"_ will be _"involved in the organisations that
constitute the state,"_ the party (in practice, its leadership) will hold
power. And for Trotsky, this substitution of the party for the class was
inevitable:

> _"We have more than once been accused of having substituted for the
dictatorship of the Soviets the dictatorship of our party. Yet it can be said
with complete justice that the dictatorship of the Soviets became possible
only by means of the dictatorship of the party. It is thanks to the clarity of
its theoretical vision and its strong revolutionary organisation that the
party has afforded to the Soviets the possibility of becoming transformed from
shapeless parliaments of labour into the apparatus of the supremacy of labour.
In this 'substitution' of the power of the party for the power of the working
class there is nothing accidental, and in reality there is no substitution at
all. The Communists express the fundamental interests of the working class. It
is quite natural that, in the period in which history brings up those
interests . . . the Communists have become the recognised representatives of
the working class as a whole."_ [**Terrorism and Communism**, p. 109]

He noted that within the state, _"the last word belongs to the Central
Committee of the party."_ [**Op. Cit.**, p. 107] As we discuss in [section
H.3.8](secH3.md#sech38), he held this position into the 1930s.

This means that given Harman's own assumptions, autocratic rule by the party
is inevitable. Ironically, he argues that _"to be a 'vanguard' is not the same
as to substitute one's own desires, or policies or interests, for those of the
class."_ He stresses that an _"organisation that is concerned with
participating in the revolutionary overthrow of capitalism by the working
class cannot conceive of substituting itself for the organs of the direct rule
of that class."_ [**Op. Cit.**, p. 33 and p. 34] However, the logic of his
argument suggests otherwise. Simply put, his arguments against a broad party
organisation are also applicable to self-management during the class struggle
and revolution. The rank and file party members are _"mixed up"_ in the class.
This leads to party members becoming subject to bourgeois influences. This
necessitates the power of the higher bodies over the lower (see [section
H.5.5](secH5.md#sech55)). The highest party organ, the central committee,
must rule over the party machine, which in turn rules over the party members,
who, in turn, rule over the workers. This logical chain was, ironically
enough, recognised by Trotsky in 1904 in his polemic against Lenin:

> _"The organisation of the party substitutes itself for the party as a whole;
then the central committee substitutes itself for the organisation; and
finally the 'dictator' substitutes himself for the central committee."_
[quoted by Harman, **Op. Cit.**, p. 22]

Obviously once in power this substitution was less of a concern for him!
Which, however, does not deny the insight Trotsky had previously showed about
the dangers inherent in the Bolshevik assumptions on working class spontaneity
and how revolutionary ideas develop. Dangers which he, ironically, helped
provide empirical evidence for.

This false picture of the party (and its role) explains the progression of the
Bolshevik party after 1917. As the soviets organised all workers, we have the
problem that the party (with its _"scientific"_ knowledge) is swamped by the
class. The task of the party is to _"persuade, not coerce these [workers] into
accepting its lead"_ and, as Lenin made clear, for it to take political power.
[Harman, **Op. Cit.**, p. 34] Once in power, the decisions of the party are in
constant danger of being overthrown by the working class, which necessitates a
state run with _"iron discipline"_ (and the necessary means of coercion) by
the party. With the disempowering of the mass organisations by the party, the
party itself becomes a substitute for popular democracy as being a party
member is the only way to influence policy. As the party grows, the influx of
new members _"dilutes"_ the organisation, necessitating a similar growth of
centralised power at the top of the organisation. This eliminated the
substitute for proletarian democracy which had developed within the party
(which explains the banning of factions within the Bolshevik party in 1921).
Slowly but surely, power concentrates into fewer and fewer hands, which,
ironically enough, necessitates a bureaucracy to feed the party leaders
information and execute its will. Isolated from all, the party inevitably
degenerates and Stalinism results.

We are sure that many Trotskyists will object to our analysis, arguing that we
ignore the problems facing the Russian Revolution in our discussion. Harman
argues that it was _"not the form of the party that produces party as opposed
to soviet rule, but the decimation of the working class"_ that occurred during
the Russian Revolution. [**Op. Cit.**, p. 37] This is false. As noted, Lenin
was always explicit about the fact that the Bolshevik's sought party rule
(_"full state power"_) and that their rule **was** working class rule. As
such, we have the first, most basic, substitution of party power for workers
power. Secondly, as we discuss in [section H.6.1](secH6.md#sech61), the
Bolshevik party had been gerrymandering and disbanding soviets before the
start of the Civil War, so proving that the war cannot be held accountable for
this process of substitution. Thirdly, Leninists are meant to know that civil
war is inevitable during a revolution. To blame the inevitable for the
degeneration of the revolution is hardly convincing (particularly as the
degeneration started before the civil war broke out).

Unsurprisingly, anarchists reject the underlying basis of this progression,
the idea that the working class, by its own efforts, is incapable of
developing beyond a _"trade union consciousness."_ The actions of the working
class itself condemned these attitudes as outdated and simply wrong long
before Lenin's infamous comments were put on paper. In every struggle, the
working class has created its own organisations to co-ordinate its struggle.
In the process of struggle, the working class changes its perspectives. This
process is uneven in both quantity and quality, but it does happen. However,
anarchists do not think that **all** working class people will, at the same
time, spontaneously become anarchists. If they did, we would be in an
anarchist society today! As we argue in [section J.3](secH3.md), anarchists
acknowledge that political development within the working class is uneven. The
difference between anarchism and Leninism is how we see socialist ideas
developing and how revolutionaries influence that process.

In every class struggle there is a radical minority which takes the lead and
many of this minority develop revolutionary conclusions from their
experiences. As such, members of the working class develop their own
revolutionary theory and it does not need bourgeois intellectuals to inject it
into them. Anarchists go on to argue that this minority (along with any
members of other classes who have broken with their background and become
libertarians) should organise and work together. The role of this
revolutionary organisation is to spread, discuss and revise its ideas and help
others draw the same conclusions as they have from their own, and others,
experiences. The aim of such a group is, by word and deed, to assist the
working class in its struggles and to draw out and clarify the libertarian
aspects of this struggle. It seeks to abolish the rigid division between
leaders and led which is the hallmark of class society by drawing the vast
majority of the working class into social struggle and revolutionary politics
by encouraging their direct management of the struggle. Only this
participation and the political discussion it generates will allow
revolutionary ideas to become widespread.

In other words, anarchists argue that precisely **because** of political
differences ("unevenness") we need the fullest possible democracy and freedom
to discuss issues and reach agreements. Only by discussion and self-activity
can the political perspectives of those in struggle develop and change. In
other words, the fact Bolshevism uses to justify its support for party power
is the strongest argument against it.

Our differences with vanguardism could not be more clear.

## H.5.4 Did Lenin abandon vanguardism?

Vanguardism rests on the premise that the working class cannot emancipate
itself. As such, the ideas of Lenin as expounded in **What is to be Done?**
(**WITBD**) contradict the key idea of Marx that the emancipation of the
working class is the task of the working class itself. Thus the paradox of
Leninism. On the one hand, it subscribes to an ideology allegedly based on
working class self-liberation. On the other, the founder of that school wrote
an obviously influential work whose premise not only logically implies that
they cannot, it also provides the perfect rationale for party dictatorship
over the working class (and as the history of Leninism in power shows, this
underlying premise was much stronger than any democratic-sounding rhetoric).

It is for this reason that many Leninists are somewhat embarrassed by Lenin's
argument in that key text. Hence we see Chris Harman writing that _"the real
theoretical basis for [Lenin's] argument on the party is not that the working
class is incapable on its own of coming to theoretical socialist consciousness
. . . The real basis for his argument is that the level of consciousness in
the working class is never uniform."_ [**Party and Class**, pp. 25-6] In other
words, Harman changes the focus of the question away from the point explicitly
and repeatedly stated by Lenin that the working class was incapable on its own
of coming to socialist consciousness and that he was simply repeating Marxist
orthodoxy when he did.

Harman bases his revision on Lenin's later comments regarding his book, namely
that he sought to _"straighten matters out"_ by _"pull[ing] in the other
direction"_ to the _"extreme"_ which the _"economists"_ had went to.
[**Collected Works**, vol. 6, p. 491] He repeated this in 1907, as we will
discuss shortly. While Lenin may have been right to attack the _"economists"_,
his argument that socialist consciousness comes to the working class only
_"from without"_ is not a case of going too far in the other direction; it is
wrong. Simply put, you do not attack ideas you disagree with by arguing an
equally false set of ideas. This suggests that Harman's attempt to downplay
Lenin's elitist position is flawed. Simply put, the _"real theoretical basis"_
of the argument was precisely the issue Lenin himself raised, namely the
incapacity of the working class to achieve socialist consciousness by itself.
It is probably the elitist conclusions of this argument which drives Harman to
try and change the focus to another issue, namely the political unevenness
within the working class.

Some go to even more extreme lengths, denying that Lenin even held such a
position. For example, Hal Draper argued at length that Lenin did not, in
fact, hold the opinions he actually expressed in his book! While Draper covers
many aspects of what he called the _"Myth of Lenin's 'Concept of The Party'"_
in his essay of the same name, we will concentrate on the key idea, namely
that socialist ideas are developed outside the class struggle by the radical
intelligentsia and introduced into the working class from without. Here, as
argued in [section H.5.1](secH5.md#sech51), is the root of the anti-
socialist basis of Leninism.

So what did Draper say? On the one hand, he denied that Lenin held this theory
(he states that it is a _"virtually non-existent theory"_ and _"non-existent
after **WITBD**"_). He argued that those who hold the position that Lenin
actually meant what he said in his book _"never quote anything other than
**WITBD**,"_ and stated that this is a _"curious fact"_ (a fact we will
disprove shortly). Draper argued as follows: _"Did Lenin put this theory
forward even in **WITBD**? Not exactly."_ He then noted that Lenin _"had just
read this theory in the most prestigious theoretical organ of Marxism of the
whole international socialist movement"_ and it had been _"put forward in an
important article by the leading Marxist authority,"_ Karl Kautsky and so
_"Lenin first paraphrased Kautsky"_ before _"quot[ing] a long passage from
Kautsky's article."_

This much, of course, is well known by anyone who has read Lenin's book. By
paraphrasing and quoting Kautsky as he does, Lenin is showing his agreement
with Kautsky's argument. Indeed, Lenin states before quoting Kautsky that his
comments are _"profoundly true and important"_. [**Essential Works of Lenin**,
p. 79] By explicitly agreeing with Kautsky, it can be said that it also
becomes Lenin's theory as well! Over time, particularly after Kautsky had been
labelled a _"renegade"_ by Lenin, Kautsky's star waned and Lenin's rose.
Little wonder the argument became associated with Lenin rather than the
discredited Kautsky. Draper then speculated that _"it is curious . . . that no
one has sought to prove that by launching this theory . . . Kautsky was laying
the basis for the demon of totalitarianism."_ A simply reason exists for this,
namely the fact that Kautsky, unlike Lenin, was never the head of a one-party
dictatorship and justified this system politically. Indeed, Kautsky attacked
the Bolsheviks for this, which caused Lenin to label him a _"renegade."_
Kautsky, in this sense, can be considered as being inconsistent with his
political assumptions, unlike Lenin who took these assumptions to their
logical conclusions.

How, after showing the obvious fact that _"the crucial 'Leninist' theory was
really Kautsky's,"_ he then wondered: _"Did Lenin, in **WITBD**, adopt
Kautsky's theory?"_ He answered his own question with an astounding _"Again,
not exactly"_! Clearly, quoting approvingly of a theory and stating it is
_"profoundly true"_ does not, in fact, make you a supporter of it! What
evidence does Draper present for his amazing answer? Well, Draper argued that
Lenin _"tried to get maximum mileage out of it against the right wing; this
was the point of his quoting it. If it did something for Kautsky's polemic, he
no doubt figured that it would do something for his."_ Or, to present a more
simple and obvious explanation, Lenin **agreed** with Kautsky's _"profoundly
true"_ argument!

Aware of this possibility, Draper tried to combat it. _"Certainly,"_ he
argued, _"this young man Lenin was not (yet) so brash as to attack his 'pope'
or correct him overtly. But there was obviously a feeling of discomfort. While
showing some modesty and attempting to avoid the appearance of a head-on
criticism, the fact is that Lenin inserted two longish footnotes rejecting (or
if you wish, amending) precisely what was worst about the Kautsky theory on
the role of the proletariat."_ So, here we have Lenin quoting Kautsky to prove
his own argument (and noting that Kautsky's words were _"profoundly true and
important"_!) but _"feeling discomfort"_ over what he has just approvingly
quoted! Incredible!

So how does Lenin _"amend"_ Kautsky's _"profoundly true and important"_
argument? In two ways, according to Draper. Firstly, in a footnote which _"was
appended right after the Kautsky passage"_ Lenin quoted. Draper argued that it
_"was specifically formulated to undermine and weaken the theoretical content
of Kautsky's position. It began: 'This does not mean, of course, that the
workers have no part in creating such an ideology.' But this was exactly what
Kautsky did mean and say. In the guise of offering a caution, Lenin was
proposing a modified view. 'They [the workers] take part, however,' Lenin's
footnote continued, 'not as workers, but as socialist theoreticians, as
Proudhons and Weitlings; in other words, they take part only when they are
able . . .' In short, Lenin was reminding the reader that Kautsky's sweeping
statements were not even 100% true historically; he pointed to exceptions."_
Yes, Lenin **did** point to exceptions **in order to refute objections to
Kautsky's argument before they were raised**! It is clear that Lenin was
**not** refuting Kautsky. Thus Proudhon adds to socialist ideology in so far
as he is a _"socialist theoretician"_ and not a worker! How clear can you be?
This can be seen from the rest of the sentence Draper truncates. Lenin
continued by noting that people like Proudhon _"take part only to the extent
that they are able, more or less, to acquire the knowledge of their age and
advance that knowledge."_ [**Op. Cit.**, p. 82f] In other words, insofar as
they learn from the _"vehicles of science."_ Neither Kautsky or Lenin denied
that it was possible for workers to acquire such knowledge and pass it on
(sometimes even develop it). However this does **not** mean that they thought
workers, as part of their daily life and struggle **as workers,** could
develop _"socialist theory."_ Thus Lenin's footnote reiterated Kautsky's
argument rather than, as Draper hoped, refute it.

Draper turns to another footnote, which he noted _"was not directly tied to
the Kautsky article, but discussed the 'spontaneity' of the socialist idea.
'It is often said,' Lenin began, 'that the working class **spontaneously**
gravitates towards socialism. This is perfectly true in the sense that
socialist theory reveals the causes of the misery of the working class . . .
and for that reason the workers are able to assimilate it so easily,' but he
reminded that this process itself was not subordinated to mere spontaneity.
'The working class spontaneously gravitates towards socialism; nevertheless, .
. . bourgeois ideology spontaneously imposes itself upon the working class to
a still greater degree.'"_ Draper argued that this _"was obviously written to
modify and recast the Kautsky theory, without coming out and saying that the
Master was wrong."_ So, here we have Lenin approvingly quoting Kautsky in the
main text while, at the same time, providing a footnote to show that, in fact,
he did not agree with what he has just quoted! Truly amazing - and easily
refuted.

Lenin's footnote stressed, in a part Draper did not consider it wise to quote,
that workers appreciate socialist theory _"**provided,** however, that this
theory does not step aside for spontaneity and **provided** it subordinates
spontaneity to itself."_ [**Op. Cit.**, p. 84f] In other words, workers
_"assimilate"_ socialist theory only when socialist theory does not adjust
itself to the _"spontaneous"_ forces at work in the class struggle. The
workers adjust to socialist theory, they do not create it. Thus, rather than
refuting Kautsky by the backdoor, Lenin in this footnote still agreed with
him. Socialism does not develop, as Kautsky stressed, from the class struggle
but rather has to be injected into it. This means, by necessity, the party
_"subordinates spontaneity to itself."_

Draper argued that this _"modification"_ simply meant that there _"are several
things that happen 'spontaneously,' and what will win out is not decided only
by spontaneity"_ but as can be seen, this is not the case. Only when
_"spontaneity"_ is subordinated to the theory (i.e. the party) can socialism
be won, a totally different position. As such, when Draper asserted that
_"[a]ll that was clear at this point was that Lenin was justifiably
dissatisfied with the formulation of Kautsky's theory,"_ he was simply
expressing wishful thinking. This footnote, like the first one, continued the
argument developed by Lenin in the main text and in no way is in contradiction
to it. As is obvious.

Draper as final evidence of his case asserted that it _"is a curious fact that
no one has ever found this alleged theory anywhere else in Lenin's voluminous
writings, not before and not after [**WITBD**]. It never appeared in Lenin
again. No Leninologist has ever quoted such a theory from any other place in
Lenin."_ However, as this theory was the orthodox Marxist position, Lenin had
no real need to reiterate this argument continuously. After all, he had quoted
the acknowledged leader of Marxism on the subject explicitly to show the
orthodoxy of his argument and the non-Marxist base of those he argued against.
Once the debate had been won and orthodox Marxism triumphant, why repeat the
argument again? This, as we will see, was exactly the position Lenin **did**
take in 1907 when he wrote an introduction to a book which contained **What is
to Be Done?**.

In contradiction to Draper's claim, Lenin **did** return to this matter. In
October 1905 he wrote a short article in praise of an article by Stalin on
this very subject. Stalin had sought to explain Lenin's ideas to the Georgian
Social-Democracy and, like Lenin, had sought to root the argument in Marxist
orthodoxy (partly to justify the argument, partly to expose the Menshevik
opposition as being non-Marxists). Stalin argued along similar lines to Lenin:

> _"the question now is: who works out, who is able to work out this socialist
consciousness (i.e. scientific socialism)? Kautsky says, and I repeat his
idea, that the masses of proletarians, as long as they remain proletarians,
have neither the time nor the opportunity to work out socialist consciousness
. . . The vehicles of science are the intellectuals . . . who have both the
time and opportunity to put themselves in the van of science and workout
socialist consciousness. Clearly, socialist consciousness is worked out by a
few Social-Democratic intellectuals who posses the time and opportunity to do
so."_ [**Collected Works**, vol. 1, p. 164]

Stalin stressed the Marxist orthodoxy by stating Social-Democracy _"comes in
and introduces socialist consciousness into the working class movement. This
is what Kautsky has in mind when he says 'socialist consciousness is something
introduced into the proletarian class struggle from without.'"_ [**Op. Cit.**,
pp. 164-5] That Stalin was simply repeating Lenin's and Kautsky's arguments is
clear, as is the fact it was considered the orthodox position within social-
democracy.

If Draper were right, then Lenin would have taken the opportunity to attack
Stalin's article and express the alternative viewpoint Draper was convinced he
held. Lenin, however, put pen to paper to **praise** Stalin's work, noting
_"the splendid way in which the problem of the celebrated 'introduction of a
consciousness from without' had been posed."_ Lenin explicitly agreed with
Stalin's summary of his argument, writing that _"social being determines
consciousness . . . Socialist consciousness corresponds to the position of the
proletariat"_ before quoting Stalin: _"'Who can and does evolve this
consciousness (scientific socialism)?'"_ He answers by again approvingly
quoting Stalin: _"its 'evolution' is a matter for a few Social-Democratic
intellectuals who posses the necessary means and time.'"_ Lenin did argue that
Social-Democracy meets _"an instinctive **urge** towards socialism"_ when it
_"comes to the proletariat with the message of socialism,"_ but this does not
counter the main argument that the working class cannot develop socialist
consciousness by it own efforts and the, by necessity, elitist and
hierarchical politics that flow from this position. [Lenin, **Collected
Works**, vol. 9, p. 388]

That Lenin did not reject his early formulations can also be seen from in his
introduction to the pamphlet _"Twelve Years"_ which contained **What is to be
Done?**. Rather than explaining the false nature of that work's more infamous
arguments, Lenin in fact defended them. For example, as regards the question
of professional revolutionaries, he argued that the statements of his
opponents now _"look ridiculous"_ as _"**today** the idea of an organisation
of professional revolutionaries has **already** scored a complete victory,"_ a
victory which _"would have been impossible if this idea had not been pushed to
the **forefront** at the time."_ He noted that his work had _"vanquished
Economism . . . and finally **created** this organisation."_ On the question
of socialist consciousness, he simply reiterated the Marxist orthodoxy of his
position, noting that its _"formulation of the relationship between
spontaneity and political consciousness was agreed upon by all the **Iskra**
editors . . . Consequently, there could be no question of any difference in
principle between the draft Party programme and **What is to be Done?** on
this issue."_ So while Lenin argued that his book _"straightens out what had
been twisted by the Economists,"_ (who had _"gone to one extreme"_) he did not
correct his earlier arguments. [**Collected Works**, vol. 13, p. 101, p. 102
and p. 107]

Looking at Lenin's arguments at the Communist International on the question of
the party we see an obvious return to the ideas of **WITBD** (see [section
H.5.5](secH5.md#sech55)). Here was have a similar legal/illegal duality,
strict centralism, strong hierarchy and the vision of the party as the
_"head"_ of the working class (i.e. its consciousness). In **Left-Wing
Communism**, Lenin mocks those who reject the idea that dictatorship by the
party is the same as that of the class (see [section
H.3.3](secH3.md#sech33)).

For Draper, the key problem was that critics of Lenin _"run two different
questions together: (a) What was, historically, the **initial** role of
intellectuals in the beginnings of the socialist movement, and (b) what **is**
\- and above all, what should be - the role of bourgeois intellectuals in a
working-class party today."_ He argued that Kautsky did not believe that
_"**if** it can be shown that intellectuals historically played a certain
initiatory role, they **must** and **should** continue to play the same role
now and forever. It does not follow; as the working class matured, it tended
to throw off leading strings."_ However, this is unconvincing. If socialist
consciousness cannot be generated by the working class by its own struggles
then this is applicable now and in the future. Thus workers who join the
socialist movement will be repeating the party ideology, as developed by
intellectuals in the past. If they **do** develop new theory, it would be, as
Lenin stressed, _"not as workers, but as socialist theoreticians"_ and so
socialist consciousness still does not derive from their own class
experiences. This places the party in a privileged position vis-à-vis the
working class and so the elitism remains.

Somewhat ironically given how much Draper is at pains to distance his hero
Lenin from claims of elitism, he himself **agreed** with the arguments of
Kautsky and Lenin. For Draper socialism did **not** develop out of the class
struggle: _"As a matter of fact, in the International of 1902 no one really
had any doubts about the historical facts concerning the beginnings of the
movement."_ This was true. Plekhanov, the father of Russian Marxism, made
similar arguments to Kautsky's before Lenin put pen to paper. For Plekhanov,
the socialist intelligentsia _"will bring **consciousness** into the working
class."_ It must _"become the leader of the working class"_ and _"explain to
it its political and economic interests."_ This would _"prepare them to play
an independent role in the social life of Russia."_ [quoted by Neil Harding,
**Lenin's Political Thought**, vol. 1, p. 50 and p. 51]

As one expert notes, _"Lenin's position . . . did not differ in any
essentials"_ from those _"Plekhanov had himself expressed."_ Its _"basic
theses were his own"_, namely that it is _"clear from Plekhanov's writing that
it was the intelligentsia which virtually created the working class movement
in its conscious form. It brought it science, revolutionary theory and
organisation."_ In summary, _"Lenin's views of the Party . . . are not to be
regarded as extraordinary, innovatory, perverse, essentially Jacobin or
unorthodox. On the contrary"_ they were _"the touchstone of orthodoxy"_ and so
_"what it [**What is to be Done?**] presented at the time"_ was _"a
restatement of the principles of Russian Marxist orthodoxy."_ By quoting
Kautsky, Lenin also proved that he was simply repeating the general Marxist
orthodoxy: _"Those who dispute Lenin's conclusions on the genesis of socialist
consciousness must it seems, also dispute Kautsky's claim to represent Social-
Democratic orthodoxy."_ [Harding, **Op. Cit.**, p. 170, p. 172, pp. 50-1, p.
187, p. 188, p. 189 and p. 169]

Moreover, Engels wrote some interesting words in the 1840s on this issue which
places the subsequent development of Marxism into sharper light. He noted that
_"it is evident that the working-men's movement is divided into two sections,
the Chartists and the Socialists. The Chartists are theoretically the more
backward, the less developed, but they are genuine proletarians . . . The
Socialists are more far-seeing . . . but proceeding originally from the
bourgeoisie, are for this reason unable to amalgamate completely with the
working class. The union of Socialism with Chartism . . . will be the next
step . . . Then, only when this has been achieved, will the working class be
the true intellectual leader of England."_ Thus socialist ideas have to be
introduced into the proletariat, as they are _"more backward"_ and cannot be
expected to develop theory for themselves! In the same year, he expounded on
what this _"union"_ would entail, writing in an Owenite paper that _"the union
between the German philosophers . . . and the German working men . . . is all
but accomplished. With the philosophers to think, and the working mean to
fight for us, will any earthly power be strong enough to resist our
progress?"_ [**Collected Works**, vol. 4, pp. 526-7 and p. 236] This, of
course, fits in with the **Communist Manifesto**'s assertion that _"a small
section of the ruling class cuts itself adrift, and joins the revolutionary
class."_ Today, this _"portion of the bourgeois ideologists"_ have _"raised
themselves to the level of comprehending theoretically the historical movement
as a whole."_ [**The Marx-Engels Reader**, p. 481] This, needless to say,
places _"bourgeois ideologists"_ (like Marx, Engels, Kautsky and Lenin) in a
privileged position within the movement and has distinctly vanguardist
undercurrents.

Seemingly unaware how this admission destroyed his case, Draper went on to
ask: _"But what followed from those facts?"_ To which he argued that Marx and
Engels _"concluded, from the same facts and subsequent experiences, that the
movement had to be sternly warned against the influence of bourgeois
intellectuals inside the party."_ (We wonder if Marx and Engels included
themselves in the list of _"bourgeois intellectuals"_ the workers had to be
_"sternly warned"_ about?) Thus, amusingly enough, Draper argued that Marx,
Engels, Kautsky and Lenin all held to the _"same facts"_ that socialist
consciousness developed outside the experiences of the working classes!

Ultimately, the whole rationale for the kind of wishful thinking that Draper
inflicted on us is flawed. As noted above, you do not combat what you think is
an incorrect position with one which you consider as also being wrong or do
not agree with! You counter what you consider as an incorrect position with
one you consider correct and agree with. As Lenin, in **WITBD**, explicitly
did. This means that later attempts by his followers to downplay the ideas
raised in Lenin's book are unconvincing. Moreover, as he was simply repeating
Social-Democratic orthodoxy it seems doubly unconvincing.

Clearly, Draper was wrong. Lenin did, as indicated above, actually meant what
he said in **WITBD**. The fact that Lenin quoted Kautsky simply shows, as
Lenin intended, that this position was the orthodox Social Democratic one,
held by the mainstream of the party (one with roots in Marx and Engels). Given
that Leninism was (and still is) a "radical" offshoot of this movement, this
should come as no surprise. However, Draper's comments remind us how religious
many forms of Marxism are - why do we need facts when we have the true faith?

## H.5.5 What is "democratic centralism"?

Anarchists oppose vanguardism for three reasons, one of which is the way it
recommends how revolutionaries should organise to influence the class
struggle.

So how is a "vanguard" party organised? To quote the Communist International's
1920 resolution on the role of the Communist Party in the revolution, the
party must have a _"centralised political apparatus"_ and _"must be organised
on the basis of iron proletarian centralism."_ This, of course, suggests a
top-down structure internally, which the resolution explicitly calls for. In
its words, _"Communist cells of every kind must be subordinate to one another
as precisely as possible in a strict hierarchy."_ [**Proceedings and Documents
of the Second Congress 1920**, vol. 1, p. 193, p. 198 and p. 199] Therefore,
the vanguard party is organised in a centralised, top-down way. However, this
is not all, as well as being _"centralised,"_ the party is also meant to be
democratic, hence the expression _"democratic centralism."_ On this the
resolution states:

> _"The Communist Party must be organised on the basis of democratic
centralism. The most important principle of democratic centralism is election
of the higher party organs by the lowest, the fact that all instructions by a
superior body are unconditionally and necessarily binding on lower ones, and
existence of a strong central party leadership whose authority over all
leading party comrades in the period between one party congress and the next
is universally accepted."_ [**Op. Cit.**, p. 198]

For Lenin, speaking in the same year, democratic centralism meant _"only that
representatives from the localities meet and elect a responsible body which
must then govern . . . Democratic centralism consists in the Congress checking
on the Central Committee, removing it and electing a new one."_ [quoted by
Robert Service, **The Bolshevik Party in Revolution**, p. 131] Thus,
_"democratic centralism"_ is inherently top-down, although the _"higher"_
party organs are, in principle, elected by the _"lower."_ However, the key
point is that the central committee is the active element, the one whose
decisions are implemented and so the focus of the structure is in the
_"centralism"_ rather than the _"democratic"_ part of the formula.

As we noted in [section H.2.14](secH2.md#sech214), the Communist Party was
expected to have a dual structure, one legal and the other illegal. It goes
without saying that the illegal structure is the real power in the party and
that it cannot be expected to be as democratic as the legal party, which in
turn would be less than democratic as the illegal would have the real power
within the organisation.

All this has clear parallels with Lenin's **What is to be done?**, where he
argued for _"a powerful and strictly secret organisation, which concentrates
in its hands all the threads of secret activities, an organisation which of
necessity must be a centralised organisation."_ This call for centralisation
is not totally dependent on secrecy, though. As he noted, _"specialisation
necessarily presupposes centralisation, and in its turn imperatively calls for
it."_ Such a centralised organisation would need leaders and Lenin argued that
_"no movement can be durable without a stable organisation of leaders to
maintain continuity."_ As such, _"the organisation must consist chiefly of
persons engaged in revolutionary activities as a profession."_ Thus, we have a
centralised organisation which is managed by specialists, by _"professional
revolutionaries."_ This does not mean that these all come from the bourgeoisie
or petit bourgeoisie. According to Lenin a _"workingman agitator who is at all
talented and 'promising' **must not be left** to work eleven hours a day in a
factory. We must arrange that he be maintained by the Party, that he may in
due time go underground."_ [**Essential Works of Lenin**, p. 158, p. 153, p.
147, p. 148 and p. 155]

Thus the full time professional revolutionaries are drawn from all classes
into the party apparatus. However, in practice the majority of such full-
timers were/are middle class. Trotsky noted that _"just as in the Bolshevik
committees, so at the [1905] Congress itself, there were almost no workingmen.
The intellectuals predominated."_ [**Stalin**, vol. 1, p. 101] This did not
change, even after the influx of working class members in 1917 the _"incidence
of middle-class activists increases at the highest echelons of the hierarchy
of executive committees."_ [Robert Service, **Op. Cit.**, p. 47] An ex-worker
was a rare sight in the Bolshevik Central Committee, an actual worker non-
existent. However, regardless of their original class background what unites
the full-timers is not their origin but rather their current relationship with
the working class, one of separation and hierarchy.

The organisational structure of this system was made clear at around the same
time as **What is to be Done?**, with Lenin arguing that the factory group (or
cell) of the party _"must consist of a small number of **revolutionaries,**
receiving **direct from the [central] committee** orders and power to conduct
the whole social-democratic work in the factory. All members of the factory
committee must regard themselves as agents of the [central] committee, bound
to submit to all its directions, bound to observe all 'laws and customs' of
this 'army in the field' in which they have entered and which they cannot
leave without permission of the commander."_ [quoted by E.H. Carr, **The
Bolshevik Revolution**, vol. 1, p. 33] The similarities to the structure
proposed by Lenin and agreed to by the Comintern in 1920 is obvious. Thus we
have a highly centralised party, one run by _"professional revolutionaries"_
from the top down.

It will be objected that Lenin was discussing the means of party building
under Tsarism and advocated wider democracy under legality. However, given
that in 1920 he universalised the Bolshevik experience and urged the creation
of a dual party structure (based on legal and illegal structures), his
comments on centralisation are applicable to vanguardism in general. Moreover,
in 1902 he based his argument on experiences drawn from democratic capitalist
regimes. As he argued, _"no revolutionary organisation has ever practised
**broad** democracy, nor could it, however much it desired to do so."_ This
was not considered as just applicable in Russia under the Tsar as Lenin then
goes on to quote the Webb's _"book on trade unionism"_ in order to clarify
what he calls _"the confusion of ideas concerning the meaning of democracy."_
He noted that _"in the first period of existence in their unions, the British
workers thought it was an indispensable sign of democracy for all members to
do all the work of managing the unions."_ This involved _"all questions
[being] decided by the votes of all the members"_ and all _"official duties"_
being _"fulfilled by all the members in turn."_ He dismissed _"such a
conception of democracy"_ as _"absurd"_ and _"historical experience"_ made
them _"understand the necessity for representative institutions"_ and _"full-
time professional officials."_ [**Essential Works of Lenin**, p. 161 and pp.
162-3]

Needless to say, Lenin linked this to Kautsky, who _"shows the need for
**professional** journalists, parliamentarians, etc., for the Social-
Democratic leadership of the proletarian class struggle"_ and who _"attacks
the 'socialism of anarchists and **litterateurs**' who . . . proclaim the
principle that laws should be passed directly by the whole people, completely
failing to understand that in modern society this principle can have only a
relative application."_ The universal nature of his dismissal of self-
management within the revolutionary organisation in favour of representative
forms is thus stressed. Significantly, Lenin stated that this _"'primitive'
conception of democracy"_ exists in two groups, the _"masses of the students
and workers"_ and the _"Economists of the Bernstein persuasion"_ (i.e.
reformists). Thus the idea of directly democratic working class organisations
is associated with opportunism. He was generous, noting that he _"would not,
of course, . . . condemn practical workers who have had too few opportunities
for studying the theory and practice of real democratic [sic!] organisation"_
but individuals _"play[ing] a leading role"_ in the movement should be so
condemned! [**Op. Cit.**, p. 163] These people should know better! Thus
_"real"_ democratic organisation implies the restriction of democracy to that
of electing leaders and any attempt to widen the input of ordinary members is
simply an expression of workers who need educating from their _"primitive"_
failings!

In summary, we have a model of a _"revolutionary"_ party which is based on
full-time _"professional revolutionaries"_ in which the concept of direct
democracy is replaced by a system of, at best, representative democracy. It is
highly centralised, as befitting a specialised organisation. As noted in
[section H.3.3](secH3.md#sech33), the _"organisational principle of
revolutionary Social-Democracy"_ was _"to proceed from the top downward"_
rather than _"from the bottom upward."_ [Lenin, **Collected Works**, vol. 7,
pp. 396-7] Rather than being only applicable in Tsarist Russia, Lenin drew on
examples from advanced, democratic capitalist countries to justify his model
in 1902 and in 1920 he advocated a similar hierarchical and top-down
organisation with a dual secret and public organisation in the **Communist
International**. The continuity of ideas is clear.

## H.5.6 Why do anarchists oppose _"democratic centralism"_?

What to make of Lenin's suggested model of _"democratic centralism"_ discussed
in the [last section](secH5.md#sech55)? It is, to use Cornelius
Castoriadis's term, a _"revolutionary party organised in a capitalist manner"_
and so in practice the _"democratic centralist"_ party, while being
centralised, will not be very democratic. In fact, the level of democracy
would reflect that in a capitalist republic rather than a socialist society:

> _"The dividing up of tasks, which is indispensable wherever there is a need
for co-operation, becomes a real division of labour, the labour of giving
orders being separate from that of carrying them out . . . this division
between directors and executants tends to broaden and deepen by itself. The
leaders specialise in their role and become indispensable while those who
carry out orders become absorbed in their concrete tasks. Deprived of
information, of the general view of the situation, and of the problems of
organisation, arrested in their development by their lack of participation in
the overall life of the Party, the organisation's rank-and-file militants less
and less have the means or the possibility of having any control over those at
the top. _

> _"This division of labour is supposed to be limited by 'democracy.' But
democracy, which should mean that **the majority rules,** is reduced to
meaning that the majority **designates its rulers;** copied in this way from
the model of bourgeois parliamentary democracy, drained of any real meaning,
it quickly becomes a veil thrown over the unlimited power of the rulers. The
base does not run the organisation just because once a year it elects
delegates who designate the central committee, no more than the people are
sovereign in a parliamentary-type republic because they periodically elect
deputies who designate the government. _

> _"Let us consider, for example, 'democratic centralism' as it is supposed to
function in an ideal Leninist party. That the central committee is designated
by a 'democratically elected' congress makes no difference since, once it is
elected, it has complete (statutory) control over the body of the Party (and
can dissolve the base organisations, kick out militants, etc.) or that, under
such conditions, it can determine the composition of the next congress. The
central committee could use its powers in an honourable way, these powers
could be reduced; the members of the Party might enjoy 'political rights' such
as being able to form factions, etc. Fundamentally this would not change the
situation, for the central committee would still remain the organ that defines
the political line of the organisation and controls its application from top
to bottom, that, in a word, has permanent monopoly on the job of leadership.
The expression of opinions only has a limited value once the way the group
functions prevents this opinion from forming on solid bases, i.e. permanent
**participation** in the organisation's activities and in the solution of
problems that arise. If the way the organisation is run makes the solution of
general problems the specific task and permanent work of a separate category
of militants, only their opinion will, or will appear, to count to the
others."_ [Castoriadis, **Social and Political Writings**, vol. 2, pp. 204-5]

Castoriadis' insight is important and strikes at the heart of the problem with
vanguard parties. They simply reflect the capitalist society they claim to
oppose. As such, Lenin's argument against _"primitive"_ democracy in the
revolutionary and labour movements is significant. When he asserts that those
who argue for direct democracy _"completely"_ fail to _"understand that in
modern society this principle can have only a relative application,"_ he is
letting the cat out of the bag. [Lenin, **Op. Cit.**, p. 163] After all,
_"modern society"_ is capitalism, a class society. In such a society, it is
understandable that self-management should not be applied as it strikes at the
heart of class society and how it operates. That Lenin can appeal to _"modern
society"_ without recognising its class basis says a lot. The question
becomes, if such a _"principle"_ is valid for a class system, is it applicable
in a socialist society and in the movement aiming to create such a society?
Can we postpone the application of our ideas until _"after the revolution"_ or
can the revolution only occur when we apply our socialist principles in
resisting class society?

In a nutshell, can the same set of organisational structures be used for the
different ends? Can bourgeois structures be considered neutral or have they,
in fact, evolved to ensure and protect minority rule? Ultimately, form and
content are not independent of each other. Form and content adapt to fit each
other and they cannot be divorced in reality. Thus, if the bourgeoisie embrace
centralisation and representation they have done so because it fits perfectly
with their specific form of class society. Neither centralisation and
representation can undermine minority rule and, if they did, they would
quickly be eliminated.

Interestingly, both Bukharin and Trotsky acknowledged that fascism had
appropriated Bolshevik ideas. The former demonstrated at the 12th Congress of
the Communist Party in 1923 how Italian fascism had _"adopted and applied in
practice the experiences of the Russian revolution"_ in terms of their
_"methods of combat."_ In fact, _"[i]f one regards them from the **formal**
point of view, that is, from the point of view of the technique of their
political methods, then one discovers in them a complete application of
Bolshevik tactics. . . in the sense of the rapid concentration of forced [and]
energetic action of a tightly structured military organisation."_ [quoted by
R. Pipes, **Russia Under the Bolshevik Regime, 1919-1924**, p. 253] The
latter, in his uncompleted biography on Stalin noted that _"Mussolini stole
from the Bolsheviks . . . Hitler imitated the Bolsheviks and Mussolini."_
[**Stalin**, vol. 2, p. 243] The question arises as to whether the same
tactics and structures serve both the needs of fascist reaction **and**
socialist revolution? Now, if Bolshevism can serve as a model for fascism, it
must contain structural and functional elements which are also common to
fascism. After all, no one has detected a tendency of Hitler or Mussolini, in
their crusade against democracy, the organised labour movement and the left,
to imitate the organisational principles of anarchism.

Surely we can expect decisive structural differences to exist between
capitalism and socialism if these societies are to have different aims. Where
one is centralised to facilitate minority rule, the other must be
decentralised and federal to facilitate mass participation. Where one is top-
down, the other must be from the bottom-up. If a _"socialism"_ exists which
uses bourgeois organisational elements then we should not be surprised if it
turns out to be socialist in name only. The same applies to revolutionary
organisations. As the anarchists of **Trotwatch** explain:

> _"In reality, a Leninist Party simply reproduces and institutionalises
existing capitalist power relations inside a supposedly 'revolutionary'
organisation: between leaders and led; order givers and order takers; between
specialists and the acquiescent and largely powerless party workers. And that
elitist power relation is extended to include the relationship between the
party and class."_ [**Carry on Recruiting!**, p. 41]

If you have an organisation which celebrates centralisation, having an
institutionalised _"leadership"_ separate from the mass of members becomes
inevitable. Thus the division of labour which exists in the capitalist
workplace or state is created. Forms cannot and do not exist independently of
people and so imply specific forms of social relationships within them. These
social relationships shape those subject to them. Can we expect the same forms
of authority to have different impacts simply because the organisation has
_"socialist"_ or _"revolutionary"_ in its name? Of course not. It is for this
reason that anarchists argue that only in a _"libertarian socialist movement
the workers learn about non-dominating forms of association through creating
and experimenting with forms such as libertarian labour organisations, which
put into practice, through struggle against exploitation, principles of
equality and free association."_ [John Clark, **The Anarchist Moment**, p. 79]

As noted above, a _"democratic centralist"_ party requires that the _"lower"_
party bodies (cells, branches, etc.) should be subordinate to the higher ones
(e.g. the central committee). The higher bodies are elected at the (usually)
annual conference. As it is impossible to mandate for future developments, the
higher bodies therefore are given carte blanche to determine policy which is
binding on the whole party (hence the _"from top-down"_ principle). In between
conferences, the job of full time (ideally elected, but not always) officers
is to lead the party and carry out the policy decided by the central
committee. At the next conference, the party membership can show its approval
of the leadership by electing another. The problems with this scheme are
numerous:

> _"The first problem is the issue of hierarchy. Why should 'higher' party
organs interpret party policy any more accurately than 'lower' ones? The pat
answer is that the 'higher' bodies compromise the most capable and experienced
members and are (from their lofty heights) in a better position to take an
overall view on a given issue. In fact what may well happen is that, for
example, central committee members may be more isolated from the outside world
than mere branch members. This might ordinarily be the case because given the
fact than many central committee members are full timers and therefore
detached from more real issues such as making a living . . ."_ [ACF, **Marxism
and its Failures**, p. 8]

Equally, in order that the _"higher"_ bodies can evaluate the situation they
need effective information from the _"lower"_ bodies. If the _"lower"_ bodies
are deemed incapable of formulating their own policies, how can they be wise
enough, firstly, to select the right leaders and, secondly, determine the
appropriate information to communicate to the _"higher"_ bodies? Given the
assumptions for centralised power in the party, can we not see that
_"democratic centralised"_ parties will be extremely inefficient in practice
as information and knowledge is lost in the party machine and whatever
decisions which are reached at the top are made in ignorance of the real
situation on the ground? As we discuss in [section H.5.8](secH5.md#sech58),
this is usually the fate of such parties.

Within the party, as noted, the role of _"professional revolutionaries"_ (or
_"full timers"_) is stressed. As Lenin argued, any worker who showed any
talent must be removed from the workplace and become a party functionary. Is
it surprising that the few Bolshevik cadres (i.e. professional
revolutionaries) of working class origin soon lost real contact with the
working class? Equally, what will their role **within** the party be? As we
discuss in [section H.5.12](sech5.md#sech512), their role in the Bolshevik
party was essentially conservative in nature and aimed to maintain their own
position.

That the anarchist critique of _"democratic centralism"_ is valid, we need
only point to the comments and analysis of numerous members (and often soon to
be ex-members) of such parties. Thus we get a continual stream of articles
discussing why specific parties are, in fact, _"bureaucratic centralist"_
rather than "democratic centralist" and what is required to reform them. That
every _"democratic centralist"_ party in existence is not that democratic does
not hinder their attempts to create one which is. In a way, the truly
_"democratic centralist"_ party is the Holy Grail of modern Leninism. As we
discuss in [section H.5.10](secH5.md#sech510), their goal may be as mythical
as that of the Arthurian legends.

## H.5.7 Is the way revolutionaries organise important?

As we discussed in the [last section](secH5.md#sech56), anarchists argue
that the way revolutionaries organise today is important. However, according
to some of Lenin's followers, the fact that the "revolutionary" party is
organised in a non-revolutionary manner does not matter. In the words of Chris
Harman, a leading member of the British **Socialist Workers Party**,
_"[e]xisting under capitalism, the revolutionary organisation [i.e. the
vanguard party] will of necessity have a quite different structure to that of
the workers' state that will arise in the process of overthrowing
capitalism."_ [**Party and Class**, p. 34]

However, in practice this distinction is impossible to make. If the party is
organised in specific ways then it is so because this is conceived to be
_"efficient,"_ _"practical"_ and so on. Hence we find Lenin arguing against
_"backwardness in organisation"_ and that the _"point at issue is whether our
ideological struggle is to have **forms of a higher type** to clothe it, forms
of Party organisation binding on all."_ Why would the "workers' state" be
based on "backward" or "lower" kinds of organisational forms? If, as Lenin
remarked, _"the organisational principle of revolutionary Social-Democracy"_
was _"to proceed from the top downward"_, why would the party, once in power,
reject its _"organisational principle"_ in favour of one it thinks is
_"opportunist,"_ _"primitive"_ and so on? [**Collected Works**, vol. 7, p.
389, p. 388 and pp. 396-7]

Therefore, as the **vanguard** the party represents the level to which the
working class is supposed to reach then its organisational principles must,
similarly, be those which the class must reach. As such, Harman's comments are
incredulous. How we organise today is hardly irrelevant, particularly if the
revolutionary organisation in question seeks (to use Lenin's words) to
_"tak[e] full state power alone."_ [**Op. Cit.**, vol. 26, p. 94] These
prejudices (and the political and organisational habits they generate) will
influence the shaping of the _"workers' state"_ by the party once it has taken
power. This decisive influence of the party and its ideological as well as
organisational assumptions can be seen when Trotsky argued in 1923 that _"the
party created the state apparatus and can rebuild it anew . . . from the party
you get the state, but not the party from the state."_ [**Leon Trotsky
Speaks**, p. 161] This is to be expected, after all the aim of the party is to
take, hold and execute power. Given that the vanguard party is organised as it
is to ensure effectiveness and efficiency, why should we assume that the
ruling party will not seek to recreate these organisational principles once in
power? As the Russian Revolution proves, this is the case (see [section
H.6](secH6.md))

To claim how we organise under capitalism is not important to a revolutionary
movement is simply not true. The way revolutionaries organise have an impact
both on themselves and how they will view the revolution developing. An
ideological prejudice for centralisation and "top-down" organisation will not
disappear once the revolution starts. Rather, it will influence the way the
party acts within it and, if it aims to seize power, how it will exercise that
power once it has.

For these reasons anarchists stress the importance of building the new world
in the shell of the old (see [section H.1.6](secH1.md#sech16)). All
organisations create social relationships which shape their memberships. As
the members of these parties will be part of the revolutionary process, they
will influence how that revolution will develop and any "transitional"
institutions which are created. As the aim of such organisations is to
facilitate the creation of socialism, the obvious implication is that the
revolutionary organisation must, itself, reflect the society it is trying to
create. Clearly, then, the idea that how we organise as revolutionaries today
can be considered somehow independent of the revolutionary process and the
nature of post-capitalist society and its institutions cannot be maintained
(particularly if the aim of the _"revolutionary"_ organisation is to seize
power on behalf of the working class).

As we argue elsewhere (see [section J.3](secJ3.md)) anarchists argue for
revolutionary groups based on self-management, federalism and decision making
from below. In other words, we apply within our organisations the same
principles as those which the working class has evolved in the course of its
own struggles. Autonomy is combined with federalism, so ensuring co-ordination
of decisions and activities is achieved from below upwards by means of
mandated and recallable delegates. Effective co-operation is achieved as it is
informed by and reflects the needs on the ground. Simply put, working class
organisation and discipline - as exemplified by the workers' council or strike
committee - represents a completely different thing from **capitalist**
organisation and discipline, of which Leninists are constantly asking for more
(albeit draped with the Red Flag and labelled _"revolutionary"_). And as we
discuss in the [next section](secH5.md#sech58), the Leninist model of top-
down centralised parties is marked more by its failures than its successes,
suggesting that not only is the vanguard model undesirable, it is also
unnecessary.

## H.5.8 Are vanguard parties effective?

In a word, no. Vanguard parties have rarely been proven to be effective organs
for fermenting revolutionary change which is, let us not forget, their stated
purpose. Indeed, rather than being in the vanguard of social struggle, the
Leninist parties are often the last to recognise, let alone understand, the
initial stirrings of important social movements and events. It is only once
these movements have exploded in the streets that the self-proclaimed
"vanguards" notice them and decide they require the party's leadership.

Part of this process are constant attempts to install their political program
onto movements that they do not understand, movements that have proven to be
successful using different tactics and methods of organisation. Rather than
learn from the experiences of others, social movements are seen as raw
material, as a source of new party members, to be used in order to advance the
party rather than the autonomy and combativeness of the working class. This
process was seen in the _"anti-globalisation"_ or _"anti-capitalist"_ movement
at the end of the 20th century. This started without the help of these self-
appointed vanguards, who once it appeared spent a lot of time trying to catch
up with the movement while criticising its proven organisational principles
and tactics.

The reasons for such behaviour are not too difficult to find. They lie in the
organisational structure favoured by these parties and the mentality lying
behind them. As anarchists have long argued, a centralised, top-down structure
will simply be unresponsive to the needs of those in struggle. The inertia
associated with the party hierarchy will ensure that it responds slowly to new
developments and its centralised structure means that the leadership is
isolated from what is happening on the ground and cannot respond
appropriately. The underlying assumption of the vanguard party, namely that
the party represents the interests of the working class, makes it unresponsive
to new developments within the class struggle. As Lenin argued that
spontaneous working class struggle tends to reformism, the leaders of a
vanguard party automatically are suspicious of new developments which, by
their very nature, rarely fit into previously agreed models of _"proletarian"_
struggle. The example of Bolshevik hostility to the soviets spontaneously
formed by workers during the 1905 Russian revolution is one of the best known
examples of this tendency.

Murray Bookchin is worth quoting at length on this subject:

> _"The 'glorious party,' when there is one, almost invariably lags behind the
events . . . In the beginning . . . it tends to have an inhibitory function,
not a 'vanguard' role. Where it exercises influence, it tends to slow down the
flow of events, not 'co- ordinate' the revolutionary forces. This is not
accidental. The party is structured along hierarchical lines **that reflect
the very society it professes to oppose.** Despite its theoretical
pretensions, it is a bourgeois organism, a miniature state, with an apparatus
and a cadre whose function it is to **seize** power, not **dissolve** power.
Rooted in the pre-revolutionary period, it assimilates all the forms,
techniques and mentality of bureaucracy. Its membership is schooled in
obedience and in the preconceptions of a rigid dogma and is taught to revere
the leadership. The party's leadership, in turn, is schooled in habits born of
command, authority, manipulation and egomania. This situation is worsened when
the party participates in parliamentary elections. In election campaigns, the
vanguard party models itself completely on existing bourgeois forms and even
acquires the paraphernalia of the electoral party. . . _

> _"As the party expands, the distance between the leadership and the ranks
inevitably increases. Its leaders not only become 'personages,' they lose
contact with the living situation below. The local groups, which know their
own immediate situation better than any remote leaders, are obliged to
subordinate their insights to directives from above. The leadership, lacking
any direct knowledge of local problems, responds sluggishly and prudently.
Although it stakes out a claim to the 'larger view,' to greater 'theoretical
competence,' the competence of the leadership tends to diminish as one ascends
the hierarchy of command. The more one approaches the level where the real
decisions are made, the more conservative is the nature of the decision-making
process, the more bureaucratic and extraneous are the factors which come into
play, the more considerations of prestige and retrenchment supplant
creativity, imagination, and a disinterested dedication to revolutionary
goals. _

> _"The party becomes less efficient from a revolutionary point of view the
more it seeks efficiency by means of hierarchy, cadres and centralisation.
Although everyone marches in step, the orders are usually wrong, especially
when events begin to move rapidly and take unexpected turns - as they do in
all revolutions. . . _

> _"On the other hand, this kind of party is extremely vulnerable in periods
of repression. The bourgeoisie has only to grab its leadership to destroy
virtually the entire movement. With its leaders in prison or in hiding, the
party becomes paralysed; the obedient membership has no one to obey and tends
to flounder. Demoralisation sets in rapidly. The party decomposes not only
because of the repressive atmosphere but also because of its poverty of inner
resources. _

> _"The foregoing account is not a series of hypothetical inferences, it is a
composite sketch of all the mass Marxian parties of the past century - the
Social Democrats, the Communists and the Trotskyist party of Ceylon (the only
mass party of its kind). To claim that these parties failed to take their
Marxian principles seriously merely conceals another question: why did this
failure happen in the first place? The fact is, these parties were co-opted
into bourgeois society because they were structured along bourgeois lines. The
germ of treachery existed in them from birth."_ [**Post-Scarcity Anarchism**,
pp. 123-6]

The evidence Bookchin summarises suggests that vanguard parties are less than
efficient in promoting revolutionary change. Sluggish, unresponsive,
undemocratic, they simply cannot adjust to the dynamic nature of social
struggle, never mind revolution. This is to be expected:

> _"For the state centralisation is the appropriate form of organisation,
since it aims at the greatest possible uniformity in social life for the
maintenance of political and social equilibrium. But for a movement whose very
existence depends on prompt action at any favourable moment and on the
independent thought and action of its supporters, centralism could but be a
curse by weakening its power of decision and systematically repressing all
immediate action. If, for example, as was the case in Germany, every local
strike had first to be approved by the Central, which was often hundreds of
miles away and was not usually in a position to pass a correct judgement on
the local conditions, one cannot wonder that the inertia of the apparatus of
organisation renders a quick attack quite impossible, and there thus arises a
state of affairs where the energetic and intellectually alert groups no longer
serve as patterns for the less active, but are condemned by these to
inactivity, inevitably bringing the whole movement to stagnation. Organisation
is, after all, only a means to an end. When it becomes an end in itself, it
kills the spirit and the vital initiative of its members and sets up that
domination by mediocrity which is the characteristic of all bureaucracies."_
[Rudolf Rocker, **Anarcho-Syndicalism**, p. 61]

As we discuss in [section H.5.12](secH5.md#sech512), the example of the
Bolshevik party during the Russian Revolution amply proves Rocker's point.
Rather than being a highly centralised, disciplined vanguard party, the
Bolshevik party was marked by extensive autonomy throughout its ranks. Party
discipline was regularly ignored, including by Lenin in his attempts to get
the central party bureaucracy to catch up with the spontaneous revolutionary
actions and ideas of the Russian working class. As Bookchin summarised, the
_"Bolshevik leadership was ordinarily extremely conservative, a trait that
Lenin had to fight throughout 1917 - first in his efforts to reorient the
Central Committee against the provisional government (the famous conflict over
the 'April Theses'), later in driving the Central Committee toward
insurrection in October. In both cases he threatened to resign from the
Central Committee and bring his views to 'the lower ranks of the party.'"_
Once in power, however, _"the Bolsheviks tended to centralise their party to
the degree that they became isolated from the working class."_ [**Op. Cit.**,
pp. 126 and p. 127]

The "vanguard" model of organising is not only inefficient and ineffective
from a revolutionary perspective, it generates bureaucratic and elitist
tendencies which undermine any revolution unfortunate enough to be dominated
by such a party. For these extremely practical and sensible reasons anarchists
reject it wholeheartedly. As we discuss in the [next
section](secH5.md#sech59), the only thing vanguard parties **are** effective
at is to supplant the diversity produced and required by revolutionary
movements with the drab conformity produced by centralisation and to replace
popular power and freedom with party power and tyranny.

## H.5.9 What are vanguard parties effective at?

As we discussed the [last section](secH5.md#sech58), vanguard parties are
not efficient as agents of revolutionary change. So, it may be asked, what
**are** vanguard parties effective at? If they are harmful to revolutionary
struggle, what are they good at? The answer to this is simple. No anarchist
would deny that vanguard parties are extremely efficient and effective at
certain things, most notably reproducing hierarchy and bourgeois values into
so-called _"revolutionary"_ organisations and movements. As Murray Bookchin
put it, the party _"is efficient in only one respect - in moulding society in
its own hierarchical image if the revolution is successful. It recreates
bureaucracy, centralisation and the state. It fosters the very social
conditions which justify this kind of society. Hence, instead of 'withering
away,' the state controlled by the 'glorious party' preserves the very
conditions which 'necessitate' the existence of a state - and a party to
'guard' it."_ [**Post-Scarcity Anarchism**, pp. 125-6]

By being structured along hierarchical lines that reflect the very system that
it professes to oppose, the vanguard party very "effectively" reproduces that
system within both the current radical social movements **and** any
revolutionary society that may be created. This means that once in power, it
shapes society in its own image. Ironically, this tendency towards
conservatism and bureaucracy was noted by Trotsky:

> _"As often happens, a sharp cleavage developed between the classes in motion
and the interests of the party machines. Even the Bolshevik Party cadres, who
enjoyed the benefit of exceptional revolutionary training, were definitely
inclined to disregard the masses and to identify their own special interests
and the interests of the machine on the very day after the monarchy was
overthrown. What, then, could be expected of these cadres when they became an
all-powerful state bureaucracy?"_ [**Stalin**, vol. 1, p. 298]

In such circumstances, it is unsurprising that urging party power and
identifying it with working class power would have less than revolutionary
results. Discussing the Bolsheviks in 1905 Trotsky points out this tendency
existed from the start:

> _"The habits peculiar to a political machine were already forming in the
underground. The young revolutionary bureaucrat was already emerging as a
type. The conditions of conspiracy, true enough, offered rather meagre scope
for such formalities of democracy as electiveness, accountability and control.
Yet, undoubtedly the committeemen narrowed these limitations considerably more
than necessity demanded and were far more intransigent and severe with the
revolutionary workingmen than with themselves, preferring to domineer even on
occasions that called for lending an attentive ear to the voice of the
masses."_ [**Op. Cit.**, p. 101]

He quoted Krupskaya, a party member, on these party bureaucrats, the
_"committeemen,"_ and how _"as a rule"_ they _"did not recognise any party
democracy"_ and _"did not want any innovations. The 'committeeman' did not
desire, and did not know how to, adapt himself to rapidly changing
conditions."_ [quoted by Trotsky, **Op. Cit.**, p. 101] This conservatism
played havoc in the party during 1917, incidentally. It would be no
exaggeration to argue that the Russian revolution occurred in spite of, rather
than because of, Bolshevik organisational principles (see [section
H.5.12](secH5.md#sech512)). These principles, however, came into their own
once the party had seized power, ensuring the consolidation of bureaucratic
rule by an elite.

That a vanguard party helps to produces a bureaucratic regime once in power
should not come as a surprise. If the party, to use Trotsky's expression,
exhibits a _"caste tendency of the committeemen"_ can we be surprised if once
in power it reproduces such a tendency in the state it is now the master of?
[**Op. Cit.**, p. 102] And this _"tendency"_ can be seen today in the
multitude of Leninist sects that exist.

## H.5.10 Why does _"democratic centralism"_ produce _"bureaucratic
centralism"_?

In spite of the almost ritualistic assertions that vanguard parties are _"the
most democratic the world has seen,"_ an army of ex-members, expelled
dissidents and disgruntled members testify that they do not live up to the
hype. They argue that most, if not all, "vanguard" parties are not
_"democratic centralist"_ but are, in fact, _"bureaucratic centralist."_
Within the party, in other words, a bureaucratic clique controls it from the
top-down with little democratic control, never mind participation. For
anarchists, this is hardly surprising. The reasons why this continually
happens are rooted in the nature of _"democratic centralism"_ itself.

Firstly, the assumption of _"democratic centralism"_ is that the membership
elect a leadership and give them the power to decide policy between
conferences and congresses. This has a subtle impact on the membership, as it
is assumed that the leadership has a special insight into social problems
above and beyond that of anyone else, otherwise they would not have been
elected to such an important position. Thus many in the membership come to
believe that disagreements with the leadership's analysis, even before they
had been clearly articulated, are liable to be wrong. Doubt dares not speak
its name. Unquestioning belief in the party leadership has been an all to
common recurring theme in many accounts of vanguard parties. The hierarchical
structure of the party promotes a hierarchical mentality in its members.

Conformity within such parties is also reinforced by the intense activism
expected by members, particularly leading activists and full-time members.
Paradoxically, the more deeply people participate in activism, the harder it
becomes to reflect on what they are doing. The unrelenting pace often induces
exhaustion and depression, while making it harder to _"think your way out"_ \-
too many commitments have been made and too little time is left over from
party activity for reflection. Moreover, high levels of activism prevent many,
particularly the most committed, from having a personal life outside their
role as party members. This high-speed political existence means that rival
social networks atrophy through neglect, so ensuring that the party line is
the only perspective which members get exposed to. Members tend to leave,
typically, because of exhaustion, crisis, even despair rather than as the
result of rational reflection and conscious decision.

Secondly, given that vanguard parties are based on the belief that they are
the guardians of _"scientific socialism,"_ this means that there is a tendency
to squeeze all of social life into the confines of the party's ideology.
Moreover, as the party's ideology is a "science" it is expected to explain
everything (hence the tendency of Leninists to expound on every subject
imaginable, regardless of whether the author knows enough about the subject to
discuss it in an informed way). The view that the party's ideology explains
everything eliminates the need for fresh or independent thought, precludes the
possibility of critically appraising past practice or acknowledging mistakes,
and removes the need to seek meaningful intellectual input outside the party's
own ideological fortress. As Victor Serge, anarchist turned Bolshevik,
admitted in his memoirs: _"Bolshevik thinking is grounded in the possession of
the truth. The Party is the repository of truth, and any form of thinking
which differs from it is a dangerous or reactionary error. Here lies the
spiritual source of its intolerance. The absolute conviction of its lofty
mission assures it of a moral energy quite astonishing in its intensity - and,
at the same time, a clerical mentality which is quick to become
Inquisitorial."_ [**Memoirs of a Revolutionary**, p. 134]

The intense level of activism means that members are bombarded with party
propaganda, are in endless party meetings, or spend time reading party
literature and so, by virtue of the fact that there is not enough time to read
everything, members end up reading nothing but party publications. Most points
of contact with the external world are eliminated or drastically curtailed.
Indeed, such alternative sources of information and such thinking is regularly
dismissed as being contaminated by bourgeois influences. This often goes so
far as to label those who question any aspect of the party's analysis
revisionists or deviationists, bending to the _"pressures of capitalism,"_ and
they are usually driven from the ranks as heretics. All this is almost always
combined with contempt for all other organisations on the Left (indeed, the
closer they are to the party's own ideological position the more likely they
are to be the targets of abuse).

Thirdly, the practice of _"democratic centralism"_ also aids this process
towards conformity. Based on the idea that the party must be a highly
disciplined fighting force, the party is endowed with a powerful central
committee and a rule that all members must publicly defend the agreed-upon
positions of the party and the decisions of the central committee, whatever
opinions they might hold to the contrary in private. Between conferences, the
party's leading bodies usually have extensive authority to govern the party's
affairs, including updating party doctrine and deciding the party's response
to current political events.

As unity is the key, there is a tendency to view any opposition as a potential
threat. It is not at all clear when _"full freedom to criticise"_ policy
internally can be said to disturb the unity of a defined action. The norms of
democratic centralism confer all power between conferences onto a central
committee, allowing it to become the arbiter of when a dissident viewpoint is
in danger of weakening unity. The evidence from numerous vanguard parties
suggest that their leaderships usually view **any** dissent as precisely such
a disruption and demand that dissidents cease their action or face expulsion
from the party.

It should also be borne in mind that Leninist parties also view themselves as
vitally important to the success of any future revolution. This cannot help
but reinforce the tendency to view dissent as something which automatically
imperils the future of the planet and, therefore, something which must be
combated at all costs. As Lenin stressed an a polemic directed to the
international communist movement in 1920, _"[w]hoever brings about even the
slightest weakening of the iron discipline of the party of the proletariat
(especially during its dictatorship) is actually aiding the bourgeoisie
against the proletariat."_ [**Collected Works**, vol. 31, p. 45] As can be
seen, Lenin stresses the importance of _"iron discipline"_ at all times, not
only during the revolution when _"the party"_ is applying _"its dictatorship"_
(see [section H.3.8](secH3.md#sech38) for more on this aspect of Leninism).
This provides a justification of whatever measures are required to restore the
illusion of unanimity, including the trampling underfoot of whatever rights
the membership may have on paper and the imposition of any decisions the
leadership considers as essential between conferences.

Fourthly, and more subtly, it is well known that when people take a public
position in defence of a proposition, there is a strong tendency for their
private attitudes to shift so that they harmonise with their public behaviour.
It is difficult to say one thing in public and hold to a set of private
beliefs at variance with what is publicly expressed. In short, if people tell
others that they support X (for whatever reason), they will slowly begin to
change their own opinions and, indeed, internally come to support X. The more
public such declarations have been, the more likely it is that such a shift
will take place. This has been confirmed by empirical research (see R.
Cialdini's **Influence: Science and Practice**). This suggests that if, in the
name of democratic centralism, party members publicly uphold the party line,
it becomes increasingly difficult to hold a private belief at variance with
publicly expressed opinions. The evidence suggests that it is not possible to
have a group of people presenting a conformist image to society at large while
maintaining an inner party regime characterised by frank and full discussion.
Conformity in public tends to produce conformity in private. So given what is
now known of social influence, _"democratic centralism"_ is almost certainly
destined to prevent genuine internal discussion. This is sadly all too often
confirmed in the internal regimes of vanguard parties, where debate is often
narrowly focused on a few minor issues of emphasis rather than fundamental
issues of policy and theory.

It has already been noted (in [section H.5.5](secH5.md#sech55)) that the
organisational norms of democratic centralism imply a concentration of power
at the top. There is abundant evidence that such a concentration has been a
vital feature of every vanguard party and that such a concentration limits
party democracy. An authoritarian inner party regime is maintained, which
ensures that decision making is concentrated in elite hands. This regime
gradually dismantles or ignores all formal controls on its activities. Members
are excluded from participation in determining policy, calling leaders to
account, or expressing dissent. This is usually combined with persistent
assurances about the essentially democratic nature of the organisation, and
the existence of exemplary democratic controls - on paper. Correlated with
this inner authoritarianism is a growing tendency toward the abuse of power by
the leaders, who act in arbitrary ways, accrue personal power and so on (as
noted by Trotsky with regards to the Bolshevik party machine). Indeed, it is
often the case that activities that would provoke outrage if engaged in by
rank-and-file members are tolerated when their leaders do it. As one group of
Scottish libertarians noted:

> _"Further, in so far as our Bolshevik friends reject and defy capitalist and
orthodox labourist conceptions, they also are as much 'individualistic' as the
anarchist. Is it not boasted, for example, that on many occasions Marx, Lenin
and Trotsky were prepared to be in a minority of one - if they thought they
were more correct than all others on the question at issue? In this, like
Galileo, they were quite in order. Where they and their followers, obsessed by
the importance of their own judgement go wrong, is in their tendency to refuse
this inalienable right to other protagonists and fighters for the working
class."_ [APCF, _"Our Reply,"_ **Class War on the Home Front**, p. 70]

As in any hierarchical structure, the tendency is for those in power to
encourage and promote those who agree with them. This means that members
usually find their influence and position in the party dependent on their
willingness to conform to the hierarchy and its leadership. Dissenters will
rarely find their contribution valued and advancement is limited, which
produces a strong tendency not to make waves. As Miasnikov, a working class
Bolshevik dissident, argued in 1921, _"the regime within the party"_ meant
that _"if someone dares to have the courage of his convictions,"_ they are
called either a self-seeker or, worse, a counter-revolutionary, a Menshevik or
an SR. Moreover, within the party, favouritism and corruption were rife. In
Miasnikov's eyes a new type of Communist was emerging, the toadying careerist
who _"knows how to please his superiors."_ [quoted by Paul Avrich, **Bolshevik
Opposition to Lenin**, p. 8 and p. 7] At the last party congress Lenin
attended, Miasnikov was expelled. Only one delegate, V. V. Kosior, _"argued
that Lenin had taken the wrong approach to the question of dissent. If someone
. . . had the courage to point out deficiencies in party work, he was marked
down as an oppositionist, relieved of authority, placed under surveillance,
and - a reference to Miasnikov - even expelled from the party."_ [Paul Avrich,
**Op. Cit.**, p. 15] Serge noted about the same period that Lenin _"proclaimed
a purge of the Party, aimed at those revolutionaries who had come in from
other parties - i.e. those who were not saturated with the Bolshevik
mentality. This meant the establishment within the Party of a dictatorship of
the old Bolsheviks, and the direction of disciplinary measures, not against
the unprincipled careerists and conformist late-comers, but against those
sections with a critical outlook."_ [**Op. Cit.**, p. 135]

This, of course, also applies to the party congress, on paper the sovereign
body of the organisation. All too often resolutions at party conferences will
either come from the leadership or be completely supportive of its position.
If branches or members submit resolutions which are critical of the
leadership, enormous pressure is exerted to ensure that they are withdrawn.
Moreover, often delegates to the congress are not mandated by their branches,
so ensuring that rank and file opinions are not raised, never mind discussed.
Other, more drastic measures have been known to occur. Victor Serge saw what
he termed the _"Party steamroller"_ at work in early 1921 when _"the voting
[was] rigged for Lenin's and Zinoviev's 'majority'"_ in one of the districts
of Petrograd. [**Op. Cit.**, p.123]

All to often, such parties have "elected" bodies which have, in practice,
usurped the normal democratic rights of members and become increasingly
removed from formal controls. All practical accountability of the leaders to
the membership for their actions is eliminated. Usually this authoritarian
structure is combined with militaristic sounding rhetoric and the argument
that the "revolutionary" movement needs to be organised in a more centralised
way than the current class system, with references to the state's forces of
repression (notably the army). As Murray Bookchin argued, the Leninist _"has
always had a grudging admiration and respect for that most inhuman of all
hierarchical institutions, the military."_ [**Toward an Ecological Society**,
p. 254f]

The modern day effectiveness of the vanguard party can be seen by the strange
fact that many Leninists fail to join any of the existing parties due to their
bureaucratic internal organisation and that many members are expelled (or
leave in disgust) as a result of their failed attempts to make them more
democratic. If vanguard parties are such positive organisations to be a member
of, why do they have such big problems with member retention? Why are there so
many vocal ex-members? Why are so many Leninists ex-members of vanguard
parties, desperately trying to find an actual party which matches their own
vision of democratic centralism rather than the bureaucratic centralism which
seems the norm?

Our account of the workings of vanguard parties explains, in part, why many
anarchists and other libertarians voice concern about them and their
underlying ideology. We do so because their practices are disruptive and
alienate new activists, hindering the very goal (socialism/revolution) they
claim to be aiming for. As anyone familiar with the numerous groupings and
parties in the Leninist left will attest, the anarchist critique of
vanguardism seems to be confirmed in reality while the Leninist defence seems
sadly lacking (unless, of course, the person is a member of such a party and
then their organisation is the exception to the rule!).

## H.5.11 Can you provide an example of the negative nature of vanguard
parties?

Yes. Our theoretical critique of vanguardism we have presented in the last few
sections is more than proved by the empirical evidence of such parties in
operation today. Rarely do "vanguard" parties reach in practice the high hopes
their supporters like to claim for them. Such parties are usually small, prone
to splitting as well as leadership cults, and usually play a negative role in
social struggle. A long line of ex-members complain that such parties are
elitist, hierarchical and bureaucratic.

Obviously we cannot hope to discuss all such parties. As such, we will take
just one example, namely the arguments of one group of dissidents of the
biggest British Leninist party, the **Socialist Workers Party**. It is worth
quoting their account of the internal workings of the SWP at length:

> _"The SWP is not democratic centralist but bureaucratic centralist. The
leadership's control of the party is unchecked by the members. New
perspectives are initiated exclusively by the central committee (CC), who then
implement their perspective against all party opposition, implicit or
explicit, legitimate or otherwise. _

> _"Once a new perspective is declared, a new cadre is selected from the top
down. The CC select the organisers, who select the district and branch
committees - any elections that take place are carried out on the basis of
'slates' so that it is virtually impossible for members to vote against the
slate proposed by the leadership. Any members who have doubts or disagreements
are written off as 'burnt out' and, depending on their reaction to this, may
be marginalised within the party and even expelled. _

> _"These methods have been disastrous for the SWP in a number of ways: Each
new perspective requires a new cadre (below the level of the CC), so the
existing cadre are actively marginalised in the party. In this way, the SWP
has failed to build a stable and experienced cadre capable of acting
independently of the leadership. Successive layers of cadres have been driven
into passivity, and even out of the revolutionary movement altogether. The
result is the loss of hundreds of potential cadres. Instead of appraising the
real, uneven development of individual cadres, the history of the party is
written in terms of a star system (comrades currently favoured by the party)
and a demonology (the 'renegades' who are brushed aside with each turn of the
party). As a result of this systematic dissolution of the cadre, the CC grows
ever more remote from the membership and increasingly bureaucratic in its
methods. In recent years the national committee has been abolished (it
obediently voted for its own dissolution, on the recommendation of the CC), to
be replaced by party councils made up of those comrades active at any one time
(i.e. those who already agree with current perspectives); district committees
are appointed rather than elected; the CC monopolise all information
concerning the party, so that it is impossible for members to know much about
what happens in the party outside their own branch; the CC give a distorted
account of events rather than admit their mistakes . . . history is rewritten
to reinforce the prestige of the CC . . . The outcome is a party whose
conferences have no democratic function, but serve only to orientate party
activists to carry out perspectives drawn up before the delegates even set out
from their branches. At every level of the party, strategy and tactics are
presented from the top down, as pre-digested instructions for action. At every
level, the comrades 'below' are seen only as a passive mass to be shifted into
action, rather than as a source of new initiatives . . . _

> _"The only exception is when a branch thinks up a new tactic to carry out
the CC's perspective. In this case, the CC may take up this tactic and apply
it across the party. In no way do rank and file members play an active role in
determining the strategy and theory of the party - except in the negative
sense that if they refuse to implement a perspective eventually even the CC
notice, and will modify the line to suit. A political culture has been created
in which the leadership outside of the CC consists almost solely of comrades
loyal to the CC, willing to follow every turn of the perspective without
criticism . . . Increasingly, the bureaucratic methods used by the CC to
enforce their control over the political direction of the party have been
extended to other areas of party life. In debates over questions of
philosophy, culture and even anthropology an informal party 'line' emerged
(i.e. concerning matters in which there can be no question of the party taking
a 'line'). Often behind these positions lay nothing more substantial than the
opinions of this or that CC member, but adherence to the line quickly became a
badge of party loyalty, disagreement became a stigma, and the effect was to
close down the democracy of the party yet further by placing even questions of
theory beyond debate. Many militants, especially working class militants with
some experience of trade union democracy, etc., are often repelled by the
undemocratic norms in the party and refuse to join, or keep their distance
despite accepting our formal politics."_ [ISG, **Discussion Document of Ex-SWP
Comrades**]

The dissidents argue that a _"democratic"_ party would involve the _"[r]egular
election of all party full-timers, branch and district leadership, conference
delegates, etc. with the right of recall,"_ which means that in the SWP
appointment of full-timers, leaders and so on is the norm. They argue for the
_"right of branches to propose motions to the party conference"_ and for the
_"right for members to communicate horizontally in the party, to produce and
distribute their own documents."_ They stress the need for _"an independent
Control Commission to review all disciplinary cases (independent of the
leadership bodies that exercise discipline), and the right of any disciplined
comrades to appeal directly to party conference."_ They argue that in a
democratic party _"no section of the party would have a monopoly of
information"_ which indicates that the SWP's leadership is essentially
secretive, withholding information from the party membership. Even more
significantly, given our discussion on the influence of the party structure on
post-revolutionary society in [section H.5.7](secH5.md#sech57), they argue
that _"[w]orst of all, the SWP are training a layer of revolutionaries to
believe that the organisational norms of the SWP are a shining example of
proletarian democracy, applicable to a future socialist society. Not
surprisingly, many people are instinctively repelled by this idea."_

Some of these critics of specific Leninist parties do not give up hope and
still look for a truly democratic centralist party rather than the
bureaucratic centralist ones which seem so common. For example, our group of
ex-SWP dissidents argue that _"[a]nybody who has spent time involved in
'Leninist' organisations will have come across workers who agree with Marxist
politics but refuse to join the party because they believe it to be
undemocratic and authoritarian. Many draw the conclusion that Leninism itself
is at fault, as every organisation that proclaims itself Leninist appears to
follow the same pattern."_ [ISG, **Lenin vs. the SWP: Bureaucratic Centralism
Or Democratic Centralism?**] This is a common refrain with Leninists - when
reality says one thing and the theory another, it must be reality that is at
fault. Yes, every Leninist organisation may be bureaucratic and authoritarian
but it is not the theory's fault that those who apply it are not capable of
actually doing so successfully. Such an application of scientific principles
by the followers of _"scientific socialism"_ is worthy of note - obviously the
usual scientific method of generalising from facts to produce a theory is
inapplicable when evaluating _"scientific socialism"_ itself. However, rather
than ponder the possibility that _"democratic centralism"_ does not actually
work and automatically generates the _"bureaucratic centralism,"_ they point
to the example of the Russian revolution and the original Bolshevik party as
proof of the validity of their hopes.

Indeed, it would be no exaggeration to argue that the only reason people take
the vanguard party organisational structure seriously is the apparent success
of the Bolsheviks in the Russian revolution. However, as noted above, even the
Bolshevik party was subject to bureaucratic tendencies and as we discuss in
the [next section](secH5.md#secH512), the experience of the 1917 Russian
Revolutions disprove the effectiveness of _"vanguard"_ style parties. The
Bolshevik party of 1917 was a totally different form of organisation than the
ideal _"democratic centralist"_ type argued for by Lenin in 1902 and 1920. As
a model of revolutionary organisation, the "vanguardist" one has been proven
false rather than confirmed by the experience of the Russian revolution.
Insofar as the Bolshevik party was effective, it operated in a non-vanguardist
way and insofar as it did operate in such a manner, it held back the struggle.

## H.5.12 Surely the Russian Revolution proves that vanguard parties work?

No, far from it. Looking at the history of vanguardism we are struck by its
failures, not its successes. Indeed, the proponents of _"democratic
centralism"_ can point to only one apparent success of their model, namely the
Russian Revolution. Strangely, though, we are warned by Leninists that failure
to use the vanguard party will inevitably condemn future revolutions to
failure:

> _"The proletariat can take power only through its vanguard. . . Without the
confidence of the class in the vanguard, without support of the vanguard by
the class, there can be no talk of the conquest of power . . . The Soviets are
the only organised form of the tie between the vanguard and the class. A
revolutionary content can be given to this form only by the party. This is
proved by the positive experience of the October Revolution and by the
negative experience of other countries (Germany, Austria, finally, Spain). No
one has either shown in practice or tried to explain articulately on paper how
the proletariat can seize power without the political leadership of a party
that knows what it wants."_ [Trotsky, **Writings 1936-37**, p. 490]

To anarchist ears, such claims seem out of place. After all, did the Russian
Revolution actually result in socialism or even a viable form of soviet
democracy? Far from it. Unless you picture revolution as simply the changing
of the party in power, you have to acknowledge that while the Bolshevik party
**did** take power in Russian in November 1917, the net effect of this was
**not** the stated goals that justified that action. Thus, if we take the term
"effective" to mean "an efficient means to achieve the desired goals" then
vanguardism has not been proven to be effective, quite the reverse (assuming
that your desired goal is a socialist society, rather than party power).
Needless to say, Trotsky blames the failure of the Russian Revolution on
_"objective"_ factors rather than Bolshevik policies and practice, an argument
we address in [section H.6](secH6.md) and will not do so here.

So while Leninists make great claims for the effectiveness of their chosen
kind of party, the hard facts of history are against their positive evaluation
of vanguard parties. Ironically, even the Russian Revolution disproves the
claims of Leninists. The fact is that the Bolshevik party in 1917 was very far
from the _"democratic centralist"_ organisation which supporters of
vanguardism like to claim it as. As such, its success in 1917 lies more in its
divergence from the principles of _"democratic centralism"_ than in their
application. The subsequent degeneration of the revolution and the party is
marked by the increasing **application** of those principles in the life of
the party.

Thus, to refute the claims of the _"effectiveness"_ and _"efficiency"_ of
vanguardism, we need to look at its one and only success, namely the Russian
Revolution. As the Cohen-Bendit brothers argued, _"far from leading the
Russian Revolution forwards, the Bolsheviks were responsible for holding back
the struggle of the masses between February and October 1917, and later for
turning the revolution into a bureaucratic counter-revolution - in both cases
because of the party's very nature, structure and ideology."_ Indeed, _"[f]rom
April to October, Lenin had to fight a constant battle to keep the Party
leadership in tune with the masses."_ [**Obsolete Communism**, p. 183 and p.
187] It was only by continually violating its own _"nature, structure and
ideology"_ that the Bolshevik party played an important role in the
revolution. Whenever the principles of _"democratic centralism"_ were applied,
the Bolshevik party played the role the Cohen-Bendit brothers subscribed to it
(and once in power, the party's negative features came to the fore).

Even Leninists acknowledge that, to quote Tony Cliff, throughout the history
of Bolshevism, _"a certain conservatism arose."_ Indeed, _"[a]t practically
all sharp turning points, Lenin had to rely on the lower strata of the party
machine against the higher, or on the rank and file against the machine as a
whole."_ [**Lenin**, vol. 2, p. 135] This fact, incidentally, refutes the
basic assumptions of Lenin's party schema, namely that the broad party
membership, like the working class, was subject to bourgeois influences so
necessitating central leadership and control from above.

Looking at both the 1905 and 1917 revolutions, we are struck by how often this
_"conservatism"_ arose and how often the higher bodies lagged behind the
spontaneous actions of the masses and the party membership. Looking at the
1905 revolution, we discover a classic example of the inefficiency of
"democratic centralism." Facing the rise of the soviets, councils of workers'
delegates elected to co-ordinate strikes and other forms of struggle, the
Bolsheviks did not know what to do. _"The Petersburg Committee of the
Bolsheviks,"_ noted Trotsky, _"was frightened at first by such an innovation
as a non-partisan representation of the embattled masses, and could find
nothing better to do than to present the Soviet with an ultimatum: immediately
adopt a Social-Democratic program or disband. The Petersburg Soviet as a
whole, including the contingent of Bolshevik workingmen as well ignored this
ultimatum without batting an eyelash."_ [**Stalin**, vol. 1, p. 106] More than
that, _"[t]he party's Central Committee published the resolution on October
27, thereby making it the binding directive for all other Bolshevik
organisations."_ [Oskar Anweiler, **The Soviets**, p. 77] It was only the
return of Lenin which stopped the Bolshevik's open attacks against the Soviet.
As we discuss in [section H.6.2](secH6.md#sech62), the rationale for these
attacks is significant as they were based on arguing that the soviets could
not reflect workers' interests because they were elected by the workers! The
implications of this perspective came clear in 1918, when the Bolsheviks
gerrymandered and disbanded soviets to remain in power (see [section
H.6.1](secH6.md#sech61)). That the Bolshevik's position flowed naturally
from Lenin's arguments in **What is to be Done?** is clear. Thus the
underlying logic of Lenin's vanguardism ensured that the Bolsheviks played a
negative role with regards the soviets which, combined with "democratic
centralism" ensured that it was spread far and wide. Only by ignoring their
own party's principles and staying in the Soviet did rank and file Bolsheviks
play a positive role in the revolution. This divergence of top and bottom
would be repeated in 1917.

Given this, perhaps it is unsurprising that Leninists started to rewrite the
history of the 1905 revolution. Victor Serge, an anti-Stalinist Leninist,
asserted in the late 1920s that in 1905 the Petrograd Soviet was _"led by
Trotsky and inspired by the Bolsheviks."_ [**Year One of the Russian
Revolution**, p. 36]. While the former claim is partially correct, the latter
is not. As noted, the Bolsheviks initially opposed the soviets and
systematically worked to undermine them. Unsurprisingly, Trotsky at that time
was a Menshevik, not a Bolshevik. After all, how could the most revolutionary
party that ever existed have messed up so badly? How could democratic
centralism fare so badly in practice? Best, then, to suggest that it did not
and give the Bolsheviks a role better suited to the rhetoric of Bolshevism
than its reality.

Trotsky was no different. He, needless to say, denied the obvious implications
of these events in 1905. While admitting that the Bolsheviks _"adjusted
themselves more slowly to the sweep of the movement"_ and that the Mensheviks
_"were preponderant in the Soviet,"_ he tries to save vanguardism by asserting
that _"the general direction of the Soviet's policy proceeded in the main
along Bolshevik lines."_ So, in spite of the lack of Bolshevik influence, in
spite of the slowness in adjusting to the revolution, Bolshevism was, in fact,
the leading set of ideas in the revolution! Ironically, a few pages later, he
mocks the claims of Stalinists that Stalin had _"isolated the Mensheviks from
the masses"_ by noting that the _"figures hardly bear [the claims] out."_
[**Op. Cit.**, p. 112 and p. 117] Shame he did not apply this criteria to his
own assertions.

Of course, every party makes mistakes. The question is, how did the _"most
revolutionary party of all time"_ fare in 1917. Surely that revolution proves
the validity of vanguardism and "democratic centralism"? After all, there was
a successful revolution, the Bolshevik party did seize power. However, the
apparent success of 1917 was not due to the application of "democratic
centralism," quite the reverse. While the myth of 1917 is that a highly
efficient, democratic centralist vanguard party ensured the overthrow of the
Provisional Government in November 1917 in favour of the Soviets (or so it
seemed at the time) the facts are somewhat different. Rather, the Bolshevik
party throughout 1917 was a fairly loose collection of local organisations
(each more than willing to ignore central commands and express their
autonomy), with much internal dissent and infighting and no discipline beyond
what was created by common loyalty. The "democratic centralist" party, as
desired by Lenin, was only created in the course of the Civil War and the
tightening of the party dictatorship. In other words, the party became more
like a "democratic centralist" one as the revolution degenerated. As such, the
various followers of Lenin (Stalinists, Trotskyists and their multitude of
offshoots) subscribe to a myth, which probably explains their lack of success
in reproducing a similar organisation since. So assuming that the Bolsheviks
did play an important role in the Russian revolution, it was because it was
**not** the centralised, disciplined Bolshevik party of Leninist myth. Indeed,
when the party **did** operate in a vanguardist manner, failure was soon to
follow.

This claim can be proven by looking at the history of the 1917 revolution. The
February revolution started with spontaneous protests and strikes yet _"the
Petrograd organisation of the Bolsheviks opposed the calling of strikes
precisely on the eve of the revolution which was destined to overthrow the
Tsar. Fortunately, the workers ignored the Bolshevik 'directives' and went on
strike anyway. In the events which followed, no one was more surprised by the
revolution than the 'revolutionary' parties, including the Bolsheviks."_
[Murray Bookchin, **Post-Scarcity Anarchism**, p. 123] Trotsky quoted one of
the Bolshevik leaders at the time:

> _"Absolutely no guiding initiative from the party centres was felt . . . the
Petrograd Committee had been arrested and the representative of the Central
Committee . . . was unable to give any directives for the coming day."_
[quoted by Trotsky, **History of the Russian Revolution**, vol. 1, p. 147]

Not the best of starts. Of course rank and file Bolsheviks took part in the
demonstrations, street fights and strikes and so violated the principles their
party was meant to be based on. As the revolution progressed, so did the dual
nature of the Bolshevik party (i.e. its practical divergence from "democratic
centralism" in order to be effective and attempts to force it back into that
schema which handicapped the revolution). However, during 1917, "democratic
centralism" was ignored in order to ensure the Bolsheviks played any role at
all in the revolution. As one historian of the party makes clear, in 1917 and
until the outbreak of the Civil War, the party operated in ways that few
modern "vanguard" parties would tolerate:

> _"The committees were a law unto themselves when it came to accepting orders
from above. Democratic centralism, as vague a principle of internal
administration as there ever has been, was commonly held at least to enjoin
lower executive bodies that they should obey the behests of all higher bodies
in the organisational hierarchy. But town committees in practice had the
devil's own job in imposing firm leadership . . . Insubordination was the rule
of the day whenever lower party bodies thought questions of importance were at
stake. _

> _"Suburb committees too faced difficulties in imposing discipline. Many a
party cell saw fit to thumb its nose at higher authority and to pursue
policies which it felt to be more suited to local circumstances or more
desirable in general. No great secret was made of this. In fact, it was openly
admitted that hardly a party committee existed which did not encounter
problems in enforcing its will even upon individual activists."_ [Robert
Service, **The Bolshevik Party in Revolution 1917-1923**, pp. 51-2]

So while Lenin's ideal model of a disciplined, centralised and top-down party
had been expounded since 1902, the operation of the party never matched his
desire. As Service notes, _"a disciplined hierarchy of command stretching down
from the regional committees to party cells"_ had _"never existed in Bolshevik
history."_ In the heady days of the revolution, when the party was flooded by
new members, Bolshevik party life was the exact opposite of that usually
considered (by both opponents and supporters of Bolshevism) as it normal mode
of operation. _"Anarchist attitudes to higher authority,"_ he argues, _"were
the rule of the day"_ and _"no Bolshevik leader in his right mind could have
contemplated a regular insistence upon rigid standards of hierarchical control
and discipline unless he had abandoned all hope of establishing a mass
socialist party."_ This meant that _"in the Russia of 1917 it was the easiest
thing in the world for lower party bodies to rebut the demands and pleas by
higher authority."_ He stresses that _"[s]uburb and town committees . . .
often refused to go along with official policies . . . they also . . .
sometimes took it into their heads to engage in active obstruction."_ [**Op.
Cit.**, p. 80, p. 62 p. 56 and p. 60]

This worked both ways, of course. Town committees did _"snub their nose at
lower-echelon viewpoints in the time before the next election. Try as hard as
they might, suburb committees and ordinary cells could meanwhile do little to
rectify matters beyond telling their own representative on their town
committee to speak on their behalf. Or, if this too failed, they could resort
to disruptive tactics by criticising it in public and refusing it all
collaboration."_ [**Op. Cit.**, pp. 52-3] Even by early 1918, the Bolshevik
party bore little resemblance to the "democratic centralist" model desires by
Lenin:

> _"The image of a disciplined hierarchy of party committees was therefore but
a thin, artificial veneer which was used by Bolshevik leaders to cover up the
cracked surface of the real picture underneath. Cells and suburb committees
saw no reason to kow-tow to town committees; nor did town committees feel
under compulsion to show any greater respect to their provincial and regional
committees than before."_ [**Op. Cit.**, p. 74]

It is this insubordination, this local autonomy and action in spite of central
orders which explains the success of the Bolsheviks in 1917. Rather than a
highly centralised and disciplined body of "professional" revolutionaries, the
party saw a _"significant change . . . within the membership of the party at
local level . . . From the time of the February revolution requirements for
party membership had been all but suspended, and now Bolshevik ranks swelled
with impetuous recruits who knew next to nothing about Marxism and who were
united by little more than overwhelming impatience for revolutionary action."_
[Alexander Rabinowitch, **Prelude to Revolution**, p. 41]

This mass of new members (many of whom were peasants who had just recently
joined the industrial workforce) had a radicalising effect on the party's
policies and structures. As even Leninist commentators argue, it was this
influx of members who allowed Lenin to gain support for his radical revision
of party aims in April. However, in spite of this radicalisation of the party
base, the party machine still was at odds with the desires of the party. As
Trotsky acknowledged, the situation _"called for resolute confrontation of the
sluggish Party machine with masses and ideas in motion."_ He stressed that
_"the masses were incomparably more revolutionary than the Party, which in
turn was more revolutionary than its committeemen."_ Ironically, given the
role Trotsky usually gave the party, he admits that _"[w]ithout Lenin, no one
had known what to make of the unprecedented situation."_ [**Stalin**, vol. 1,
p. 301, p. 305 and p. 297]

Which is significant in itself. The Bolshevik party is usually claimed as
being the most "revolutionary" that ever existed, yet here is Trotsky
admitting that its leading members did not have a clue what to do. He even
argued that _"[e]very time the Bolshevik leaders had to act without Lenin they
fell into error, usually inclining to the Right."_ [**Op. Cit.**, p. 299] This
negative opinion of the Bolsheviks applied even to the _"left Bolsheviks,
especially the workers"_ whom we are informed _"tried with all their force to
break through this quarantine"_ created by the Bolshevik leaders policy _"of
waiting, of accommodation, and of actual retreat before the Compromisers"_
after the February revolution and before the arrival of Lenin. Trotsky argued
that _"they did not know how to refute the premise about the bourgeois
character of the revolution and the danger of an isolation of the proletariat.
They submitted, gritting their teeth, to the directions of their leaders."_
[**History of the Russian Revolution**, vol. 1, p. 273] It seems strange, to
say the least, that without one person the whole of the party was reduced to
such a level given that the aim of the "revolutionary" party was to develop
the political awareness of its members.

Lenin's arrival, according to Trotsky, allowed the influence of the more
radical rank and file to defeat the conservatism of the party machine. By the
end of April, Lenin had managed to win over the majority of the party
leadership to his position. However, this _"April conflict between Lenin and
the general staff of the party was not the only one of its kind. Throughout
the whole history of Bolshevism . . . all the leaders of the party at all the
most important moments stood to the **right** of Lenin."_ [**Op. Cit.**, p.
305] As such, if "democratic centralism" had worked as intended, the whole
party would have been arguing for incorrect positions the bulk of its
existence (assuming, of course, that Lenin was correct most of the time).

For Trotsky, _"Lenin exerted influence not so much as an individual but
because he embodied the influence of the class on the Party and of the Party
on its machine."_ Yet, this was the machine which Lenin had forged, which
embodied his vision of how a "revolutionary" party should operate and was
headed by him. To argue that the party machine was behind the party membership
and the membership behind the class shows the bankruptcy of Lenin's
organisational scheme. This "backwardness", moreover, indicates an
independence of the party bureaucracy from the membership and the membership
from the masses. As Lenin's constantly repeated aim was for the party to seize
power (based on the dubious assumption that class power would only be
expressed, indeed was identical to, party power) this independence held
serious dangers, dangers which became apparent once this goal was achieved.
This is confirmed when Trotsky asked the question _"by what miracle did Lenin
manage in a few short weeks to turn the Party's course into a new channel?"_
Significantly, he answers as follows: _"Lenin's personal attributes and the
objective situation."_ [**Stalin**, vol. 1, p. 299] No mention is made of the
democratic features of the party organisation, which suggests that without
Lenin the rank and file party members would not have been able to shift the
weight of the party machine in their favour. Trotsky seemed close to admitting
this:

> _"As often happens, a sharp cleavage developed between the classes in motion
and the interests of the party machines. Even the Bolshevik Party cadres, who
enjoyed the benefit of exceptional revolutionary training, were definitely
inclined to disregard the masses and to identify their own special interests
and the interests of the machine on the very day after the monarchy was
overthrown."_ [**Op. Cit.**, vol. 1, p. 298]

Thus the party machine, which embodied the principles of "democratic
centralism" proved less than able to the task assigned it in practice. Without
Lenin, it is doubtful that the party membership would have overcome the party
machine:

> _"Lenin was strong not only because he understood the laws of the class
struggle but also because his ear was faultlessly attuned to the stirrings of
the masses in motion. He represented not so much the Party machine as the
vanguard of the proletariat. He was definitely convinced that thousands from
among those workers who had borne the brunt of supporting the underground
Party would now support him. The masses at the moment were more revolutionary
than the Party, and the Party more revolutionary than its machine. As early as
March the actual attitude of the workers and soldiers had in many cases become
stormily apparent, and it was widely at variance with the instructions issued
by all the parties, including the Bolsheviks."_ [**Op. Cit.**, p. 299]

Little wonder the local party groupings ignored the party machine, practising
autonomy and initiative in the face of a party machine inclined to
conservatism, inertia, bureaucracy and remoteness. This conflict between the
party machine and the principles it was based on and the needs of the
revolution and party membership was expressed continually throughout 1917:

> _"In short, the success of the revolution called for action against the
'highest circles of the party,' who, from February to October, utterly failed
to play the revolutionary role they ought to have taken in theory. The masses
themselves made the revolution, with or even against the party - this much at
least was clear to Trotsky the historian. But far from drawing the correct
conclusion, Trotsky the theorist continued to argue that the masses are
incapable of making a revolution without a leader."_ [Daniel &amp; Gabriel
Cohn-Bendit, **Op. Cit.**, p. 188]

Looking at the development of the revolution from April onwards, we are struck
by the sluggishness of the party hierarchy. At every revolutionary upsurge,
the party simply was not up to the task of responding to the needs of masses
and the local party groupings closest to them. The can be seen in June, July
and October itself. At each turn, the rank and file groupings or Lenin had to
constantly violate the principles of their own party in order to be effective.

For example, when discussing the cancellation by the central committee of a
demonstration planned for June 10th by the Petrograd Bolsheviks, the
unresponsiveness of the party hierarchy can be seen. The _"speeches by Lenin
and Zinoviev [justifying their actions] by no means satisfied the Petersburg
Committee. If anything, it appears that their explanations served to
strengthen the feeling that at best the party leadership had acted
irresponsibly and incompetently and was seriously out of touch with reality."_
Indeed, many _"blamed the Central Committee for taking so long to respond to
Military Organisation appeals for a demonstration."_ During the discussions in
late June, 1917, on whether to take direct action against the Provisional
Government there was a _"wide gulf"_ between lower organs evaluations of the
current situation and that of the Central Committee. [Rabinowitch, **Op.
Cit.**, p. 88, p. 92 and p. 129] Indeed, among the delegates from the
Bolshevik military groups, only Lashevich (an old Bolshevik) spoke in favour
of the Central Committee position and he noted that _"[f]requently it is
impossible to make out where the Bolshevik ends and the Anarchist begins."_
[quoted by Rabinowitch, **Op. Cit.**, p. 129]

In the July days, the breach between the local party groups and the central
committee increased. This spontaneous uprising was opposed to by the Bolshevik
leadership, in spite of the leading role of their own militants (along with
anarchists) in fermenting it. While calling on their own activists to restrain
the masses, the party leadership was ignored by the rank and file membership
who played an active role in the event. Sickened by being asked to play the
role of _"fireman"_, the party militants rejected party discipline in order to
maintain their credibility with the working class. Rank and file activists,
pointing to the snowballing of the movement, showed clear dissatisfaction with
the Central Committee. One argued that it _"was not aware of the latest
developments when it made its decision to oppose the movement into the
streets."_ Ultimately, the Central Committee appeal _"for restraining the
masses . . . was removed from"_ **Pravda** _"and so the party's indecision was
reflected by a large blank space on page one."_ [Rabinowitch, **Op. Cit.**, p.
150, p. 159 and p. 175] Ultimately, the indecisive nature of the leadership
can be explained by the fact it did not think it could seize state power for
itself (_"the state of popular consciousness . . . made impossible the seizure
of power by the Bolsheviks in July."_ [Trotsky, **History of the Russian
Revolution**, vol. 2, p. 81]).

The indecision of the party hierarchy did have an effect, of course. While the
anarchists at Kronstadt looked at the demonstration as the start of an
uprising, the Bolsheviks there were _"wavering indecisively in the middle"_
between them and the Left-Social Revolutionaries who saw it as a means of
applying pressure on the government. This was because they were _"hamstrung by
the indecision of the party Central Committee."_ [Rabinowitch, **Op. Cit.**,
p. 187] Little wonder so many Bolshevik party organisations developed and
protected their own autonomy and ability to act!

Significantly, one of the main Bolshevik groupings which helped organise and
support the July uprising, the Military Organisation, started their own paper
after the Central Committee had decreed after the failed revolt that neither
it, nor the Petersburg Committee, should be allowed to have one. It _"angrily
insisted on what it considered its just prerogatives"_ and in _"no uncertain
terms it affirmed its right to publish an independent newspaper and formally
protested what is referred to as 'a system of persecution and repression of an
extremely peculiar character which had begun with the election of the new
Central Committee.'"_ [Rabinowitch, **Op. Cit.**, p. 227] The Central
Committee backed down, undoubtedly due to the fact it could not enforce its
decision.

This was but one example of what the Cohn-Bendit brothers pointed to, namely
that _"five months after the Revolution and three months before the October
uprising, the masses were still governing themselves, and the Bolshevik
vanguard simply had to toe the line."_ [**Op. Cit.**, p. 186] Within that
vanguard, the central committee proved to be out of touch with the rank and
file, who ignored it rather than break with their fellow workers.

Even by October, the party machine still lagged behind the needs of the
revolution. In fact, Lenin could only impose his view by going over the head
of the Central Committee. According to Trotsky's account, _"this time he [wa]s
not satisfied with furious criticism"_ of the _"ruinous Fabianism of the
Petrograd leadership"_ and _"by way of protest he resign[ed] from the Central
Committee."_ [**History of the Russian Revolution**, vol. 3, p. 131] Trotsky
quoted Lenin as follows:

> _"I am compelled to request permission to withdraw from the Central
Committee, which I hereby do, and leave myself freedom of agitation in the
lower ranks of the party and at the party congress."_ [quoted by Trotsky,
**Op. Cit.**, p. 131]

Thus the October revolution was precipitated by a blatant violation of the
principles Lenin spent his life advocating. Indeed, if someone else other than
Lenin had done this we are sure that Lenin, and his numerous followers, would
have dismissed it as the action of a _"petty-bourgeois intellectual"_ who
cannot handle party _"discipline."_ This is itself significant, as is the fact
that he decided to appeal to the _"lower ranks"_ of the party - rather than
being "democratic" the party machine effectively blocked communication and
control from the bottom-up. Looking to the more radical party membership, he
_"could only impose his view by going over the head of his Central
Committee."_ [Daniel and Gabriel Cohn-Bendit, **Op. Cit.**, p. 187] He made
sure to send his letter of protest to _"the Petrograd and Moscow committees"_
and also made sure that _"copies fell into the hands of the more reliable
party workers of the district locals."_ By early October (and _"over the heads
of the Central Committee"_) he wrote _"directly to the Petrograd and Moscow
committees"_ calling for insurrection. He also _"appealed to a Petrograd party
conference to speak a firm word in favour of insurrection."_ [Trotsky, **Op.
Cit.**, p. 131 and p. 132]

In October, Lenin had to fight what he called _"a wavering"_ in the _"upper
circles of the party"_ which lead to a _"sort of dread of the struggle for
power, an inclination to replace this struggle with resolutions, protests and
conferences."_ [quoted by Trotsky, **Op. Cit.**, p. 132] For Trotsky, this
represented _"almost a direct pitting of the party against the Central
Committee,"_ required because _"it was a question of the fate of the
revolution"_ and so _"all other considerations fell away."_ On October 8th,
when Lenin addressed the Bolshevik delegates of the forthcoming Northern
Congress of Soviets on this subject, he did so _"personally"_ as there _"was
no party decision"_ and the _"higher institutions of the party had not yet
expressed themselves."_ [Trotsky, **Op. Cit.**, pp. 132-3 and p. 133]
Ultimately, the Central Committee came round to Lenin's position but they did
so under pressure of means at odds with the principles of the party.

This divergence between the image and reality of the Bolsheviks explains their
success. If the party had applied or had remained true to the principles of
"democratic centralism" it is doubtful that it would have played an important
role in the movement. As Alexander Rabinowitch argues, Bolshevik
organisational unity and discipline is _"vastly exaggerated"_ and, in fact,
Bolshevik success in 1917 was down to _"the party's internally relatively
democratic, tolerant, and decentralised structure and method of operation, as
well as its essentially open and mass character - in striking contrast to the
traditional Leninist model."_ In 1917, he goes on, _"subordinate party bodies
like the Petersburg Committee and the Military Organisation were permitted
considerable independence and initiative . . . Most importantly, these lower
bodies were able to tailor their tactics and appeals to suit their own
particular constituencies amid rapidly changing conditions. Vast numbers of
new members were recruited into the party . . . The newcomers included tens of
thousands of workers and soldiers . . . who knew little, if anything, about
Marxism and cared nothing about party discipline."_ For example, while the
slogan _"All Power to the Soviets"_ was _"officially withdrawn by the Sixth
[Party] Congress in late July, this change did not take hold at the local
level."_ [**The Bolsheviks Come to Power**, p. 311, p. 312 and p. 313]

It is no exaggeration to argue that if any member of a current vanguard party
acted as the Bolshevik rank and file did in 1917, they would quickly be
expelled (this probably explains why no such party has been remotely
successful since). However, this ferment from below was quickly undermined
within the party with the start of the Civil War. It is from this period when
"democratic centralism" was actually applied within the party and clarified as
an organisational principle:

> _"It was quite a turnabout since the anarchic days before the Civil War. The
Central Committee had always advocated the virtues of obedience and co-
operation; but the rank-and-filers of 1917 had cared little about such
entreaties as they did about appeals made by other higher authorities. The
wartime emergency now supplied an opportunity to expatiate on this theme at
will."_ [Service, **Op. Cit.**, p. 91]

Service stresses that _"it appears quite remarkable how quickly the
Bolsheviks, who for years had talked idly about a strict hierarchy of command
inside the party, at last began to put ideas into practice."_ [**Op. Cit.**,
p. 96]

In other words, the conversion of the Bolshevik party into a fully fledged
_"democratic centralist"_ party occurred during the degeneration of the
Revolution. This was both a consequence of the rising authoritarianism within
the party, state and society as well as one of its causes so it is quite
ironic that the model used by modern day followers of Lenin is that of the
party during the decline of the revolution, not its peak. This is not
surprising. Once in power, the Bolshevik party imposed a state capitalist
regime onto the Russian people. Can it be surprising that the party structure
which it developed to aid this process was also based on bourgeois attitudes
and organisation? The party model advocated by Lenin may not have been very
effective during a revolution but it was exceedingly effective at promoting
hierarchy and authority in the post-revolutionary regime. It simply replaced
the old ruling elite with another, made up of members of the radical
intelligentsia and the odd ex-worker or ex-peasant.

This was due to the hierarchical and top-down nature of the party Lenin had
created. While the party base was largely working class, the leadership was
not. Full-time revolutionaries, they were either middle-class intellectuals or
(occasionally) ex-workers and (even rarer) ex-peasants who had left their
class to become part of the party machine. Even the delegates at party
congresses did not truly reflect the class basis of the party membership. For
example, the number of delegates was still dominated by white-collar or others
(59.1% to 40.9%) at the sixth party congress at the end of July 1917. [Cliff,
**Lenin**, vol. 2, p. 160] So while the party gathered more working class
members in 1917, it cannot be said that this was reflected in the party
leadership which remained dominated by non-working class elements. Rather than
being a genuine working class organisation, the Bolshevik party was a
hierarchical group headed by non-working class elements whose working class
base could not effectively control them even during the revolution in 1917. It
was only effective because these newly joined and radicalised working class
members ignored their own party structure and its defining ideology.

After the revolution, the Bolsheviks saw their membership start to decrease.
Significantly, _"the decline in numbers which occurred from early 1918
onwards"_ started happening _"contrary to what is usually assumed, some months
before the Central Committee's decree in midsummer that the party should be
purged of its 'undesirable' elements."_ These lost members reflected two
things. Firstly, the general decline in the size of the industrial working
class. This meant that the radicalised new elements from the countryside which
had flocked to the Bolsheviks in 1917 returned home. Secondly, the loss of
popular support due to the realities of the Bolshevik regime. This can be seen
from the fact that while the Bolsheviks were losing members, the Left SRs
almost doubled in size to 100,000 (the Mensheviks claimed to have a similar
number). Rather than non-proletarians leaving, _"[i]t is more probable by far
that it was industrial workers who were leaving in droves. After all, it would
have been strange if the growing unpopularity of Sovnarkom in factory milieu
had been confined exclusively to non-Bolsheviks."_ Unsurprisingly, given its
position in power, _"[a]s the proportion of working-class members declined, so
that of entrants from the middle-class rose; the steady drift towards a party
in which industrial workers no longer numerically predominated was under
way."_ By late 1918 membership started to increase again but _"[m]ost
newcomers were not of working-class origin . . . the proportion of Bolsheviks
of working-class origin fell from 57 per cent at the year's beginning to 48
per cent at the end."_ It should be noted that it was not specified how many
classed as having working-class origin were still employed in working-class
jobs. [Robert Service, **Op. Cit.**, p. 70, pp. 70-1 and p. 90] A new ruling
elite was thus born, thanks to the way vanguard parties are structured and the
application of vanguardist principles which had previously been ignored.

In summary, the experience of the Russian Revolution does not, in fact, show
the validity of the "vanguard" model. The Bolshevik party in 1917 played a
leading role in the revolution only insofar as its members violated its own
organisational principles (Lenin included). Faced with a real revolution and
an influx of more radical new members, the party had to practice anarchist
ideas of autonomy, local initiative and the ignoring of central orders which
had no bearing to reality on the ground. When the party did try to apply the
top-down and hierarchical principles of "democratic centralism" it failed to
adjust to the needs of the moment. Moreover, when these principles were
finally applied they helped ensure the degeneration of the revolution. This
was to be expected, given the nature of vanguardism and the Bolshevik vision
of socialism.

[‹ H.4 Didn't Engels refute anarchism in "On Authority"?](secH4.md "Go to
previous page" ) [up](secHcon.md "Go to parent page" ) [H.6 Why did the
Russian Revolution fail? ›](secH6.md "Go to next page" )

