#ifndef _VOBJECTS_H
#define _VOBJECTS_H

#include "VPoly.h"

#ifdef VObjects_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

typedef struct {
	char     *name;				/* object name */
	VPoint    xaxis, yaxis, zaxis;
	VPoint    center;			/* average of all the object's points */
	double    extent;			/* distance from center to most distant point */
	int       numPolys;			/* polygon count */
	VPolygon **polygon;			/* pointer to array of polygon pointers */
	unsigned short *order;		/* 3-D relative polygon depth ordering */
} VObject;

EXTERN int VComputeObjectAspect (VObject * obj, VPoint * loc);

/**
 * Determine if an object should be ordered. Objects that are not
 * made of entirely the same color, or that have colored back-sides
 * probably should be ordered.
 */
EXTERN int VObjectNeedsOrdering (VObject * obj);

EXTERN void VComputePolygonOrdering (VObject * obj);

EXTERN void VDestroyObject (VObject *obj);

EXTERN VObject *VCopyObject (VObject *);

EXTERN VObject * VExtrudeObject(VObject * obj, VPoint * vec);

EXTERN VObject *VReadObject (FILE * f);

EXTERN VObject *VReadDepthCueuedObject (FILE * f, int is_depth_cueing);

EXTERN int VWriteObject (FILE *, VObject *);

EXTERN void VSetReadObjectScale (VPoint *);

EXTERN void VComputeObjectExtent (VObject *);

/*
 *  DXF to V-library (obv) file converter
 */

EXTERN VObject * VReadDXFObject(FILE *f);

EXTERN VObject * VReadDepthCueuedDXFObject(FILE *f, int is_depth_cueing);

#undef EXTERN
#endif
