#region License
//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2009 the Open Toolkit library.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
#endregion

namespace OpenTK.Graphics.ES10
{
    using System;
    using System.Text;
    using System.Runtime.InteropServices;
    #pragma warning disable 3019
    #pragma warning disable 1591
    #pragma warning disable 1572
    #pragma warning disable 1573

    partial class GL
    {

        
        /// <summary>
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTURE, where i ranges from 0 to the larger of (GL_MAX_TEXTURE_COORDS - 1) and (GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS - 1). The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glActiveTexture")]
        public static 
        void ActiveTexture(OpenTK.Graphics.ES10.All texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glActiveTexture((OpenTK.Graphics.ES10.All)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the alpha test function
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the alpha comparison function. Symbolic constants GL_NEVER, GL_LESS, GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value that incoming alpha values are compared to. This value is clamped to the range [0,1], where 0 represents the lowest possible alpha value and 1 the highest possible value. The initial reference value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glAlphaFunc")]
        public static 
        void AlphaFunc(OpenTK.Graphics.ES10.All func, Single @ref)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glAlphaFunc((OpenTK.Graphics.ES10.All)func, (Single)@ref);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glAlphaFuncx")]
        public static 
        void AlphaFuncx(OpenTK.Graphics.ES10.All func, int @ref)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glAlphaFuncx((OpenTK.Graphics.ES10.All)func, (int)@ref);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named texture to a texturing target
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the texture is bound. Must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="texture">
        /// <para>
        /// Specifies the name of a texture.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glBindTexture")]
        public static 
        void BindTexture(OpenTK.Graphics.ES10.All target, Int32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindTexture((OpenTK.Graphics.ES10.All)target, (UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named texture to a texturing target
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the texture is bound. Must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="texture">
        /// <para>
        /// Specifies the name of a texture.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glBindTexture")]
        public static 
        void BindTexture(OpenTK.Graphics.ES10.All target, UInt32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindTexture((OpenTK.Graphics.ES10.All)target, (UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify pixel arithmetic
        /// </summary>
        /// <param name="sfactor">
        /// <para>
        /// Specifies how the red, green, blue, and alpha source blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA, GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, GL_ONE_MINUS_CONSTANT_ALPHA, and GL_SRC_ALPHA_SATURATE. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dfactor">
        /// <para>
        /// Specifies how the red, green, blue, and alpha destination blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glBlendFunc")]
        public static 
        void BlendFunc(OpenTK.Graphics.ES10.All sfactor, OpenTK.Graphics.ES10.All dfactor)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBlendFunc((OpenTK.Graphics.ES10.All)sfactor, (OpenTK.Graphics.ES10.All)dfactor);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Clear buffers to preset values
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Bitwise OR of masks that indicate the buffers to be cleared. The four masks are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT, GL_ACCUM_BUFFER_BIT, and GL_STENCIL_BUFFER_BIT.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glClear")]
        public static 
        void Clear(Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClear((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Clear buffers to preset values
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Bitwise OR of masks that indicate the buffers to be cleared. The four masks are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT, GL_ACCUM_BUFFER_BIT, and GL_STENCIL_BUFFER_BIT.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glClear")]
        public static 
        void Clear(UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClear((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify clear values for the color buffers
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify the red, green, blue, and alpha values used when the color buffers are cleared. The initial values are all 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glClearColor")]
        public static 
        void ClearColor(Single red, Single green, Single blue, Single alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearColor((Single)red, (Single)green, (Single)blue, (Single)alpha);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glClearColorx")]
        public static 
        void ClearColorx(int red, int green, int blue, int alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearColorx((int)red, (int)green, (int)blue, (int)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the clear value for the depth buffer
        /// </summary>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth value used when the depth buffer is cleared. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glClearDepthf")]
        public static 
        void ClearDepth(Single depth)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearDepthf((Single)depth);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glClearDepthx")]
        public static 
        void ClearDepthx(int depth)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearDepthx((int)depth);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the clear value for the stencil buffer
        /// </summary>
        /// <param name="s">
        /// <para>
        /// Specifies the index used when the stencil buffer is cleared. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glClearStencil")]
        public static 
        void ClearStencil(Int32 s)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearStencil((Int32)s);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTURE, where i ranges from 0 to the value of GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value. The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glClientActiveTexture")]
        public static 
        void ClientActiveTexture(OpenTK.Graphics.ES10.All texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClientActiveTexture((OpenTK.Graphics.ES10.All)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glColor4f")]
        public static 
        void Color4(Single red, Single green, Single blue, Single alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColor4f((Single)red, (Single)green, (Single)blue, (Single)alpha);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glColor4x")]
        public static 
        void Color4x(int red, int green, int blue, int alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColor4x((int)red, (int)green, (int)blue, (int)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable and disable writing of frame buffer color components
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify whether red, green, blue, and alpha can or cannot be written into the frame buffer. The initial values are all GL_TRUE, indicating that the color components can be written.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glColorMask")]
        public static 
        void ColorMask(bool red, bool green, bool blue, bool alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColorMask((bool)red, (bool)green, (bool)blue, (bool)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T3)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES10.All target, Int32 level, OpenTK.Graphics.ES10.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T7 data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (OpenTK.Graphics.ES10.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T7)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES10.All target, Int32 level, OpenTK.Graphics.ES10.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,,] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (OpenTK.Graphics.ES10.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES10.All target, Int32 level, OpenTK.Graphics.ES10.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (OpenTK.Graphics.ES10.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES10.All target, Int32 level, OpenTK.Graphics.ES10.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (OpenTK.Graphics.ES10.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D(OpenTK.Graphics.ES10.All target, Int32 level, OpenTK.Graphics.ES10.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, IntPtr data)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (OpenTK.Graphics.ES10.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, Int32 imageSize, [InAttribute, OutAttribute] ref T8 data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T8)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, Int32 imageSize, [InAttribute, OutAttribute] T8[,,] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, Int32 imageSize, [InAttribute, OutAttribute] T8[,] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, Int32 imageSize, [InAttribute, OutAttribute] T8[] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, Int32 imageSize, IntPtr data)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (Int32)imageSize, (IntPtr)data);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Copy pixels into a 2D texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the internal format of the texture. Must be one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_RGB, GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. Must be 0 or 2 sup n + 2 ( border ) for some integer .
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. Must be 0 or 2 sup m + 2 ( border ) for some integer .
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCopyTexImage2D")]
        public static 
        void CopyTexImage2D(OpenTK.Graphics.ES10.All target, Int32 level, OpenTK.Graphics.ES10.All internalformat, Int32 x, Int32 y, Int32 width, Int32 height, Int32 border)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCopyTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (OpenTK.Graphics.ES10.All)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height, (Int32)border);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Copy a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCopyTexSubImage2D")]
        public static 
        void CopyTexSubImage2D(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCopyTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify whether front- or back-facing facets can be culled
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies whether front- or back-facing facets are candidates for culling. Symbolic constants GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK are accepted. The initial value is GL_BACK.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glCullFace")]
        public static 
        void CullFace(OpenTK.Graphics.ES10.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCullFace((OpenTK.Graphics.ES10.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDeleteTextures")]
        public static 
        unsafe void DeleteTextures(Int32 n, Int32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, Int32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, ref Int32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, ref UInt32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDeleteTextures")]
        public static 
        unsafe void DeleteTextures(Int32 n, UInt32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, UInt32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value used for depth buffer comparisons
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the depth comparison function. Symbolic constants GL_NEVER, GL_LESS, GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The initial value is GL_LESS.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDepthFunc")]
        public static 
        void DepthFunc(OpenTK.Graphics.ES10.All func)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthFunc((OpenTK.Graphics.ES10.All)func);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable writing into the depth buffer
        /// </summary>
        /// <param name="flag">
        /// <para>
        /// Specifies whether the depth buffer is enabled for writing. If flag is GL_FALSE, depth buffer writing is disabled. Otherwise, it is enabled. Initially, depth buffer writing is enabled.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDepthMask")]
        public static 
        void DepthMask(bool flag)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthMask((bool)flag);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify mapping of depth values from normalized device coordinates to window coordinates
        /// </summary>
        /// <param name="nearVal">
        /// <para>
        /// Specifies the mapping of the near clipping plane to window coordinates. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="farVal">
        /// <para>
        /// Specifies the mapping of the far clipping plane to window coordinates. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDepthRangef")]
        public static 
        void DepthRange(Single zNear, Single zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthRangef((Single)zNear, (Single)zFar);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDepthRangex")]
        public static 
        void DepthRangex(int zNear, int zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthRangex((int)zNear, (int)zFar);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDisable")]
        public static 
        void Disable(OpenTK.Graphics.ES10.All cap)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisable((OpenTK.Graphics.ES10.All)cap);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDisableClientState")]
        public static 
        void DisableClientState(OpenTK.Graphics.ES10.All array)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisableClientState((OpenTK.Graphics.ES10.All)array);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="first">
        /// <para>
        /// Specifies the starting index in the enabled arrays.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of indices to be rendered.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDrawArrays")]
        public static 
        void DrawArrays(OpenTK.Graphics.ES10.All mode, Int32 first, Int32 count)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDrawArrays((OpenTK.Graphics.ES10.All)mode, (Int32)first, (Int32)count);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES10.All mode, Int32 count, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] ref T3 indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES10.All)mode, (Int32)count, (OpenTK.Graphics.ES10.All)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                indices = (T3)indices_ptr.Target;
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES10.All mode, Int32 count, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T3[,,] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES10.All)mode, (Int32)count, (OpenTK.Graphics.ES10.All)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES10.All mode, Int32 count, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T3[,] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES10.All)mode, (Int32)count, (OpenTK.Graphics.ES10.All)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES10.All mode, Int32 count, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T3[] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES10.All)mode, (Int32)count, (OpenTK.Graphics.ES10.All)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements(OpenTK.Graphics.ES10.All mode, Int32 count, OpenTK.Graphics.ES10.All type, IntPtr indices)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDrawElements((OpenTK.Graphics.ES10.All)mode, (Int32)count, (OpenTK.Graphics.ES10.All)type, (IntPtr)indices);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable server-side GL capabilities
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies a symbolic constant indicating a GL capability.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glEnable")]
        public static 
        void Enable(OpenTK.Graphics.ES10.All cap)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnable((OpenTK.Graphics.ES10.All)cap);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable client-side capability
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies the capability to enable. Symbolic constants GL_COLOR_ARRAY, GL_EDGE_FLAG_ARRAY, GL_FOG_COORD_ARRAY, GL_INDEX_ARRAY, GL_NORMAL_ARRAY, GL_SECONDARY_COLOR_ARRAY, GL_TEXTURE_COORD_ARRAY, and GL_VERTEX_ARRAY are accepted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glEnableClientState")]
        public static 
        void EnableClientState(OpenTK.Graphics.ES10.All array)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnableClientState((OpenTK.Graphics.ES10.All)array);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Block until all GL execution is complete
        /// </summary>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFinish")]
        public static 
        void Finish()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFinish();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Force execution of GL commands in finite time
        /// </summary>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFlush")]
        public static 
        void Flush()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFlush();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFogf")]
        public static 
        void Fog(OpenTK.Graphics.ES10.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFogf((OpenTK.Graphics.ES10.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFogfv")]
        public static 
        unsafe void Fog(OpenTK.Graphics.ES10.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFogfv((OpenTK.Graphics.ES10.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFogfv")]
        public static 
        void Fog(OpenTK.Graphics.ES10.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glFogfv((OpenTK.Graphics.ES10.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFogx")]
        public static 
        void Fogx(OpenTK.Graphics.ES10.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFogx((OpenTK.Graphics.ES10.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFogxv")]
        public static 
        unsafe void Fogx(OpenTK.Graphics.ES10.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFogxv((OpenTK.Graphics.ES10.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFogxv")]
        public static 
        void Fogx(OpenTK.Graphics.ES10.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glFogxv((OpenTK.Graphics.ES10.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define front- and back-facing polygons
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies the orientation of front-facing polygons. GL_CW and GL_CCW are accepted. The initial value is GL_CCW.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFrontFace")]
        public static 
        void FrontFace(OpenTK.Graphics.ES10.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFrontFace((OpenTK.Graphics.ES10.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix by a perspective matrix
        /// </summary>
        /// <param name="left">
        /// <para>
        /// Specify the coordinates for the left and right vertical clipping planes.
        /// </para>
        /// </param>
        /// <param name="bottom">
        /// <para>
        /// Specify the coordinates for the bottom and top horizontal clipping planes.
        /// </para>
        /// </param>
        /// <param name="nearVal">
        /// <para>
        /// Specify the distances to the near and far depth clipping planes. Both distances must be positive.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFrustumf")]
        public static 
        void Frustum(Single left, Single right, Single bottom, Single top, Single zNear, Single zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFrustumf((Single)left, (Single)right, (Single)bottom, (Single)top, (Single)zNear, (Single)zFar);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glFrustumx")]
        public static 
        void Frustumx(int left, int right, int bottom, int top, int zNear, int zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFrustumx((int)left, (int)right, (int)bottom, (int)top, (int)zNear, (int)zFar);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGenTextures")]
        public static 
        unsafe void GenTextures(Int32 n, Int32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, Int32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, ref Int32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, ref UInt32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGenTextures")]
        public static 
        unsafe void GenTextures(Int32 n, UInt32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, UInt32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return error information
        /// </summary>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGetError")]
        public static 
        OpenTK.Graphics.ES10.All GetError()
        {
            return Delegates.glGetError();
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGetIntegerv")]
        public static 
        unsafe void GetInteger(OpenTK.Graphics.ES10.All pname, Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetIntegerv((OpenTK.Graphics.ES10.All)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGetIntegerv")]
        public static 
        void GetInteger(OpenTK.Graphics.ES10.All pname, Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetIntegerv((OpenTK.Graphics.ES10.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGetIntegerv")]
        public static 
        void GetInteger(OpenTK.Graphics.ES10.All pname, ref Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetIntegerv((OpenTK.Graphics.ES10.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a string describing the current GL connection
        /// </summary>
        /// <param name="name">
        /// <para>
        /// Specifies a symbolic constant, one of GL_VENDOR, GL_RENDERER, GL_VERSION, GL_SHADING_LANGUAGE_VERSION, or GL_EXTENSIONS.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glGetString")]
        public static 
        unsafe System.String GetString(OpenTK.Graphics.ES10.All name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe { return new string((sbyte*)Delegates.glGetString((OpenTK.Graphics.ES10.All)name)); }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify implementation-specific hints
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a symbolic constant indicating the behavior to be controlled. GL_FOG_HINT, GL_GENERATE_MIPMAP_HINT, GL_LINE_SMOOTH_HINT, GL_PERSPECTIVE_CORRECTION_HINT, GL_POINT_SMOOTH_HINT, GL_POLYGON_SMOOTH_HINT, GL_TEXTURE_COMPRESSION_HINT, and GL_FRAGMENT_SHADER_DERIVATIVE_HINT are accepted.
        /// </para>
        /// </param>
        /// <param name="mode">
        /// <para>
        /// Specifies a symbolic constant indicating the desired behavior. GL_FASTEST, GL_NICEST, and GL_DONT_CARE are accepted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glHint")]
        public static 
        void Hint(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glHint((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set light source parameters
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light. The number of lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT , where i ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued light source parameter for light. GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter pname of light source light will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightf")]
        public static 
        void Light(OpenTK.Graphics.ES10.All light, OpenTK.Graphics.ES10.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightf((OpenTK.Graphics.ES10.All)light, (OpenTK.Graphics.ES10.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set light source parameters
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light. The number of lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT , where i ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued light source parameter for light. GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter pname of light source light will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightfv")]
        public static 
        unsafe void Light(OpenTK.Graphics.ES10.All light, OpenTK.Graphics.ES10.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightfv((OpenTK.Graphics.ES10.All)light, (OpenTK.Graphics.ES10.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set light source parameters
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light. The number of lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT , where i ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued light source parameter for light. GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter pname of light source light will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightfv")]
        public static 
        void Light(OpenTK.Graphics.ES10.All light, OpenTK.Graphics.ES10.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glLightfv((OpenTK.Graphics.ES10.All)light, (OpenTK.Graphics.ES10.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the lighting model parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued lighting model parameter. GL_LIGHT_MODEL_LOCAL_VIEWER, GL_LIGHT_MODEL_COLOR_CONTROL, and GL_LIGHT_MODEL_TWO_SIDE are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that param will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightModelf")]
        public static 
        void LightModel(OpenTK.Graphics.ES10.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightModelf((OpenTK.Graphics.ES10.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the lighting model parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued lighting model parameter. GL_LIGHT_MODEL_LOCAL_VIEWER, GL_LIGHT_MODEL_COLOR_CONTROL, and GL_LIGHT_MODEL_TWO_SIDE are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that param will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightModelfv")]
        public static 
        unsafe void LightModel(OpenTK.Graphics.ES10.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightModelfv((OpenTK.Graphics.ES10.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the lighting model parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued lighting model parameter. GL_LIGHT_MODEL_LOCAL_VIEWER, GL_LIGHT_MODEL_COLOR_CONTROL, and GL_LIGHT_MODEL_TWO_SIDE are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that param will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightModelfv")]
        public static 
        void LightModel(OpenTK.Graphics.ES10.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glLightModelfv((OpenTK.Graphics.ES10.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightModelx")]
        public static 
        void LightModelx(OpenTK.Graphics.ES10.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightModelx((OpenTK.Graphics.ES10.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightModelxv")]
        public static 
        unsafe void LightModelx(OpenTK.Graphics.ES10.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightModelxv((OpenTK.Graphics.ES10.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightModelxv")]
        public static 
        void LightModelx(OpenTK.Graphics.ES10.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glLightModelxv((OpenTK.Graphics.ES10.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightx")]
        public static 
        void Lightx(OpenTK.Graphics.ES10.All light, OpenTK.Graphics.ES10.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightx((OpenTK.Graphics.ES10.All)light, (OpenTK.Graphics.ES10.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightxv")]
        public static 
        unsafe void Lightx(OpenTK.Graphics.ES10.All light, OpenTK.Graphics.ES10.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightxv((OpenTK.Graphics.ES10.All)light, (OpenTK.Graphics.ES10.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLightxv")]
        public static 
        void Lightx(OpenTK.Graphics.ES10.All light, OpenTK.Graphics.ES10.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glLightxv((OpenTK.Graphics.ES10.All)light, (OpenTK.Graphics.ES10.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the width of rasterized lines
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specifies the width of rasterized lines. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLineWidth")]
        public static 
        void LineWidth(Single width)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLineWidth((Single)width);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLineWidthx")]
        public static 
        void LineWidthx(int width)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLineWidthx((int)width);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replace the current matrix with the identity matrix
        /// </summary>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLoadIdentity")]
        public static 
        void LoadIdentity()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLoadIdentity();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replace the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLoadMatrixf")]
        public static 
        void LoadMatrix(ref Single m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glLoadMatrixf((Single*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replace the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLoadMatrixf")]
        public static 
        unsafe void LoadMatrix(Single* m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLoadMatrixf((Single*)m);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replace the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLoadMatrixf")]
        public static 
        void LoadMatrix(Single[] m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glLoadMatrixf((Single*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLoadMatrixx")]
        public static 
        unsafe void LoadMatrixx(int* m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLoadMatrixx((int*)m);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLoadMatrixx")]
        public static 
        void LoadMatrixx(int[] m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* m_ptr = m)
                {
                    Delegates.glLoadMatrixx((int*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLoadMatrixx")]
        public static 
        void LoadMatrixx(ref int m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* m_ptr = &m)
                {
                    Delegates.glLoadMatrixx((int*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a logical pixel operation for color index rendering
        /// </summary>
        /// <param name="opcode">
        /// <para>
        /// Specifies a symbolic constant that selects a logical operation. The following symbols are accepted: GL_CLEAR, GL_SET, GL_COPY, GL_COPY_INVERTED, GL_NOOP, GL_INVERT, GL_AND, GL_NAND, GL_OR, GL_NOR, GL_XOR, GL_EQUIV, GL_AND_REVERSE, GL_AND_INVERTED, GL_OR_REVERSE, and GL_OR_INVERTED. The initial value is GL_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glLogicOp")]
        public static 
        void LogicOp(OpenTK.Graphics.ES10.All opcode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLogicOp((OpenTK.Graphics.ES10.All)opcode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify material parameters for the lighting model
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which face or faces are being updated. Must be one of GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the single-valued material parameter of the face or faces that is being updated. Must be GL_SHININESS.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter GL_SHININESS will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMaterialf")]
        public static 
        void Material(OpenTK.Graphics.ES10.All face, OpenTK.Graphics.ES10.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMaterialf((OpenTK.Graphics.ES10.All)face, (OpenTK.Graphics.ES10.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify material parameters for the lighting model
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which face or faces are being updated. Must be one of GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the single-valued material parameter of the face or faces that is being updated. Must be GL_SHININESS.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter GL_SHININESS will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMaterialfv")]
        public static 
        unsafe void Material(OpenTK.Graphics.ES10.All face, OpenTK.Graphics.ES10.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMaterialfv((OpenTK.Graphics.ES10.All)face, (OpenTK.Graphics.ES10.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify material parameters for the lighting model
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which face or faces are being updated. Must be one of GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the single-valued material parameter of the face or faces that is being updated. Must be GL_SHININESS.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter GL_SHININESS will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMaterialfv")]
        public static 
        void Material(OpenTK.Graphics.ES10.All face, OpenTK.Graphics.ES10.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glMaterialfv((OpenTK.Graphics.ES10.All)face, (OpenTK.Graphics.ES10.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMaterialx")]
        public static 
        void Materialx(OpenTK.Graphics.ES10.All face, OpenTK.Graphics.ES10.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMaterialx((OpenTK.Graphics.ES10.All)face, (OpenTK.Graphics.ES10.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMaterialxv")]
        public static 
        unsafe void Materialx(OpenTK.Graphics.ES10.All face, OpenTK.Graphics.ES10.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMaterialxv((OpenTK.Graphics.ES10.All)face, (OpenTK.Graphics.ES10.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMaterialxv")]
        public static 
        void Materialx(OpenTK.Graphics.ES10.All face, OpenTK.Graphics.ES10.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glMaterialxv((OpenTK.Graphics.ES10.All)face, (OpenTK.Graphics.ES10.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify which matrix is the current matrix
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies which matrix stack is the target for subsequent matrix operations. Three values are accepted: GL_MODELVIEW, GL_PROJECTION, and GL_TEXTURE. The initial value is GL_MODELVIEW. Additionally, if the ARB_imaging extension is supported, GL_COLOR is also accepted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMatrixMode")]
        public static 
        void MatrixMode(OpenTK.Graphics.ES10.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMatrixMode((OpenTK.Graphics.ES10.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMultiTexCoord4f")]
        public static 
        void MultiTexCoord4(OpenTK.Graphics.ES10.All target, Single s, Single t, Single r, Single q)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMultiTexCoord4f((OpenTK.Graphics.ES10.All)target, (Single)s, (Single)t, (Single)r, (Single)q);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMultiTexCoord4x")]
        public static 
        void MultiTexCoord4x(OpenTK.Graphics.ES10.All target, int s, int t, int r, int q)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMultiTexCoord4x((OpenTK.Graphics.ES10.All)target, (int)s, (int)t, (int)r, (int)q);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMultMatrixf")]
        public static 
        void MultMatrix(ref Single m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glMultMatrixf((Single*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMultMatrixf")]
        public static 
        unsafe void MultMatrix(Single* m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMultMatrixf((Single*)m);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMultMatrixf")]
        public static 
        void MultMatrix(Single[] m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glMultMatrixf((Single*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMultMatrixx")]
        public static 
        unsafe void MultMatrixx(int* m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMultMatrixx((int*)m);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMultMatrixx")]
        public static 
        void MultMatrixx(int[] m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* m_ptr = m)
                {
                    Delegates.glMultMatrixx((int*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glMultMatrixx")]
        public static 
        void MultMatrixx(ref int m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* m_ptr = &m)
                {
                    Delegates.glMultMatrixx((int*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the current normal vector
        /// </summary>
        /// <param name="nx">
        /// <para>
        /// Specify the , , and coordinates of the new current normal. The initial value of the current normal is the unit vector, (0, 0, 1).
        /// </para>
        /// <para>
        /// 
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glNormal3f")]
        public static 
        void Normal3(Single nx, Single ny, Single nz)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glNormal3f((Single)nx, (Single)ny, (Single)nz);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glNormal3x")]
        public static 
        void Normal3x(int nx, int ny, int nz)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glNormal3x((int)nx, (int)ny, (int)nz);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer<T2>(OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] ref T2 pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glNormalPointer((OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T2)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer<T2>(OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T2[,,] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glNormalPointer((OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer<T2>(OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T2[,] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glNormalPointer((OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer<T2>(OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T2[] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glNormalPointer((OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer(OpenTK.Graphics.ES10.All type, Int32 stride, IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glNormalPointer((OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix with an orthographic matrix
        /// </summary>
        /// <param name="left">
        /// <para>
        /// Specify the coordinates for the left and right vertical clipping planes.
        /// </para>
        /// </param>
        /// <param name="bottom">
        /// <para>
        /// Specify the coordinates for the bottom and top horizontal clipping planes.
        /// </para>
        /// </param>
        /// <param name="nearVal">
        /// <para>
        /// Specify the distances to the nearer and farther depth clipping planes. These values are negative if the plane is to be behind the viewer.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glOrthof")]
        public static 
        void Ortho(Single left, Single right, Single bottom, Single top, Single zNear, Single zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glOrthof((Single)left, (Single)right, (Single)bottom, (Single)top, (Single)zNear, (Single)zFar);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glOrthox")]
        public static 
        void Orthox(int left, int right, int bottom, int top, int zNear, int zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glOrthox((int)left, (int)right, (int)bottom, (int)top, (int)zNear, (int)zFar);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set pixel storage modes
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the parameter to be set. Six values affect the packing of pixel data into memory: GL_PACK_SWAP_BYTES, GL_PACK_LSB_FIRST, GL_PACK_ROW_LENGTH, GL_PACK_IMAGE_HEIGHT, GL_PACK_SKIP_PIXELS, GL_PACK_SKIP_ROWS, GL_PACK_SKIP_IMAGES, and GL_PACK_ALIGNMENT. Six more affect the unpacking of pixel data from memory: GL_UNPACK_SWAP_BYTES, GL_UNPACK_LSB_FIRST, GL_UNPACK_ROW_LENGTH, GL_UNPACK_IMAGE_HEIGHT, GL_UNPACK_SKIP_PIXELS, GL_UNPACK_SKIP_ROWS, GL_UNPACK_SKIP_IMAGES, and GL_UNPACK_ALIGNMENT.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname is set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glPixelStorei")]
        public static 
        void PixelStore(OpenTK.Graphics.ES10.All pname, Int32 param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPixelStorei((OpenTK.Graphics.ES10.All)pname, (Int32)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the diameter of rasterized points
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the diameter of rasterized points. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glPointSize")]
        public static 
        void PointSize(Single size)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPointSize((Single)size);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glPointSizex")]
        public static 
        void PointSizex(int size)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPointSizex((int)size);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the scale and units used to calculate depth values
        /// </summary>
        /// <param name="factor">
        /// <para>
        /// Specifies a scale factor that is used to create a variable depth offset for each polygon. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="units">
        /// <para>
        /// Is multiplied by an implementation-specific value to create a constant depth offset. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glPolygonOffset")]
        public static 
        void PolygonOffset(Single factor, Single units)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPolygonOffset((Single)factor, (Single)units);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glPolygonOffsetx")]
        public static 
        void PolygonOffsetx(int factor, int units)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPolygonOffsetx((int)factor, (int)units);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glPopMatrix")]
        public static 
        void PopMatrix()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPopMatrix();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Push and pop the current matrix stack
        /// </summary>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glPushMatrix")]
        public static 
        void PushMatrix()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPushMatrix();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] ref T6 pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T6)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T6[,,] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T6[,] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T6[] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix by a rotation matrix
        /// </summary>
        /// <param name="angle">
        /// <para>
        /// Specifies the angle of rotation, in degrees.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the x, y, and z coordinates of a vector, respectively.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glRotatef")]
        public static 
        void Rotate(Single angle, Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glRotatef((Single)angle, (Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glRotatex")]
        public static 
        void Rotatex(int angle, int x, int y, int z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glRotatex((int)angle, (int)x, (int)y, (int)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify multisample coverage parameters
        /// </summary>
        /// <param name="value">
        /// <para>
        /// Specify a single floating-point sample coverage value. The value is clamped to the range [0 ,1]. The initial value is 1.0.
        /// </para>
        /// </param>
        /// <param name="invert">
        /// <para>
        /// Specify a single boolean value representing if the coverage masks should be inverted. GL_TRUE and GL_FALSE are accepted. The initial value is GL_FALSE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glSampleCoverage")]
        public static 
        void SampleCoverage(Single value, bool invert)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glSampleCoverage((Single)value, (bool)invert);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glSampleCoveragex")]
        public static 
        void SampleCoveragex(int value, bool invert)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glSampleCoveragex((int)value, (bool)invert);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix by a general scaling matrix
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify scale factors along the x, y, and z axes, respectively.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glScalef")]
        public static 
        void Scale(Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glScalef((Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glScalex")]
        public static 
        void Scalex(int x, int y, int z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glScalex((int)x, (int)y, (int)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define the scissor box
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the lower left corner of the scissor box. Initially (0, 0).
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the width and height of the scissor box. When a GL context is first attached to a window, width and height are set to the dimensions of that window.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glScissor")]
        public static 
        void Scissor(Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glScissor((Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Select flat or smooth shading
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies a symbolic value representing a shading technique. Accepted values are GL_FLAT and GL_SMOOTH. The initial value is GL_SMOOTH.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glShadeModel")]
        public static 
        void ShadeModel(OpenTK.Graphics.ES10.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glShadeModel((OpenTK.Graphics.ES10.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back function and reference value for stencil testing
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glStencilFunc")]
        public static 
        void StencilFunc(OpenTK.Graphics.ES10.All func, Int32 @ref, Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilFunc((OpenTK.Graphics.ES10.All)func, (Int32)@ref, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back function and reference value for stencil testing
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glStencilFunc")]
        public static 
        void StencilFunc(OpenTK.Graphics.ES10.All func, Int32 @ref, UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilFunc((OpenTK.Graphics.ES10.All)func, (Int32)@ref, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Control the front and back writing of individual bits in the stencil planes
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Specifies a bit mask to enable and disable writing of individual bits in the stencil planes. Initially, the mask is all 1's.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glStencilMask")]
        public static 
        void StencilMask(Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilMask((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Control the front and back writing of individual bits in the stencil planes
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Specifies a bit mask to enable and disable writing of individual bits in the stencil planes. Initially, the mask is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glStencilMask")]
        public static 
        void StencilMask(UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilMask((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back stencil test actions
        /// </summary>
        /// <param name="sfail">
        /// <para>
        /// Specifies the action to take when the stencil test fails. Eight symbolic constants are accepted: GL_KEEP, GL_ZERO, GL_REPLACE, GL_INCR, GL_INCR_WRAP, GL_DECR, GL_DECR_WRAP, and GL_INVERT. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        /// <param name="dpfail">
        /// <para>
        /// Specifies the stencil action when the stencil test passes, but the depth test fails. dpfail accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        /// <param name="dppass">
        /// <para>
        /// Specifies the stencil action when both the stencil test and the depth test pass, or when the stencil test passes and either there is no depth buffer or depth testing is not enabled. dppass accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glStencilOp")]
        public static 
        void StencilOp(OpenTK.Graphics.ES10.All fail, OpenTK.Graphics.ES10.All zfail, OpenTK.Graphics.ES10.All zpass)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilOp((OpenTK.Graphics.ES10.All)fail, (OpenTK.Graphics.ES10.All)zfail, (OpenTK.Graphics.ES10.All)zpass);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T3)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexEnvf")]
        public static 
        void TexEnv(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvf((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexEnvfv")]
        public static 
        unsafe void TexEnv(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvfv((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexEnvfv")]
        public static 
        void TexEnv(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glTexEnvfv((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexEnvx")]
        public static 
        void TexEnvx(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvx((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexEnvxv")]
        public static 
        unsafe void TexEnvx(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvxv((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexEnvxv")]
        public static 
        void TexEnvx(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glTexEnvxv((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] ref T8 pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T8)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T8[,,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T8[,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T8[] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D(OpenTK.Graphics.ES10.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexParameterf")]
        public static 
        void TexParameter(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameterf((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexParameterx")]
        public static 
        void TexParameterx(OpenTK.Graphics.ES10.All target, OpenTK.Graphics.ES10.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameterx((OpenTK.Graphics.ES10.All)target, (OpenTK.Graphics.ES10.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] ref T8 pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T8)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T8[,,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T8[,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, [InAttribute, OutAttribute] T8[] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D(OpenTK.Graphics.ES10.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES10.All format, OpenTK.Graphics.ES10.All type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexSubImage2D((OpenTK.Graphics.ES10.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES10.All)format, (OpenTK.Graphics.ES10.All)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix by a translation matrix
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the x, y, and z coordinates of a translation vector.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTranslatef")]
        public static 
        void Translate(Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTranslatef((Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glTranslatex")]
        public static 
        void Translatex(int x, int y, int z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTranslatex((int)x, (int)y, (int)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T3)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer<T3>(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer(Int32 size, OpenTK.Graphics.ES10.All type, Int32 stride, IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES10.All)type, (Int32)stride, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the viewport
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the lower left corner of the viewport rectangle, in pixels. The initial value is (0,0).
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the width and height of the viewport. When a GL context is first attached to a window, width and height are set to the dimensions of that window.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "glViewport")]
        public static 
        void Viewport(Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glViewport((Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

    }
}
