\name{algo.call}
\alias{algo.call}
\title{Query Transmission to Specified Surveillance Algorithm}
\description{
  Transmission of a object of class disProg to the specified surveillance algorithm.
}
\usage{
    algo.call(disProgObj, control = list(
                     list(funcName = "rki1", range = range),
                     list(funcName = "rki", range = range,
                          b = 2, w = 4, actY = TRUE),
                     list(funcName = "rki", range = range,
                          b = 2, w = 5, actY = TRUE)))
}
\arguments{
  \item{disProgObj}{object of class disProg, which includes the state chain and the observed}
  \item{control}{specifies which surveillance algorithm should be used with their parameters.
    The parameter \code{funcName} and \code{range} must be
    specified. Here, \code{funcName} is the appropriate
    method function (without '\code{algo.}') and \code{range} defines
    the timepoints to be evaluated by the actual system.}
}
\value{
  a list of survRes objects generated by the specified surveillance algorithm
}
\seealso{\code{\link{algo.rki}}, \code{\link{algo.bayes}}, \code{\link{algo.farrington}}}
\examples{
# Create a test object
disProg <- sim.pointSource(p = 0.99, r = 0.5, length = 400, A = 1,
                           alpha = 1, beta = 0, phi = 0,
                           frequency = 1, state = NULL, K = 1.7)

# Let this object be tested from any methods in range = 200:400
range <- 200:400
survRes <- algo.call(disProg,
                     control = list(
                         list(funcName = "rki1", range = range),
                         list(funcName = "rki2", range = range),
                         list(funcName = "rki3", range = range),
                         list(funcName = "rki", range = range,
                              b = 3, w = 2, actY = FALSE),
                         list(funcName = "rki", range = range,
                              b = 2, w = 9, actY = TRUE),
                         list(funcName = "bayes1", range = range),
                         list(funcName = "bayes2", range = range),
                         list(funcName = "bayes3", range = range),
                         list(funcName = "bayes",
                              range = range, b = 1, w = 5, actY = TRUE,alpha=0.05)
                     ))
# show selected survRes objects
names(survRes)
plot(survRes[["rki(6,6,0)"]])
survRes[["bayes(5,5,1)"]]
}
\keyword{classif}
