#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 BetaRays
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Touhou 14
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220701.1

GAME_ID='touhou-14-demo'
GAME_NAME='Touhou Kishinjou ~ Double Dealing Character (demo)'

# This DRM-free archive is no longer available from Playism store,
# since their owners closed it down in favour of Steam.
ARCHIVE_BASE_0='DoubleDealingCharacterDemo.zip'
ARCHIVE_BASE_0_MD5='76a751e8becb51689c2256d218cda788'
ARCHIVE_BASE_0_SIZE='190000'
ARCHIVE_BASE_0_VERSION='0.01b-playism'

CONTENT_PATH_DEFAULT='Double Dealing Character DEMO (Touhou14)'
ARCHIVE_DOC_DATA_FILES='
*.txt'
ARCHIVE_GAME_BIN_FILES='
*.exe'
ARCHIVE_GAME_DATA_FILES='
*.dat'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='th14.exe'
APP_MAIN_ICON='th14.exe'

APP_CONFIG_ID="${GAME_ID}-config"
APP_CONFIG_NAME="$GAME_NAME - configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_TYPE='wine'
APP_CONFIG_EXE='custom.exe'
APP_CONFIG_ICON='custom.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine libGL.so.1"
PKG_BIN_DEPS_DEB='fonts-wqy-microhei'
PKG_BIN_DEPS_ARCH='wqy-microhei'
PKG_BIN_DEPS_GENTOO='media-fonts/wqy-microhei'

# Use persistent storage for user data

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/${USER}/Application Data/ShanghaiAlice/th14tr'
DATA_DIRS="$DATA_DIRS ./userdata"

# iconv is used to convert files encoding

SCRIPT_DEPS="$SCRIPT_DEPS iconv"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Convert the text files to UTF-8 encoding

(
	content_path=$(content_path_default)
	cd "${PLAYIT_WORKDIR}/gamedata/${content_path}"
	iconv_shell_command='contents=$(iconv --from-code CP932 --to-code UTF-8 "$1")'
	iconv_shell_command="$iconv_shell_command"'; printf "%s" "$contents" > "$1"'
	find . \( -name '*.txt' -o -name '*.html' \) -exec \
		sh -c "$iconv_shell_command" -- '{}' \;
)

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN' 'APP_CONFIG'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN' 'APP_CONFIG'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
