#!/bin/sh
set -o errexit

###
# Copyright (©) 2015-2022, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (©) 2021-2022, Anna Lea
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Bad Dream Fever
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220102.1

# Set game-specific variables

GAME_ID='bad-dream-fever'
GAME_NAME='Bad Dream Fever'

ARCHIVE_BASE_0='setup_bad_dream_fever_1.0_(26985).exe'
ARCHIVE_BASE_0_MD5='19336f3d5f3920873c7f111f9bda3f8b'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='490000'
ARCHIVE_BASE_0_VERSION='1.0-gog26985'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/bad_dream_fever'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
bad?dream?fever.exe
d3dx9_43.dll
options.ini
__redist/directx'
ARCHIVE_GAME_DATA_FILES='
*.dat
*.ogg
data.win
splash.png
language'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='bad dream fever.exe'
APP_MAIN_ICON='bad dream fever.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Install shipped DirectX in the WINE prefix

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Install shipped DirectX on first launch
if [ ! -e directx9_installed ]; then
	sleep 3s
	wine __redist/directx/dxsetup.exe /silent
	touch directx9_installed
fi'

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "${PLAYIT_WORKDIR}"

# Print instructions

print_instructions

exit 0
