/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import picard.PicardException;

public class Range {
    public final int start;
    public final int end;
    public final int length;

    public Range(int start, int end) {
        if (end < start) {
            throw new PicardException("Nonsensical Range(" + start + ", " + end + ")");
        }
        this.start = start;
        this.end = end;
        this.length = end - start + 1;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Range)) {
            return false;
        }
        Range that = (Range)object;
        return that.start == this.start && that.end == this.end;
    }

    public int hashCode() {
        return (int)Math.pow(this.start, this.end);
    }

    public String toString() {
        return "Range(" + this.start + ", " + this.end + ", " + this.length + ")";
    }
}

