/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.util.Arrays;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JTreeLocation {
    @RunsInCurrentThread
    public Pair<Rectangle, Point> rowBoundsAndCoordinates(JTree tree, int row) {
        Rectangle rowBounds = tree.getRowBounds(this.validIndex(tree, row));
        if (rowBounds != null) {
            return new Pair<Rectangle, Point>(rowBounds, this.pointAt(rowBounds));
        }
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"The tree row ", row, " is not visible"}));
    }

    @RunsInCurrentThread
    public TreePath pathFor(JTree tree, int row) {
        TreePath path = tree.getPathForRow(this.validIndex(tree, row));
        if (path != null) {
            return path;
        }
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find tree path for row [", String.valueOf(row), "]"}));
    }

    @RunsInCurrentThread
    public int validIndex(JTree tree, int row) {
        int rowCount = tree.getRowCount();
        if (row >= 0 && row < rowCount) {
            return row;
        }
        throw new IndexOutOfBoundsException(Strings.concat((Object[])new Object[]{"The given row (", String.valueOf(row), ") should be greater than or equal to 0 and less than ", String.valueOf(rowCount)}));
    }

    @RunsInCurrentThread
    public Pair<Rectangle, Point> pathBoundsAndCoordinates(JTree tree, TreePath path) {
        Rectangle pathBounds = tree.getPathBounds(path);
        if (pathBounds != null) {
            return new Pair<Rectangle, Point>(pathBounds, this.pointAt(pathBounds));
        }
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"The tree path ", Arrays.format((Object)path.getPath()), " is not visible"}));
    }

    private Point pointAt(Rectangle cellBounds) {
        return new Point(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
    }
}

