/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ThreadCheckingRepaintManager
extends RepaintManager {
    private boolean completeCheck = true;
    private boolean checkIsShowing = false;

    public ThreadCheckingRepaintManager() {
    }

    public ThreadCheckingRepaintManager(boolean bl) {
        this.checkIsShowing = bl;
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean bl) {
        this.completeCheck = bl;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    @Override
    public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    private void checkThreadViolations(JComponent jComponent) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || this.checkIsShowing(jComponent))) {
            StackTraceElement[] stackTraceElementArray;
            Exception exception = new Exception();
            boolean bl = false;
            boolean bl2 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = exception.getStackTrace()) {
                if (bl && stackTraceElement.getClassName().startsWith("javax.swing.")) {
                    bl2 = true;
                }
                if (!"repaint".equals(stackTraceElement.getMethodName())) continue;
                bl = true;
            }
            if (bl && !bl2) {
                return;
            }
            System.out.println("----------Wrong Thread START");
            System.out.println(this.getStrackTraceAsString(exception));
            System.out.println("----------Wrong Thread END");
        }
    }

    private boolean checkIsShowing(JComponent jComponent) {
        if (this.checkIsShowing) {
            return jComponent.isShowing();
        }
        return true;
    }

    private String getStrackTraceAsString(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }
}

