/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.awt.Color;
import org.fest.util.Strings;

public final class Colors {
    public static Color colorFromHexString(String hexString) {
        if (hexString == null) {
            throw new NullPointerException("The hexadecimal code should not be null");
        }
        if (Strings.isEmpty((String)hexString)) {
            throw new IllegalArgumentException("The hexadecimal code should not be empty");
        }
        try {
            return new Color(Integer.parseInt(hexString, 16));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(Strings.concat((Object[])new Object[]{"The hexadecimal code ", Strings.quote((String)hexString), " is not a valid color code"}));
        }
    }

    private Colors() {
    }
}

