/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.LazyBSONCallback;
import org.bson.io.BSONByteBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyBSONObject
implements BSONObject {
    static final int FIRST_ELMT_OFFSET = 4;
    protected final int _doc_start_offset;
    protected final BSONByteBuffer _input;
    protected final LazyBSONCallback _callback;
    private static final Logger log = Logger.getLogger("org.bson.LazyBSONObject");

    public LazyBSONObject(byte[] data, LazyBSONCallback callback) {
        this(BSONByteBuffer.wrap(data), callback);
    }

    public LazyBSONObject(byte[] data, int offset, LazyBSONCallback callback) {
        this(BSONByteBuffer.wrap(data, offset, data.length - offset), offset, callback);
    }

    public LazyBSONObject(BSONByteBuffer buffer, LazyBSONCallback callback) {
        this(buffer, 0, callback);
    }

    public LazyBSONObject(BSONByteBuffer buffer, int offset, LazyBSONCallback callback) {
        this._callback = callback;
        this._input = buffer;
        this._doc_start_offset = offset;
    }

    @Override
    public Object put(String key, Object v) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public void putAll(BSONObject o) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public Object get(String key) {
        ArrayList<ElementRecord> elements = this.getElementsToKey(key);
        if (elements == null || elements.size() == 0) {
            return null;
        }
        ElementRecord lastRec = elements.get(elements.size() - 1);
        return lastRec.name.equals(key) ? this.getElementValue(lastRec) : null;
    }

    ArrayList<ElementRecord> getElementsToKey(String key) {
        int offset = this._doc_start_offset + 4;
        ArrayList<ElementRecord> elements = new ArrayList<ElementRecord>();
        while (!this.isElementEmpty(offset)) {
            int fieldSize = this.sizeCString(offset);
            int elementSize = this.getElementBSONSize(offset++);
            String name = this._input.getCString(offset);
            ElementRecord rec = new ElementRecord(name, offset);
            elements.add(rec);
            if (name.equals(key)) break;
            offset += fieldSize + elementSize;
        }
        return elements;
    }

    @Override
    public Map toMap() {
        throw new UnsupportedOperationException("Not Supported");
    }

    @Override
    public Object removeField(String key) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    @Deprecated
    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    @Override
    public boolean containsField(String s) {
        return this.keySet().contains(s);
    }

    @Override
    public Set<String> keySet() {
        return new LazyBSONKeySet();
    }

    protected boolean isElementEmpty(int offset) {
        return this.getElementType(offset) == 0;
    }

    public boolean isEmpty() {
        return this.isElementEmpty(this._doc_start_offset + 4);
    }

    private int getBSONSize(int offset) {
        return this._input.getInt(offset);
    }

    public int getBSONSize() {
        return this._input.getInt(this._doc_start_offset);
    }

    private String getElementFieldName(int offset) {
        return this._input.getCString(offset);
    }

    protected byte getElementType(int offset) {
        return this._input.get(offset);
    }

    protected int getElementBSONSize(int offset) {
        int x = 0;
        byte type = this.getElementType(offset++);
        int n = this.sizeCString(offset++);
        int valueOffset = offset + n;
        switch (type) {
            case -1: 
            case 0: 
            case 6: 
            case 10: 
            case 127: {
                break;
            }
            case 8: {
                x = 1;
                break;
            }
            case 16: {
                x = 4;
                break;
            }
            case 1: 
            case 9: 
            case 17: 
            case 18: {
                x = 8;
                break;
            }
            case 7: {
                x = 12;
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                x = this._input.getInt(valueOffset) + 4;
                break;
            }
            case 15: {
                x = this._input.getInt(valueOffset);
                break;
            }
            case 12: {
                x = this._input.getInt(valueOffset) + 4 + 12;
                break;
            }
            case 3: 
            case 4: {
                x = this._input.getInt(valueOffset);
                break;
            }
            case 5: {
                x = this._input.getInt(valueOffset) + 4 + 1;
                break;
            }
            case 11: {
                int part1 = this.sizeCString(valueOffset) + 1;
                int part2 = this.sizeCString(valueOffset + part1) + 1;
                x = part1 + part2 + 4;
                break;
            }
            default: {
                throw new BSONException("Invalid type " + type + " for field " + this.getElementFieldName(offset));
            }
        }
        return x;
    }

    protected int sizeCString(int offset) {
        byte b;
        int end = ++offset;
        while ((b = this._input.get(end)) != 0) {
            ++end;
        }
        return end - offset + 1;
    }

    protected Object getElementValue(ElementRecord record) {
        switch (record.type) {
            case 0: 
            case 6: 
            case 10: {
                return null;
            }
            case 127: {
                return new MaxKey();
            }
            case -1: {
                return new MinKey();
            }
            case 8: {
                return this._input.get(record.valueOffset) != 0;
            }
            case 16: {
                return this._input.getInt(record.valueOffset);
            }
            case 17: {
                int inc = this._input.getInt(record.valueOffset);
                int time = this._input.getInt(record.valueOffset + 4);
                return new BSONTimestamp(time, inc);
            }
            case 9: {
                return new Date(this._input.getLong(record.valueOffset));
            }
            case 18: {
                return this._input.getLong(record.valueOffset);
            }
            case 1: {
                return Double.longBitsToDouble(this._input.getLong(record.valueOffset));
            }
            case 7: {
                return new ObjectId(this._input.getIntBE(record.valueOffset), this._input.getIntBE(record.valueOffset + 4), this._input.getIntBE(record.valueOffset + 8));
            }
            case 14: {
                return new Symbol(this._input.getUTF8String(record.valueOffset));
            }
            case 13: {
                return new Code(this._input.getUTF8String(record.valueOffset));
            }
            case 2: {
                return this._input.getUTF8String(record.valueOffset);
            }
            case 15: {
                int strsize = this._input.getInt(record.valueOffset + 4);
                String code = this._input.getUTF8String(record.valueOffset + 4);
                BSONObject scope = (BSONObject)this._callback.createObject(this._input.array(), record.valueOffset + 4 + 4 + strsize);
                return new CodeWScope(code, scope);
            }
            case 12: {
                int csize = this._input.getInt(record.valueOffset);
                String ns = this._input.getCString(record.valueOffset + 4);
                int oidOffset = record.valueOffset + csize + 4;
                ObjectId oid = new ObjectId(this._input.getIntBE(oidOffset), this._input.getIntBE(oidOffset + 4), this._input.getIntBE(oidOffset + 8));
                return this._callback.createDBRef(ns, oid);
            }
            case 3: {
                return this._callback.createObject(this._input.array(), record.valueOffset);
            }
            case 4: {
                return this._callback.createArray(this._input.array(), record.valueOffset);
            }
            case 5: {
                return this.readBinary(record.valueOffset);
            }
            case 11: {
                int n = this.sizeCString(record.valueOffset);
                String pattern = this._input.getCString(record.valueOffset);
                String flags = this._input.getCString(record.valueOffset + n);
                return Pattern.compile(pattern, BSON.regexFlags(flags));
            }
        }
        throw new BSONException("Invalid type " + record.type + " for field " + this.getElementFieldName(record.offset));
    }

    private Object readBinary(int valueOffset) {
        int totalLen = this._input.getInt(valueOffset);
        byte bType = this._input.get(valueOffset += 4);
        ++valueOffset;
        switch (bType) {
            case 0: {
                byte[] bin = new byte[totalLen];
                for (int n = 0; n < totalLen; ++n) {
                    bin[n] = this._input.get(valueOffset + n);
                }
                return bin;
            }
            case 2: {
                int len = this._input.getInt(valueOffset);
                if (len + 4 != totalLen) {
                    throw new IllegalArgumentException("Bad Data Size; Binary Subtype 2.  { actual len: " + len + " expected totalLen: " + totalLen + "}");
                }
                valueOffset += 4;
                byte[] bin = new byte[len];
                for (int n = 0; n < len; ++n) {
                    bin[n] = this._input.get(valueOffset + n);
                }
                return bin;
            }
            case 3: {
                if (totalLen != 16) {
                    throw new IllegalArgumentException("Bad Data Size; Binary Subtype 3 (UUID). { total length: " + totalLen + " != 16");
                }
                long part1 = this._input.getLong(valueOffset);
                long part2 = this._input.getLong(valueOffset += 8);
                return new UUID(part1, part2);
            }
        }
        byte[] bin = new byte[totalLen];
        for (int n = 0; n < totalLen; ++n) {
            bin[n] = this._input.get(valueOffset + n);
        }
        return bin;
    }

    public String toString() {
        return JSON.serialize(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyBSONKeySet
    implements Set<String> {
        @Override
        public int size() {
            int size = 0;
            for (String key : this) {
                ++size;
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            return LazyBSONObject.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            for (String key : this) {
                if (!key.equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            return new LazyBSONIterator();
        }

        @Override
        public Object[] toArray() {
            String[] array = new String[this.size()];
            return this.toArray(array);
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            int i = 0;
            for (String key : this) {
                ts[++i] = key;
            }
            return ts;
        }

        @Override
        public boolean add(String e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsAll(Collection<?> clctn) {
            for (Object item : clctn) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends String> clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean retainAll(Collection<?> clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean removeAll(Collection<?> clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyBSONIterator
    implements Iterator<String> {
        int offset;

        public LazyBSONIterator() {
            this.offset = LazyBSONObject.this._doc_start_offset + 4;
        }

        @Override
        public boolean hasNext() {
            return !LazyBSONObject.this.isElementEmpty(this.offset);
        }

        @Override
        public String next() {
            int fieldSize = LazyBSONObject.this.sizeCString(this.offset);
            int elementSize = LazyBSONObject.this.getElementBSONSize(this.offset++);
            String key = LazyBSONObject.this._input.getCString(this.offset);
            this.offset += fieldSize + elementSize;
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class ElementRecord {
        final String name;
        final byte type;
        final int fieldNameSize;
        final int valueOffset;
        final int offset;

        ElementRecord(String name, int offset) {
            this.name = name;
            this.offset = offset;
            this.type = LazyBSONObject.this.getElementType(offset - 1);
            this.fieldNameSize = LazyBSONObject.this.sizeCString(offset) + 1;
            this.valueOffset = offset + this.fieldNameSize;
        }
    }
}

