/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleExpression
extends Expression {
    Expression[] components;
    int[] evaluationModes;

    public TupleExpression(int width) {
        this.components = new Expression[width];
        this.evaluationModes = new int[width];
    }

    public void setExpression(int i, Expression exp) {
        this.components[i] = exp;
        this.adoptChildExpression(this.components[i]);
        this.evaluationModes[i] = -1;
    }

    public Expression[] getComponents() {
        return this.components;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = visitor.simplify(this.components[i]);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.doPromotion(this, this.components[i], offer);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return new ExternalObjectType(Object.class, th.getConfiguration());
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = visitor.typeCheck(this.components[i], contextItemType);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = visitor.optimize(this.components[i], contextItemType);
            this.adoptChildExpression(this.components[i]);
            this.evaluationModes[i] = i < 2 ? ExpressionTool.eagerEvaluationMode(this.components[i]) : ExpressionTool.lazyEvaluationMode(this.components[i]);
        }
        return this;
    }

    @Override
    public Expression copy() {
        TupleExpression te = new TupleExpression(this.components.length);
        Expression[] c2 = new Expression[this.components.length];
        int[] e2 = new int[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            c2[i] = this.components[i].copy();
            e2[i] = this.evaluationModes[i];
        }
        te.components = c2;
        te.evaluationModes = e2;
        return te;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("tuple");
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].explain(out);
        }
        out.endElement();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Value[] tuple = new Value[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            tuple[i] = Value.asValue(ExpressionTool.evaluate(this.components[i], this.evaluationModes[i], context, 10));
        }
        return new ObjectValue(tuple);
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return Arrays.asList(this.components).iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] != original) continue;
            this.components[i] = replacement;
            found = true;
        }
        return found;
    }
}

