/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_PD.C $
   $Locker: ska $	$Name:  $	$State: Exp $
	char *cfgi_packData(const char * const data, const char * const comment
	 , int needData);

	Pack the data and the comment portion together 

	Both are delimited by " ;" if the comment is present.

	If needData is true and data == NULL, the return value is NULL.
	In all other cases data == NULL <=> data == "".

	If comment is present, the constructed string is duplicated into
	the heap and is automatically free()'ed when this function is
	called next.

ob: cfgi_packData
ty: L
su: inifile
sh: Concatenate data and comment of a value
lo: Concatenates the specified data and comment and return the result both
	delimited by the string " ;" (one space and one semicolon).\par
	The result is cached within the variable cfgi_data, if necessary.\par
	If \para{comment} == NULL, no delimiter is appended.\par
	If \para{data} == NULL && \para(needData} is true, the result is
	\tok{NULL}, no matter what \para{comment} contains.
re: cfgi_data
wa: The returned string is automatically destroyed, when this function
	is called next or the \subsys{inifile} is closed.
fi: cfgi_pd.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_PD.C 1.4 2001/02/27 01:27:56 ska Exp ska $";
#endif

char *cfgi_packData(const char * const data, const char * const comment
 , int needData)
{	const char *d;

	DBG_ENTER("cfgi_packData", Suppl_inifile)
	DBG_ARGUMENTS( ("data=\"%s\", cmt=\"%s\", need_data=%d", data, comment, needData) )

	chkHeap
	StrFree(cfgi_data);

	if((d = data) == 0) {
		if(needData)
			DBG_RETURN_S( 0)
		d = "";
	}

	if(!comment)				/* no need for heap actions */
		DBG_RETURN_S( (char*)d)

	chkHeap
	DBG_RETURN_BS( cfgi_data = EStrConcat(3, data, " ;", comment))
}
